/*
 * Decompiled with CFR 0.152.
 */
package com.joutvhu.dynamic.jdbc.query;

import com.joutvhu.dynamic.jdbc.DynamicQuery;
import com.joutvhu.dynamic.jdbc.query.DynamicJdbcQueryMethod;
import com.joutvhu.dynamic.jdbc.query.DynamicJdbcRepositoryQuery;
import java.lang.reflect.Method;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.jdbc.repository.QueryMappingConfiguration;
import org.springframework.data.jdbc.repository.support.DynamicOpenJdbcQueryLookupStrategy;
import org.springframework.data.mapping.callback.EntityCallbacks;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.relational.core.dialect.Dialect;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class DynamicJdbcQueryLookupStrategy
extends DynamicOpenJdbcQueryLookupStrategy {
    private RelationalMappingContext context;
    private QueryLookupStrategy jdbcQueryLookupStrategy;

    public DynamicJdbcQueryLookupStrategy(ApplicationEventPublisher publisher, @Nullable EntityCallbacks callbacks, RelationalMappingContext context, JdbcConverter converter, Dialect dialect, QueryMappingConfiguration queryMappingConfiguration, NamedParameterJdbcOperations operations, @Nullable BeanFactory beanfactory, QueryLookupStrategy queryLookupStrategy) {
        super(publisher, callbacks, context, converter, dialect, queryMappingConfiguration, operations, beanfactory);
        this.context = context;
        this.jdbcQueryLookupStrategy = queryLookupStrategy;
    }

    @Override
    public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
        if (this.isDynamicQueryMethod(method)) {
            DynamicJdbcQueryMethod queryMethod = new DynamicJdbcQueryMethod(method, metadata, factory, namedQueries, (MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty>)this.context);
            RowMapper<Object> mapper = queryMethod.isModifyingQuery() ? null : this.createMapper(queryMethod);
            DynamicJdbcRepositoryQuery query = new DynamicJdbcRepositoryQuery(queryMethod, this.getOperations(), mapper, this.getConverter());
            query.setBeanFactory(this.getBeanFactory());
            return query;
        }
        return this.jdbcQueryLookupStrategy.resolveQuery(method, metadata, factory, namedQueries);
    }

    private boolean isDynamicQueryMethod(Method method) {
        DynamicQuery annotation = method.getAnnotation(DynamicQuery.class);
        return annotation != null;
    }

    public static QueryLookupStrategy create(ApplicationEventPublisher publisher, @Nullable EntityCallbacks callbacks, RelationalMappingContext context, JdbcConverter converter, Dialect dialect, QueryMappingConfiguration queryMappingConfiguration, NamedParameterJdbcOperations operations, @Nullable BeanFactory beanFactory, QueryLookupStrategy queryLookupStrategy) {
        Assert.notNull((Object)publisher, (String)"ApplicationEventPublisher must not be null");
        Assert.notNull((Object)context, (String)"RelationalMappingContextPublisher must not be null");
        Assert.notNull((Object)converter, (String)"JdbcConverter must not be null");
        Assert.notNull((Object)dialect, (String)"Dialect must not be null");
        Assert.notNull((Object)queryMappingConfiguration, (String)"QueryMappingConfiguration must not be null");
        Assert.notNull((Object)operations, (String)"NamedParameterJdbcOperations must not be null");
        return new DynamicJdbcQueryLookupStrategy(publisher, callbacks, context, converter, dialect, queryMappingConfiguration, operations, beanFactory, queryLookupStrategy);
    }
}

