/*
 * Decompiled with CFR 0.152.
 */
package com.github.jinahya.jsonrpc2.bind;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.jinahya.jsonrpc2.bind.ErrorObject;
import com.github.jinahya.jsonrpc2.bind.JsonrpcObject;
import java.util.Objects;
import javax.json.bind.annotation.JsonbTransient;
import javax.validation.constraints.AssertTrue;

public class ResponseObject<T, U extends ErrorObject<?>>
extends JsonrpcObject {
    private T result;
    private U error;

    @Override
    public String toString() {
        return super.toString() + "{result=" + this.result + ",error=" + this.error + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResponseObject)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResponseObject that = (ResponseObject)o;
        return Objects.equals(this.getResult(), that.getResult()) && Objects.equals(this.getError(), that.getError());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getResult(), this.getError());
    }

    @JsonIgnore
    @JsonbTransient
    @AssertTrue(message="either result or error can be set")
    public @AssertTrue(message="either result or error can be set") boolean isResultAndErrorAreExclusive() {
        return this.getResult() != null ^ this.getError() != null;
    }

    public T getResult() {
        return this.result;
    }

    public void setResult(T result) {
        this.result = result;
    }

    public U getError() {
        return this.error;
    }

    public void setError(U error) {
        this.error = error;
    }
}

