/*
 * Decompiled with CFR 0.152.
 */
package com.github.jinahya.jsonrpc2.bind;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.jinahya.jsonrpc2.bind.JsonrpcObject;
import java.util.Objects;
import javax.json.bind.annotation.JsonbTransient;
import javax.validation.constraints.AssertFalse;
import javax.validation.constraints.NotEmpty;

public class RequestObject<T>
extends JsonrpcObject {
    @NotEmpty
    private String method;
    private T params;

    @Override
    public String toString() {
        return super.toString() + "{method=" + this.method + ",params=" + this.params + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RequestObject)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RequestObject that = (RequestObject)o;
        return Objects.equals(this.getMethod(), that.getMethod()) && Objects.equals(this.getParams(), that.getParams());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getMethod(), this.getParams());
    }

    @JsonIgnore
    @JsonbTransient
    public boolean isNotification() {
        return this.getId() == null;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    @JsonIgnore
    @JsonbTransient
    @AssertFalse
    public boolean isMethodReservedForRpcInternal() {
        String method = this.getMethod();
        return method != null && method.startsWith("rpc.");
    }

    public T getParams() {
        return this.params;
    }

    public void setParams(T params) {
        this.params = params;
    }
}

