/*
 * Decompiled with CFR 0.152.
 */
package com.github.jinahya.jsonrpc2.bind;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Objects;
import javax.json.bind.annotation.JsonbTransient;
import javax.validation.constraints.NotNull;

public class ErrorObject<T>
implements Serializable {
    public static final long MIN_RESERVED_CODE = -32768L;
    public static final long MAX_RESERVED_CODE = 32000L;
    public static final long CODE_PARSE_ERROR = -32700L;
    public static final long CODE_INVALID_REQUEST = -32600L;
    public static final long CODE_METHOD_NOT_FOUND = -32601L;
    public static final long CODE_INVALID_PARAMS = -32602L;
    public static final long CODE_INTERNAL_ERROR = -32603L;
    public static final long MIN_CODE_SERVER_ERROR = -32000L;
    public static final long MAX_CODE_SERVER_ERROR = -32099L;
    private long code;
    @NotNull
    private String message;
    private T data;

    public String toString() {
        return super.toString() + "{code=" + this.code + ",message=" + this.message + ",data=" + this.data + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ErrorObject)) {
            return false;
        }
        ErrorObject that = (ErrorObject)o;
        return this.getCode() == that.getCode() && Objects.equals(this.getMessage(), that.getMessage()) && Objects.equals(this.getData(), that.getData());
    }

    public int hashCode() {
        return Objects.hash(this.getCode(), this.getMessage(), this.getData());
    }

    public long getCode() {
        return this.code;
    }

    public void setCode(long code) {
        this.code = code;
    }

    @JsonIgnore
    @JsonbTransient
    public boolean isCodeReserved() {
        return this.code >= -32768L && this.code <= 32000L;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public static class Undefined
    extends ErrorObject<Object> {
    }
}

