/*
 * Decompiled with CFR 0.152.
 */
package com.github.jiahaowen.spring.assistant.component.idempotent.key;

import com.github.jiahaowen.spring.assistant.component.idempotent.annotation.Idempotent;
import com.github.jiahaowen.spring.assistant.component.idempotent.key.ReturnValueStrategy;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class DefaultReturnValue
implements ReturnValueStrategy {
    private static final Map<Class<?>, Object> defaultTypeValue = new HashMap(16);

    @Override
    public Object value(Idempotent idempotent) {
        Class<?> clz = idempotent.returnType();
        String value = idempotent.returnValue();
        if (this.isCustomType(clz)) {
            return this.newInstance(clz);
        }
        if (value == null || "".equals(value)) {
            return this.getDefaultValue(clz);
        }
        return this.convertValue(clz, value);
    }

    private Object newInstance(Class<?> clz) {
        try {
            return clz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(String.format("\u8bf7\u4e3a[%s]\u7c7b\u63d0\u4f9b\u4e00\u4e2a\u9ed8\u8ba4\u7684\u6784\u9020\u51fd\u6570", clz.getName()));
        }
    }

    private Object convertValue(Class<?> clz, String value) {
        if (clz.isAssignableFrom(Integer.class)) {
            return Integer.valueOf(value);
        }
        if (clz.isAssignableFrom(Short.class)) {
            return Short.valueOf(value);
        }
        if (clz.isAssignableFrom(Byte.class)) {
            return Byte.valueOf(value);
        }
        if (clz.isAssignableFrom(Float.class)) {
            return Float.valueOf(value);
        }
        if (clz.isAssignableFrom(Double.class)) {
            return Double.valueOf(value);
        }
        if (clz.isAssignableFrom(Long.class)) {
            return Long.valueOf(value);
        }
        if (clz.isAssignableFrom(Boolean.class)) {
            return Boolean.valueOf(value);
        }
        if (clz.isAssignableFrom(Void.class)) {
            return null;
        }
        return value;
    }

    private boolean isCustomType(Class<?> clz) {
        return !defaultTypeValue.containsKey(clz);
    }

    private Object getDefaultValue(Class<?> clz) {
        return defaultTypeValue.get(clz);
    }

    static {
        defaultTypeValue.put(String.class, null);
        defaultTypeValue.put(Integer.class, 0);
        defaultTypeValue.put(Short.class, 0);
        defaultTypeValue.put(Byte.class, 0);
        defaultTypeValue.put(Long.class, 0L);
        defaultTypeValue.put(Character.class, null);
        defaultTypeValue.put(Float.class, Float.valueOf(0.0f));
        defaultTypeValue.put(Double.class, 0.0);
        defaultTypeValue.put(Boolean.class, false);
        defaultTypeValue.put(Void.class, null);
    }
}

