/*
 * Decompiled with CFR 0.152.
 */
package com.github.jiahaowen.spring.assistant.component.idempotent.key;

import com.github.jiahaowen.spring.assistant.component.idempotent.annotation.Idempotent;
import com.github.jiahaowen.spring.assistant.component.idempotent.annotation.IdempotentParam;
import com.github.jiahaowen.spring.assistant.component.idempotent.key.IdempotentKeyStrategy;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.stereotype.Component;

@Component
public class DefaultIdempotentKey
implements IdempotentKeyStrategy {
    @Override
    public String key(MethodInvocation invocation) {
        Method method = invocation.getMethod();
        Idempotent idempotent = method.getAnnotation(Idempotent.class);
        if (idempotent.previous().isEmpty() && invocation.getArguments().length == 0) {
            throw new IllegalArgumentException("idempotent must set previous key or has IdempotentParam value");
        }
        Annotation[][] annotations = method.getParameterAnnotations();
        StringBuilder sb = new StringBuilder();
        sb.append(method.getDeclaringClass().getName()).append(".").append(method.getName()).append("-");
        int iLen = annotations.length;
        for (int i = 0; i < iLen; ++i) {
            int jLen = annotations[i].length;
            for (int j = 0; j < jLen; ++j) {
                Annotation annotation = annotations[i][j];
                if (!annotation.annotationType().isAssignableFrom(IdempotentParam.class)) continue;
                sb.append(this.extractValueFromParam(annotation, invocation.getArguments()[i]));
            }
        }
        return idempotent.previous().isEmpty() ? sb.toString() : idempotent.previous() + "-" + sb.toString();
    }

    private String extractValueFromParam(Annotation annotation, Object object) {
        IdempotentParam param = (IdempotentParam)annotation;
        String[] value = param.value();
        StringBuilder sb = new StringBuilder();
        for (String v : value) {
            sb.append(v.contains(".") ? this.extractValueFromObject(v, object) : String.valueOf(object)).append("-");
        }
        return sb.toString();
    }

    private String extractValueFromObject(String value, Object object) {
        Object currentObject = object;
        for (String s : value.split("\\.")) {
            try {
                Method method = currentObject.getClass().getMethod("get" + Character.toUpperCase(s.charAt(0)) + s.substring(1), new Class[0]);
                method.setAccessible(true);
                currentObject = method.invoke(currentObject, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                throw new IllegalStateException(String.format("IdempotentParam \u5b9a\u4e49\u7684value\u503c[%s],\u5728\u5bf9\u8c61[%s]\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u8bbe\u7f6e\u4e86get\u65b9\u6cd5", s, currentObject.getClass()));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new IllegalStateException("\u5f53\u524d\u6267\u884c\u7684\u65b9\u6cd5\u6ca1\u6709\u8bbf\u95ee\u6743\u9650:" + e);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                throw new IllegalStateException("\u6267\u884c\u5f53\u524d\u65b9\u6cd5\u62a5\u9519\uff1a" + e);
            }
        }
        return String.valueOf(currentObject);
    }
}

