/*
 * Decompiled with CFR 0.152.
 */
package com.github.jiahaowen.spring.assistant.component.idempotent.interceptor;

import com.github.jiahaowen.spring.assistant.component.idempotent.annotation.Idempotent;
import com.github.jiahaowen.spring.assistant.component.idempotent.data.IdempotentOperateUtil;
import com.github.jiahaowen.spring.assistant.component.idempotent.key.DefaultIdempotentKey;
import com.github.jiahaowen.spring.assistant.component.idempotent.key.DefaultReturnValue;
import com.github.jiahaowen.spring.assistant.component.idempotent.key.IdempotentKeyStrategy;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class IdempotentInterceptor
implements MethodInterceptor {
    private static final Logger log = LoggerFactory.getLogger(IdempotentInterceptor.class);
    private IdempotentKeyStrategy distributeLockCacheKeyStrategy = new DefaultIdempotentKey();

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        if (method.isAnnotationPresent(Idempotent.class)) {
            Idempotent idempotent = method.getAnnotation(Idempotent.class);
            String key = this.distributeLockCacheKeyStrategy.key(invocation);
            if (!IdempotentOperateUtil.proceed(key, idempotent.expiredTime())) {
                return new DefaultReturnValue().value(idempotent);
            }
            try {
                return invocation.proceed();
            }
            catch (Throwable throwable) {
                log.warn("\u4e1a\u52a1\u64cd\u4f5c\u5931\u8d25\uff0c\u8bbe\u7f6e\u7684\u552f\u4e00\u6807\u8bc6\u9700\u8981\u6e05\u7406\u3002\u5f53\u524d\u6267\u884c\u7684\u65b9\u6cd5\u4e3a\uff1amethod\uff1a{}\uff0c\u7f13\u5b58key\u4e3a\uff1a{}\uff0c\u9519\u8bef\u5f02\u5e38\u4e3a\uff1a", new Object[]{method.getName(), key, throwable});
                IdempotentOperateUtil.callBack(key);
                throw throwable;
            }
        }
        return invocation.proceed();
    }
}

