/*
 * Decompiled with CFR 0.152.
 */
package com.github.jiahaowen.spring.assistant.component.idempotent.data;

import com.github.jiahaowen.spring.assistant.component.idempotent.data.IdempotentOperate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.RedisConnectionUtils;
import redis.clients.jedis.Jedis;

public class DefaultIdempotentOperate
implements IdempotentOperate,
InitializingBean {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private JedisConnectionFactory redisConnectionFactory;
    private Jedis jedis;

    @Override
    public boolean proceed(String key, int expiredTime) {
        boolean result;
        String string = this.jedis.setex(key, expiredTime, key);
        boolean bl = result = string.equals("OK");
        if (!result) {
            this.log.warn("\u5f53\u524d\u64cd\u4f5c\u5df2\u7ecf\u88ab\u5f53\u505a\u91cd\u590d\u6267\u884c\u7684\u64cd\u4f5c\uff0ckey\u4e3a\uff1a{}", (Object)key);
        }
        return result;
    }

    @Override
    public void callback(String key) {
        this.jedis.del(key);
    }

    public void afterPropertiesSet() throws Exception {
        RedisConnection redisConnection = RedisConnectionUtils.getConnection((RedisConnectionFactory)this.redisConnectionFactory);
        this.jedis = (Jedis)redisConnection.getNativeConnection();
    }
}

