package com.jh.custom.util.sdk;

import android.content.Context;
import android.os.RemoteException;

import com.android.installreferrer.api.InstallReferrerClient;
import com.android.installreferrer.api.InstallReferrerStateListener;
import com.android.installreferrer.api.ReferrerDetails;

public class ReferrerUtil {
    private static final String TNK_REFERRER_KEY = "tnk_ref=";
    private static final String TNK_SNSID_REF_KEY = "tnk_sid=";

    public static final int NOT_ADD_DEPENDENCIES = -2;
    public static final int SERVICE_DISCONNECTED = -1;
    public static final int OK = 0;
    public static final int SERVICE_UNAVAILABLE = 1;
    public static final int FEATURE_NOT_SUPPORTED = 2;

    public static boolean isStart = false;
    public static long referrerClickTime;
    public static long appInstallTime;
    public static int refCode;
    public static String snsId;

    public static void startReferrer(final Context context, final OnResultListener listener) {

        try {
            final InstallReferrerClient referrerClient = InstallReferrerClient.newBuilder(context).build();
            referrerClient.startConnection(new InstallReferrerStateListener() {
                @Override
                public void onInstallReferrerSetupFinished(int responseCode) {
                    isStart = true;

                    switch (responseCode) {
                        case InstallReferrerClient.InstallReferrerResponse.OK:
                            // 성공
                            try {
                                ReferrerDetails response = referrerClient.getInstallReferrer();
                                String referrerUrl = response.getInstallReferrer();

                                referrerClickTime = response.getReferrerClickTimestampSeconds();
                                appInstallTime = response.getInstallBeginTimestampSeconds();


                                String[] params = referrerUrl.split("&");
                                for(String param:params) {
                                    if (param.startsWith(TNK_REFERRER_KEY)) {

                                        param = param.replace(TNK_REFERRER_KEY, "");

                                        refCode = Integer.parseInt(param);
                                    }
                                    else if (param.startsWith(TNK_SNSID_REF_KEY)) {

                                        snsId = param.replace(TNK_SNSID_REF_KEY, "");

                                    }
                                }

                                listener.onResult(OK);
                                referrerClient.endConnection();  // 연결 해제
                            } catch (RemoteException e) { }

                            break;
                        case InstallReferrerClient.InstallReferrerResponse.FEATURE_NOT_SUPPORTED:
                            // 현재 Play Store 앱에서 API를 사용할 수 없음
                            listener.onResult(FEATURE_NOT_SUPPORTED);
                            break;
                        case InstallReferrerClient.InstallReferrerResponse.SERVICE_UNAVAILABLE:
                            // 연결을 설정할 수 없음
                            listener.onResult(SERVICE_UNAVAILABLE);
                            break;
                    }
                }

                @Override
                public void onInstallReferrerServiceDisconnected() {
                    // startConnection() 메서드를 호출하여 Google Play에 연결을 다시 시작하십시오.
                    listener.onResult(SERVICE_DISCONNECTED);
                }
            });
        } catch (NoClassDefFoundError e) {
            // installreferrer 라이브러리 추가하지 않았을 경우
            listener.onResult(NOT_ADD_DEPENDENCIES);

            throw new NoClassDefFoundError("Add the dependencies of the Google Play Install Referrer API.");
        }
    }

    public static long getReferrerClickTime() {
        return referrerClickTime;
    }

    public static long getAppInstallTime() {
        return appInstallTime;
    }

    public static int getRefCode() {
        return refCode;
    }

    public static String getSnsId() {
        return snsId;
    }

    public interface OnResultListener {
        void onResult(int resultCode);
    }
}
