/*
 * Decompiled with CFR 0.152.
 */
package com.github.jerryxia.devhelperspringbootsample.web;

import com.github.jerryxia.devutil.SystemClock;
import com.github.jerryxia.devutil.dataobject.web.response.SimpleRes;
import com.vip.vjtools.vjkit.time.DateFormatUtil;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class HomeController {
    private static final Logger log = LoggerFactory.getLogger(HomeController.class);

    @GetMapping(value={"/"})
    public ModelAndView index(HttpServletRequest req) {
        String requestFirst = "requestFirst";
        HttpSession session = req.getSession();
        if (session.getAttribute(requestFirst) == null) {
            String now = DateFormatUtil.DEFAULT_ON_SECOND_FORMAT.format(SystemClock.nowDate());
            log.info("first request time: {}", (Object)now);
            log.info("session: {}", (Object)session.getClass().toGenericString());
            session.setAttribute(requestFirst, (Object)now);
        } else {
            log.info("session storage data: {}", session.getAttribute(requestFirst));
        }
        String appName = "devhelper-spring-boot-sample";
        log.debug("appName: {}, now: {}", (Object)appName, (Object)DateFormatUtil.DEFAULT_ON_SECOND_FORMAT.format(SystemClock.nowDate()));
        ModelAndView mv = new ModelAndView("home/index");
        mv.addObject("appName", (Object)appName);
        mv.addObject("requestFirst", session.getAttribute(requestFirst));
        return mv;
    }

    @ResponseBody
    @PostMapping(value={"/now"})
    public SimpleRes now() {
        SimpleRes response = new SimpleRes();
        Date now = SystemClock.nowDate();
        if (now.getTime() % 2L == 0L) {
            log.warn("random warn message, {}", (Object)now);
        } else {
            log.error("random error message, {}", (Object)now);
        }
        response.getData().put("t", DateFormatUtil.DEFAULT_ON_SECOND_FORMAT.format(now));
        return response;
    }
}

