/*
 * Decompiled with CFR 0.152.
 */
package com.github.jchanghong.http;

import cn.hutool.crypto.SecureUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.github.jchanghong.http.OkHttps;
import com.github.jchanghong.http.OkhttpsKt;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import okhttp3.Cookie;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002*+B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\u0016\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u0005J@\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050$2\u0006\u0010%\u001a\u00020\u00052\b\b\u0002\u0010&\u001a\u00020\u00052\b\b\u0002\u0010'\u001a\u00020\u00052\u0010\b\u0002\u0010(\u001a\n\u0012\u0004\u0012\u00020 \u0018\u00010)R)\u0010\u0003\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\t\u001a\u00020\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u0006,"}, d2={"Lcom/github/jchanghong/http/OkHttps;", "", "()V", "cookieStore", "Ljava/util/HashMap;", "", "Lokhttp3/Cookie;", "getCookieStore", "()Ljava/util/HashMap;", "httpClient", "Lokhttp3/OkHttpClient;", "getHttpClient", "()Lokhttp3/OkHttpClient;", "httpClient$delegate", "Lkotlin/Lazy;", "lasthttpRequest", "Lokhttp3/Request;", "getLasthttpRequest", "()Lokhttp3/Request;", "setLasthttpRequest", "(Lokhttp3/Request;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "pviaURL", "getPviaURL", "()Ljava/lang/String;", "setPviaURL", "(Ljava/lang/String;)V", "createSSLSocketFactory", "Ljavax/net/ssl/SSLSocketFactory;", "loginForPvia", "", "user", "password", "requestCSRFRequestHead", "Lkotlin/Pair;", "url", "nameRegex", "valueRegex", "loginaction", "Lkotlin/Function0;", "TrustAllCerts", "TrustAllHostnameVerifier", "kotlin-lib"})
public final class OkHttps {
    @NotNull
    private static String pviaURL;
    @NotNull
    private static final Lazy httpClient$delegate;
    private static final Logger logger;
    @NotNull
    private static final HashMap<String, HashMap<String, Cookie>> cookieStore;
    @Nullable
    private static Request lasthttpRequest;
    public static final OkHttps INSTANCE;

    @NotNull
    public final String getPviaURL() {
        return pviaURL;
    }

    public final void setPviaURL(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        pviaURL = string;
    }

    @NotNull
    public final OkHttpClient getHttpClient() {
        Lazy lazy = httpClient$delegate;
        OkHttps okHttps = this;
        Object var3_3 = null;
        boolean bl = false;
        return (OkHttpClient)lazy.getValue();
    }

    private final SSLSocketFactory createSSLSocketFactory() {
        SSLContext sSLContext = SSLContext.getInstance("TLS");
        Intrinsics.checkNotNullExpressionValue((Object)sSLContext, (String)"SSLContext.getInstance(\"TLS\")");
        SSLContext sc = sSLContext;
        sc.init(null, new TrustManager[]{new TrustAllCerts()}, new SecureRandom());
        SSLSocketFactory sSLSocketFactory = sc.getSocketFactory();
        Intrinsics.checkNotNullExpressionValue((Object)sSLSocketFactory, (String)"sc.socketFactory");
        return sSLSocketFactory;
    }

    @NotNull
    public final HashMap<String, HashMap<String, Cookie>> getCookieStore() {
        return cookieStore;
    }

    @Nullable
    public final Request getLasthttpRequest() {
        return lasthttpRequest;
    }

    public final void setLasthttpRequest(@Nullable Request request) {
        lasthttpRequest = request;
    }

    @NotNull
    public final Pair<String, String> requestCSRFRequestHead(@NotNull String url, @NotNull String nameRegex, @NotNull String valueRegex, @Nullable Function0<Unit> loginaction2) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)nameRegex, (String)"nameRegex");
        Intrinsics.checkNotNullParameter((Object)valueRegex, (String)"valueRegex");
        String execute4 = OkhttpsKt.get(this.getHttpClient(), url, null, loginaction2);
        String string = "name=\"" + valueRegex + "\"\\s+content=\"(\\S+)\"";
        boolean bl = false;
        Regex toRegex1 = new Regex(string);
        String string2 = "name=\"" + nameRegex + "\"\\s+content=\"(\\S+)\"";
        boolean bl2 = false;
        Regex toRegex2 = new Regex(string2);
        MatchResult matchResult = Regex.find$default((Regex)toRegex1, (CharSequence)execute4, (int)0, (int)2, null);
        Intrinsics.checkNotNull((Object)matchResult);
        String v = (String)matchResult.getGroupValues().get(1);
        MatchResult matchResult2 = Regex.find$default((Regex)toRegex2, (CharSequence)execute4, (int)0, (int)2, null);
        Intrinsics.checkNotNull((Object)matchResult2);
        String k = (String)matchResult2.getGroupValues().get(1);
        logger.info(" csrf :" + k + "  -> " + v);
        return TuplesKt.to((Object)k, (Object)v);
    }

    public static /* synthetic */ Pair requestCSRFRequestHead$default(OkHttps okHttps, String string, String string2, String string3, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "_csrf_header";
        }
        if ((n & 4) != 0) {
            string3 = "_csrf";
        }
        if ((n & 8) != 0) {
            function0 = null;
        }
        return okHttps.requestCSRFRequestHead(string, string2, string3, (Function0<Unit>)function0);
    }

    public final void loginForPvia(@NotNull String user, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        String execute2 = OkhttpsKt.postForm$default(this.getHttpClient(), pviaURL + "/portal/login/ajax/postLoginData.do", MapsKt.mapOf((Pair)TuplesKt.to((Object)"userName", (Object)user)), null, null, 12, null);
        JSONObject parseObj1 = JSONUtil.parseObj((String)execute2);
        JSONObject parseObj = parseObj1.getJSONObject((Object)"data");
        String vcodestr = parseObj.getStr((Object)"vCode");
        String salt = parseObj.getStr((Object)"salt");
        String passtmp = SecureUtil.sha256((String)(SecureUtil.sha256((String)(password + salt)) + vcodestr));
        boolean bl = false;
        HashMap formBodyLogin = new HashMap();
        ((Map)formBodyLogin).put("userName", user);
        Map map = formBodyLogin;
        String string = passtmp;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"passtmp");
        map.put("password", string);
        ((Map)formBodyLogin).put("serviceUrl", pviaURL + "/portal/cas/loginPage?service=" + pviaURL + "/portal");
        ((Map)formBodyLogin).put("imageCode", "");
        Map map2 = formBodyLogin;
        String string2 = parseObj.getStr((Object)"codeId");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"parseObj.getStr(\"codeId\")");
        map2.put("codeId", string2);
        ((Map)formBodyLogin).put("userType", "0");
        ((Map)formBodyLogin).put("lang", "zh_CN");
        String execute3 = OkhttpsKt.postForm$default(this.getHttpClient(), pviaURL + "/portal/login/ajax/submit.do", formBodyLogin, null, null, 12, null);
        boolean bl2 = false;
        System.out.println((Object)execute3);
        String url2 = JSONUtil.parseObj((String)execute3).getStr((Object)"data").toString();
        CharSequence charSequence = url2;
        boolean bl3 = false;
        boolean bl4 = false;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            logger.info("\u767b\u9646\u6210\u529f");
        } else {
            logger.error("\u767b\u9646\u5931\u8d25");
        }
        Response execute5 = this.getHttpClient().newCall(new Request.Builder().url(url2).build()).execute();
        execute5.close();
    }

    private OkHttps() {
    }

    static {
        OkHttps okHttps;
        INSTANCE = okHttps = new OkHttps();
        pviaURL = "https://1.1.1.1:443";
        httpClient$delegate = LazyKt.lazy((Function0)httpClient.2.INSTANCE);
        logger = LoggerFactory.getLogger(OkHttps.class);
        cookieStore = new HashMap();
    }

    public static final /* synthetic */ Logger access$getLogger$p(OkHttps $this) {
        OkHttps okHttps = $this;
        return logger;
    }

    public static final /* synthetic */ SSLSocketFactory access$createSSLSocketFactory(OkHttps $this) {
        return $this.createSSLSocketFactory();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016\u00a2\u0006\u0002\u0010\nJ%\u0010\u000b\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/github/jchanghong/http/OkHttps$TrustAllCerts;", "Ljavax/net/ssl/X509TrustManager;", "()V", "checkClientTrusted", "", "chain", "", "Ljava/security/cert/X509Certificate;", "authType", "", "([Ljava/security/cert/X509Certificate;Ljava/lang/String;)V", "checkServerTrusted", "getAcceptedIssuers", "()[Ljava/security/cert/X509Certificate;", "kotlin-lib"})
    private static final class TrustAllCerts
    implements X509TrustManager {
        @Override
        public void checkClientTrusted(@NotNull X509Certificate[] chain, @Nullable String authType) {
            Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        }

        @Override
        public void checkServerTrusted(@NotNull X509Certificate[] chain, @Nullable String authType) {
            Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        }

        @Override
        @NotNull
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/github/jchanghong/http/OkHttps$TrustAllHostnameVerifier;", "Ljavax/net/ssl/HostnameVerifier;", "()V", "verify", "", "hostname", "", "session", "Ljavax/net/ssl/SSLSession;", "kotlin-lib"})
    private static final class TrustAllHostnameVerifier
    implements HostnameVerifier {
        @Override
        public boolean verify(@Nullable String hostname, @Nullable SSLSession session) {
            OkHttps.access$getLogger$p(INSTANCE).info(Intrinsics.stringPlus((String)hostname, (Object)String.valueOf(session)));
            return true;
        }
    }
}

