/*
 * Decompiled with CFR 0.152.
 */
package com.github.jchanghong.gson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.github.jchanghong.kotlin.DatesKt;
import java.util.Date;
import kotlin.Metadata;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/github/jchanghong/gson/JacksonModel2;", "Lcom/fasterxml/jackson/databind/module/SimpleModule;", "()V", "kotlin-lib-min"})
public final class JacksonModel2
extends SimpleModule {
    public JacksonModel2() {
        Class<Date> clazz = Date.class;
        StdDeserializer<Date> value12 = new StdDeserializer<Date>(clazz){

            @Nullable
            public Date deserialize(@Nullable JsonParser parser, @Nullable DeserializationContext ctxt) {
                JsonParser jsonParser = parser;
                if (jsonParser == null) {
                    return null;
                }
                if (parser.getCurrentToken() == JsonToken.VALUE_NULL) {
                    return null;
                }
                if (parser.getCurrentToken() == JsonToken.VALUE_NUMBER_INT) {
                    return new Date(parser.getLongValue());
                }
                String toString = parser.getValueAsString();
                Date toLocalDateTime = DatesKt.toDateJdk7OrNull(toString);
                return toLocalDateTime;
            }
        };
        this.addDeserializer(Date.class, (JsonDeserializer)value12);
    }
}

