/*
 * Decompiled with CFR 0.152.
 */
package com.github.jchanghong.file;

import cn.hutool.core.io.FileUtil;
import com.github.jchanghong.log.KStaticLogKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J/\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\r\"\u00020\u0004\u00a2\u0006\u0002\u0010\u000eJ\u001a\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00042\b\b\u0002\u0010\u0011\u001a\u00020\u0004H\u0007J\f\u0010\u0012\u001a\u00020\t*\u00020\u0006H\u0002\u00a8\u0006\u0013"}, d2={"Lcom/github/jchanghong/file/FileHelper;", "", "()V", "compareContent", "", "file1", "Ljava/io/File;", "file2", "copyFiles", "", "root", "destPath", "pathRegex", "", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "removeMavenLastAndRemoteFiles", "path", "group", "myDelete", "kotlin-lib-min"})
public final class FileHelper {
    @NotNull
    public static final FileHelper INSTANCE = new FileHelper();

    private FileHelper() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String compareContent(@NotNull File file1, @NotNull File file2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)file1, (String)"file1");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file2");
        Iterable $this$map$iv = FilesKt.readLines$default((File)file1, null, (int)1, null);
        boolean $i$f$map = false;
        Object object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void var13_15 = it;
            boolean bl2 = false;
            void v0 = var13_15;
            if (v0 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String string2 = ((Object)StringsKt.trim((CharSequence)((CharSequence)v0))).toString();
            collection.add(string2);
        }
        HashSet set1 = CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv));
        List lines2 = FilesKt.readLines$default((File)file2, null, (int)1, null);
        StringBuilder builder = new StringBuilder();
        builder.append("\u5927\u5c0f\u5206\u522b\u662f " + set1.size() + ' ' + lines2.size() + " \n");
        object = lines2.iterator();
        while (object.hasNext()) {
            String l;
            String string = l = (String)object.next();
            boolean bl = false;
            String string3 = string;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            if (set1.contains(((Object)StringsKt.trim((CharSequence)string3)).toString())) continue;
            builder.append(Intrinsics.stringPlus((String)l, (Object)"\n"));
        }
        object = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"builder.toString()");
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public final void copyFiles(@NotNull String root, @NotNull String destPath, String ... pathRegex) {
        Object object;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)destPath, (String)"destPath");
        Intrinsics.checkNotNullParameter((Object)pathRegex, (String)"pathRegex");
        String[] $this$map$iv = pathRegex;
        boolean $i$f$map2 = false;
        String[] stringArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            object = item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void var16_25 = it;
            boolean bl2 = false;
            Regex regex = new Regex((String)var16_25);
            collection.add(regex);
        }
        List map = (List)destination$iv$iv;
        File desp = new File(destPath);
        if (!FileUtil.isDirectory((String)root)) {
            String $i$f$map2 = Intrinsics.stringPlus((String)root, (Object)" \u4e0d\u662f\u76ee\u5f55");
            boolean $this$mapTo$iv$iv2 = false;
            throw (Throwable)new IllegalStateException($i$f$map2.toString());
        }
        Sequence $this$forEach$iv = (Sequence)FilesKt.walkBottomUp((File)new File(root));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Regex firstOrNull;
            Object v1;
            File it;
            block4: {
                it = (File)element$iv;
                boolean bl = false;
                if (!it.isFile()) continue;
                Iterable $this$firstOrNull$iv = map;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv2 : $this$firstOrNull$iv) {
                    Regex regex = (Regex)element$iv2;
                    boolean bl3 = false;
                    String string = it.getAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.absolutePath");
                    Object object2 = Regex.find$default((Regex)regex, (CharSequence)string, (int)0, (int)2, null);
                    object2 = object2 == null ? null : object2.getGroupValues();
                    boolean bl4 = false;
                    boolean bl5 = false;
                    boolean bl6 = !(object2 == null || object2.isEmpty());
                    if (!bl6) continue;
                    v1 = element$iv2;
                    break block4;
                }
                v1 = null;
            }
            if ((firstOrNull = (Regex)v1) == null) continue;
            String $i$f$firstOrNull = it.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)$i$f$firstOrNull, (String)"it.absolutePath");
            String removePrefix = StringsKt.removePrefix((String)StringsKt.removePrefix((String)StringsKt.removePrefix((String)$i$f$firstOrNull, (CharSequence)root), (CharSequence)"/"), (CharSequence)"\\");
            File target = new File(desp, removePrefix);
            object = it.getAbsolutePath() + "-> " + target.getAbsolutePath();
            boolean bl = false;
            System.out.println(object);
            FilesKt.copyTo$default((File)it, (File)target, (boolean)true, (int)0, (int)4, null);
        }
    }

    private final void myDelete(File $this$myDelete) {
        if ($this$myDelete.isDirectory()) {
            return;
        }
        String string = $this$myDelete.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this.name");
        boolean bl = false;
        String name = ((Object)StringsKt.trimEnd((CharSequence)string)).toString();
        if (StringsKt.endsWith$default((String)name, (String)".lastUpdated", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)name, (String)"_remote.repositories", (boolean)false, (int)2, null)) {
            $this$myDelete.delete();
            KStaticLogKt.kInfo(Intrinsics.stringPlus((String)$this$myDelete.getAbsolutePath(), (Object)"\u5df2\u5220\u9664"), new Object[0]);
        }
    }

    @JvmOverloads
    public final void removeMavenLastAndRemoteFiles(@NotNull String path, @NotNull String group) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        File parent = new File(path);
        if (!parent.exists() || parent.isFile()) {
            String string = Intrinsics.stringPlus((String)path, (Object)"\u76ee\u5f55\u4e0d\u5b58\u5728");
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Object object = (String[])group;
        boolean bl = false;
        if (object.length() > 0 && (!(parent = new File(parent, CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)group, (String[])(object = new String[]{"."}), (boolean)false, (int)0, (int)6, null), (CharSequence)"/", null, null, (int)0, null, null, (int)62, null))).exists() || parent.isFile())) {
            object = Intrinsics.stringPlus((String)path, (Object)"\u76ee\u5f55\u4e0d\u5b58\u5728");
            bl = false;
            throw (Throwable)new IllegalStateException(object.toString());
        }
        Sequence $this$forEach$iv = (Sequence)FilesKt.walkTopDown((File)parent);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl2 = false;
            INSTANCE.myDelete(it);
        }
    }

    public static /* synthetic */ void removeMavenLastAndRemoteFiles$default(FileHelper fileHelper, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "";
        }
        fileHelper.removeMavenLastAndRemoteFiles(string, string2);
    }

    @JvmOverloads
    public final void removeMavenLastAndRemoteFiles(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        FileHelper.removeMavenLastAndRemoteFiles$default(this, path, null, 2, null);
    }
}

