/*
 * Decompiled with CFR 0.152.
 */
package com.github.jchanghong.database;

import cn.hutool.db.meta.Column;
import cn.hutool.db.meta.JdbcType;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import com.github.jchanghong.str.StrHelperKt;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Locale;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\n\u0010\u001e\u001a\u0004\u0018\u00010\u0011H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\t\"\u0004\b\r\u0010\u000bR\u001a\u0010\u000e\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\t\"\u0004\b\u000f\u0010\u000bR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0016\u001a\n \u0018*\u0004\u0018\u00010\u00170\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0013\"\u0004\b\u001b\u0010\u0015\u00a8\u0006\u001f"}, d2={"Lcom/github/jchanghong/database/DBColumn;", "", "column", "Lcn/hutool/db/meta/Column;", "(Lcn/hutool/db/meta/Column;)V", "getColumn", "()Lcn/hutool/db/meta/Column;", "isJson", "", "()Z", "setJson", "(Z)V", "isJsonB", "setJsonB", "isUUID", "setUUID", "javaTypeName", "", "getJavaTypeName", "()Ljava/lang/String;", "setJavaTypeName", "(Ljava/lang/String;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "propertyName", "getPropertyName", "setPropertyName", "configJavaTypeName", "", "configJavaTypeNameOther", "kotlin-lib-min"})
public final class DBColumn {
    @NotNull
    private final Column column;
    private final Logger logger;
    private boolean isJsonB;
    private boolean isJson;
    private boolean isUUID;
    @NotNull
    private String javaTypeName;
    @NotNull
    private String propertyName;

    public DBColumn(@NotNull Column column) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        this.column = column;
        this.logger = LoggerFactory.getLogger(DBColumn.class);
        this.javaTypeName = "";
        this.propertyName = "";
        String string = this.column.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"column.name");
        this.propertyName = StrHelperKt.toCamelCase(string);
        if (this.column.getTypeEnum() == JdbcType.OTHER && Intrinsics.areEqual((Object)"jsonb", (Object)this.column.getTypeName())) {
            this.isJsonB = true;
        }
        if (this.column.getTypeEnum() == JdbcType.OTHER && Intrinsics.areEqual((Object)"json", (Object)this.column.getTypeName())) {
            this.isJson = true;
        }
        if (this.column.getTypeEnum() == JdbcType.OTHER && Intrinsics.areEqual((Object)"uuid", (Object)this.column.getTypeName())) {
            this.isUUID = true;
        }
        this.configJavaTypeName();
    }

    @NotNull
    public final Column getColumn() {
        return this.column;
    }

    public final boolean isJsonB() {
        return this.isJsonB;
    }

    public final void setJsonB(boolean bl) {
        this.isJsonB = bl;
    }

    public final boolean isJson() {
        return this.isJson;
    }

    public final void setJson(boolean bl) {
        this.isJson = bl;
    }

    public final boolean isUUID() {
        return this.isUUID;
    }

    public final void setUUID(boolean bl) {
        this.isUUID = bl;
    }

    @NotNull
    public final String getJavaTypeName() {
        return this.javaTypeName;
    }

    public final void setJavaTypeName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.javaTypeName = string;
    }

    @NotNull
    public final String getPropertyName() {
        return this.propertyName;
    }

    public final void setPropertyName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.propertyName = string;
    }

    private final void configJavaTypeName() {
        String string;
        Object object = this.column.getTypeEnum();
        int n = object == null ? -1 : WhenMappings.$EnumSwitchMapping$0[object.ordinal()];
        switch (n) {
            case 1: {
                string = Reflection.getOrCreateKotlinClass(JSONArray.class).getSimpleName();
                break;
            }
            case 2: {
                String string2 = this.column.getTypeName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"column.typeName");
                if (StringsKt.contains$default((CharSequence)string2, (CharSequence)"bool", (boolean)false, (int)2, null)) {
                    string = Reflection.getOrCreateKotlinClass(Boolean.TYPE).getSimpleName();
                    break;
                }
                string = Reflection.getOrCreateKotlinClass(Boolean.TYPE).getSimpleName();
                break;
            }
            case 3: {
                string = Reflection.getOrCreateKotlinClass(Integer.TYPE).getSimpleName();
                break;
            }
            case 4: {
                string = Reflection.getOrCreateKotlinClass(Integer.TYPE).getSimpleName();
                break;
            }
            case 5: {
                string = Reflection.getOrCreateKotlinClass(Integer.TYPE).getSimpleName();
                break;
            }
            case 6: {
                string = Reflection.getOrCreateKotlinClass(Long.TYPE).getSimpleName();
                break;
            }
            case 7: {
                string = Reflection.getOrCreateKotlinClass(BigDecimal.class).getSimpleName();
                break;
            }
            case 8: {
                string = Reflection.getOrCreateKotlinClass(BigDecimal.class).getSimpleName();
                break;
            }
            case 9: {
                string = Reflection.getOrCreateKotlinClass(BigDecimal.class).getSimpleName();
                break;
            }
            case 10: {
                string = Reflection.getOrCreateKotlinClass(BigDecimal.class).getSimpleName();
                break;
            }
            case 11: {
                string = Reflection.getOrCreateKotlinClass(BigDecimal.class).getSimpleName();
                break;
            }
            case 12: {
                string = Reflection.getOrCreateKotlinClass(Character.TYPE).getSimpleName();
                break;
            }
            case 13: {
                String string2 = this.column.getTypeName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"column.typeName");
                boolean bl = false;
                String string3 = string2.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
                if (StringsKt.contains$default((CharSequence)string3, (CharSequence)"uuid", (boolean)false, (int)2, null)) {
                    string = Reflection.getOrCreateKotlinClass(UUID.class).getQualifiedName();
                    break;
                }
                string = Reflection.getOrCreateKotlinClass(String.class).getSimpleName();
                break;
            }
            case 14: {
                string = Reflection.getOrCreateKotlinClass(String.class).getSimpleName();
                break;
            }
            case 15: {
                string = Reflection.getOrCreateKotlinClass(LocalDate.class).getQualifiedName();
                break;
            }
            case 16: {
                string = Reflection.getOrCreateKotlinClass(LocalTime.class).getSimpleName();
                break;
            }
            case 17: {
                string = Reflection.getOrCreateKotlinClass(Date.class).getSimpleName();
                break;
            }
            case 18: {
                String string2 = this.column.getTypeName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"column.typeName");
                boolean bl = false;
                String string4 = string2.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
                if (StringsKt.contains$default((CharSequence)string4, (CharSequence)"uuid", (boolean)false, (int)2, null)) {
                    string = Reflection.getOrCreateKotlinClass(UUID.class).getQualifiedName();
                    break;
                }
                string = Reflection.getOrCreateKotlinClass(byte[].class).getSimpleName();
                break;
            }
            case 19: {
                string = Reflection.getOrCreateKotlinClass(byte[].class).getSimpleName();
                break;
            }
            case 20: {
                string = Reflection.getOrCreateKotlinClass(byte[].class).getSimpleName();
                break;
            }
            case 21: {
                string = Reflection.getOrCreateKotlinClass(Object.class).getSimpleName();
                break;
            }
            case 22: {
                string = this.configJavaTypeNameOther();
                break;
            }
            case 23: {
                string = Reflection.getOrCreateKotlinClass(byte[].class).getSimpleName();
                break;
            }
            case 24: {
                string = Reflection.getOrCreateKotlinClass(String.class).getSimpleName();
                break;
            }
            case 25: {
                string = Reflection.getOrCreateKotlinClass(Boolean.TYPE).getSimpleName();
                break;
            }
            case 26: {
                string = Reflection.getOrCreateKotlinClass(Object.class).getSimpleName();
                break;
            }
            case 27: {
                string = Reflection.getOrCreateKotlinClass(Object.class).getSimpleName();
                break;
            }
            case 28: {
                string = Reflection.getOrCreateKotlinClass(String.class).getSimpleName();
                break;
            }
            case 29: {
                string = Reflection.getOrCreateKotlinClass(String.class).getSimpleName();
                break;
            }
            case 30: {
                string = Reflection.getOrCreateKotlinClass(String.class).getSimpleName();
                break;
            }
            case 31: {
                string = Reflection.getOrCreateKotlinClass(Object.class).getSimpleName();
                break;
            }
            case 32: {
                string = Reflection.getOrCreateKotlinClass(Object.class).getSimpleName();
                break;
            }
            case 33: {
                string = Reflection.getOrCreateKotlinClass(Object.class).getSimpleName();
                break;
            }
            case 34: {
                string = Reflection.getOrCreateKotlinClass(Object.class).getSimpleName();
                break;
            }
            case 35: {
                string = Reflection.getOrCreateKotlinClass(Object.class).getSimpleName();
                break;
            }
            case 36: {
                string = Reflection.getOrCreateKotlinClass(Long.TYPE).getSimpleName();
                break;
            }
            case 37: {
                string = Reflection.getOrCreateKotlinClass(String.class).getSimpleName();
                break;
            }
            case 38: {
                string = Reflection.getOrCreateKotlinClass(String.class).getSimpleName();
                break;
            }
            case 39: {
                string = Reflection.getOrCreateKotlinClass(OffsetDateTime.class).getQualifiedName();
                break;
            }
            case 40: {
                string = Reflection.getOrCreateKotlinClass(OffsetTime.class).getSimpleName();
                break;
            }
            case 41: {
                string = Reflection.getOrCreateKotlinClass(ZonedDateTime.class).getSimpleName();
                break;
            }
            default: {
                string = Reflection.getOrCreateKotlinClass(Object.class).getSimpleName();
            }
        }
        String avaTypeName1 = string;
        object = avaTypeName1;
        this.javaTypeName = object == null ? "Any" : object;
        this.logger.info("configJavaTypeName() typeName:" + this.column.getTypeName() + " typeEnum:" + this.column.getTypeEnum().name() + " javaTypeName:" + this.javaTypeName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String configJavaTypeNameOther() {
        String string = this.column.getTypeName();
        if (string == null) return "Any";
        int n = -1;
        switch (string.hashCode()) {
            case 101429370: {
                if (string.equals("jsonb")) {
                    n = 1;
                }
                break;
            }
            case 3271912: {
                if (string.equals("json")) {
                    n = 2;
                }
                break;
            }
            case 3601339: {
                if (string.equals("uuid")) {
                    n = 3;
                }
                break;
            }
        }
        switch (n) {
            case 2: {
                String string2 = Reflection.getOrCreateKotlinClass(JSONObject.class).getSimpleName();
                return string2;
            }
            case 1: {
                String string2 = Reflection.getOrCreateKotlinClass(JSONObject.class).getSimpleName();
                return string2;
            }
            case 3: {
                String string2 = Reflection.getOrCreateKotlinClass(UUID.class).getSimpleName();
                return string2;
            }
            default: {
                return "Any";
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JdbcType.values().length];
            nArray[JdbcType.ARRAY.ordinal()] = 1;
            nArray[JdbcType.BIT.ordinal()] = 2;
            nArray[JdbcType.TINYINT.ordinal()] = 3;
            nArray[JdbcType.SMALLINT.ordinal()] = 4;
            nArray[JdbcType.INTEGER.ordinal()] = 5;
            nArray[JdbcType.BIGINT.ordinal()] = 6;
            nArray[JdbcType.FLOAT.ordinal()] = 7;
            nArray[JdbcType.REAL.ordinal()] = 8;
            nArray[JdbcType.DOUBLE.ordinal()] = 9;
            nArray[JdbcType.NUMERIC.ordinal()] = 10;
            nArray[JdbcType.DECIMAL.ordinal()] = 11;
            nArray[JdbcType.CHAR.ordinal()] = 12;
            nArray[JdbcType.VARCHAR.ordinal()] = 13;
            nArray[JdbcType.LONGVARCHAR.ordinal()] = 14;
            nArray[JdbcType.DATE.ordinal()] = 15;
            nArray[JdbcType.TIME.ordinal()] = 16;
            nArray[JdbcType.TIMESTAMP.ordinal()] = 17;
            nArray[JdbcType.BINARY.ordinal()] = 18;
            nArray[JdbcType.VARBINARY.ordinal()] = 19;
            nArray[JdbcType.LONGVARBINARY.ordinal()] = 20;
            nArray[JdbcType.NULL.ordinal()] = 21;
            nArray[JdbcType.OTHER.ordinal()] = 22;
            nArray[JdbcType.BLOB.ordinal()] = 23;
            nArray[JdbcType.CLOB.ordinal()] = 24;
            nArray[JdbcType.BOOLEAN.ordinal()] = 25;
            nArray[JdbcType.CURSOR.ordinal()] = 26;
            nArray[JdbcType.UNDEFINED.ordinal()] = 27;
            nArray[JdbcType.NVARCHAR.ordinal()] = 28;
            nArray[JdbcType.NCHAR.ordinal()] = 29;
            nArray[JdbcType.NCLOB.ordinal()] = 30;
            nArray[JdbcType.STRUCT.ordinal()] = 31;
            nArray[JdbcType.JAVA_OBJECT.ordinal()] = 32;
            nArray[JdbcType.DISTINCT.ordinal()] = 33;
            nArray[JdbcType.REF.ordinal()] = 34;
            nArray[JdbcType.DATALINK.ordinal()] = 35;
            nArray[JdbcType.ROWID.ordinal()] = 36;
            nArray[JdbcType.LONGNVARCHAR.ordinal()] = 37;
            nArray[JdbcType.SQLXML.ordinal()] = 38;
            nArray[JdbcType.DATETIMEOFFSET.ordinal()] = 39;
            nArray[JdbcType.TIME_WITH_TIMEZONE.ordinal()] = 40;
            nArray[JdbcType.TIMESTAMP_WITH_TIMEZONE.ordinal()] = 41;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

