/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.reflectionmodel;

import com.github.javaparser.ast.AccessSpecifier;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import com.github.javaparser.resolution.types.ResolvedArrayType;
import com.github.javaparser.resolution.types.ResolvedPrimitiveType;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.resolution.types.ResolvedTypeVariable;
import com.github.javaparser.resolution.types.ResolvedVoidType;
import com.github.javaparser.resolution.types.ResolvedWildcard;
import com.github.javaparser.symbolsolver.model.resolution.TypeSolver;
import com.github.javaparser.symbolsolver.model.typesystem.ReferenceTypeImpl;
import com.github.javaparser.symbolsolver.reflectionmodel.ReflectionAnnotationDeclaration;
import com.github.javaparser.symbolsolver.reflectionmodel.ReflectionClassDeclaration;
import com.github.javaparser.symbolsolver.reflectionmodel.ReflectionEnumDeclaration;
import com.github.javaparser.symbolsolver.reflectionmodel.ReflectionInterfaceDeclaration;
import com.github.javaparser.symbolsolver.reflectionmodel.ReflectionTypeParameter;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;

public class ReflectionFactory {
    public static ResolvedReferenceTypeDeclaration typeDeclarationFor(Class<?> clazz, TypeSolver typeSolver) {
        if (clazz.isArray()) {
            throw new IllegalArgumentException("No type declaration available for an Array");
        }
        if (clazz.isPrimitive()) {
            throw new IllegalArgumentException();
        }
        if (clazz.isAnnotation()) {
            return new ReflectionAnnotationDeclaration(clazz, typeSolver);
        }
        if (clazz.isInterface()) {
            return new ReflectionInterfaceDeclaration(clazz, typeSolver);
        }
        if (clazz.isEnum()) {
            return new ReflectionEnumDeclaration(clazz, typeSolver);
        }
        return new ReflectionClassDeclaration(clazz, typeSolver);
    }

    public static ResolvedType typeUsageFor(Type type, TypeSolver typeSolver) {
        if (type instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)type;
            boolean declaredOnClass = tv.getGenericDeclaration() instanceof Type;
            ReflectionTypeParameter typeParameter = new ReflectionTypeParameter(tv, declaredOnClass, typeSolver);
            return new ResolvedTypeVariable((ResolvedTypeParameterDeclaration)typeParameter);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            ResolvedReferenceType rawType = ReflectionFactory.typeUsageFor(pt.getRawType(), typeSolver).asReferenceType();
            ArrayList<Type> actualTypes = new ArrayList<Type>();
            actualTypes.addAll(Arrays.asList(pt.getActualTypeArguments()));
            rawType = rawType.transformTypeParameters(tp -> ReflectionFactory.typeUsageFor((Type)actualTypes.remove(0), typeSolver)).asReferenceType();
            return rawType;
        }
        if (type instanceof Class) {
            Class c = (Class)type;
            if (c.isPrimitive()) {
                if (c.getName().equals(Void.TYPE.getName())) {
                    return ResolvedVoidType.INSTANCE;
                }
                return ResolvedPrimitiveType.byName((String)c.getName());
            }
            if (c.isArray()) {
                return new ResolvedArrayType(ReflectionFactory.typeUsageFor(c.getComponentType(), typeSolver));
            }
            return new ReferenceTypeImpl(ReflectionFactory.typeDeclarationFor(c, typeSolver), typeSolver);
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            return new ResolvedArrayType(ReflectionFactory.typeUsageFor(genericArrayType.getGenericComponentType(), typeSolver));
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            if (wildcardType.getLowerBounds().length <= 0 || wildcardType.getUpperBounds().length <= 0 || wildcardType.getUpperBounds().length != 1 || wildcardType.getUpperBounds()[0].getTypeName().equals("java.lang.Object")) {
                // empty if block
            }
            if (wildcardType.getLowerBounds().length > 0) {
                if (wildcardType.getLowerBounds().length > 1) {
                    throw new UnsupportedOperationException();
                }
                return ResolvedWildcard.superBound((ResolvedType)ReflectionFactory.typeUsageFor(wildcardType.getLowerBounds()[0], typeSolver));
            }
            if (wildcardType.getUpperBounds().length > 0) {
                if (wildcardType.getUpperBounds().length > 1) {
                    throw new UnsupportedOperationException();
                }
                return ResolvedWildcard.extendsBound((ResolvedType)ReflectionFactory.typeUsageFor(wildcardType.getUpperBounds()[0], typeSolver));
            }
            return ResolvedWildcard.UNBOUNDED;
        }
        throw new UnsupportedOperationException(type.getClass().getCanonicalName() + " " + type);
    }

    static AccessSpecifier modifiersToAccessLevel(int modifiers) {
        if (Modifier.isPublic(modifiers)) {
            return AccessSpecifier.PUBLIC;
        }
        if (Modifier.isProtected(modifiers)) {
            return AccessSpecifier.PROTECTED;
        }
        if (Modifier.isPrivate(modifiers)) {
            return AccessSpecifier.PRIVATE;
        }
        return AccessSpecifier.DEFAULT;
    }
}

