/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.type;

import com.github.javaparser.Range;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.nodeTypes.NodeWithAnnotations;
import com.github.javaparser.ast.nodeTypes.NodeWithSimpleName;
import com.github.javaparser.ast.nodeTypes.NodeWithTypeArguments;
import com.github.javaparser.ast.observing.ObservableProperty;
import com.github.javaparser.ast.type.PrimitiveType;
import com.github.javaparser.ast.type.ReferenceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.utils.Utils;
import java.util.Optional;

public final class ClassOrInterfaceType
extends ReferenceType<ClassOrInterfaceType>
implements NodeWithSimpleName<ClassOrInterfaceType>,
NodeWithAnnotations<ClassOrInterfaceType>,
NodeWithTypeArguments<ClassOrInterfaceType> {
    private ClassOrInterfaceType scope;
    private SimpleName name;
    private NodeList<Type<?>> typeArguments;

    public ClassOrInterfaceType() {
        this(null, null, new SimpleName(), null);
    }

    public ClassOrInterfaceType(String name) {
        this(null, null, new SimpleName(name), null);
    }

    public ClassOrInterfaceType(ClassOrInterfaceType scope, String name) {
        this(null, scope, new SimpleName(name), null);
    }

    public ClassOrInterfaceType(Range range, ClassOrInterfaceType scope, SimpleName name, NodeList<Type<?>> typeArguments) {
        super(range);
        this.setScope(scope);
        this.setName(name);
        this.setTypeArguments((NodeList)typeArguments);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    @Override
    public SimpleName getName() {
        return this.name;
    }

    public Optional<ClassOrInterfaceType> getScope() {
        return Optional.ofNullable(this.scope);
    }

    public boolean isBoxedType() {
        return PrimitiveType.unboxMap.containsKey(this.name);
    }

    public PrimitiveType toUnboxedType() throws UnsupportedOperationException {
        if (!this.isBoxedType()) {
            throw new UnsupportedOperationException(this.name + " isn't a boxed type.");
        }
        return new PrimitiveType(PrimitiveType.unboxMap.get(this.name));
    }

    @Override
    public ClassOrInterfaceType setName(SimpleName name) {
        this.notifyPropertyChange(ObservableProperty.NAME, this.name, name);
        this.name = Utils.assertNotNull(name);
        return this;
    }

    public ClassOrInterfaceType setScope(ClassOrInterfaceType scope) {
        this.notifyPropertyChange(ObservableProperty.TYPE_ARGUMENTS, this.typeArguments, this.typeArguments);
        this.scope = scope;
        this.setAsParentNodeOf(this.scope);
        return this;
    }

    @Override
    public Optional<NodeList<Type<?>>> getTypeArguments() {
        return Optional.ofNullable(this.typeArguments);
    }

    @Override
    public ClassOrInterfaceType setTypeArguments(NodeList<Type<?>> typeArguments) {
        this.notifyPropertyChange(ObservableProperty.TYPE_ARGUMENTS, this.typeArguments, typeArguments);
        this.typeArguments = typeArguments;
        this.setAsParentNodeOf(this.typeArguments);
        return this;
    }
}

