/*
 * Copyright (c) 2015 Avast a.s., www.avast.com
 */
package cz.jalasoft.net.http;

import java.io.Closeable;

/**
 * An abstraction of a HTTP communication client that
 * triggers basic HTTP opeations.
 *
 * @author Jan Lastovicka (lastovicka@avast.com)
 * @since 2015-02-21
 */
public interface HttpClient extends Closeable {

    /**
     * Performs POST operation - sends a request and retrieves a response.
     * @param request a request tobe sent, must notbe null
     * @return a response, never null
     * @throws java.lang.IllegalArgumentException if request is null
     */
    HttpResponse post(HttpPostRequest request);
}
