/*
 * Decompiled with CFR 0.152.
 */
package org.mdedetrich.stripe.v1;

import akka.http.scaladsl.HttpExt;
import akka.http.scaladsl.model.ContentType;
import akka.http.scaladsl.model.ContentTypes$;
import akka.http.scaladsl.model.FormData$;
import akka.http.scaladsl.model.HttpEntity;
import akka.http.scaladsl.model.HttpEntity$;
import akka.http.scaladsl.model.HttpHeader;
import akka.http.scaladsl.model.HttpMessage;
import akka.http.scaladsl.model.HttpMessage$;
import akka.http.scaladsl.model.HttpMethod;
import akka.http.scaladsl.model.HttpMethods$;
import akka.http.scaladsl.model.HttpProtocol;
import akka.http.scaladsl.model.HttpRequest;
import akka.http.scaladsl.model.HttpRequest$;
import akka.http.scaladsl.model.HttpResponse;
import akka.http.scaladsl.model.RequestEntity;
import akka.http.scaladsl.model.Uri;
import akka.http.scaladsl.model.Uri$;
import akka.http.scaladsl.model.headers.Authorization;
import akka.http.scaladsl.model.headers.BasicHttpCredentials;
import akka.http.scaladsl.model.headers.HttpCredentials;
import akka.http.scaladsl.model.headers.RawHeader;
import akka.http.scaladsl.unmarshalling.Unmarshal$;
import akka.stream.Materializer;
import com.typesafe.scalalogging.Logger;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.DecodingFailure;
import io.circe.Json;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoField;
import java.util.UUID;
import org.mdedetrich.akka.http.support.CirceHttpSupport$;
import org.mdedetrich.stripe.Config$;
import org.mdedetrich.stripe.IdempotencyKey;
import org.mdedetrich.stripe.InvalidJsonModelException;
import org.mdedetrich.stripe.MaxNumberOfRetries;
import org.mdedetrich.stripe.PostParams$;
import org.mdedetrich.stripe.v1.DeleteResponse;
import org.mdedetrich.stripe.v1.DeleteResponse$;
import org.mdedetrich.stripe.v1.Errors;
import org.mdedetrich.stripe.v1.Errors$;
import org.mdedetrich.stripe.v1.Errors$Type$ApiConnectionError$;
import org.mdedetrich.stripe.v1.Errors$Type$ApiError$;
import org.mdedetrich.stripe.v1.ListFilterInput;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;

public final class package$ {
    public static final package$ MODULE$ = new package$();
    private static final String idempotencyKeyHeader = "Idempotency-Key";
    private static final String stripeAccountHeader;
    private static final String stripeVersionHeader;
    private static volatile byte bitmap$init$0;

    static {
        bitmap$init$0 = (byte)(bitmap$init$0 | 2);
        stripeAccountHeader = "Stripe-Account";
        bitmap$init$0 = (byte)(bitmap$init$0 | 4);
        stripeVersionHeader = "Stripe-Version";
        bitmap$init$0 = (byte)(bitmap$init$0 | 8);
    }

    public Future<Try<DeleteResponse>> createRequestDELETE(Uri finalUrl, Option<IdempotencyKey> idempotencyKey, Logger logger, HttpExt client, Materializer materializer, ExecutionContext executionContext, String apiKey) {
        List<HttpHeader> headers = this.buildHeaders(apiKey, (Option<String>)None$.MODULE$, idempotencyKey);
        Uri x$1 = finalUrl;
        HttpMethod x$2 = HttpMethods$.MODULE$.DELETE();
        List<HttpHeader> x$32 = headers;
        RequestEntity x$4 = HttpRequest$.MODULE$.apply$default$4();
        HttpProtocol x$5 = HttpRequest$.MODULE$.apply$default$5();
        HttpRequest req = HttpRequest$.MODULE$.apply(x$2, x$1, x$32, x$4, x$5);
        return client.singleRequest(req, client.singleRequest$default$2(), client.singleRequest$default$3(), client.singleRequest$default$4()).map((Function1 & Serializable)response -> {
            BoxedUnit boxedUnit;
            if (logger.underlying().isDebugEnabled()) {
                logger.underlying().debug("Received response {}", response);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit x$1 = boxedUnit;
            return new Tuple2(response, (Object)x$1);
        }, executionContext).flatMap((Function1 & Serializable)x$3 -> {
            Tuple2 tuple2 = x$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            HttpResponse response = (HttpResponse)tuple2._1();
            Future future = MODULE$.parseStripeServerError(response, finalUrl, (Option<Map<String, String>>)None$.MODULE$, (Option<Json>)None$.MODULE$, logger, executionContext, materializer, DeleteResponse$.MODULE$.deleteResponseDecoder()).map((Function1 & Serializable)parsed -> {
                Success success;
                Either either = parsed;
                if (either instanceof Right) {
                    Right right = (Right)either;
                    Try triedDeleteResponse = (Try)right.value();
                    success = new Success(triedDeleteResponse.get());
                } else if (either instanceof Left) {
                    Left left = (Left)either;
                    Errors.Error error = (Errors.Error)left.value();
                    success = new Failure((Throwable)error);
                } else {
                    throw new MatchError((Object)either);
                }
                Success result = success;
                return new Tuple2(parsed, (Object)result);
            }, executionContext).map((Function1 & Serializable)x$2 -> {
                Try result;
                Tuple2 tuple2 = x$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Try try_ = result = (Try)tuple2._2();
                return try_;
            }, executionContext);
            return future;
        }, executionContext);
    }

    public <M> Future<Try<M>> createRequestGET(Uri finalUrl, Logger logger, Option<String> stripeAccount, HttpExt client, Materializer materializer, ExecutionContext executionContext, Decoder<M> decoder, String apiKey) {
        List<HttpHeader> headers = this.buildHeaders(apiKey, stripeAccount, (Option<IdempotencyKey>)None$.MODULE$);
        Uri x$1 = finalUrl;
        HttpMethod x$2 = HttpMethods$.MODULE$.GET();
        List<HttpHeader> x$3 = headers;
        RequestEntity x$4 = HttpRequest$.MODULE$.apply$default$4();
        HttpProtocol x$5 = HttpRequest$.MODULE$.apply$default$5();
        HttpRequest req = HttpRequest$.MODULE$.apply(x$2, x$1, x$3, x$4, x$5);
        return client.singleRequest(req, client.singleRequest$default$2(), client.singleRequest$default$3(), client.singleRequest$default$4()).map((Function1 & Serializable)response -> {
            BoxedUnit boxedUnit;
            if (logger.underlying().isDebugEnabled()) {
                logger.underlying().debug("Received response {}", response);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit x$4 = boxedUnit;
            return new Tuple2(response, (Object)x$4);
        }, executionContext).flatMap((Function1 & Serializable)x$6 -> {
            Tuple2 tuple2 = x$6;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            HttpResponse response = (HttpResponse)tuple2._1();
            Future future = MODULE$.parseStripeServerError(response, finalUrl, (Option<Map<String, String>>)None$.MODULE$, (Option<Json>)None$.MODULE$, logger, executionContext, materializer, decoder).map((Function1 & Serializable)parsed -> {
                Success success;
                Either either = parsed;
                if (either instanceof Right) {
                    Right right = (Right)either;
                    Try triedValue = (Try)right.value();
                    success = new Success(triedValue.get());
                } else if (either instanceof Left) {
                    Left left = (Left)either;
                    Errors.Error error = (Errors.Error)left.value();
                    success = new Failure((Throwable)error);
                } else {
                    throw new MatchError((Object)either);
                }
                Success result = success;
                return new Tuple2(parsed, (Object)result);
            }, executionContext).map((Function1 & Serializable)x$5 -> {
                Try result;
                Tuple2 tuple2 = x$5;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Try try_ = result = (Try)tuple2._2();
                return try_;
            }, executionContext);
            return future;
        }, executionContext);
    }

    public <M> Option<String> createRequestGET$default$3() {
        return None$.MODULE$;
    }

    public <M> Future<Try<M>> createRequestPOST(String finalUrl, Map<String, String> postFormParameters, Option<IdempotencyKey> idempotencyKey, Logger logger, Option<String> stripeAccount, HttpExt client, Materializer materializer, ExecutionContext executionContext, Decoder<M> decoder, String apiKey) {
        List<HttpHeader> headers = this.buildHeaders(apiKey, stripeAccount, idempotencyKey);
        Uri x$1 = Uri$.MODULE$.apply(finalUrl);
        RequestEntity x$2 = FormData$.MODULE$.apply(postFormParameters).toEntity();
        HttpMethod x$3 = HttpMethods$.MODULE$.POST();
        List<HttpHeader> x$4 = headers;
        HttpProtocol x$5 = HttpRequest$.MODULE$.apply$default$5();
        HttpRequest req = HttpRequest$.MODULE$.apply(x$3, x$1, x$4, x$2, x$5);
        return client.singleRequest(req, client.singleRequest$default$2(), client.singleRequest$default$3(), client.singleRequest$default$4()).map((Function1 & Serializable)response -> {
            BoxedUnit boxedUnit;
            if (logger.underlying().isDebugEnabled()) {
                logger.underlying().debug("Received response {}", response);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit x$7 = boxedUnit;
            return new Tuple2(response, (Object)x$7);
        }, executionContext).flatMap((Function1 & Serializable)x$9 -> {
            Tuple2 tuple2 = x$9;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            HttpResponse response = (HttpResponse)tuple2._1();
            Future future = MODULE$.parseStripeServerError(response, Uri$.MODULE$.apply(finalUrl), (Option<Map<String, String>>)new Some((Object)postFormParameters), (Option<Json>)None$.MODULE$, logger, executionContext, materializer, decoder).map((Function1 & Serializable)parsed -> {
                Success success;
                Either either = parsed;
                if (either instanceof Right) {
                    Right right = (Right)either;
                    Try triedValue = (Try)right.value();
                    success = new Success(triedValue.get());
                } else if (either instanceof Left) {
                    Left left = (Left)either;
                    Errors.Error error = (Errors.Error)left.value();
                    success = new Failure((Throwable)error);
                } else {
                    throw new MatchError((Object)either);
                }
                Success result = success;
                return new Tuple2(parsed, (Object)result);
            }, executionContext).map((Function1 & Serializable)x$8 -> {
                Try result;
                Tuple2 tuple2 = x$8;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Try try_ = result = (Try)tuple2._2();
                return try_;
            }, executionContext);
            return future;
        }, executionContext);
    }

    public <M> Option<String> createRequestPOST$default$5() {
        return None$.MODULE$;
    }

    public Uri listFilterInputToUri(ListFilterInput createdInput, Uri baseUrl, String key) {
        Uri uri;
        ListFilterInput listFilterInput = createdInput;
        if (listFilterInput instanceof ListFilterInput.Object) {
            ListFilterInput.Object object = (ListFilterInput.Object)listFilterInput;
            Map query = PostParams$.MODULE$.flatten((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(4).append(key).append("[gt]").toString()), (Object)object.gt().map((Function1 & Serializable)dateTime -> MODULE$.stripeDateTimeParamWrites((OffsetDateTime)dateTime))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(5).append(key).append("[gte]").toString()), (Object)object.gte().map((Function1 & Serializable)dateTime -> MODULE$.stripeDateTimeParamWrites((OffsetDateTime)dateTime))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(4).append(key).append("[lt]").toString()), (Object)object.lt().map((Function1 & Serializable)dateTime -> MODULE$.stripeDateTimeParamWrites((OffsetDateTime)dateTime))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(5).append(key).append("[lte]").toString()), (Object)object.lte().map((Function1 & Serializable)dateTime -> MODULE$.stripeDateTimeParamWrites((OffsetDateTime)dateTime)))})));
            uri = baseUrl.withQuery(Uri.Query$.MODULE$.apply(query));
        } else if (listFilterInput instanceof ListFilterInput.Timestamp) {
            ListFilterInput.Timestamp timestamp = (ListFilterInput.Timestamp)listFilterInput;
            uri = baseUrl.withQuery(Uri.Query$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)String.valueOf(key)), (Object)this.stripeDateTimeParamWrites(timestamp.timestamp()))})));
        } else {
            throw new MatchError((Object)listFilterInput);
        }
        return uri;
    }

    public String transformParam(String param) {
        return StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("_([a-z\\d])")).replaceAllIn((CharSequence)param, (Function1 & Serializable)m -> m.group(1).toUpperCase());
    }

    public String stripeDateTimeParamWrites(OffsetDateTime dateTime) {
        return ((Object)BoxesRunTime.boxToInteger((int)dateTime.get(ChronoField.OFFSET_SECONDS))).toString();
    }

    public <T> Future<T> handleIdempotent(Function0<Function1<Option<IdempotencyKey>, Future<Try<T>>>> request, int numberOfRetries, ExecutionContext executionContext) {
        Some idempotencyKey = new Some((Object)new IdempotencyKey(UUID.randomUUID().toString()));
        return this.handle((Future)((Function1)request.apply()).apply((Object)idempotencyKey), numberOfRetries, executionContext);
    }

    public <T> Future<T> handle(Future<Try<T>> request, int numberOfRetries, ExecutionContext executionContext) {
        return package$.responseBlockWithRetries$1(0, numberOfRetries, executionContext, request).flatMap((Function1 & Serializable)x0$1 -> {
            Future future;
            Try try_ = x0$1;
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                Object success2 = success.value();
                future = Future$.MODULE$.successful(success2);
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable throwable = failure.exception();
                future = Future$.MODULE$.failed(throwable);
            } else {
                throw new MatchError((Object)try_);
            }
            return future;
        }, executionContext);
    }

    public <T> int handleIdempotent$default$2() {
        return Config$.MODULE$.numberOfRetries();
    }

    public <T> int handle$default$2() {
        return Config$.MODULE$.numberOfRetries();
    }

    public String idempotencyKeyHeader() {
        if ((byte)(bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/stan/Dev/stripe-scala/src/main/scala/org/mdedetrich/stripe/v1/package.scala: 272");
        }
        return idempotencyKeyHeader;
    }

    public String stripeAccountHeader() {
        if ((byte)(bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/stan/Dev/stripe-scala/src/main/scala/org/mdedetrich/stripe/v1/package.scala: 277");
        }
        return stripeAccountHeader;
    }

    public String stripeVersionHeader() {
        if ((byte)(bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/stan/Dev/stripe-scala/src/main/scala/org/mdedetrich/stripe/v1/package.scala: 282");
        }
        return stripeVersionHeader;
    }

    private List<HttpHeader> buildHeaders(String apiKey, Option<String> stripeAccount, Option<IdempotencyKey> idempotencyKey) {
        return (List)((StrictOptimizedIterableOps)new .colon.colon((Object)stripeAccount.map((Function1 & Serializable)a -> new RawHeader(MODULE$.stripeAccountHeader(), a)), (List)new .colon.colon((Object)new Some((Object)new Authorization((HttpCredentials)new BasicHttpCredentials(apiKey, ""))), (List)new .colon.colon((Object)idempotencyKey.map((Function1 & Serializable)i -> package$.$anonfun$buildHeaders$2(((IdempotencyKey)i).key())), (List)Nil$.MODULE$)))).flatten(Predef$.MODULE$.$conforms());
    }

    public <A> Future<Either<Errors.Error, Try<A>>> parseStripeServerError(HttpResponse response, Uri finalUrl, Option<Map<String, String>> postFormParameters, Option<Json> postJsonParameters, Logger logger, ExecutionContext executionContext, Materializer materializer, Decoder<A> decoder) {
        Future future;
        BoxedUnit boxedUnit;
        int httpCode = response.status().intValue();
        if (logger.underlying().isDebugEnabled()) {
            logger.underlying().debug("Response status code is {}", (Object)BoxesRunTime.boxToInteger((int)httpCode));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (response.status().isSuccess()) {
            future = Unmarshal$.MODULE$.apply((Object)HttpEntity$.MODULE$.HttpEntityScalaDSLSugar((HttpEntity)response.entity()).withContentType((ContentType)ContentTypes$.MODULE$.application$divjson())).to(CirceHttpSupport$.MODULE$.circeUnmarshaller(decoder), executionContext, materializer).map((Function1 & Serializable)x -> new Right((Object)new Success(x)), executionContext).recover((PartialFunction)new Serializable(){
                private static final long serialVersionUID = 0L;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    Right right = new Right((Object)new Failure(A1));
                    return (B1)right;
                }

                public final boolean isDefinedAt(Throwable x1) {
                    Throwable throwable = x1;
                    boolean bl = true;
                    return bl;
                }
            }, executionContext);
        } else {
            int n = httpCode;
            switch (n) {
                case 400: 
                case 401: 
                case 402: 
                case 404: 
                case 429: {
                    future = Unmarshal$.MODULE$.apply((Object)HttpEntity$.MODULE$.HttpEntityScalaDSLSugar((HttpEntity)response.entity()).withContentType((ContentType)ContentTypes$.MODULE$.application$divjson())).to(CirceHttpSupport$.MODULE$.circeJsonUnmarshaller(), executionContext, materializer).map((Function1 & Serializable)x -> new Success(x), executionContext).recover((PartialFunction)new Serializable(){
                        private static final long serialVersionUID = 0L;

                        public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                            A1 A1 = x2;
                            Failure failure = new Failure(A1);
                            return (B1)failure;
                        }

                        public final boolean isDefinedAt(Throwable x2) {
                            Throwable throwable = x2;
                            boolean bl = true;
                            return bl;
                        }
                    }, executionContext).map((Function1 & Serializable)json -> {
                        Try jsonResponse = json.map((Function1 & Serializable)jsValue -> {
                            Either either;
                            int n = httpCode;
                            switch (n) {
                                case 400: {
                                    Decoder decoder = Decoder$.MODULE$.instance((Function1 & Serializable)c -> c.downField("error").as(Errors$.MODULE$.badRequestDecoder()));
                                    either = decoder.apply(jsValue.hcursor());
                                    break;
                                }
                                case 401: 
                                case 403: {
                                    Decoder decoder = Decoder$.MODULE$.instance((Function1 & Serializable)c -> c.downField("error").as(Errors$.MODULE$.unauthorizedDecoder()));
                                    either = decoder.apply(jsValue.hcursor());
                                    break;
                                }
                                case 402: {
                                    Decoder decoder = Decoder$.MODULE$.instance((Function1 & Serializable)c -> c.downField("error").as(Errors$.MODULE$.requestFailedDecoder()));
                                    either = decoder.apply(jsValue.hcursor());
                                    break;
                                }
                                case 404: {
                                    Decoder decoder = Decoder$.MODULE$.instance((Function1 & Serializable)c -> c.downField("error").as(Errors$.MODULE$.notFoundDecoder()));
                                    either = decoder.apply(jsValue.hcursor());
                                    break;
                                }
                                case 429: {
                                    Decoder decoder = Decoder$.MODULE$.instance((Function1 & Serializable)c -> c.downField("error").as(Errors$.MODULE$.tooManyRequestsDecoder()));
                                    either = decoder.apply(jsValue.hcursor());
                                    break;
                                }
                                default: {
                                    throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                                }
                            }
                            Either jsResult = either;
                            return (Errors.Error)jsResult.fold((Function1 & Serializable)decodingFailure -> {
                                throw new InvalidJsonModelException(httpCode, finalUrl, postFormParameters, postJsonParameters, (Json)jsValue, (DecodingFailure)decodingFailure);
                            }, (Function1 & Serializable)error -> error);
                        });
                        return new Tuple2(json, (Object)jsonResponse);
                    }, executionContext).map((Function1 & Serializable)x$10 -> {
                        Errors.Error error;
                        Tuple2 tuple2 = x$10;
                        if (tuple2 != null) {
                            Errors.Error error2;
                            Try jsonResponse = (Try)tuple2._2();
                            Try try_ = jsonResponse;
                            if (!(try_ instanceof Success)) {
                                if (try_ instanceof Failure) {
                                    Failure failure = (Failure)try_;
                                    Throwable throwable = failure.exception();
                                    throw throwable;
                                }
                                throw new MatchError((Object)try_);
                            }
                            Success success = (Success)try_;
                            error = error2 = (Errors.Error)success.value();
                        } else {
                            throw new MatchError((Object)tuple2);
                        }
                        Left left = new Left((Object)error);
                        return left;
                    }, executionContext);
                    break;
                }
                case 500: 
                case 502: 
                case 503: 
                case 504: {
                    HttpMessage.HttpMessageScalaDSLSugar$.MODULE$.discardEntityBytes$extension(HttpMessage$.MODULE$.HttpMessageScalaDSLSugar((HttpMessage)response), materializer);
                    throw new Errors.StripeServerError(response);
                }
                default: {
                    HttpMessage.HttpMessageScalaDSLSugar$.MODULE$.discardEntityBytes$extension(HttpMessage$.MODULE$.HttpMessageScalaDSLSugar((HttpMessage)response), materializer);
                    throw new Errors.UnhandledServerError(response);
                }
            }
        }
        return future.map((Function1 & Serializable)result -> result, executionContext);
    }

    public Map<String, String> mapToPostParams(Option<Map<String, String>> optionalMap, String parentKey) {
        Map map;
        Option<Map<String, String>> option = optionalMap;
        if (option instanceof Some) {
            Some some = (Some)option;
            Map map2 = (Map)some.value();
            map = (Map)map2.map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(2).append(parentKey).append("[").append(key).append("]").toString()), (Object)value);
                return tuple22;
            });
        } else if (None$.MODULE$.equals(option)) {
            map = Predef$.MODULE$.Map().empty();
        } else {
            throw new MatchError(option);
        }
        return map;
    }

    private static final Future responseBlock$1(Future request$1) {
        return request$1;
    }

    private static final Future responseBlockWithRetries$1(int currentRetryCount, int numberOfRetries$1, ExecutionContext executionContext$4, Future request$1) {
        return currentRetryCount > numberOfRetries$1 ? Future$.MODULE$.failed((Throwable)new MaxNumberOfRetries(currentRetryCount)) : package$.responseBlock$1(request$1).flatMap((Function1 & Serializable)x0$1 -> {
            Future future;
            Try try_ = x0$1;
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                Object customer = success.value();
                future = Future$.MODULE$.successful((Object)new Success(customer));
            } else if (try_ instanceof Failure) {
                Future future2;
                Failure failure = (Failure)try_;
                Throwable failure2 = failure.exception();
                Throwable throwable = failure2;
                if (throwable instanceof Errors.Error.RequestFailed) {
                    Errors.Error.RequestFailed requestFailed = (Errors.Error.RequestFailed)throwable;
                    Errors.Type error = requestFailed.type();
                    Errors.Type type = error;
                    Future future3 = Errors$Type$ApiError$.MODULE$.equals(type) ? package$.responseBlockWithRetries$1(currentRetryCount + 1, numberOfRetries$1, executionContext$4, request$1) : (Errors$Type$ApiConnectionError$.MODULE$.equals(type) ? package$.responseBlockWithRetries$1(currentRetryCount + 1, numberOfRetries$1, executionContext$4, request$1) : Future$.MODULE$.failed(failure2));
                    future2 = future3;
                } else {
                    future2 = throwable instanceof Errors.Error.TooManyRequests ? package$.responseBlockWithRetries$1(currentRetryCount + 1, numberOfRetries$1, executionContext$4, request$1) : Future$.MODULE$.failed(failure2);
                }
                future = future2;
            } else {
                throw new MatchError((Object)try_);
            }
            return future;
        }, executionContext$4);
    }

    public static final /* synthetic */ RawHeader $anonfun$buildHeaders$2(String i) {
        return new RawHeader(MODULE$.idempotencyKeyHeader(), i);
    }

    private package$() {
    }
}

