/*
 * Decompiled with CFR 0.152.
 */
package org.mdedetrich.stripe.v1;

import akka.http.scaladsl.HttpExt;
import akka.http.scaladsl.model.Uri$;
import akka.stream.Materializer;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.Encoder;
import io.circe.Encoder$;
import java.io.Serializable;
import java.time.OffsetDateTime;
import org.mdedetrich.stripe.IdempotencyKey;
import org.mdedetrich.stripe.PostParams$;
import org.mdedetrich.stripe.v1.BankAccounts;
import org.mdedetrich.stripe.v1.BankAccounts$;
import org.mdedetrich.stripe.v1.Cards;
import org.mdedetrich.stripe.v1.Cards$;
import org.mdedetrich.stripe.v1.Tokens;
import org.mdedetrich.stripe.v1.Tokens$Type$;
import org.mdedetrich.stripe.v1.package$;
import org.mdedetrich.stripe.v1.package$defaults$;
import scala.Function1;
import scala.Function8;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple9;
import scala.UninitializedFieldError;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Try;

public final class Tokens$
implements LazyLogging {
    public static final Tokens$ MODULE$ = new Tokens$();
    private static final Decoder<Tokens.Token> tokenDecoder;
    private static final Encoder<Tokens.Token> tokenEncoder;
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;
    private static volatile byte bitmap$init$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
        tokenDecoder = Decoder$.MODULE$.forProduct8("id", "created", "livemode", "type", "used", "bank_account", "card", "client_ip", (Function8 & Serializable)(id, created, livemode, type, used, bankAccount, card, clientIp) -> Tokens$.$anonfun$tokenDecoder$1(id, created, BoxesRunTime.unboxToBoolean((Object)livemode), type, BoxesRunTime.unboxToBoolean((Object)used), bankAccount, card, clientIp), Decoder$.MODULE$.decodeString(), package$defaults$.MODULE$.stripeDateTimeDecoder(), Decoder$.MODULE$.decodeBoolean(), Tokens$Type$.MODULE$.tokenTypeDecoder(), Decoder$.MODULE$.decodeBoolean(), Decoder$.MODULE$.decodeOption(BankAccounts$.MODULE$.bankAccountDecoder()), Decoder$.MODULE$.decodeOption(Cards$.MODULE$.cardDecoder()), Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeString()));
        bitmap$init$0 = (byte)(bitmap$init$0 | 4);
        tokenEncoder = Encoder$.MODULE$.forProduct9("id", "object", "created", "livemode", "type", "used", "bank_account", "card", "client_ip", (Function1 & Serializable)x -> new Tuple9((Object)x.id(), (Object)"token", x.bankAccount(), x.card(), x.clientIp(), (Object)x.created(), (Object)BoxesRunTime.boxToBoolean((boolean)x.livemode()), (Object)x.type(), (Object)BoxesRunTime.boxToBoolean((boolean)x.used())), Encoder$.MODULE$.encodeString(), Encoder$.MODULE$.encodeString(), Encoder$.MODULE$.encodeOption(BankAccounts$.MODULE$.bankAccountEncoder()), Encoder$.MODULE$.encodeOption(Cards$.MODULE$.cardEncoder()), Encoder$.MODULE$.encodeOption(Encoder$.MODULE$.encodeString()), package$defaults$.MODULE$.stripeDateTimeEncoder(), Encoder$.MODULE$.encodeBoolean(), Tokens$Type$.MODULE$.tokenTypeEncoder(), Encoder$.MODULE$.encodeBoolean());
        bitmap$init$0 = (byte)(bitmap$init$0 | 8);
    }

    private Logger logger$lzycompute() {
        Tokens$ tokens$ = this;
        synchronized (tokens$) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        return !bitmap$trans$0 ? this.logger$lzycompute() : logger;
    }

    public Decoder<Tokens.Token> tokenDecoder() {
        if ((byte)(bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/stan/Dev/stripe-scala/src/main/scala/org/mdedetrich/stripe/v1/Tokens.scala: 60");
        }
        return tokenDecoder;
    }

    public Encoder<Tokens.Token> tokenEncoder() {
        if ((byte)(bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/stan/Dev/stripe-scala/src/main/scala/org/mdedetrich/stripe/v1/Tokens.scala: 71");
        }
        return tokenEncoder;
    }

    public Future<Try<Tokens.Token>> create(Tokens.TokenInput tokenInput, Option<IdempotencyKey> idempotencyKey, String apiKey, String endpoint, HttpExt client, Materializer materializer, ExecutionContext executionContext) {
        BoxedUnit boxedUnit;
        Map<String, String> map;
        Map map2 = PostParams$.MODULE$.flatten((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"customer"), tokenInput.customer())})));
        Tokens.TokenData tokenData = tokenInput.tokenData();
        if (tokenData instanceof Tokens.TokenData.Card) {
            Tokens.TokenData.Card card = (Tokens.TokenData.Card)tokenData;
            Map map3 = PostParams$.MODULE$.flatten((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exp_month"), (Object)new Some((Object)((Object)BoxesRunTime.boxToInteger((int)card.expMonth())).toString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exp_year"), (Object)new Some((Object)((Object)BoxesRunTime.boxToInteger((int)card.expYear())).toString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"number"), (Object)new Some((Object)card.number())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"address_city"), card.addressCity()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"address_country"), card.addressCountry()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"address_line1"), card.addressLine1()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"address_line2"), card.addressLine2()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"address_state"), card.addressState()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"address_zip"), card.addressZip()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"currency"), (Object)card.currency().map((Function1 & Serializable)x$1 -> x$1.iso().toLowerCase())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cvc"), card.cvc()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), card.name())})));
            map = package$.MODULE$.mapToPostParams((Option<Map<String, String>>)new Some(map3), "card");
        } else if (tokenData instanceof Tokens.TokenData.BankAccount) {
            Tokens.TokenData.BankAccount bankAccount = (Tokens.TokenData.BankAccount)tokenData;
            Map map4 = PostParams$.MODULE$.flatten((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"account_number"), (Object)new Some((Object)bankAccount.accountNumber())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"country"), (Object)new Some((Object)bankAccount.country())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"currency"), (Object)new Some((Object)bankAccount.currency().iso().toLowerCase())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"routing_number"), bankAccount.routingNumber()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"account_holder_name"), bankAccount.accountHolderName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"account_holder_type"), (Object)bankAccount.accountHolderType().map((Function1 & Serializable)x$2 -> x$2.id()))})));
            map = package$.MODULE$.mapToPostParams((Option<Map<String, String>>)new Some(map4), "bank_account");
        } else if (tokenData instanceof Tokens.TokenData.PII) {
            Tokens.TokenData.PII pII = (Tokens.TokenData.PII)tokenData;
            Map map5 = PostParams$.MODULE$.flatten((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pii"), pII.pii()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"personal_id_number"), (Object)new Some((Object)pII.personalIdNumber()))})));
            map = package$.MODULE$.mapToPostParams((Option<Map<String, String>>)new Some(map5), "pii");
        } else {
            throw new MatchError((Object)tokenData);
        }
        Map postFormParameters = (Map)map2.$plus$plus(map);
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Generated POST form parameters is {}", (Object)postFormParameters);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        String finalUrl = new StringBuilder(0).append(endpoint).append("/v1/tokens").toString();
        return package$.MODULE$.createRequestPOST(finalUrl, (Map<String, String>)postFormParameters, idempotencyKey, this.logger(), package$.MODULE$.createRequestPOST$default$5(), client, materializer, executionContext, this.tokenDecoder(), apiKey);
    }

    public Option<IdempotencyKey> create$default$2(Tokens.TokenInput tokenInput) {
        return None$.MODULE$;
    }

    public Future<Try<Tokens.Token>> get(String id, String apiKey, String endpoint, HttpExt client, Materializer materializer, ExecutionContext executionContext) {
        String finalUrl = new StringBuilder(0).append(endpoint).append(new StringBuilder(11).append("/v1/tokens/").append(id).toString()).toString();
        return package$.MODULE$.createRequestGET(Uri$.MODULE$.apply(finalUrl), this.logger(), package$.MODULE$.createRequestGET$default$3(), client, materializer, executionContext, this.tokenDecoder(), apiKey);
    }

    public static final /* synthetic */ Tokens.Token $anonfun$tokenDecoder$1(String id, OffsetDateTime created, boolean livemode, Tokens.Type type, boolean used, Option bankAccount, Option card, Option clientIp) {
        return new Tokens.Token(id, created, livemode, type, used, (Option<BankAccounts.BankAccount>)bankAccount, (Option<Cards.Card>)card, (Option<String>)clientIp);
    }

    private Tokens$() {
    }
}

