/*
 * Decompiled with CFR 0.152.
 */
package org.mdedetrich.stripe.v1;

import akka.http.scaladsl.HttpExt;
import akka.stream.Materializer;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.DecodingFailure$;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json;
import io.circe.KeyDecoder$;
import io.circe.KeyEncoder$;
import io.circe.syntax.package;
import java.io.Serializable;
import java.time.OffsetDateTime;
import org.mdedetrich.stripe.IdempotencyKey;
import org.mdedetrich.stripe.PostParams;
import org.mdedetrich.stripe.PostParams$;
import org.mdedetrich.stripe.v1.Charges;
import org.mdedetrich.stripe.v1.Charges$FraudDetails$;
import org.mdedetrich.stripe.v1.Charges$FraudDetails$StripeReport$;
import org.mdedetrich.stripe.v1.Charges$FraudDetails$UserReport$;
import org.mdedetrich.stripe.v1.Charges$Source$;
import org.mdedetrich.stripe.v1.Charges$SourceInput$Customer$;
import org.mdedetrich.stripe.v1.Charges$Status$;
import org.mdedetrich.stripe.v1.Currency;
import org.mdedetrich.stripe.v1.Currency$;
import org.mdedetrich.stripe.v1.Disputes;
import org.mdedetrich.stripe.v1.Disputes$;
import org.mdedetrich.stripe.v1.Errors;
import org.mdedetrich.stripe.v1.Errors$Code$;
import org.mdedetrich.stripe.v1.Refunds;
import org.mdedetrich.stripe.v1.Refunds$RefundList$;
import org.mdedetrich.stripe.v1.Shippings;
import org.mdedetrich.stripe.v1.Shippings$;
import org.mdedetrich.stripe.v1.package$;
import org.mdedetrich.stripe.v1.package$defaults$;
import scala.Function0;
import scala.Function1;
import scala.Function11;
import scala.Function12;
import scala.Function2;
import scala.Function22;
import scala.Function7;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple12;
import scala.Tuple2;
import scala.Tuple22;
import scala.Tuple7;
import scala.Tuple8;
import scala.UninitializedFieldError;
import scala.collection.MapOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.math.BigDecimal;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Left;
import scala.util.Try;

public final class Charges$
implements LazyLogging {
    public static final Charges$ MODULE$ = new Charges$();
    private static final Decoder<Charges.FraudDetails> fraudDetailsDecoder;
    private static final Encoder<Charges.FraudDetails> fraudDetailsEncoder;
    private static final Decoder<Charges.SourceInput.Customer> sourceInputCustomerDecoder;
    private static final Decoder<Charges.SourceInput.Card> sourceInputCardDecoder;
    private static final Decoder<Charges.SourceInput> chargeSourceInputDecoder;
    private static final Encoder<Charges.SourceInput.Customer> chargeSourceInputCustomerEncoder;
    private static final Encoder<Charges.SourceInput.Token> chargeSourceInputTokenEncoder;
    private static final Encoder<Charges.SourceInput.Card> chargeSourceInputCustomerCard;
    private static final Encoder<Charges.SourceInput> chargeSourceInputEncoder;
    private static final PostParams<Charges.SourceInput.Card> cardPostParams;
    private static final PostParams<Charges.SourceInput> sourceInputPostParams;
    private static final Decoder<Charges.Source> sourceDecoder;
    private static final Encoder<Charges.Source> sourceEncoder;
    private static final Decoder<Tuple22<String, BigDecimal, BigDecimal, Option<String>, Option<String>, Object, OffsetDateTime, Currency, Option<String>, Option<String>, Option<String>, Option<Disputes.Dispute>, Option<Errors.Code>, Option<String>, Option<Charges.FraudDetails>, Option<String>, Object, Option<Map<String, String>>, Option<String>, Object, Option<String>, Option<String>>> chargeDecoderOne;
    private static final Decoder<Tuple7<Object, Option<Refunds.RefundList>, Option<Shippings.Shipping>, Charges.Source, Option<String>, Option<String>, Charges.Status>> chargeDecoderTwo;
    private static final Decoder<Charges.Charge> chargeDecoder;
    private static final Encoder<Charges.Charge> chargeEncoderOne;
    private static final Encoder<Charges.Charge> chargeEncoderTwo;
    private static final Encoder<Charges.Charge> chargeEncoder;
    private static final Decoder<Charges.ChargeInput> chargeInputDecoder;
    private static final PostParams<Charges.ChargeInput> chargeInputPostParams;
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;
    private static volatile int bitmap$init$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
        fraudDetailsDecoder = Decoder$.MODULE$.forProduct2("user_report", "stripe_report", (Function2 & Serializable)(userReport, stripeReport) -> new Charges.FraudDetails((Option<Charges.FraudDetails.UserReport>)userReport, (Option<Charges.FraudDetails.StripeReport>)stripeReport), Decoder$.MODULE$.decodeOption(Charges$FraudDetails$UserReport$.MODULE$.userReportDecoder()), Decoder$.MODULE$.decodeOption(Charges$FraudDetails$StripeReport$.MODULE$.stripeReportDecoder()));
        bitmap$init$0 |= 2;
        fraudDetailsEncoder = Encoder$.MODULE$.forProduct2("user_report", "stripe_report", (Function1 & Serializable)x -> (Tuple2)Charges$FraudDetails$.MODULE$.unapply((Charges.FraudDetails)x).get(), Encoder$.MODULE$.encodeOption(Charges$FraudDetails$UserReport$.MODULE$.userReportEncoder()), Encoder$.MODULE$.encodeOption(Charges$FraudDetails$StripeReport$.MODULE$.stripeReportEncoder()));
        bitmap$init$0 |= 4;
        sourceInputCustomerDecoder = Decoder$.MODULE$.apply(Decoder$.MODULE$.decodeString()).map((Function1)Charges$SourceInput$Customer$.MODULE$);
        bitmap$init$0 |= 0x20;
        sourceInputCardDecoder = Decoder$.MODULE$.forProduct11("exp_month", "exp_year", "number", "cvc", "address_city", "address_country", "address_line1", "address_line2", "name", "address_state", "address_zip", (Function11 & Serializable)(expMonth, expYear, number, cvc, addressCity, addressCountry, addressLine1, addressLine2, name, addressState, addressZip) -> Charges$.$anonfun$sourceInputCardDecoder$1(BoxesRunTime.unboxToInt((Object)expMonth), BoxesRunTime.unboxToInt((Object)expYear), number, cvc, addressCity, addressCountry, addressLine1, addressLine2, name, addressState, addressZip), Decoder$.MODULE$.decodeInt(), Decoder$.MODULE$.decodeInt(), Decoder$.MODULE$.decodeString(), Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeString()), Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeString()), Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeString()), Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeString()), Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeString()), Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeString()), Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeString()), Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeString()));
        bitmap$init$0 |= 0x40;
        chargeSourceInputDecoder = Decoder$.MODULE$.instance((Function1 & Serializable)c -> c.as(Decoder$.MODULE$.decodeJson()).flatMap((Function1 & Serializable)json -> (json.isString() ? ((Decoder)Predef$.MODULE$.implicitly(MODULE$.sourceInputCustomerDecoder())).apply(c) : (json.isObject() ? ((Decoder)Predef$.MODULE$.implicitly(MODULE$.sourceInputCardDecoder())).apply(c) : scala.package$.MODULE$.Left().apply((Object)DecodingFailure$.MODULE$.apply("Invalid Charge Source Input", (Function0 & Serializable)() -> c.history())))).map((Function1 & Serializable)result -> result)));
        bitmap$init$0 |= 0x80;
        chargeSourceInputCustomerEncoder = Encoder$.MODULE$.instance((Function1 & Serializable)x$1 -> package.EncoderOps$.MODULE$.asJson$extension(io.circe.syntax.package$.MODULE$.EncoderOps((Object)x$1.id()), Encoder$.MODULE$.encodeString()));
        bitmap$init$0 |= 0x100;
        chargeSourceInputTokenEncoder = Encoder$.MODULE$.instance((Function1 & Serializable)x$2 -> package.EncoderOps$.MODULE$.asJson$extension(io.circe.syntax.package$.MODULE$.EncoderOps((Object)x$2.id()), Encoder$.MODULE$.encodeString()));
        bitmap$init$0 |= 0x200;
        chargeSourceInputCustomerCard = Encoder$.MODULE$.forProduct12("exp_month", "exp_year", "number", "object", "cvc", "address_city", "address_country", "address_line1", "address_line2", "name", "address_state", "address_zip", (Function1 & Serializable)x -> new Tuple12((Object)BoxesRunTime.boxToInteger((int)x.expMonth()), (Object)BoxesRunTime.boxToInteger((int)x.expYear()), (Object)x.number(), (Object)"card", x.cvc(), x.addressCity(), x.addressCountry(), x.addressLine1(), x.addressLine2(), x.name(), x.addressState(), x.addressCity()), Encoder$.MODULE$.encodeInt(), Encoder$.MODULE$.encodeInt(), Encoder$.MODULE$.encodeString(), Encoder$.MODULE$.encodeString(), Encoder$.MODULE$.encodeOption(Encoder$.MODULE$.encodeString()), Encoder$.MODULE$.encodeOption(Encoder$.MODULE$.encodeString()), Encoder$.MODULE$.encodeOption(Encoder$.MODULE$.encodeString()), Encoder$.MODULE$.encodeOption(Encoder$.MODULE$.encodeString()), Encoder$.MODULE$.encodeOption(Encoder$.MODULE$.encodeString()), Encoder$.MODULE$.encodeOption(Encoder$.MODULE$.encodeString()), Encoder$.MODULE$.encodeOption(Encoder$.MODULE$.encodeString()), Encoder$.MODULE$.encodeOption(Encoder$.MODULE$.encodeString()));
        bitmap$init$0 |= 0x400;
        chargeSourceInputEncoder = Encoder$.MODULE$.instance((Function1 & Serializable)x0$1 -> {
            Json json;
            Charges.SourceInput sourceInput = x0$1;
            if (sourceInput instanceof Charges.SourceInput.Customer) {
                Charges.SourceInput.Customer customer = (Charges.SourceInput.Customer)sourceInput;
                json = ((Encoder)Predef$.MODULE$.implicitly(MODULE$.chargeSourceInputCustomerEncoder())).apply((Object)customer);
            } else if (sourceInput instanceof Charges.SourceInput.Card) {
                Charges.SourceInput.Card card = (Charges.SourceInput.Card)sourceInput;
                json = ((Encoder)Predef$.MODULE$.implicitly(MODULE$.chargeSourceInputCustomerCard())).apply((Object)card);
            } else if (sourceInput instanceof Charges.SourceInput.Token) {
                Charges.SourceInput.Token token = (Charges.SourceInput.Token)sourceInput;
                json = ((Encoder)Predef$.MODULE$.implicitly(MODULE$.chargeSourceInputTokenEncoder())).apply((Object)token);
            } else {
                throw new MatchError((Object)sourceInput);
            }
            return json;
        });
        bitmap$init$0 |= 0x800;
        cardPostParams = PostParams$.MODULE$.params((Function1 & Serializable)t -> {
            Map mandatory = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exp_month"), (Object)((Object)BoxesRunTime.boxToInteger((int)t.expMonth())).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exp_year"), (Object)((Object)BoxesRunTime.boxToInteger((int)t.expYear())).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"number"), (Object)t.number())}));
            Map optional = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cvc"), t.cvc()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"address_city"), t.addressCity()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"address_country"), t.addressCountry()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"address_line1"), t.addressLine1()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"address_line2"), t.addressLine2()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), t.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"address_state"), t.addressState()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"address_zip"), t.addressZip())}));
            return (Map)mandatory.$plus$plus(PostParams$.MODULE$.flatten(optional));
        });
        bitmap$init$0 |= 0x1000;
        sourceInputPostParams = PostParams$.MODULE$.params((Function1 & Serializable)x0$2 -> {
            Map map;
            Charges.SourceInput sourceInput = x0$2;
            if (sourceInput instanceof Charges.SourceInput.Token) {
                Charges.SourceInput.Token token = (Charges.SourceInput.Token)sourceInput;
                map = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"source"), (Object)token.id())}));
            } else if (sourceInput instanceof Charges.SourceInput.Customer) {
                Charges.SourceInput.Customer customer = (Charges.SourceInput.Customer)sourceInput;
                map = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"customer"), (Object)customer.id())}));
            } else if (sourceInput instanceof Charges.SourceInput.Card) {
                Charges.SourceInput.Card card = (Charges.SourceInput.Card)sourceInput;
                map = PostParams$.MODULE$.toPostParams(card, MODULE$.cardPostParams());
            } else {
                throw new MatchError((Object)sourceInput);
            }
            return map;
        });
        bitmap$init$0 |= 0x2000;
        sourceDecoder = Decoder$.MODULE$.instance((Function1 & Serializable)c -> c.as(Decoder$.MODULE$.decodeJsonObject()).flatMap((Function1 & Serializable)obj -> ((Json)obj.toMap().apply((Object)"object")).as(Decoder$.MODULE$.decodeString()).flatMap((Function1 & Serializable)tpe -> {
            Left left;
            block7: {
                block5: {
                    block6: {
                        String string = tpe;
                        switch (string == null ? 0 : string.hashCode()) {
                            case -1177318867: {
                                if (!"account".equals(string)) break block5;
                                break block6;
                            }
                            case 3046160: {
                                if ("card".equals(string)) {
                                    break;
                                }
                                break block5;
                            }
                            default: {
                                break block5;
                            }
                        }
                        Decoder decoder = (Decoder)Predef$.MODULE$.implicitly(Charges$Source$.MODULE$.maskedCardSourceDecoder());
                        left = decoder.apply(c);
                        break block7;
                    }
                    Decoder decoder = (Decoder)Predef$.MODULE$.implicitly(Charges$Source$.MODULE$.accountSourceDecoder());
                    left = decoder.apply(c);
                    break block7;
                }
                left = scala.package$.MODULE$.Left().apply((Object)DecodingFailure$.MODULE$.apply("Expected valid object type", (Function0 & Serializable)() -> c.history()));
            }
            return left.map((Function1 & Serializable)source -> source);
        })));
        bitmap$init$0 |= 0x8000;
        sourceEncoder = Encoder$.MODULE$.instance((Function1 & Serializable)x0$3 -> {
            Json json;
            Charges.Source source = x0$3;
            if (source instanceof Charges.Source.MaskedCard) {
                Charges.Source.MaskedCard maskedCard = (Charges.Source.MaskedCard)source;
                json = ((Encoder)Predef$.MODULE$.implicitly(Charges$Source$.MODULE$.maskedCardSourceEncoder())).apply((Object)maskedCard);
            } else if (source instanceof Charges.Source.Account) {
                Charges.Source.Account account = (Charges.Source.Account)source;
                json = ((Encoder)Predef$.MODULE$.implicitly(Charges$Source$.MODULE$.accountSourceEncoder())).apply((Object)account);
            } else {
                throw new MatchError((Object)source);
            }
            return json;
        });
        bitmap$init$0 |= 0x10000;
        chargeDecoderOne = Decoder$.MODULE$.forProduct22("id", "amount", "amount_refunded", "application_fee", "balance_transaction", "captured", "created", "currency", "customer", "description", "destination", "dispute", "failure_code", "failure_message", "fraud_details", "invoice", "livemode", "metadata", "order", "paid", "receipt_email", "receipt_number", (Function22 & Serializable)(x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$23, x$24) -> Charges$.$anonfun$chargeDecoderOne$1(x$3, x$4, x$5, x$6, x$7, BoxesRunTime.unboxToBoolean((Object)x$8), x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, BoxesRunTime.unboxToBoolean((Object)x$19), x$20, x$21, BoxesRunTime.unboxToBoolean((Object)x$22), x$23, x$24), Decoder$.MODULE$.decodeString(), Decoder$.MODULE$.decodeBigDecimal(), Decoder$.MODULE$.decodeBigDecimal(), Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeString()), Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeString()), Decoder$.MODULE$.decodeBoolean(), package$defaults$.MODULE$.stripeDateTimeDecoder(), Currency$.MODULE$.currencyDecoder(), Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeString()), Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeString()), Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeString()), Decoder$.MODULE$.decodeOption(Disputes$.MODULE$.disputeDecoder()), Decoder$.MODULE$.decodeOption(Errors$Code$.MODULE$.errorCodeDecoder()), Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeString()), Decoder$.MODULE$.decodeOption(MODULE$.fraudDetailsDecoder()), Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeString()), Decoder$.MODULE$.decodeBoolean(), Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeMap(KeyDecoder$.MODULE$.decodeKeyString(), Decoder$.MODULE$.decodeString())), Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeString()), Decoder$.MODULE$.decodeBoolean(), Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeString()), Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeString()));
        bitmap$init$0 |= 0x40000;
        chargeDecoderTwo = Decoder$.MODULE$.forProduct7("refunded", "refunds", "shipping", "source", "source_transfer", "statement_descriptor", "status", (Function7 & Serializable)(x$25, x$26, x$27, x$28, x$29, x$30, x$31) -> Charges$.$anonfun$chargeDecoderTwo$1(BoxesRunTime.unboxToBoolean((Object)x$25), x$26, x$27, x$28, x$29, x$30, x$31), Decoder$.MODULE$.decodeBoolean(), Decoder$.MODULE$.decodeOption(Refunds$RefundList$.MODULE$.refundListDecoder()), Decoder$.MODULE$.decodeOption(Shippings$.MODULE$.shippingDecoder()), MODULE$.sourceDecoder(), Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeString()), Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeString()), Charges$Status$.MODULE$.chargeStatusDecoder());
        bitmap$init$0 |= 0x80000;
        chargeDecoder = Decoder$.MODULE$.instance((Function1 & Serializable)c -> MODULE$.chargeDecoderOne().apply(c).flatMap((Function1 & Serializable)one -> MODULE$.chargeDecoderTwo().apply(c).map((Function1 & Serializable)two -> {
            Tuple22 tuple22 = one;
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            String id = (String)tuple22._1();
            BigDecimal amount = (BigDecimal)tuple22._2();
            BigDecimal amountRefunded = (BigDecimal)tuple22._3();
            Option applicationFee = (Option)tuple22._4();
            Option balanceTransaction = (Option)tuple22._5();
            boolean captured = BoxesRunTime.unboxToBoolean((Object)tuple22._6());
            OffsetDateTime created = (OffsetDateTime)tuple22._7();
            Currency currency = (Currency)tuple22._8();
            Option customer = (Option)tuple22._9();
            Option description = (Option)tuple22._10();
            Option destination = (Option)tuple22._11();
            Option dispute = (Option)tuple22._12();
            Option failureCode = (Option)tuple22._13();
            Option failureMessage = (Option)tuple22._14();
            Option fraudDetails = (Option)tuple22._15();
            Option invoice = (Option)tuple22._16();
            boolean livemode = BoxesRunTime.unboxToBoolean((Object)tuple22._17());
            Option metadata = (Option)tuple22._18();
            Option order = (Option)tuple22._19();
            boolean paid = BoxesRunTime.unboxToBoolean((Object)tuple22._20());
            Option receiptEmail = (Option)tuple22._21();
            Option receiptNumber = (Option)tuple22._22();
            Tuple22 tuple222 = new Tuple22((Object)id, (Object)amount, (Object)amountRefunded, (Object)applicationFee, (Object)balanceTransaction, (Object)BoxesRunTime.boxToBoolean((boolean)captured), (Object)created, (Object)currency, (Object)customer, (Object)description, (Object)destination, (Object)dispute, (Object)failureCode, (Object)failureMessage, (Object)fraudDetails, (Object)invoice, (Object)BoxesRunTime.boxToBoolean((boolean)livemode), (Object)metadata, (Object)order, (Object)BoxesRunTime.boxToBoolean((boolean)paid), (Object)receiptEmail, (Object)receiptNumber);
            Tuple22 tuple223 = tuple222;
            String id2 = (String)tuple223._1();
            BigDecimal amount2 = (BigDecimal)tuple223._2();
            BigDecimal amountRefunded2 = (BigDecimal)tuple223._3();
            Option applicationFee2 = (Option)tuple223._4();
            Option balanceTransaction2 = (Option)tuple223._5();
            boolean captured2 = BoxesRunTime.unboxToBoolean((Object)tuple223._6());
            OffsetDateTime created2 = (OffsetDateTime)tuple223._7();
            Currency currency2 = (Currency)tuple223._8();
            Option customer2 = (Option)tuple223._9();
            Option description2 = (Option)tuple223._10();
            Option destination2 = (Option)tuple223._11();
            Option dispute2 = (Option)tuple223._12();
            Option failureCode2 = (Option)tuple223._13();
            Option failureMessage2 = (Option)tuple223._14();
            Option fraudDetails2 = (Option)tuple223._15();
            Option invoice2 = (Option)tuple223._16();
            boolean livemode2 = BoxesRunTime.unboxToBoolean((Object)tuple223._17());
            Option metadata2 = (Option)tuple223._18();
            Option order2 = (Option)tuple223._19();
            boolean paid2 = BoxesRunTime.unboxToBoolean((Object)tuple223._20());
            Option receiptEmail2 = (Option)tuple223._21();
            Option receiptNumber2 = (Option)tuple223._22();
            Tuple7 tuple7 = two;
            if (tuple7 == null) {
                throw new MatchError((Object)tuple7);
            }
            boolean refunded = BoxesRunTime.unboxToBoolean((Object)tuple7._1());
            Option refunds = (Option)tuple7._2();
            Option shipping = (Option)tuple7._3();
            Charges.Source source = (Charges.Source)tuple7._4();
            Option sourceTransfer = (Option)tuple7._5();
            Option statementDescriptor = (Option)tuple7._6();
            Charges.Status status = (Charges.Status)tuple7._7();
            Tuple7 tuple72 = new Tuple7((Object)BoxesRunTime.boxToBoolean((boolean)refunded), (Object)refunds, (Object)shipping, (Object)source, (Object)sourceTransfer, (Object)statementDescriptor, (Object)status);
            Tuple7 tuple73 = tuple72;
            boolean refunded2 = BoxesRunTime.unboxToBoolean((Object)tuple73._1());
            Option refunds2 = (Option)tuple73._2();
            Option shipping2 = (Option)tuple73._3();
            Charges.Source source2 = (Charges.Source)tuple73._4();
            Option sourceTransfer2 = (Option)tuple73._5();
            Option statementDescriptor2 = (Option)tuple73._6();
            Charges.Status status2 = (Charges.Status)tuple73._7();
            return new Charges.Charge(id2, amount2, amountRefunded2, (Option<String>)applicationFee2, (Option<String>)balanceTransaction2, captured2, created2, currency2, (Option<String>)customer2, (Option<String>)description2, (Option<String>)destination2, (Option<Disputes.Dispute>)dispute2, (Option<Errors.Code>)failureCode2, (Option<String>)failureMessage2, (Option<Charges.FraudDetails>)fraudDetails2, (Option<String>)invoice2, livemode2, (Option<Map<String, String>>)metadata2, (Option<String>)order2, paid2, (Option<String>)receiptEmail2, (Option<String>)receiptNumber2, refunded2, (Option<Refunds.RefundList>)refunds2, (Option<Shippings.Shipping>)shipping2, source2, (Option<String>)sourceTransfer2, (Option<String>)statementDescriptor2, status2);
        })));
        bitmap$init$0 |= 0x100000;
        chargeEncoderOne = Encoder$.MODULE$.forProduct22("id", "object", "amount", "amount_refunded", "application_fee", "balance_transaction", "captured", "created", "currency", "customer", "description", "destination", "dispute", "failure_code", "failure_message", "fraud_details", "invoice", "livemode", "metadata", "order", "paid", "receipt_email", (Function1 & Serializable)x -> new Tuple22((Object)x.id(), (Object)"charge", (Object)x.amount(), (Object)x.amountRefunded(), x.applicationFee(), x.balanceTransaction(), (Object)BoxesRunTime.boxToBoolean((boolean)x.captured()), (Object)x.created(), (Object)x.currency(), x.customer(), x.description(), x.destination(), x.dispute(), x.failureCode(), x.failureMessage(), x.fraudDetails(), x.invoice(), (Object)BoxesRunTime.boxToBoolean((boolean)x.livemode()), x.metadata(), x.order(), (Object)BoxesRunTime.boxToBoolean((boolean)x.paid()), x.receiptEmail()), Encoder$.MODULE$.encodeString(), Encoder$.MODULE$.encodeString(), Encoder$.MODULE$.encodeBigDecimal(), Encoder$.MODULE$.encodeBigDecimal(), Encoder$.MODULE$.encodeOption(Encoder$.MODULE$.encodeString()), Encoder$.MODULE$.encodeOption(Encoder$.MODULE$.encodeString()), Encoder$.MODULE$.encodeBoolean(), package$defaults$.MODULE$.stripeDateTimeEncoder(), Currency$.MODULE$.currencyEncoder(), Encoder$.MODULE$.encodeOption(Encoder$.MODULE$.encodeString()), Encoder$.MODULE$.encodeOption(Encoder$.MODULE$.encodeString()), Encoder$.MODULE$.encodeOption(Encoder$.MODULE$.encodeString()), Encoder$.MODULE$.encodeOption(Disputes$.MODULE$.disputeEncoder()), Encoder$.MODULE$.encodeOption(Errors$Code$.MODULE$.errorCodeEncoder()), Encoder$.MODULE$.encodeOption(Encoder$.MODULE$.encodeString()), Encoder$.MODULE$.encodeOption(MODULE$.fraudDetailsEncoder()), Encoder$.MODULE$.encodeOption(Encoder$.MODULE$.encodeString()), Encoder$.MODULE$.encodeBoolean(), Encoder$.MODULE$.encodeOption((Encoder)Encoder$.MODULE$.encodeMap(KeyEncoder$.MODULE$.encodeKeyString(), Encoder$.MODULE$.encodeString())), Encoder$.MODULE$.encodeOption(Encoder$.MODULE$.encodeString()), Encoder$.MODULE$.encodeBoolean(), Encoder$.MODULE$.encodeOption(Encoder$.MODULE$.encodeString()));
        bitmap$init$0 |= 0x200000;
        chargeEncoderTwo = Encoder$.MODULE$.forProduct8("receipt_number", "refunded", "refunds", "shipping", "source", "source_transfer", "statement_descriptor", "status", (Function1 & Serializable)x -> new Tuple8(x.receiptNumber(), (Object)BoxesRunTime.boxToBoolean((boolean)x.refunded()), x.refunds(), x.shipping(), (Object)x.source(), x.sourceTransfer(), x.statementDescriptor(), (Object)x.status()), Encoder$.MODULE$.encodeOption(Encoder$.MODULE$.encodeString()), Encoder$.MODULE$.encodeBoolean(), Encoder$.MODULE$.encodeOption(Refunds$RefundList$.MODULE$.refundListEncoder()), Encoder$.MODULE$.encodeOption(Shippings$.MODULE$.shippingEncoder()), MODULE$.sourceEncoder(), Encoder$.MODULE$.encodeOption(Encoder$.MODULE$.encodeString()), Encoder$.MODULE$.encodeOption(Encoder$.MODULE$.encodeString()), Charges$Status$.MODULE$.chargeStatusEncoder());
        bitmap$init$0 |= 0x400000;
        chargeEncoder = Encoder$.MODULE$.instance((Function1 & Serializable)x -> MODULE$.chargeEncoderOne().apply(x).deepMerge(MODULE$.chargeEncoderTwo().apply(x)));
        bitmap$init$0 |= 0x800000;
        chargeInputDecoder = Decoder$.MODULE$.forProduct12("amount", "currency", "capture", "application_fee", "description", "destination", "metadata", "receipt_email", "shipping", "customer", "source", "statement_descriptor", (Function12 & Serializable)(amount, currency, capture, applicationFee, description, destination, metadata, receiptEmail, shipping, customer, source, statementDescriptor) -> Charges$.$anonfun$chargeInputDecoder$1(amount, currency, BoxesRunTime.unboxToBoolean((Object)capture), applicationFee, description, destination, metadata, receiptEmail, shipping, customer, source, statementDescriptor), Decoder$.MODULE$.decodeBigDecimal(), Currency$.MODULE$.currencyDecoder(), Decoder$.MODULE$.decodeBoolean(), Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeBigDecimal()), Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeString()), Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeString()), Decoder$.MODULE$.decodeMap(KeyDecoder$.MODULE$.decodeKeyString(), Decoder$.MODULE$.decodeString()), Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeString()), Decoder$.MODULE$.decodeOption(Shippings$.MODULE$.shippingDecoder()), Decoder$.MODULE$.decodeOption(MODULE$.sourceInputCustomerDecoder()), Decoder$.MODULE$.decodeOption(MODULE$.chargeSourceInputDecoder()), Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeString()));
        bitmap$init$0 |= 0x2000000;
        chargeInputPostParams = PostParams$.MODULE$.params((Function1 & Serializable)chargeInput -> (Map)((MapOps)PostParams$.MODULE$.flatten((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)new Some((Object)chargeInput.amount().toString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"currency"), (Object)new Some((Object)chargeInput.currency().iso().toLowerCase())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"capture"), (Object)new Some((Object)((Object)BoxesRunTime.boxToBoolean((boolean)chargeInput.capture())).toString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"application_fee"), (Object)chargeInput.applicationFee().map((Function1 & Serializable)x$34 -> x$34.toString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"description"), chargeInput.description()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"destination"), chargeInput.destination()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"receipt_email"), chargeInput.receiptEmail()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"customer"), (Object)chargeInput.customer().map((Function1 & Serializable)x$35 -> x$35.id())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"statement_descriptor"), chargeInput.statementDescriptor())}))).$plus$plus(PostParams$.MODULE$.toPostParams("metadata", chargeInput.metadata()))).$plus$plus(PostParams$.MODULE$.toPostParams(chargeInput.source(), MODULE$.sourceInputPostParams())));
        bitmap$init$0 |= 0x4000000;
    }

    private Logger logger$lzycompute() {
        Charges$ charges$ = this;
        synchronized (charges$) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        return !bitmap$trans$0 ? this.logger$lzycompute() : logger;
    }

    public Decoder<Charges.FraudDetails> fraudDetailsDecoder() {
        if ((bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/stan/Dev/stripe-scala/src/main/scala/org/mdedetrich/stripe/v1/Charges.scala: 63");
        }
        return fraudDetailsDecoder;
    }

    public Encoder<Charges.FraudDetails> fraudDetailsEncoder() {
        if ((bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/stan/Dev/stripe-scala/src/main/scala/org/mdedetrich/stripe/v1/Charges.scala: 68");
        }
        return fraudDetailsEncoder;
    }

    public Decoder<Charges.SourceInput.Customer> sourceInputCustomerDecoder() {
        if ((bitmap$init$0 & 0x20) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/stan/Dev/stripe-scala/src/main/scala/org/mdedetrich/stripe/v1/Charges.scala: 114");
        }
        return sourceInputCustomerDecoder;
    }

    public Decoder<Charges.SourceInput.Card> sourceInputCardDecoder() {
        if ((bitmap$init$0 & 0x40) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/stan/Dev/stripe-scala/src/main/scala/org/mdedetrich/stripe/v1/Charges.scala: 116");
        }
        return sourceInputCardDecoder;
    }

    public Decoder<Charges.SourceInput> chargeSourceInputDecoder() {
        if ((bitmap$init$0 & 0x80) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/stan/Dev/stripe-scala/src/main/scala/org/mdedetrich/stripe/v1/Charges.scala: 130");
        }
        return chargeSourceInputDecoder;
    }

    public Encoder<Charges.SourceInput.Customer> chargeSourceInputCustomerEncoder() {
        if ((bitmap$init$0 & 0x100) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/stan/Dev/stripe-scala/src/main/scala/org/mdedetrich/stripe/v1/Charges.scala: 145");
        }
        return chargeSourceInputCustomerEncoder;
    }

    public Encoder<Charges.SourceInput.Token> chargeSourceInputTokenEncoder() {
        if ((bitmap$init$0 & 0x200) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/stan/Dev/stripe-scala/src/main/scala/org/mdedetrich/stripe/v1/Charges.scala: 148");
        }
        return chargeSourceInputTokenEncoder;
    }

    public Encoder<Charges.SourceInput.Card> chargeSourceInputCustomerCard() {
        if ((bitmap$init$0 & 0x400) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/stan/Dev/stripe-scala/src/main/scala/org/mdedetrich/stripe/v1/Charges.scala: 151");
        }
        return chargeSourceInputCustomerCard;
    }

    public Encoder<Charges.SourceInput> chargeSourceInputEncoder() {
        if ((bitmap$init$0 & 0x800) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/stan/Dev/stripe-scala/src/main/scala/org/mdedetrich/stripe/v1/Charges.scala: 182");
        }
        return chargeSourceInputEncoder;
    }

    public PostParams<Charges.SourceInput.Card> cardPostParams() {
        if ((bitmap$init$0 & 0x1000) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/stan/Dev/stripe-scala/src/main/scala/org/mdedetrich/stripe/v1/Charges.scala: 188");
        }
        return cardPostParams;
    }

    public PostParams<Charges.SourceInput> sourceInputPostParams() {
        if ((bitmap$init$0 & 0x2000) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/stan/Dev/stripe-scala/src/main/scala/org/mdedetrich/stripe/v1/Charges.scala: 207");
        }
        return sourceInputPostParams;
    }

    public Decoder<Charges.Source> sourceDecoder() {
        if ((bitmap$init$0 & 0x8000) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/stan/Dev/stripe-scala/src/main/scala/org/mdedetrich/stripe/v1/Charges.scala: 304");
        }
        return sourceDecoder;
    }

    public Encoder<Charges.Source> sourceEncoder() {
        if ((bitmap$init$0 & 0x10000) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/stan/Dev/stripe-scala/src/main/scala/org/mdedetrich/stripe/v1/Charges.scala: 321");
        }
        return sourceEncoder;
    }

    private Decoder<Tuple22<String, BigDecimal, BigDecimal, Option<String>, Option<String>, Object, OffsetDateTime, Currency, Option<String>, Option<String>, Option<String>, Option<Disputes.Dispute>, Option<Errors.Code>, Option<String>, Option<Charges.FraudDetails>, Option<String>, Object, Option<Map<String, String>>, Option<String>, Object, Option<String>, Option<String>>> chargeDecoderOne() {
        if ((bitmap$init$0 & 0x40000) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/stan/Dev/stripe-scala/src/main/scala/org/mdedetrich/stripe/v1/Charges.scala: 418");
        }
        return chargeDecoderOne;
    }

    private Decoder<Tuple7<Object, Option<Refunds.RefundList>, Option<Shippings.Shipping>, Charges.Source, Option<String>, Option<String>, Charges.Status>> chargeDecoderTwo() {
        if ((bitmap$init$0 & 0x80000) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/stan/Dev/stripe-scala/src/main/scala/org/mdedetrich/stripe/v1/Charges.scala: 468");
        }
        return chargeDecoderTwo;
    }

    public Decoder<Charges.Charge> chargeDecoder() {
        if ((bitmap$init$0 & 0x100000) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/stan/Dev/stripe-scala/src/main/scala/org/mdedetrich/stripe/v1/Charges.scala: 488");
        }
        return chargeDecoder;
    }

    private Encoder<Charges.Charge> chargeEncoderOne() {
        if ((bitmap$init$0 & 0x200000) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/stan/Dev/stripe-scala/src/main/scala/org/mdedetrich/stripe/v1/Charges.scala: 552");
        }
        return chargeEncoderOne;
    }

    private Encoder<Charges.Charge> chargeEncoderTwo() {
        if ((bitmap$init$0 & 0x400000) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/stan/Dev/stripe-scala/src/main/scala/org/mdedetrich/stripe/v1/Charges.scala: 603");
        }
        return chargeEncoderTwo;
    }

    public Encoder<Charges.Charge> chargeEncoder() {
        if ((bitmap$init$0 & 0x800000) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/stan/Dev/stripe-scala/src/main/scala/org/mdedetrich/stripe/v1/Charges.scala: 626");
        }
        return chargeEncoder;
    }

    public Decoder<Charges.ChargeInput> chargeInputDecoder() {
        if ((bitmap$init$0 & 0x2000000) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/stan/Dev/stripe-scala/src/main/scala/org/mdedetrich/stripe/v1/Charges.scala: 709");
        }
        return chargeInputDecoder;
    }

    public PostParams<Charges.ChargeInput> chargeInputPostParams() {
        if ((bitmap$init$0 & 0x4000000) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/stan/Dev/stripe-scala/src/main/scala/org/mdedetrich/stripe/v1/Charges.scala: 724");
        }
        return chargeInputPostParams;
    }

    public Future<Try<Charges.Charge>> create(Charges.ChargeInput chargeInput, Option<IdempotencyKey> idempotencyKey, String apiKey, String endpoint, HttpExt client, Materializer materializer, ExecutionContext executionContext) {
        BoxedUnit boxedUnit;
        Map<String, String> postFormParameters = PostParams$.MODULE$.toPostParams(chargeInput, this.chargeInputPostParams());
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Generated POST form parameters is {}", postFormParameters);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        String finalUrl = new StringBuilder(11).append(endpoint).append("/v1/charges").toString();
        return package$.MODULE$.createRequestPOST(finalUrl, postFormParameters, idempotencyKey, this.logger(), package$.MODULE$.createRequestPOST$default$5(), client, materializer, executionContext, this.chargeDecoder(), apiKey);
    }

    public Option<IdempotencyKey> create$default$2(Charges.ChargeInput chargeInput) {
        return None$.MODULE$;
    }

    public static final /* synthetic */ Charges.SourceInput.Card $anonfun$sourceInputCardDecoder$1(int expMonth, int expYear, String number, Option cvc, Option addressCity, Option addressCountry, Option addressLine1, Option addressLine2, Option name, Option addressState, Option addressZip) {
        return new Charges.SourceInput.Card(expMonth, expYear, number, (Option<String>)cvc, (Option<String>)addressCity, (Option<String>)addressCountry, (Option<String>)addressLine1, (Option<String>)addressLine2, (Option<String>)name, (Option<String>)addressState, (Option<String>)addressZip);
    }

    public static final /* synthetic */ Tuple22 $anonfun$chargeDecoderOne$1(String x$3, BigDecimal x$4, BigDecimal x$5, Option x$6, Option x$7, boolean x$8, OffsetDateTime x$9, Currency x$10, Option x$11, Option x$12, Option x$13, Option x$14, Option x$15, Option x$16, Option x$17, Option x$18, boolean x$19, Option x$20, Option x$21, boolean x$22, Option x$23, Option x$24) {
        return new Tuple22((Object)x$3, (Object)x$4, (Object)x$5, (Object)x$6, (Object)x$7, (Object)BoxesRunTime.boxToBoolean((boolean)x$8), (Object)x$9, (Object)x$10, (Object)x$11, (Object)x$12, (Object)x$13, (Object)x$14, (Object)x$15, (Object)x$16, (Object)x$17, (Object)x$18, (Object)BoxesRunTime.boxToBoolean((boolean)x$19), (Object)x$20, (Object)x$21, (Object)BoxesRunTime.boxToBoolean((boolean)x$22), (Object)x$23, (Object)x$24);
    }

    public static final /* synthetic */ Tuple7 $anonfun$chargeDecoderTwo$1(boolean x$25, Option x$26, Option x$27, Charges.Source x$28, Option x$29, Option x$30, Charges.Status x$31) {
        return new Tuple7((Object)BoxesRunTime.boxToBoolean((boolean)x$25), (Object)x$26, (Object)x$27, (Object)x$28, (Object)x$29, (Object)x$30, (Object)x$31);
    }

    public static final /* synthetic */ Charges.ChargeInput $anonfun$chargeInputDecoder$1(BigDecimal amount, Currency currency, boolean capture, Option applicationFee, Option description, Option destination, Map metadata, Option receiptEmail, Option shipping, Option customer, Option source, Option statementDescriptor) {
        return new Charges.ChargeInput(amount, currency, capture, (Option<BigDecimal>)applicationFee, (Option<String>)description, (Option<String>)destination, (Map<String, String>)metadata, (Option<String>)receiptEmail, (Option<Shippings.Shipping>)shipping, (Option<Charges.SourceInput.Customer>)customer, (Option<Charges.SourceInput>)source, (Option<String>)statementDescriptor);
    }

    private Charges$() {
    }
}

