/*
 * Decompiled with CFR 0.152.
 */
package com.github.j5ik2o.reactive.redis.pool;

import akka.actor.ActorSystem;
import akka.stream.Supervision;
import cats.data.Kleisli;
import cats.data.NonEmptyList;
import com.github.j5ik2o.reactive.redis.PeerConfig;
import com.github.j5ik2o.reactive.redis.RedisConnection;
import com.github.j5ik2o.reactive.redis.RedisConnectionPool;
import com.github.j5ik2o.reactive.redis.pool.PoolType;
import com.github.j5ik2o.reactive.redis.pool.PoolType$Blaze$;
import com.github.j5ik2o.reactive.redis.pool.PoolType$Queue$;
import com.github.j5ik2o.reactive.redis.pool.RedisConnectionAllocator;
import com.github.j5ik2o.reactive.redis.pool.RedisConnectionExpiration;
import com.github.j5ik2o.reactive.redis.pool.RedisConnectionPoolable;
import com.github.j5ik2o.reactive.redis.pool.StormpotConfig;
import com.github.j5ik2o.reactive.redis.pool.StormpotConnection;
import com.github.j5ik2o.reactive.redis.pool.StormpotPool$;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Scheduler;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import stormpot.Allocator;
import stormpot.BlazePool;
import stormpot.Config;
import stormpot.Expiration;
import stormpot.LifecycledResizablePool;
import stormpot.ManagedPool;
import stormpot.QueuePool;
import stormpot.Timeout;

@ScalaSignature(bytes="\u0006\u0001\t}t!B\u0001\u0003\u0011\u0003y\u0011\u0001D*u_Jl\u0007o\u001c;Q_>d'BA\u0002\u0005\u0003\u0011\u0001xn\u001c7\u000b\u0005\u00151\u0011!\u0002:fI&\u001c(BA\u0004\t\u0003!\u0011X-Y2uSZ,'BA\u0005\u000b\u0003\u0019QW'[63_*\u00111\u0002D\u0001\u0007O&$\b.\u001e2\u000b\u00035\t1aY8n\u0007\u0001\u0001\"\u0001E\t\u000e\u0003\t1QA\u0005\u0002\t\u0002M\u0011Ab\u0015;pe6\u0004x\u000e\u001e)p_2\u001c\"!\u0005\u000b\u0011\u0005UAR\"\u0001\f\u000b\u0003]\tQa]2bY\u0006L!!\u0007\f\u0003\r\u0005s\u0017PU3g\u0011\u0015Y\u0012\u0003\"\u0001\u001d\u0003\u0019a\u0014N\\5u}Q\tq\u0002C\u0003\u001f#\u0011\u0005q$\u0001\u0005pMNKgn\u001a7f)%\u0001#\u0011\tB\"\u0005\u000b\u00129\u0005F\u0003\"\u0005{\u0011y\u0004\u0005\u0002\u0011E\u0019!!C\u0001\u0002$'\t\u0011C\u0005E\u0002&M!j\u0011\u0001B\u0005\u0003O\u0011\u00111CU3eSN\u001cuN\u001c8fGRLwN\u001c)p_2\u0004\"!\u000b\u0018\u000e\u0003)R!a\u000b\u0017\u0002\t\u00154\u0018\r\u001c\u0006\u0002[\u0005)Qn\u001c8jq&\u0011qF\u000b\u0002\u0005)\u0006\u001c8\u000e\u0003\u00052E\t\u0015\r\u0011\"\u00013\u0003Q\u0019wN\u001c8fGRLwN\u001c)p_2\u001cuN\u001c4jOV\t1\u0007\u0005\u0002\u0011i%\u0011QG\u0001\u0002\u000f'R|'/\u001c9pi\u000e{gNZ5h\u0011!9$E!A!\u0002\u0013\u0019\u0014!F2p]:,7\r^5p]B{w\u000e\\\"p]\u001aLw\r\t\u0005\ts\t\u0012)\u0019!C\u0001u\u0005Y\u0001/Z3s\u0007>tg-[4t+\u0005Y\u0004c\u0001\u001fB\u00076\tQH\u0003\u0002?\u007f\u0005!A-\u0019;b\u0015\u0005\u0001\u0015\u0001B2biNL!AQ\u001f\u0003\u00199{g.R7qifd\u0015n\u001d;\u0011\u0005\u0015\"\u0015BA#\u0005\u0005)\u0001V-\u001a:D_:4\u0017n\u001a\u0005\t\u000f\n\u0012\t\u0011)A\u0005w\u0005a\u0001/Z3s\u0007>tg-[4tA!A\u0011J\tBC\u0002\u0013\u0005!*A\u0007oK^\u001cuN\u001c8fGRLwN\\\u000b\u0002\u0017B\u0011A\n\u0018\b\u0003\u001bjs!AT-\u000f\u0005=CfB\u0001)X\u001d\t\tfK\u0004\u0002S+6\t1K\u0003\u0002U\u001d\u00051AH]8pizJ\u0011!D\u0005\u0003\u00171I!!\u0003\u0006\n\u0005\u001dA\u0011BA\u0003\u0007\u0013\tYF!A\u0004qC\u000e\\\u0017mZ3\n\u0005us&A\u0005(foJ+G-[:D_:tWm\u0019;j_:T!a\u0017\u0003\t\u0011\u0001\u0014#\u0011!Q\u0001\n-\u000baB\\3x\u0007>tg.Z2uS>t\u0007\u0005\u0003\u0005cE\t\u0015\r\u0011\"\u0001d\u0003I\u0019X\u000f]3sm&\u001c\u0018n\u001c8EK\u000eLG-\u001a:\u0016\u0003\u0011\u00042!F3h\u0013\t1gC\u0001\u0004PaRLwN\u001c\t\u0003QBt!!\u001b8\u000e\u0003)T!a\u001b7\u0002\rM$(/Z1n\u0015\u0005i\u0017\u0001B1lW\u0006L!a\u001c6\u0002\u0017M+\b/\u001a:wSNLwN\\\u0005\u0003cJ\u0014q\u0001R3dS\u0012,'O\u0003\u0002pU\"AAO\tB\u0001B\u0003%A-A\ntkB,'O^5tS>tG)Z2jI\u0016\u0014\b\u0005\u0003\u0005wE\t\u0005\t\u0015a\u0003x\u0003\u0019\u0019\u0018p\u001d;f[B\u0011\u0001p_\u0007\u0002s*\u0011!\u0010\\\u0001\u0006C\u000e$xN]\u0005\u0003yf\u00141\"Q2u_J\u001c\u0016p\u001d;f[\"AaP\tB\u0001B\u0003-q0A\u0005tG\",G-\u001e7feB!\u0011\u0011AA\u0004\u001b\t\t\u0019AC\u0002\u0002\u00061\n\u0011\"\u001a=fGV$\u0018n\u001c8\n\t\u0005%\u00111\u0001\u0002\n'\u000eDW\rZ;mKJDaa\u0007\u0012\u0005\n\u00055ACCA\b\u0003+\t9\"!\u0007\u0002\u001cQ)\u0011%!\u0005\u0002\u0014!1a/a\u0003A\u0004]DaA`A\u0006\u0001\by\bBB\u0019\u0002\f\u0001\u00071\u0007\u0003\u0004:\u0003\u0017\u0001\ra\u000f\u0005\u0007\u0013\u0006-\u0001\u0019A&\t\u0011\t\fY\u0001%AA\u0002\u0011D\u0011\"a\b#\u0005\u0004%\t!!\t\u0002\u0019\u0011+e)Q+M)~\u001b\u0016JW#\u0016\u0005\u0005\r\u0002cA\u000b\u0002&%\u0019\u0011q\u0005\f\u0003\u0007%sG\u000f\u0003\u0005\u0002,\t\u0002\u000b\u0011BA\u0012\u00035!UIR!V\u0019R{6+\u0013.FA!I\u0011q\u0006\u0012C\u0002\u0013\u0005\u0011\u0011E\u0001!\t\u00163\u0015)\u0016'U?\u000ec\u0015)S'`)&kUiT+U?&sulU#D\u001f:#5\u000b\u0003\u0005\u00024\t\u0002\u000b\u0011BA\u0012\u0003\u0005\"UIR!V\u0019R{6\tT!J\u001b~#\u0016*T#P+R{\u0016JT0T\u000b\u000e{e\nR*!\u0011\u001d\t9D\tC\u0005\u0003s\t\u0011B\\3x\u0007>tg-[4\u0015\t\u0005m\u0012Q\n\t\u0007\u0003{\t\u0019%a\u0012\u000e\u0005\u0005}\"BAA!\u0003!\u0019Ho\u001c:na>$\u0018\u0002BA#\u0003\u007f\u0011aaQ8oM&<\u0007c\u0001\t\u0002J%\u0019\u00111\n\u0002\u0003/I+G-[:D_:tWm\u0019;j_:\u0004vn\u001c7bE2,\u0007bBA(\u0003k\u0001\raQ\u0001\u000ba\u0016,'oQ8oM&<\u0007bBA*E\u0011%\u0011QK\u0001\b]\u0016<\bk\\8m)\u0011\t9&!\u001b\u0013\r\u0005e\u0013QLA2\r\u0019\tYF\t\u0001\u0002X\taAH]3gS:,W.\u001a8u}A1\u0011QHA0\u0003\u000fJA!!\u0019\u0002@\t9B*\u001b4fGf\u001cG.\u001a3SKNL'0\u00192mKB{w\u000e\u001c\t\u0005\u0003{\t)'\u0003\u0003\u0002h\u0005}\"aC'b]\u0006<W\r\u001a)p_2D\u0001\"a\u001b\u0002R\u0001\u0007\u00111H\u0001\u0007G>tg-[4\t\u0013\u0005=$E1A\u0005\n\u0005E\u0014!\u00029p_2\u001cXCAA:!\u0019\t)(! \u0002\u0004:!\u0011qOA>\u001d\r\u0011\u0016\u0011P\u0005\u0002/%\u00111LF\u0005\u0005\u0003\u007f\n\tIA\u0002TKFT!a\u0017\f\u0013\r\u0005\u0015\u0015QLA2\r\u0019\tYF\t\u0001\u0002\u0004\"A\u0011\u0011\u0012\u0012!\u0002\u0013\t\u0019(\u0001\u0004q_>d7\u000f\t\u0005\n\u0003\u001b\u0013#\u0019!C\u0005\u0003\u001f\u000bQ!\u001b8eKb,\"!!%\u0011\t\u0005M\u0015QU\u0007\u0003\u0003+SA!a&\u0002\u001a\u00061\u0011\r^8nS\u000eTA!a'\u0002\u001e\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\u0005}\u0015\u0011U\u0001\u0005kRLGN\u0003\u0002\u0002$\u0006!!.\u0019<b\u0013\u0011\t9+!&\u0003\u0015\u0005#x.\\5d\u0019>tw\r\u0003\u0005\u0002,\n\u0002\u000b\u0011BAI\u0003\u0019Ig\u000eZ3yA!9\u0011q\u0016\u0012\u0005\n\u0005E\u0016aB4fiB{w\u000e\\\u000b\u0003\u0003g\u0013b!!.\u0002^\u0005\rdABA.E\u0001\t\u0019\fC\u0005\u0002:\n\u0012\r\u0011\"\u0003\u0002<\u0006Y1\r\\1j[RKWm\\;u+\t\ti\f\u0005\u0003\u0002>\u0005}\u0016\u0002BAa\u0003\u007f\u0011q\u0001V5nK>,H\u000f\u0003\u0005\u0002F\n\u0002\u000b\u0011BA_\u00031\u0019G.Y5n)&,w.\u001e;!\u0011\u001d\tIM\tC!\u0003\u0017\fqb^5uQ\u000e{gN\\3di&|g.T\u000b\u0005\u0003\u001b\f)\u000e\u0006\u0003\u0002P\u0006\u001d\b\u0003B\u0015/\u0003#\u0004B!a5\u0002V2\u0001A\u0001CAl\u0003\u000f\u0014\r!!7\u0003\u0003Q\u000bB!a7\u0002bB\u0019Q#!8\n\u0007\u0005}gCA\u0004O_RD\u0017N\\4\u0011\u0007U\t\u0019/C\u0002\u0002fZ\u00111!\u00118z\u0011!\tI/a2A\u0002\u0005-\u0018A\u0002:fC\u0012,'\u000f\u0005\u0004M\u0003[D\u0013\u0011[\u0005\u0004\u0003_t&!\u0006*fC\u0012,'OU3eSN\u001cuN\u001c8fGRLwN\u001c\u0015\t\u0003\u000f\f\u00190a@\u0003\u0002A!\u0011Q_A~\u001b\t\t9P\u0003\u0003\u0002z\u0006\u0005\u0016\u0001\u00027b]\u001eLA!!@\u0002x\n\u00012+\u001e9qe\u0016\u001c8oV1s]&twm]\u0001\u0006m\u0006dW/\u001a\u0017\u0007\u0005\u0007\u00119Aa\u0003\"\u0005\t\u0015\u0011\u0001H8sO::\u0018M\u001d;sK6|g/\u001a:/o\u0006\u0014Ho\u001d\u0018FcV\fGn]\u0011\u0003\u0005\u0013\t!d\u001c:h]]\f'\u000f\u001e:f[>4XM\u001d\u0018xCJ$8O\f(vY2\f#A!\u0004\u00023=\u0014xML<beR\u0014X-\\8wKJts/\u0019:ug:2\u0016M\u001d\u0005\b\u0005#\u0011C\u0011\tB\n\u0003A\u0011wN\u001d:po\u000e{gN\\3di&|g.\u0006\u0002\u0003\u0016A!\u0011F\fB\f!\r)#\u0011D\u0005\u0004\u00057!!a\u0004*fI&\u001c8i\u001c8oK\u000e$\u0018n\u001c8\t\u000f\t}!\u0005\"\u0011\u0003\"\u0005\u0001\"/\u001a;ve:\u001cuN\u001c8fGRLwN\u001c\u000b\u0005\u0005G\u0011Y\u0003\u0005\u0003*]\t\u0015\u0002cA\u000b\u0003(%\u0019!\u0011\u0006\f\u0003\tUs\u0017\u000e\u001e\u0005\t\u0005[\u0011i\u00021\u0001\u0003\u0018\u0005y!/\u001a3jg\u000e{gN\\3di&|g\u000eC\u0004\u00032\t\"\t%!\t\u0002\u00139,X.Q2uSZ,\u0007b\u0002B\u001bE\u0011\u0005#qG\u0001\u0006G2,\u0017M\u001d\u000b\u0003\u0005KAqAa\u000f#\t\u0003\u00129$A\u0004eSN\u0004xn]3\t\u000bYl\u00029A<\t\u000byl\u00029A@\t\u000bEj\u0002\u0019A\u001a\t\r\u0005=S\u00041\u0001D\u0011\u0015IU\u00041\u0001L\u0011\u001d\u0011W\u0004%AA\u0002\u0011DqAa\u0013\u0012\t\u0003\u0011i%\u0001\u0006pM6+H\u000e^5qY\u0016$\"Ba\u0014\u0003V\t]#\u0011\fB.)\u0015\t#\u0011\u000bB*\u0011\u00191(\u0011\na\u0002o\"1aP!\u0013A\u0004}Da!\rB%\u0001\u0004\u0019\u0004BB\u001d\u0003J\u0001\u00071\b\u0003\u0004J\u0005\u0013\u0002\ra\u0013\u0005\tE\n%\u0003\u0013!a\u0001I\"I!qL\t\u0012\u0002\u0013%!\u0011M\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\t\r$f\u00013\u0003f-\u0012!q\r\t\u0005\u0005S\u0012\u0019(\u0004\u0002\u0003l)!!Q\u000eB8\u0003%)hn\u00195fG.,GMC\u0002\u0003rY\t!\"\u00198o_R\fG/[8o\u0013\u0011\u0011)Ha\u001b\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0003zE\t\n\u0011\"\u0001\u0003b\u0005\u0011rNZ*j]\u001edW\r\n3fM\u0006,H\u000e\u001e\u00135\u0011%\u0011i(EI\u0001\n\u0003\u0011\t'\u0001\u000bpM6+H\u000e^5qY\u0016$C-\u001a4bk2$H\u0005\u000e")
public final class StormpotPool
extends RedisConnectionPool<Task> {
    private final StormpotConfig connectionPoolConfig;
    private final NonEmptyList<PeerConfig> peerConfigs;
    private final Function3<PeerConfig, Option<Function1<Throwable, Supervision.Directive>>, Seq<Function1<RedisConnection.Event, BoxedUnit>>, RedisConnection> newConnection;
    private final Option<Function1<Throwable, Supervision.Directive>> supervisionDecider;
    private final ActorSystem system;
    private final Scheduler scheduler;
    private final int DEFAULT_SIZE;
    private final int DEFAULT_CLAIM_TIMEOUT_IN_SECONDS;
    private final Seq<LifecycledResizablePool<RedisConnectionPoolable>> pools;
    private final AtomicLong index;
    private final Timeout claimTieout;

    public static Option<Function1<Throwable, Supervision.Directive>> ofMultiple$default$4() {
        return StormpotPool$.MODULE$.ofMultiple$default$4();
    }

    public static Option<Function1<Throwable, Supervision.Directive>> ofSingle$default$4() {
        return StormpotPool$.MODULE$.ofSingle$default$4();
    }

    public static StormpotPool ofMultiple(StormpotConfig stormpotConfig, NonEmptyList<PeerConfig> nonEmptyList, Function3<PeerConfig, Option<Function1<Throwable, Supervision.Directive>>, Seq<Function1<RedisConnection.Event, BoxedUnit>>, RedisConnection> function3, Option<Function1<Throwable, Supervision.Directive>> option, ActorSystem actorSystem, Scheduler scheduler) {
        return StormpotPool$.MODULE$.ofMultiple(stormpotConfig, nonEmptyList, function3, option, actorSystem, scheduler);
    }

    public static StormpotPool ofSingle(StormpotConfig stormpotConfig, PeerConfig peerConfig, Function3<PeerConfig, Option<Function1<Throwable, Supervision.Directive>>, Seq<Function1<RedisConnection.Event, BoxedUnit>>, RedisConnection> function3, Option<Function1<Throwable, Supervision.Directive>> option, ActorSystem actorSystem, Scheduler scheduler) {
        return StormpotPool$.MODULE$.ofSingle(stormpotConfig, peerConfig, function3, option, actorSystem, scheduler);
    }

    public StormpotConfig connectionPoolConfig() {
        return this.connectionPoolConfig;
    }

    public NonEmptyList<PeerConfig> peerConfigs() {
        return this.peerConfigs;
    }

    public Function3<PeerConfig, Option<Function1<Throwable, Supervision.Directive>>, Seq<Function1<RedisConnection.Event, BoxedUnit>>, RedisConnection> newConnection() {
        return this.newConnection;
    }

    public Option<Function1<Throwable, Supervision.Directive>> supervisionDecider() {
        return this.supervisionDecider;
    }

    public int DEFAULT_SIZE() {
        return this.DEFAULT_SIZE;
    }

    public int DEFAULT_CLAIM_TIMEOUT_IN_SECONDS() {
        return this.DEFAULT_CLAIM_TIMEOUT_IN_SECONDS;
    }

    private Config<RedisConnectionPoolable> newConfig(PeerConfig peerConfig) {
        return new Config().setAllocator((Allocator)new RedisConnectionAllocator(peerConfig, this.newConnection(), this.supervisionDecider(), this.system)).setExpiration((Expiration)new RedisConnectionExpiration((Duration)this.connectionPoolConfig().validationTimeout().getOrElse((Function0 & Serializable & scala.Serializable)() -> new package.DurationInt(package$.MODULE$.DurationInt(3)).seconds()), this.system, this.scheduler)).setSize(BoxesRunTime.unboxToInt((Object)this.connectionPoolConfig().sizePerPeer().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this.DEFAULT_SIZE()))).setBackgroundExpirationEnabled(BoxesRunTime.unboxToBoolean((Object)this.connectionPoolConfig().backgroundExpirationEnabled().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false))).setPreciseLeakDetectionEnabled(BoxesRunTime.unboxToBoolean((Object)this.connectionPoolConfig().preciseLeakDetectionEnabled().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false)));
    }

    private LifecycledResizablePool<RedisConnectionPoolable> newPool(Config<RedisConnectionPoolable> config) {
        BlazePool blazePool;
        PoolType poolType = this.connectionPoolConfig().poolType();
        if (PoolType$Blaze$.MODULE$.equals(poolType)) {
            blazePool = new BlazePool(config);
        } else if (PoolType$Queue$.MODULE$.equals(poolType)) {
            blazePool = new QueuePool(config);
        } else {
            throw new MatchError((Object)poolType);
        }
        return blazePool;
    }

    private Seq<LifecycledResizablePool<RedisConnectionPoolable>> pools() {
        return this.pools;
    }

    private AtomicLong index() {
        return this.index;
    }

    private LifecycledResizablePool<RedisConnectionPoolable> getPool() {
        return (LifecycledResizablePool)this.pools().apply((int)this.index().getAndIncrement() % this.pools().size());
    }

    private Timeout claimTieout() {
        return this.claimTieout;
    }

    public <T> Task<T> withConnectionM(Kleisli<Task, RedisConnection, T> reader) {
        Task task;
        RedisConnectionPoolable poolable = null;
        try {
            this.logger().debug("---- start");
            poolable = (RedisConnectionPoolable)this.getPool().claim(this.claimTieout());
            this.logger().debug(new StringBuilder(11).append("poolabel = ").append(poolable).toString());
            task = (Task)reader.run().apply((Object)poolable.redisConnection());
        }
        finally {
            if (poolable != null) {
                poolable.release();
            }
            this.logger().debug("---- finish");
        }
        return task;
    }

    public Task<RedisConnection> borrowConnection() {
        Task task;
        try {
            RedisConnectionPoolable c = (RedisConnectionPoolable)this.getPool().claim(this.claimTieout());
            task = Task$.MODULE$.pure((Object)new StormpotConnection(c));
        }
        catch (Throwable t) {
            task = Task$.MODULE$.raiseError(t);
        }
        return task;
    }

    public Task<BoxedUnit> returnConnection(RedisConnection redisConnection) {
        Task task;
        RedisConnection redisConnection2 = redisConnection;
        if (redisConnection2 instanceof StormpotConnection) {
            StormpotConnection stormpotConnection = (StormpotConnection)redisConnection2;
            try {
                stormpotConnection.redisConnectionPoolable().release();
                task = Task$.MODULE$.pure((Object)BoxedUnit.UNIT);
            }
            catch (Throwable t) {
                task = Task$.MODULE$.raiseError(t);
            }
        } else {
            throw new IllegalArgumentException("Invalid connection class");
        }
        Task task2 = task;
        return task2;
    }

    public int numActive() {
        return BoxesRunTime.unboxToInt((Object)this.pools().foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable & scala.Serializable)(x$1, x$2) -> BoxesRunTime.boxToInteger((int)StormpotPool.$anonfun$numActive$1(BoxesRunTime.unboxToInt((Object)x$1), x$2))));
    }

    public void clear() {
        this.pools().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            StormpotPool.$anonfun$clear$1(x$3);
            return BoxedUnit.UNIT;
        });
        this.pools().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            StormpotPool.$anonfun$clear$2(this, x$4);
            return BoxedUnit.UNIT;
        });
    }

    public void dispose() {
        this.pools().foreach((Function1 & Serializable & scala.Serializable)x$5 -> x$5.shutdown());
    }

    public static final /* synthetic */ int $anonfun$numActive$1(int x$1, LifecycledResizablePool x$2) {
        return x$1 + (int)((ManagedPool)x$2).getAllocationCount();
    }

    public static final /* synthetic */ void $anonfun$clear$1(LifecycledResizablePool x$3) {
        ((ManagedPool)x$3).setTargetSize(0);
    }

    public static final /* synthetic */ void $anonfun$clear$2(StormpotPool $this, LifecycledResizablePool x$4) {
        ((ManagedPool)x$4).setTargetSize(BoxesRunTime.unboxToInt((Object)$this.connectionPoolConfig().sizePerPeer().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> $this.DEFAULT_SIZE())));
    }

    public StormpotPool(StormpotConfig connectionPoolConfig, NonEmptyList<PeerConfig> peerConfigs, Function3<PeerConfig, Option<Function1<Throwable, Supervision.Directive>>, Seq<Function1<RedisConnection.Event, BoxedUnit>>, RedisConnection> newConnection, Option<Function1<Throwable, Supervision.Directive>> supervisionDecider, ActorSystem system, Scheduler scheduler) {
        this.connectionPoolConfig = connectionPoolConfig;
        this.peerConfigs = peerConfigs;
        this.newConnection = newConnection;
        this.supervisionDecider = supervisionDecider;
        this.system = system;
        this.scheduler = scheduler;
        this.DEFAULT_SIZE = 8;
        this.DEFAULT_CLAIM_TIMEOUT_IN_SECONDS = 10;
        this.pools = (Seq)peerConfigs.toList().map((Function1 & Serializable & scala.Serializable)peerConfig -> {
            Config<RedisConnectionPoolable> config = this.newConfig((PeerConfig)peerConfig);
            return this.newPool(config);
        }, List$.MODULE$.canBuildFrom());
        this.index = new AtomicLong(0L);
        this.claimTieout = (Timeout)connectionPoolConfig.claimTimeout().map((Function1 & Serializable & scala.Serializable)v -> new Timeout(v.length(), v.unit())).getOrElse((Function0 & Serializable & scala.Serializable)() -> new Timeout((long)this.DEFAULT_CLAIM_TIMEOUT_IN_SECONDS(), TimeUnit.SECONDS));
    }
}

