/*
 * Decompiled with CFR 0.152.
 */
package com.github.j5ik2o.pekko.persistence.dynamodb.state.scaladsl;

import com.github.j5ik2o.pekko.persistence.dynamodb.client.v2.StreamReadClient;
import com.github.j5ik2o.pekko.persistence.dynamodb.client.v2.StreamWriteClient;
import com.github.j5ik2o.pekko.persistence.dynamodb.config.BackoffConfig;
import com.github.j5ik2o.pekko.persistence.dynamodb.context.PluginContext;
import com.github.j5ik2o.pekko.persistence.dynamodb.model.Context;
import com.github.j5ik2o.pekko.persistence.dynamodb.model.Context$;
import com.github.j5ik2o.pekko.persistence.dynamodb.model.PersistenceId;
import com.github.j5ik2o.pekko.persistence.dynamodb.model.PersistenceId$;
import com.github.j5ik2o.pekko.persistence.dynamodb.state.AkkaSerialized;
import com.github.j5ik2o.pekko.persistence.dynamodb.state.AkkaSerialized$;
import com.github.j5ik2o.pekko.persistence.dynamodb.state.DynamoDBDurableStateStoreProvider$;
import com.github.j5ik2o.pekko.persistence.dynamodb.state.GetRawObjectResult;
import com.github.j5ik2o.pekko.persistence.dynamodb.state.PartitionKey;
import com.github.j5ik2o.pekko.persistence.dynamodb.state.SortKey;
import com.github.j5ik2o.pekko.persistence.dynamodb.state.StatePluginContext;
import com.github.j5ik2o.pekko.persistence.dynamodb.state.StateSerializer;
import com.github.j5ik2o.pekko.persistence.dynamodb.state.TableName;
import com.github.j5ik2o.pekko.persistence.dynamodb.state.scaladsl.ScalaDurableStateUpdateStore;
import com.github.j5ik2o.pekko.persistence.dynamodb.utils.LoggingSupport;
import java.io.IOException;
import java.io.Serializable;
import java.util.UUID;
import org.apache.pekko.Done;
import org.apache.pekko.Done$;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.actor.CoordinatedShutdown;
import org.apache.pekko.actor.CoordinatedShutdown$;
import org.apache.pekko.annotation.ApiMayChange;
import org.apache.pekko.persistence.state.scaladsl.GetObjectResult;
import org.apache.pekko.persistence.state.scaladsl.GetObjectResult$;
import org.apache.pekko.serialization.Serialization;
import org.apache.pekko.serialization.SerializationExtension$;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.Materializer$;
import org.apache.pekko.stream.scaladsl.Sink$;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.Source$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.GetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.PutItemRequest;

@ApiMayChange
public final class DynamoDBDurableStateStoreV2<A>
implements ScalaDurableStateUpdateStore<A>,
LoggingSupport {
    private Logger logger;
    private final StatePluginContext pluginContext;
    private final Option asyncClient;
    private final Option syncClient;
    private final ActorSystem system;
    private final ActorSystem mat;
    private final ExecutionContext ec;
    private final StreamWriteClient streamWriteClient;
    private final StreamReadClient streamReadClient;
    private final StateSerializer akkaSerialization;

    public DynamoDBDurableStateStoreV2(StatePluginContext pluginContext, Option<DynamoDbAsyncClient> asyncClient, Option<DynamoDbClient> syncClient) {
        this.pluginContext = pluginContext;
        this.asyncClient = asyncClient;
        this.syncClient = syncClient;
        LoggingSupport.$init$((LoggingSupport)this);
        this.system = pluginContext.system();
        this.mat = pluginContext.system();
        this.ec = pluginContext.pluginExecutor();
        UUID id = UUID.randomUUID();
        ((CoordinatedShutdown)CoordinatedShutdown$.MODULE$.apply(this.system())).addTask(CoordinatedShutdown$.MODULE$.PhaseBeforeActorSystemTerminate(), new StringBuilder(1).append(DynamoDBDurableStateStoreProvider$.MODULE$.Identifier()).append("-").append(id).toString(), (Function0 & Serializable)() -> Future$.MODULE$.apply(this::$init$$$anonfun$1$$anonfun$1, this.ec()));
        BackoffConfig writeBackoffConfig = pluginContext.pluginConfig().writeBackoffConfig();
        BackoffConfig readBackoffConfig = pluginContext.pluginConfig().readBackoffConfig();
        this.streamWriteClient = new StreamWriteClient((PluginContext)pluginContext, asyncClient, syncClient, writeBackoffConfig);
        this.streamReadClient = new StreamReadClient((PluginContext)pluginContext, asyncClient, syncClient, readBackoffConfig);
        Serialization serialization = (Serialization)SerializationExtension$.MODULE$.apply(this.system());
        this.akkaSerialization = new StateSerializer(serialization, pluginContext.metricsReporter(), pluginContext.traceReporter());
        Statics.releaseFence();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$github$j5ik2o$pekko$persistence$dynamodb$utils$LoggingSupport$_setter_$logger_$eq(Logger x$0) {
        this.logger = x$0;
    }

    public StatePluginContext pluginContext() {
        return this.pluginContext;
    }

    public Option<DynamoDbAsyncClient> asyncClient() {
        return this.asyncClient;
    }

    public Option<DynamoDbClient> syncClient() {
        return this.syncClient;
    }

    public ActorSystem system() {
        return this.system;
    }

    public ActorSystem mat() {
        return this.mat;
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    public Future<GetRawObjectResult<A>> getRawObject(String persistenceId) {
        PersistenceId pid = PersistenceId$.MODULE$.apply(persistenceId);
        Context context = Context$.MODULE$.newContext(UUID.randomUUID(), pid, Context$.MODULE$.newContext$default$3());
        Context newContext = (Context)this.pluginContext().metricsReporter().fold(() -> DynamoDBDurableStateStoreV2.$anonfun$1(context), (Function1 & Serializable)_$1 -> _$1.beforeStateStoreGetObject(context));
        Future traced = (Future)this.pluginContext().traceReporter().fold(() -> this.$anonfun$6(pid), (Function1 & Serializable)_$5 -> _$5.traceStateStoreGetObject(context, () -> this.$anonfun$7$$anonfun$1(pid)));
        traced.onComplete((Function1)(JProcedure1 & Serializable)x$1 -> {
            Try try_ = x$1;
            if (try_ instanceof Success) {
                this.pluginContext().metricsReporter().foreach((Function1)(JProcedure1 & Serializable)_$6 -> _$6.afterStateStoreGetObject(newContext));
                return;
            }
            if (try_ instanceof Failure) {
                Throwable ex = ((Failure)try_).exception();
                this.pluginContext().metricsReporter().foreach((Function1)(JProcedure1 & Serializable)_$7 -> _$7.errorStateStoreGetObject(newContext, ex));
                return;
            }
            throw new MatchError((Object)try_);
        }, this.ec());
        return traced;
    }

    public Future<GetObjectResult<A>> getObject(String persistenceId) {
        return this.getRawObject(persistenceId).map((Function1 & Serializable)x$1 -> {
            GetRawObjectResult getRawObjectResult = x$1;
            if (GetRawObjectResult.Empty$.MODULE$.equals(getRawObjectResult)) {
                return GetObjectResult$.MODULE$.apply((Option)None$.MODULE$, 0L);
            }
            if (getRawObjectResult instanceof GetRawObjectResult.Just) {
                GetRawObjectResult.Just just = GetRawObjectResult.Just$.MODULE$.unapply((GetRawObjectResult.Just)getRawObjectResult);
                String string = just._1();
                String string2 = just._2();
                String string3 = just._3();
                Object object = just._4();
                long l = just._5();
                int n = just._6();
                Option option = just._7();
                Option option2 = just._8();
                long l2 = just._9();
                Object value = object;
                long revision = l;
                return GetObjectResult$.MODULE$.apply((Option)Some$.MODULE$.apply(value), revision);
            }
            throw new MatchError((Object)getRawObjectResult);
        }, this.ec());
    }

    public Future<Done> upsertObject(String persistenceId, long revision, A value, String tag) {
        Predef$.MODULE$.require(revision > 0L);
        PersistenceId pid = PersistenceId$.MODULE$.apply(persistenceId);
        Context context = Context$.MODULE$.newContext(UUID.randomUUID(), pid, Context$.MODULE$.newContext$default$3());
        Context newContext = (Context)this.pluginContext().metricsReporter().fold(() -> DynamoDBDurableStateStoreV2.$anonfun$8(context), (Function1 & Serializable)_$8 -> _$8.beforeStateStoreUpsertObject(context));
        Future traced = (Future)this.pluginContext().traceReporter().fold(() -> this.$anonfun$11(persistenceId, revision, value, tag, pid), (Function1 & Serializable)_$9 -> _$9.traceStateStoreUpsertObject(context, () -> this.$anonfun$12$$anonfun$1(persistenceId, revision, value, tag, pid)));
        traced.onComplete((Function1)(JProcedure1 & Serializable)x$1 -> {
            Try try_ = x$1;
            if (try_ instanceof Success) {
                this.pluginContext().metricsReporter().foreach((Function1)(JProcedure1 & Serializable)_$10 -> _$10.afterStateStoreUpsertObject(newContext));
                return;
            }
            if (try_ instanceof Failure) {
                Throwable ex = ((Failure)try_).exception();
                this.pluginContext().metricsReporter().foreach((Function1)(JProcedure1 & Serializable)_$11 -> _$11.errorStateStoreUpsertObject(newContext, ex));
                return;
            }
            throw new MatchError((Object)try_);
        }, this.ec());
        return traced;
    }

    public Future<Done> deleteObject(String persistenceId, long revision) {
        return this.deleteObject(persistenceId);
    }

    public Future<Done> deleteObject(String persistenceId) {
        PersistenceId pid = PersistenceId$.MODULE$.apply(persistenceId);
        Context context = Context$.MODULE$.newContext(UUID.randomUUID(), pid, Context$.MODULE$.newContext$default$3());
        Context newContext = (Context)this.pluginContext().metricsReporter().fold(() -> DynamoDBDurableStateStoreV2.$anonfun$13(context), (Function1 & Serializable)_$12 -> _$12.beforeStateStoreDeleteObject(context));
        Future traced = (Future)this.pluginContext().traceReporter().fold(() -> this.$anonfun$15(pid), (Function1 & Serializable)_$13 -> _$13.traceStateStoreDeleteObject(context, () -> this.$anonfun$16$$anonfun$1(pid)));
        traced.onComplete((Function1)(JProcedure1 & Serializable)x$1 -> {
            Try try_ = x$1;
            if (try_ instanceof Success) {
                this.pluginContext().metricsReporter().foreach((Function1)(JProcedure1 & Serializable)_$14 -> _$14.afterStateStoreDeleteObject(newContext));
                return;
            }
            if (try_ instanceof Failure) {
                Throwable ex = ((Failure)try_).exception();
                this.pluginContext().metricsReporter().foreach((Function1)(JProcedure1 & Serializable)_$15 -> _$15.errorStateStoreDeleteObject(newContext, ex));
                return;
            }
            throw new MatchError((Object)try_);
        }, this.ec());
        return traced;
    }

    private void dispose() {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply(this.asyncClient(), this.syncClient());
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (option instanceof Some) {
                DynamoDbAsyncClient a = (DynamoDbAsyncClient)((Some)option).value();
                a.close();
                return;
            }
            if (option2 instanceof Some) {
                DynamoDbClient s = (DynamoDbClient)((Some)option2).value();
                s.close();
                return;
            }
        }
    }

    private final Done$ $init$$$anonfun$1$$anonfun$1() {
        this.dispose();
        return Done$.MODULE$;
    }

    private static final Context $anonfun$1(Context context$1) {
        return context$1;
    }

    private static final Source future$1$$anonfun$1$$anonfun$3() {
        return Source$.MODULE$.single((Object)GetRawObjectResult.Empty$.MODULE$);
    }

    private final Future future$1(PersistenceId pid$1) {
        TableName tableName = this.pluginContext().tableNameResolver().resolve(pid$1);
        PartitionKey pkey = this.pluginContext().partitionKeyResolver().resolve(pid$1);
        SortKey skey = this.pluginContext().sortKeyResolver().resolve(pid$1);
        Object[] objectArray = new Tuple2[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().partitionKeyColumnName());
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, AttributeValue.builder().s(pkey.asString()).build());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().sortKeyColumnName());
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, AttributeValue.builder().s(skey.asString()).build());
        GetItemRequest request = (GetItemRequest)GetItemRequest.builder().tableName(tableName.asString()).key(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).asJava()).consistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginContext().pluginConfig().consistentRead())).build();
        return (Future)((Source)Source$.MODULE$.single((Object)request).via((Graph)this.streamReadClient.getFlow()).flatMapConcat((Function1 & Serializable)result -> {
            if (result.sdkHttpResponse().isSuccessful()) {
                return (Graph)Option$.MODULE$.apply((Object)result.item()).map((Function1 & Serializable)_$2 -> CollectionConverters$.MODULE$.MapHasAsScala(_$2).asScala()).map((Function1 & Serializable)item -> {
                    if (item.nonEmpty()) {
                        this.logger().debug(new StringBuilder(7).append("item = ").append(item).toString());
                        String persistenceId = ((AttributeValue)item.apply((Object)this.pluginContext().pluginConfig().columnsDefConfig().persistenceIdColumnName())).s();
                        int serializerId = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(((AttributeValue)item.apply((Object)this.pluginContext().pluginConfig().columnsDefConfig().serializerIdColumnName())).n()));
                        Option serializerManifest = item.get((Object)this.pluginContext().pluginConfig().columnsDefConfig().serializerManifestColumnName()).map((Function1 & Serializable)_$3 -> _$3.s());
                        byte[] payloadAsArrayByte = ((AttributeValue)item.apply((Object)this.pluginContext().pluginConfig().columnsDefConfig().payloadColumnName())).b().asByteArray();
                        long revision = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(((AttributeValue)item.apply((Object)this.pluginContext().pluginConfig().columnsDefConfig().revisionColumnName())).n()));
                        Option tag = item.get((Object)this.pluginContext().pluginConfig().columnsDefConfig().tagsColumnName()).map((Function1 & Serializable)_$4 -> _$4.s());
                        long ordering = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(((AttributeValue)item.apply((Object)this.pluginContext().pluginConfig().columnsDefConfig().orderingColumnName())).n()));
                        AkkaSerialized akkaSerialized = AkkaSerialized$.MODULE$.apply(serializerId, serializerManifest, payloadAsArrayByte);
                        Future payloadFuture = this.akkaSerialization.deserialize(persistenceId, akkaSerialized, this.ec()).map((Function1 & Serializable)payload -> GetRawObjectResult.Just$.MODULE$.apply(pkey.asString(), skey.asString(), persistenceId, payload, revision, serializerId, serializerManifest, tag, ordering), this.ec());
                        return Source$.MODULE$.future(payloadFuture);
                    }
                    return Source$.MODULE$.single((Object)GetRawObjectResult.Empty$.MODULE$);
                }).getOrElse(DynamoDBDurableStateStoreV2::future$1$$anonfun$1$$anonfun$3);
            }
            int statusCode = result.sdkHttpResponse().statusCode();
            return Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).toString()));
        })).runWith((Graph)Sink$.MODULE$.head(), Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)this.mat()));
    }

    private final Future $anonfun$6(PersistenceId pid$7) {
        return this.future$1(pid$7);
    }

    private final Future $anonfun$7$$anonfun$1(PersistenceId pid$8) {
        return this.future$1(pid$8);
    }

    private static final Context $anonfun$8(Context context$4) {
        return context$4;
    }

    private static final scala.collection.immutable.Map $anonfun$10$$anonfun$2() {
        return Predef$.MODULE$.Map().empty();
    }

    private final Future future$2(String persistenceId$2, long revision$2, Object value$1, String tag$2, PersistenceId pid$3) {
        TableName tableName = this.pluginContext().tableNameResolver().resolve(pid$3);
        PartitionKey pkey = this.pluginContext().partitionKeyResolver().resolve(pid$3);
        SortKey skey = this.pluginContext().sortKeyResolver().resolve(pid$3);
        Future request = this.akkaSerialization.serialize(persistenceId$2, value$1, this.ec()).map((Function1 & Serializable)serialized -> {
            scala.collection.immutable.Map map;
            PutItemRequest.Builder builder = PutItemRequest.builder().tableName(tableName.asString());
            Object[] objectArray = new Tuple2[7];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().partitionKeyColumnName());
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, AttributeValue.builder().s(pkey.asString()).build());
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().sortKeyColumnName());
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, AttributeValue.builder().s(skey.asString()).build());
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().persistenceIdColumnName());
            objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, AttributeValue.builder().s(persistenceId$2).build());
            String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().revisionColumnName());
            objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, AttributeValue.builder().n(BoxesRunTime.boxToLong((long)(revision$2 + 1L)).toString()).build());
            String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().payloadColumnName());
            objectArray[4] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, AttributeValue.builder().b(SdkBytes.fromByteArray((byte[])serialized.payload())).build());
            String string6 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().serializerIdColumnName());
            objectArray[5] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string6, AttributeValue.builder().n(BoxesRunTime.boxToInteger((int)serialized.serializerId()).toString()).build());
            String string7 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().orderingColumnName());
            objectArray[6] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string7, AttributeValue.builder().n(BoxesRunTime.boxToLong((long)System.currentTimeMillis()).toString()).build());
            MapOps mapOps = (MapOps)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            if (tag$2.isEmpty()) {
                map = Predef$.MODULE$.Map().empty();
            } else {
                Object[] objectArray2 = new Tuple2[1];
                String string8 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().tagsColumnName());
                objectArray2[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string8, AttributeValue.builder().s(tag$2).build());
                map = (IterableOnce)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2));
            }
            return (PutItemRequest)builder.item(CollectionConverters$.MODULE$.MapHasAsJava((Map)((MapOps)mapOps.$plus$plus((IterableOnce)map)).$plus$plus((IterableOnce)serialized.serializerManifest().map((Function1 & Serializable)v -> {
                Object[] objectArray = new Tuple2[1];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().serializerManifestColumnName());
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, AttributeValue.builder().s(v).build());
                return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            }).getOrElse(DynamoDBDurableStateStoreV2::$anonfun$10$$anonfun$2))).asJava()).build();
        }, this.ec());
        return (Future)((Source)Source$.MODULE$.future(request).via((Graph)this.streamWriteClient.putItemFlow()).flatMapConcat((Function1 & Serializable)response -> {
            if (response.sdkHttpResponse().isSuccessful()) {
                return Source$.MODULE$.single((Object)Done$.MODULE$);
            }
            int statusCode = response.sdkHttpResponse().statusCode();
            return Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).toString()));
        })).runWith((Graph)Sink$.MODULE$.head(), Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)this.mat()));
    }

    private final Future $anonfun$11(String persistenceId$5, long revision$5, Object value$3, String tag$5, PersistenceId pid$9) {
        return this.future$2(persistenceId$5, revision$5, value$3, tag$5, pid$9);
    }

    private final Future $anonfun$12$$anonfun$1(String persistenceId$6, long revision$6, Object value$4, String tag$6, PersistenceId pid$10) {
        return this.future$2(persistenceId$6, revision$6, value$4, tag$6, pid$10);
    }

    private static final Context $anonfun$13(Context context$7) {
        return context$7;
    }

    private final Future future$3(PersistenceId pid$5) {
        TableName tableName = this.pluginContext().tableNameResolver().resolve(pid$5);
        PartitionKey pkey = this.pluginContext().partitionKeyResolver().resolve(pid$5);
        SortKey skey = this.pluginContext().sortKeyResolver().resolve(pid$5);
        Object[] objectArray = new Tuple2[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().partitionKeyColumnName());
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, AttributeValue.builder().s(pkey.asString()).build());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().sortKeyColumnName());
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, AttributeValue.builder().s(skey.asString()).build());
        DeleteItemRequest request = (DeleteItemRequest)DeleteItemRequest.builder().tableName(tableName.asString()).key(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).asJava()).build();
        return (Future)((Source)Source$.MODULE$.single((Object)request).via((Graph)this.streamWriteClient.deleteItemFlow()).flatMapConcat((Function1 & Serializable)response -> {
            if (response.sdkHttpResponse().isSuccessful()) {
                return Source$.MODULE$.single((Object)Done$.MODULE$);
            }
            int statusCode = response.sdkHttpResponse().statusCode();
            return Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).toString()));
        })).runWith((Graph)Sink$.MODULE$.head(), Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)this.mat()));
    }

    private final Future $anonfun$15(PersistenceId pid$11) {
        return this.future$3(pid$11);
    }

    private final Future $anonfun$16$$anonfun$1(PersistenceId pid$12) {
        return this.future$3(pid$12);
    }
}

