/*
 * Decompiled with CFR 0.152.
 */
package com.github.j5ik2o.pekko.persistence.dynamodb.state;

import com.github.j5ik2o.pekko.persistence.dynamodb.metrics.MetricsReporter;
import com.github.j5ik2o.pekko.persistence.dynamodb.model.Context;
import com.github.j5ik2o.pekko.persistence.dynamodb.model.Context$;
import com.github.j5ik2o.pekko.persistence.dynamodb.model.PersistenceId;
import com.github.j5ik2o.pekko.persistence.dynamodb.model.PersistenceId$;
import com.github.j5ik2o.pekko.persistence.dynamodb.state.AkkaSerialized;
import com.github.j5ik2o.pekko.persistence.dynamodb.state.AkkaSerialized$;
import com.github.j5ik2o.pekko.persistence.dynamodb.trace.TraceReporter;
import java.io.Serializable;
import java.util.UUID;
import org.apache.pekko.serialization.AsyncSerializer;
import org.apache.pekko.serialization.Serialization;
import org.apache.pekko.serialization.Serializer;
import org.apache.pekko.serialization.Serializers$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

public final class StateSerializer {
    private final Serialization serialization;
    private final Option<MetricsReporter> metricsReporter;
    private final Option<TraceReporter> traceReporter;

    public StateSerializer(Serialization serialization, Option<MetricsReporter> metricsReporter, Option<TraceReporter> traceReporter) {
        this.serialization = serialization;
        this.metricsReporter = metricsReporter;
        this.traceReporter = traceReporter;
    }

    public Future<AkkaSerialized> serialize(String persistenceId, Object payload, ExecutionContext ec) {
        PersistenceId pid = PersistenceId$.MODULE$.apply(persistenceId);
        Context context = Context$.MODULE$.newContext(UUID.randomUUID(), pid, Context$.MODULE$.newContext$default$3());
        Context newContext = (Context)this.metricsReporter.fold(() -> StateSerializer.$anonfun$1(context), (Function1 & Serializable)_$1 -> _$1.beforeStateStoreSerializeState(context));
        Future traced = (Future)this.traceReporter.fold(() -> this.$anonfun$3(payload, ec), (Function1 & Serializable)_$2 -> _$2.traceStateStoreSerializeState(context, () -> this.$anonfun$4$$anonfun$1(payload, ec)));
        traced.onComplete((Function1)(JProcedure1 & Serializable)x$1 -> {
            Try try_ = x$1;
            if (try_ instanceof Success) {
                this.metricsReporter.foreach((Function1)(JProcedure1 & Serializable)_$3 -> _$3.afterStateStoreSerializeState(newContext));
                return;
            }
            if (try_ instanceof Failure) {
                Throwable ex = ((Failure)try_).exception();
                this.metricsReporter.foreach((Function1)(JProcedure1 & Serializable)_$4 -> _$4.errorStateStoreSerializeState(newContext, ex));
                return;
            }
            throw new MatchError((Object)try_);
        }, ec);
        return traced;
    }

    public Future<Object> deserialize(String persistenceId, AkkaSerialized serialized, ExecutionContext ec) {
        PersistenceId pid = PersistenceId$.MODULE$.apply(persistenceId);
        Context context = Context$.MODULE$.newContext(UUID.randomUUID(), pid, Context$.MODULE$.newContext$default$3());
        Context newContext = (Context)this.metricsReporter.fold(() -> StateSerializer.$anonfun$5(context), (Function1 & Serializable)_$5 -> _$5.beforeStateStoreDeserializeState(context));
        Future traced = (Future)this.traceReporter.fold(() -> this.$anonfun$7(serialized, ec), (Function1 & Serializable)_$6 -> _$6.traceStateStoreDeserializeState(context, () -> this.$anonfun$8$$anonfun$1(serialized, ec)));
        traced.onComplete((Function1)(JProcedure1 & Serializable)x$1 -> {
            Try try_ = x$1;
            if (try_ instanceof Success) {
                this.metricsReporter.foreach((Function1)(JProcedure1 & Serializable)_$7 -> _$7.afterStateStoreDeserializeState(newContext));
                return;
            }
            if (try_ instanceof Failure) {
                Throwable ex = ((Failure)try_).exception();
                this.metricsReporter.foreach((Function1)(JProcedure1 & Serializable)_$8 -> _$8.errorStateStoreDeserializeState(newContext, ex));
                return;
            }
            throw new MatchError((Object)try_);
        }, ec);
        return traced;
    }

    private Future<Serializer> serializerAsync(Object payload) {
        Future future;
        try {
            future = Future$.MODULE$.successful((Object)this.serialization.findSerializerFor(payload));
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable ex = throwable3 = (Throwable)option.get();
                future = Future$.MODULE$.failed(ex);
            }
            throw throwable;
        }
        return future;
    }

    private Future<byte[]> toBinaryAsync(Serializer serializer, Object payload) {
        Serializer serializer2 = serializer;
        if (serializer2 instanceof AsyncSerializer) {
            AsyncSerializer asyncSerializer = (AsyncSerializer)serializer2;
            return asyncSerializer.toBinaryAsync(payload);
        }
        Try try_ = this.serialization.serialize(payload);
        if (try_ instanceof Success) {
            byte[] value = (byte[])((Success)try_).value();
            return Future$.MODULE$.successful((Object)value);
        }
        if (try_ instanceof Failure) {
            Throwable ex = ((Failure)try_).exception();
            return Future$.MODULE$.failed(ex);
        }
        throw new MatchError((Object)try_);
    }

    private Future<Object> fromBinaryAsync(Serializer serializer, AkkaSerialized serialized) {
        Future future;
        Serializer serializer2 = serializer;
        if (serializer2 instanceof AsyncSerializer) {
            AsyncSerializer asyncSerializer = (AsyncSerializer)serializer2;
            future = asyncSerializer.fromBinaryAsync(serialized.payload(), (String)serialized.serializerManifest().getOrElse(StateSerializer::$anonfun$9));
        } else {
            Try try_ = this.serialization.deserialize(serialized.payload(), serialized.serializerId(), (String)serialized.serializerManifest().getOrElse(StateSerializer::$anonfun$10));
            if (try_ instanceof Success) {
                Object value = ((Success)try_).value();
                future = Future$.MODULE$.successful(value);
            } else if (try_ instanceof Failure) {
                Throwable ex = ((Failure)try_).exception();
                future = Future$.MODULE$.failed(ex);
            } else {
                throw new MatchError((Object)try_);
            }
        }
        Future future2 = future;
        return future2;
    }

    private static final Context $anonfun$1(Context context$1) {
        return context$1;
    }

    private final Future future$1(Object payload$1, ExecutionContext ec$1) {
        Object p2 = payload$1;
        return this.serializerAsync(p2).flatMap((Function1 & Serializable)serializer -> Future$.MODULE$.successful((Object)Serializers$.MODULE$.manifestFor(serializer, p2)).flatMap((Function1 & Serializable)serializerManifest -> this.toBinaryAsync((Serializer)serializer, p2).map((Function1 & Serializable)payload -> AkkaSerialized$.MODULE$.apply(serializer.identifier(), (Option<String>)(serializerManifest.isEmpty() ? None$.MODULE$ : Some$.MODULE$.apply(serializerManifest)), (byte[])payload), ec$1), ec$1), ec$1);
    }

    private final Future $anonfun$3(Object payload$3, ExecutionContext ec$8) {
        return this.future$1(payload$3, ec$8);
    }

    private final Future $anonfun$4$$anonfun$1(Object payload$4, ExecutionContext ec$9) {
        return this.future$1(payload$4, ec$9);
    }

    private static final Context $anonfun$5(Context context$4) {
        return context$4;
    }

    private final Future future$2(AkkaSerialized serialized$1, ExecutionContext ec$5) {
        return this.serializerAsync(serialized$1.payload()).flatMap((Function1 & Serializable)serializer -> this.fromBinaryAsync((Serializer)serializer, serialized$1).map((Function1 & Serializable)result -> result, ec$5), ec$5);
    }

    private final Future $anonfun$7(AkkaSerialized serialized$4, ExecutionContext ec$10) {
        return this.future$2(serialized$4, ec$10);
    }

    private final Future $anonfun$8$$anonfun$1(AkkaSerialized serialized$5, ExecutionContext ec$11) {
        return this.future$2(serialized$5, ec$11);
    }

    private static final String $anonfun$9() {
        return "";
    }

    private static final String $anonfun$10() {
        return "";
    }
}

