/*
 * Decompiled with CFR 0.152.
 */
package com.github.j5ik2o.pekko.persistence.dynamodb.state;

import com.github.j5ik2o.pekko.persistence.dynamodb.config.client.ClientVersion$;
import com.github.j5ik2o.pekko.persistence.dynamodb.context.PluginContext;
import com.github.j5ik2o.pekko.persistence.dynamodb.metrics.MetricsReporter;
import com.github.j5ik2o.pekko.persistence.dynamodb.metrics.MetricsReporterProvider;
import com.github.j5ik2o.pekko.persistence.dynamodb.metrics.MetricsReporterProvider$;
import com.github.j5ik2o.pekko.persistence.dynamodb.state.PartitionKeyResolver;
import com.github.j5ik2o.pekko.persistence.dynamodb.state.PartitionKeyResolverProvider;
import com.github.j5ik2o.pekko.persistence.dynamodb.state.PartitionKeyResolverProvider$;
import com.github.j5ik2o.pekko.persistence.dynamodb.state.SortKeyResolver;
import com.github.j5ik2o.pekko.persistence.dynamodb.state.SortKeyResolverProvider;
import com.github.j5ik2o.pekko.persistence.dynamodb.state.SortKeyResolverProvider$;
import com.github.j5ik2o.pekko.persistence.dynamodb.state.StateDynamicAccessor;
import com.github.j5ik2o.pekko.persistence.dynamodb.state.StateDynamicAccessor$;
import com.github.j5ik2o.pekko.persistence.dynamodb.state.StatePluginContext$;
import com.github.j5ik2o.pekko.persistence.dynamodb.state.TableNameResolver;
import com.github.j5ik2o.pekko.persistence.dynamodb.state.TableNameResolverProvider;
import com.github.j5ik2o.pekko.persistence.dynamodb.state.TableNameResolverProvider$;
import com.github.j5ik2o.pekko.persistence.dynamodb.state.config.StatePluginConfig;
import com.github.j5ik2o.pekko.persistence.dynamodb.trace.TraceReporter;
import com.github.j5ik2o.pekko.persistence.dynamodb.trace.TraceReporterProvider;
import com.github.j5ik2o.pekko.persistence.dynamodb.trace.TraceReporterProvider$;
import com.github.j5ik2o.pekko.persistence.dynamodb.utils.DispatcherUtils$;
import java.io.Serializable;
import org.apache.pekko.actor.ActorSystem;
import scala.Enumeration;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutorService;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class StatePluginContext
implements PluginContext,
Product,
Serializable {
    private final ActorSystem system;
    private final StatePluginConfig pluginConfig;
    private final Option metricsReporter;
    private final Option traceReporter;
    private final ExecutionContext pluginExecutor;
    private final PartitionKeyResolver partitionKeyResolver;
    private final SortKeyResolver sortKeyResolver;
    private final TableNameResolver tableNameResolver;

    public static StatePluginContext apply(ActorSystem actorSystem, StatePluginConfig statePluginConfig) {
        return StatePluginContext$.MODULE$.apply(actorSystem, statePluginConfig);
    }

    public static StatePluginContext fromProduct(Product product) {
        return StatePluginContext$.MODULE$.fromProduct(product);
    }

    public static StatePluginContext unapply(StatePluginContext statePluginContext) {
        return StatePluginContext$.MODULE$.unapply(statePluginContext);
    }

    public StatePluginContext(ActorSystem system, StatePluginConfig pluginConfig) {
        ExecutionContextExecutorService executionContextExecutorService;
        this.system = system;
        this.pluginConfig = pluginConfig;
        MetricsReporterProvider metricsReporterProvider = MetricsReporterProvider$.MODULE$.create((PluginContext)this);
        this.metricsReporter = metricsReporterProvider.create();
        TraceReporterProvider traceReporterProvider = TraceReporterProvider$.MODULE$.create((PluginContext)this);
        this.traceReporter = traceReporterProvider.create();
        Enumeration.Value value = pluginConfig.clientConfig().clientVersion();
        Enumeration.Value value2 = ClientVersion$.MODULE$.V1();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            executionContextExecutorService = DispatcherUtils$.MODULE$.newV1Executor((PluginContext)this);
        } else {
            Enumeration.Value value4 = ClientVersion$.MODULE$.V2();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                executionContextExecutorService = DispatcherUtils$.MODULE$.newV2Executor((PluginContext)this);
            } else {
                throw new MatchError((Object)value);
            }
        }
        this.pluginExecutor = executionContextExecutorService;
        PartitionKeyResolverProvider provider = PartitionKeyResolverProvider$.MODULE$.create(this);
        this.partitionKeyResolver = provider.create();
        SortKeyResolverProvider provider2 = SortKeyResolverProvider$.MODULE$.create(this);
        this.sortKeyResolver = provider2.create();
        TableNameResolverProvider provider3 = TableNameResolverProvider$.MODULE$.create(this);
        this.tableNameResolver = provider3.create();
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof StatePluginContext)) return false;
        StatePluginContext statePluginContext = (StatePluginContext)object;
        ActorSystem actorSystem = this.system();
        ActorSystem actorSystem2 = statePluginContext.system();
        if (actorSystem == null) {
            if (actorSystem2 != null) {
                return false;
            }
        } else if (!actorSystem.equals(actorSystem2)) return false;
        StatePluginConfig statePluginConfig = this.pluginConfig();
        StatePluginConfig statePluginConfig2 = statePluginContext.pluginConfig();
        if (statePluginConfig == null) {
            if (statePluginConfig2 == null) return true;
            return false;
        } else {
            if (!((Object)statePluginConfig).equals(statePluginConfig2)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof StatePluginContext;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "StatePluginContext";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        if (1 == n2) {
            return this._2();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "system";
        }
        if (1 == n2) {
            return "pluginConfig";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public ActorSystem system() {
        return this.system;
    }

    public StatePluginConfig pluginConfig() {
        return this.pluginConfig;
    }

    public <A> StateDynamicAccessor<A> newDynamicAccessor(ClassTag<A> evidence$1) {
        return StateDynamicAccessor$.MODULE$.apply(this, evidence$1);
    }

    public Option<MetricsReporter> metricsReporter() {
        return this.metricsReporter;
    }

    public Option<TraceReporter> traceReporter() {
        return this.traceReporter;
    }

    public ExecutionContext pluginExecutor() {
        return this.pluginExecutor;
    }

    public PartitionKeyResolver partitionKeyResolver() {
        return this.partitionKeyResolver;
    }

    public SortKeyResolver sortKeyResolver() {
        return this.sortKeyResolver;
    }

    public TableNameResolver tableNameResolver() {
        return this.tableNameResolver;
    }

    public StatePluginContext copy(ActorSystem system, StatePluginConfig pluginConfig) {
        return new StatePluginContext(system, pluginConfig);
    }

    public ActorSystem copy$default$1() {
        return this.system();
    }

    public StatePluginConfig copy$default$2() {
        return this.pluginConfig();
    }

    public ActorSystem _1() {
        return this.system();
    }

    public StatePluginConfig _2() {
        return this.pluginConfig();
    }
}

