/*
 * Decompiled with CFR 0.152.
 */
package com.github.j5ik2o.pekko.persistence.dynamodb.state;

import com.github.j5ik2o.pekko.persistence.dynamodb.model.PersistenceId;
import com.github.j5ik2o.pekko.persistence.dynamodb.model.PersistenceId$;
import com.github.j5ik2o.pekko.persistence.dynamodb.state.PartitionKey;
import com.github.j5ik2o.pekko.persistence.dynamodb.state.PartitionKey$;
import com.github.j5ik2o.pekko.persistence.dynamodb.state.StatePluginContext;
import com.github.j5ik2o.pekko.persistence.dynamodb.state.ToPersistenceIdOps;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.text.DecimalFormat;
import net.ceedubs.ficus.Ficus$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scala.runtime.ScalaRunTime$;

public interface PartitionKeyResolver {
    public PartitionKey resolve(PersistenceId var1);

    public static final class PersistenceIdBased
    implements PartitionKeyResolver,
    ToPersistenceIdOps {
        private final StatePluginContext pluginContext;

        public PersistenceIdBased(StatePluginContext pluginContext) {
            this.pluginContext = pluginContext;
        }

        @Override
        public String separator() {
            return (String)Ficus$.MODULE$.toFicusConfig(this.pluginContext.pluginConfig().sourceConfig()).getAs("persistence-id-separator", Ficus$.MODULE$.optionValueReader(Ficus$.MODULE$.stringValueReader())).getOrElse(this::separator$$anonfun$1);
        }

        @Override
        public PartitionKey resolve(PersistenceId persistenceId) {
            String string;
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            DecimalFormat df = new DecimalFormat("0000000000000000000000000000000000000000");
            byte[] bytes = StringOps$.MODULE$.reverse$extension(Predef$.MODULE$.augmentString(persistenceId.asString())).getBytes(StandardCharsets.UTF_8);
            BigInt hash = package$.MODULE$.BigInt().apply(md5.digest(bytes));
            BigInt mod = hash.abs().$percent(BigInt$.MODULE$.int2bigInt(this.pluginContext.pluginConfig().shardCount())).$plus(BigInt$.MODULE$.int2bigInt(1));
            Option<String> modelNameOpt = this.ToPersistenceIdOps(persistenceId).prefix();
            Option<String> option = modelNameOpt;
            if (option instanceof Some) {
                String modelName = (String)((Some)option).value();
                string = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s-%s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{modelName, df.format(mod)}));
            } else if (None$.MODULE$.equals(option)) {
                string = df.format(mod);
            } else {
                throw new MatchError(option);
            }
            String pkey = string;
            return PartitionKey$.MODULE$.apply(pkey);
        }

        private final String separator$$anonfun$1() {
            return PersistenceId$.MODULE$.Separator();
        }
    }
}

