/*
 * Decompiled with CFR 0.152.
 */
package com.github.j5ik2o.pekko.persistence.dynamodb.state;

import com.github.j5ik2o.pekko.persistence.dynamodb.config.client.ClientVersion$;
import com.github.j5ik2o.pekko.persistence.dynamodb.state.DynamoDBDurableStateStoreProvider$;
import com.github.j5ik2o.pekko.persistence.dynamodb.state.StateDynamicAccessor$;
import com.github.j5ik2o.pekko.persistence.dynamodb.state.StatePluginContext;
import com.github.j5ik2o.pekko.persistence.dynamodb.state.StatePluginContext$;
import com.github.j5ik2o.pekko.persistence.dynamodb.state.config.StatePluginConfig;
import com.github.j5ik2o.pekko.persistence.dynamodb.state.config.StatePluginConfig$;
import com.github.j5ik2o.pekko.persistence.dynamodb.state.javadsl.JavaDynamoDBDurableStateStore;
import com.github.j5ik2o.pekko.persistence.dynamodb.state.scaladsl.ScalaDurableStateUpdateStore;
import com.github.j5ik2o.pekko.persistence.dynamodb.state.scaladsl.ScalaDurableStateUpdateStoreFactory;
import com.github.j5ik2o.pekko.persistence.dynamodb.utils.PlugInLifecycleHandler;
import com.github.j5ik2o.pekko.persistence.dynamodb.utils.PlugInLifecycleHandlerFactory;
import com.typesafe.config.Config;
import java.util.UUID;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.annotation.ApiMayChange;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.persistence.state.DurableStateStoreProvider;
import org.apache.pekko.persistence.state.javadsl.DurableStateUpdateStore;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.SystemMaterializer;
import org.apache.pekko.stream.SystemMaterializer$;
import scala.Enumeration;
import scala.MatchError;
import scala.concurrent.ExecutionContext;
import scala.reflect.ClassTag$;

@ApiMayChange
public final class DynamoDBDurableStateStoreProvider
implements DurableStateStoreProvider {
    private final ExtendedActorSystem system;
    private final Materializer mat;
    private final LoggingAdapter _log;
    private final StatePluginConfig statePluginConfig;
    private final StatePluginContext statePluginContext;
    private final PlugInLifecycleHandler plugInLifecycleHandler;
    private final ExecutionContext ec;

    public static String Identifier() {
        return DynamoDBDurableStateStoreProvider$.MODULE$.Identifier();
    }

    public DynamoDBDurableStateStoreProvider(ExtendedActorSystem system) {
        this.system = system;
        this.mat = ((SystemMaterializer)SystemMaterializer$.MODULE$.apply((ActorSystem)system)).materializer();
        this._log = system.log();
        UUID id = UUID.randomUUID();
        this._log().debug("dynamodb state store provider: id = {}", (Object)id);
        system.dynamicAccess();
        Config config = system.settings().config().getConfig(DynamoDBDurableStateStoreProvider$.MODULE$.Identifier());
        this.statePluginConfig = StatePluginConfig$.MODULE$.fromConfig(config);
        this.statePluginContext = StatePluginContext$.MODULE$.apply((ActorSystem)system, this.statePluginConfig);
        PlugInLifecycleHandlerFactory plugInLifecycleHandlerFactory = (PlugInLifecycleHandlerFactory)this.statePluginContext.newDynamicAccessor(ClassTag$.MODULE$.apply(PlugInLifecycleHandlerFactory.class)).createThrow(this.statePluginConfig.plugInLifecycleHandlerFactoryClassName());
        this.plugInLifecycleHandler = plugInLifecycleHandlerFactory.create();
        this.ec = this.statePluginContext.pluginExecutor();
    }

    public Materializer mat() {
        return this.mat;
    }

    public LoggingAdapter _log() {
        return this._log;
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    private <A> ScalaDurableStateUpdateStore<A> createStore() {
        String string;
        Enumeration.Value value = this.statePluginConfig.clientConfig().clientVersion();
        Enumeration.Value value2 = ClientVersion$.MODULE$.V2();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            string = "com.github.j5ik2o.pekko.persistence.dynamodb.state.scaladsl.V2ScalaDurableStateUpdateStoreFactory";
        } else {
            Enumeration.Value value4 = ClientVersion$.MODULE$.V2Dax();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                string = "com.github.j5ik2o.pekko.persistence.dynamodb.state.scaladsl.V2DaxScalaDurableStateUpdateStoreFactory";
            } else {
                Enumeration.Value value6 = ClientVersion$.MODULE$.V1();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    string = "com.github.j5ik2o.pekko.persistence.dynamodb.state.scaladsl.V1ScalaDurableStateUpdateStoreFactory";
                } else {
                    Enumeration.Value value8 = ClientVersion$.MODULE$.V1Dax();
                    Enumeration.Value value9 = value;
                    if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                        string = "com.github.j5ik2o.pekko.persistence.dynamodb.state.scaladsl.V1DaxScalaDurableStateUpdateStoreFactory";
                    } else {
                        throw new MatchError((Object)value);
                    }
                }
            }
        }
        String className = string;
        ScalaDurableStateUpdateStoreFactory f = (ScalaDurableStateUpdateStoreFactory)StateDynamicAccessor$.MODULE$.apply(this.statePluginContext, ClassTag$.MODULE$.apply(ScalaDurableStateUpdateStoreFactory.class)).createThrow(className);
        return f.create();
    }

    public org.apache.pekko.persistence.state.scaladsl.DurableStateUpdateStore<Object> scaladslDurableStateStore() {
        return this.createStore();
    }

    public DurableStateUpdateStore<Object> javadslDurableStateStore() {
        ScalaDurableStateUpdateStore store = this.createStore();
        this.plugInLifecycleHandler.start();
        return new JavaDynamoDBDurableStateStore<Object>((ActorSystem)this.system, this.statePluginContext.pluginExecutor(), store);
    }
}

