/*
 * Decompiled with CFR 0.152.
 */
package com.github.j5ik2o.pekko.persistence.dynamodb.snapshot.dao;

import com.github.j5ik2o.pekko.persistence.dynamodb.client.v2.StreamReadClient;
import com.github.j5ik2o.pekko.persistence.dynamodb.client.v2.StreamWriteClient;
import com.github.j5ik2o.pekko.persistence.dynamodb.context.PluginContext;
import com.github.j5ik2o.pekko.persistence.dynamodb.model.PersistenceId;
import com.github.j5ik2o.pekko.persistence.dynamodb.model.PersistenceId$;
import com.github.j5ik2o.pekko.persistence.dynamodb.model.SequenceNumber;
import com.github.j5ik2o.pekko.persistence.dynamodb.model.SequenceNumber$;
import com.github.j5ik2o.pekko.persistence.dynamodb.snapshot.SnapshotPluginContext;
import com.github.j5ik2o.pekko.persistence.dynamodb.snapshot.dao.SnapshotDao;
import com.github.j5ik2o.pekko.persistence.dynamodb.snapshot.dao.SnapshotRow$;
import com.github.j5ik2o.pekko.persistence.dynamodb.snapshot.serialization.ByteArraySnapshotSerializer;
import java.io.IOException;
import java.io.Serializable;
import java.util.Optional;
import org.apache.pekko.NotUsed;
import org.apache.pekko.persistence.SnapshotMetadata;
import org.apache.pekko.serialization.Serialization;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.Source$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteRequest;
import software.amazon.awssdk.services.dynamodb.model.PutItemRequest;
import software.amazon.awssdk.services.dynamodb.model.QueryRequest;
import software.amazon.awssdk.services.dynamodb.model.WriteRequest;

public final class V2LegacySnapshotDaoImpl
implements SnapshotDao {
    private final SnapshotPluginContext pluginContext;
    private final Option<DynamoDbAsyncClient> asyncClient;
    private final Option<DynamoDbClient> syncClient;
    private final StreamReadClient streamReadClient;
    private final StreamWriteClient streamWriteClient;
    private final ByteArraySnapshotSerializer serializer;

    public V2LegacySnapshotDaoImpl(SnapshotPluginContext pluginContext, Option<DynamoDbAsyncClient> asyncClient, Option<DynamoDbClient> syncClient, Serialization serialization) {
        this.pluginContext = pluginContext;
        this.asyncClient = asyncClient;
        this.syncClient = syncClient;
        Tuple2 tuple2 = Tuple2$.MODULE$.apply(asyncClient, syncClient);
        if (tuple2 != null && None$.MODULE$.equals(tuple2._1()) && None$.MODULE$.equals(tuple2._2())) {
            throw new IllegalArgumentException("aws clients is both None");
        }
        this.streamReadClient = new StreamReadClient((PluginContext)pluginContext, asyncClient, syncClient, pluginContext.pluginConfig().readBackoffConfig());
        this.streamWriteClient = new StreamWriteClient((PluginContext)pluginContext, asyncClient, syncClient, pluginContext.pluginConfig().writeBackoffConfig());
        this.serializer = new ByteArraySnapshotSerializer(serialization, pluginContext.metricsReporter(), pluginContext.traceReporter());
    }

    public Source<BoxedUnit, NotUsed> delete(PersistenceId persistenceId, SequenceNumber sequenceNr) {
        Object[] objectArray = new Tuple2[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext.pluginConfig().columnsDefConfig().persistenceIdColumnName());
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, AttributeValue.builder().s(persistenceId.asString()).build());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext.pluginConfig().columnsDefConfig().sequenceNrColumnName());
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, AttributeValue.builder().n(sequenceNr.asString()).build());
        DeleteItemRequest req = (DeleteItemRequest)DeleteItemRequest.builder().tableName(this.pluginContext.pluginConfig().tableName()).key(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).asJava()).build();
        return (Source)Source$.MODULE$.single((Object)req).via((Graph)this.streamWriteClient.deleteItemFlow()).flatMapConcat((Function1 & Serializable)response -> {
            if (response.sdkHttpResponse().isSuccessful()) {
                return Source$.MODULE$.single((Object)BoxedUnit.UNIT);
            }
            int statusCode = response.sdkHttpResponse().statusCode();
            Optional statusText = response.sdkHttpResponse().statusText();
            Optional optional = OptionConverters$.MODULE$.RichOptionalGeneric(statusText);
            return Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).append(OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(optional).fold(V2LegacySnapshotDaoImpl::delete$$anonfun$1$$anonfun$1, (Function1 & Serializable)s -> new StringBuilder(2).append(", ").append((String)s).toString())).toString()));
        });
    }

    public Source<BoxedUnit, NotUsed> deleteAllSnapshots(PersistenceId persistenceId, ExecutionContext ec) {
        Object[] objectArray = new Tuple2[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"#pid");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)this.pluginContext.pluginConfig().columnsDefConfig().persistenceIdColumnName());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"#snr");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)this.pluginContext.pluginConfig().columnsDefConfig().sequenceNrColumnName());
        Object[] objectArray2 = new Tuple2[3];
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)":pid");
        objectArray2[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, AttributeValue.builder().s(persistenceId.asString()).build());
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)":min");
        objectArray2[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, AttributeValue.builder().n(BoxesRunTime.boxToInteger((int)0).toString()).build());
        String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)":max");
        objectArray2[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, AttributeValue.builder().n(BoxesRunTime.boxToLong((long)Long.MAX_VALUE).toString()).build());
        QueryRequest queryRequest = (QueryRequest)QueryRequest.builder().tableName(this.pluginContext.pluginConfig().tableName()).keyConditionExpression("#pid = :pid and #snr between :min and :max").expressionAttributeNames(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).asJava()).expressionAttributeValues(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2))).asJava()).consistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginContext.pluginConfig().consistentRead())).build();
        return this.queryDelete(queryRequest);
    }

    public Source<BoxedUnit, NotUsed> deleteUpToMaxSequenceNr(PersistenceId persistenceId, SequenceNumber maxSequenceNr, ExecutionContext ec) {
        Object[] objectArray = new Tuple2[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"#pid");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)this.pluginContext.pluginConfig().columnsDefConfig().persistenceIdColumnName());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"#snr");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)this.pluginContext.pluginConfig().columnsDefConfig().sequenceNrColumnName());
        Object[] objectArray2 = new Tuple2[3];
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)":pid");
        objectArray2[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, AttributeValue.builder().s(persistenceId.asString()).build());
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)":min");
        objectArray2[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, AttributeValue.builder().n(BoxesRunTime.boxToInteger((int)0).toString()).build());
        String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)":max");
        objectArray2[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, AttributeValue.builder().n(maxSequenceNr.asString()).build());
        QueryRequest queryRequest = (QueryRequest)QueryRequest.builder().tableName(this.pluginContext.pluginConfig().tableName()).keyConditionExpression("#pid = :pid and #snr between :min and :max").expressionAttributeNames(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).asJava()).expressionAttributeValues(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2))).asJava()).consistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginContext.pluginConfig().consistentRead())).build();
        return this.queryDelete(queryRequest);
    }

    public Source<BoxedUnit, NotUsed> deleteUpToMaxTimestamp(PersistenceId persistenceId, long maxTimestamp, ExecutionContext ec) {
        Object[] objectArray = new Tuple2[3];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"#pid");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)this.pluginContext.pluginConfig().columnsDefConfig().persistenceIdColumnName());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"#snr");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)this.pluginContext.pluginConfig().columnsDefConfig().sequenceNrColumnName());
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"#created");
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)this.pluginContext.pluginConfig().columnsDefConfig().createdColumnName());
        Object[] objectArray2 = new Tuple2[4];
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)":pid");
        objectArray2[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, AttributeValue.builder().s(persistenceId.asString()).build());
        String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)":min");
        objectArray2[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, AttributeValue.builder().n(BoxesRunTime.boxToInteger((int)0).toString()).build());
        String string6 = (String)Predef$.MODULE$.ArrowAssoc((Object)":max");
        objectArray2[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string6, AttributeValue.builder().n(BoxesRunTime.boxToLong((long)Long.MAX_VALUE).toString()).build());
        String string7 = (String)Predef$.MODULE$.ArrowAssoc((Object)":maxTimestamp");
        objectArray2[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string7, AttributeValue.builder().n(BoxesRunTime.boxToLong((long)maxTimestamp).toString()).build());
        QueryRequest queryRequest = (QueryRequest)QueryRequest.builder().tableName(this.pluginContext.pluginConfig().tableName()).keyConditionExpression("#pid = :pid and #snr between :min and :max").filterExpression("#created <= :maxTimestamp").expressionAttributeNames(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).asJava()).expressionAttributeValues(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2))).asJava()).consistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginContext.pluginConfig().consistentRead())).build();
        return this.queryDelete(queryRequest);
    }

    public Source<BoxedUnit, NotUsed> deleteUpToMaxSequenceNrAndMaxTimestamp(PersistenceId persistenceId, SequenceNumber maxSequenceNr, long maxTimestamp, ExecutionContext ec) {
        Object[] objectArray = new Tuple2[3];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"#pid");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)this.pluginContext.pluginConfig().columnsDefConfig().persistenceIdColumnName());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"#snr");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)this.pluginContext.pluginConfig().columnsDefConfig().sequenceNrColumnName());
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"#created");
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)this.pluginContext.pluginConfig().columnsDefConfig().createdColumnName());
        Object[] objectArray2 = new Tuple2[4];
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)":pid");
        objectArray2[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, AttributeValue.builder().s(persistenceId.asString()).build());
        String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)":min");
        objectArray2[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, AttributeValue.builder().n(BoxesRunTime.boxToInteger((int)0).toString()).build());
        String string6 = (String)Predef$.MODULE$.ArrowAssoc((Object)":max");
        objectArray2[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string6, AttributeValue.builder().n(maxSequenceNr.asString()).build());
        String string7 = (String)Predef$.MODULE$.ArrowAssoc((Object)":maxTimestamp");
        objectArray2[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string7, AttributeValue.builder().n(BoxesRunTime.boxToLong((long)maxTimestamp).toString()).build());
        QueryRequest queryRequest = (QueryRequest)QueryRequest.builder().tableName(this.pluginContext.pluginConfig().tableName()).keyConditionExpression("#pid = :pid and #snr between :min and :max").filterExpression("#created <= :maxTimestamp").expressionAttributeNames(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).asJava()).expressionAttributeValues(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2))).asJava()).consistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginContext.pluginConfig().consistentRead())).build();
        return this.queryDelete(queryRequest);
    }

    private Future<Option<Tuple2<SnapshotMetadata, Object>>> deserialize(Option<scala.collection.immutable.Map<String, AttributeValue>> rowOpt, ExecutionContext ec) {
        Option<scala.collection.immutable.Map<String, AttributeValue>> option = rowOpt;
        if (option instanceof Some) {
            scala.collection.immutable.Map row = (scala.collection.immutable.Map)((Some)option).value();
            PersistenceId persistenceId = PersistenceId$.MODULE$.apply(((AttributeValue)row.apply((Object)this.pluginContext.pluginConfig().columnsDefConfig().persistenceIdColumnName())).s());
            SequenceNumber sequenceNumber = SequenceNumber$.MODULE$.apply(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(((AttributeValue)row.apply((Object)this.pluginContext.pluginConfig().columnsDefConfig().sequenceNrColumnName())).n())));
            byte[] byArray = ((AttributeValue)row.apply((Object)this.pluginContext.pluginConfig().columnsDefConfig().snapshotColumnName())).b().asByteArray();
            long l = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(((AttributeValue)row.apply((Object)this.pluginContext.pluginConfig().columnsDefConfig().createdColumnName())).n()));
            return this.serializer.deserialize(SnapshotRow$.MODULE$.apply(persistenceId, sequenceNumber, l, byArray), ec).map((Function1 & Serializable)_$1 -> Some$.MODULE$.apply(_$1), ec);
        }
        if (None$.MODULE$.equals(option)) {
            return Future$.MODULE$.successful((Object)None$.MODULE$);
        }
        throw new MatchError(option);
    }

    public Source<Option<Tuple2<SnapshotMetadata, Object>>, NotUsed> latestSnapshot(PersistenceId persistenceId, ExecutionContext ec) {
        Object[] objectArray = new Tuple2[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"#pid");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)this.pluginContext.pluginConfig().columnsDefConfig().persistenceIdColumnName());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"#snr");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)this.pluginContext.pluginConfig().columnsDefConfig().sequenceNrColumnName());
        Object[] objectArray2 = new Tuple2[3];
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)":pid");
        objectArray2[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, AttributeValue.builder().s(persistenceId.asString()).build());
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)":min");
        objectArray2[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, AttributeValue.builder().n(BoxesRunTime.boxToInteger((int)0).toString()).build());
        String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)":max");
        objectArray2[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, AttributeValue.builder().n(BoxesRunTime.boxToLong((long)Long.MAX_VALUE).toString()).build());
        QueryRequest queryRequest = (QueryRequest)QueryRequest.builder().tableName(this.pluginContext.pluginConfig().tableName()).keyConditionExpression("#pid = :pid and #snr between :min and :max").expressionAttributeNames(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).asJava()).expressionAttributeValues(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2))).asJava()).scanIndexForward(Predef$.MODULE$.boolean2Boolean(false)).limit(Predef$.MODULE$.int2Integer(1)).consistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginContext.pluginConfig().consistentRead())).build();
        return (Source)Source$.MODULE$.single((Object)queryRequest).via((Graph)this.streamReadClient.queryFlow()).flatMapConcat((Function1 & Serializable)response -> {
            if (response.sdkHttpResponse().isSuccessful()) {
                return Source$.MODULE$.single((Object)((IterableOps)((IterableOps)Option$.MODULE$.apply((Object)response.items()).map((Function1 & Serializable)_$2 -> CollectionConverters$.MODULE$.ListHasAsScala(_$2).asScala()).getOrElse(V2LegacySnapshotDaoImpl::latestSnapshot$$anonfun$1$$anonfun$2)).map((Function1 & Serializable)_$3 -> CollectionConverters$.MODULE$.MapHasAsScala(_$3).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()))).headOption());
            }
            int statusCode = response.sdkHttpResponse().statusCode();
            Optional statusText = response.sdkHttpResponse().statusText();
            Optional optional = OptionConverters$.MODULE$.RichOptionalGeneric(statusText);
            return Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).append(OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(optional).fold(V2LegacySnapshotDaoImpl::latestSnapshot$$anonfun$1$$anonfun$4, (Function1 & Serializable)s -> new StringBuilder(2).append(", ").append((String)s).toString())).toString()));
        }).mapAsync(1, (Function1 & Serializable)rowOpt -> this.deserialize((Option<scala.collection.immutable.Map<String, AttributeValue>>)rowOpt, ec));
    }

    public Source<Option<Tuple2<SnapshotMetadata, Object>>, NotUsed> snapshotForMaxTimestamp(PersistenceId persistenceId, long maxTimestamp, ExecutionContext ec) {
        Object[] objectArray = new Tuple2[3];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"#pid");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)this.pluginContext.pluginConfig().columnsDefConfig().persistenceIdColumnName());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"#snr");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)this.pluginContext.pluginConfig().columnsDefConfig().sequenceNrColumnName());
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"#created");
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)this.pluginContext.pluginConfig().columnsDefConfig().createdColumnName());
        Object[] objectArray2 = new Tuple2[4];
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)":pid");
        objectArray2[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, AttributeValue.builder().s(persistenceId.asString()).build());
        String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)":min");
        objectArray2[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, AttributeValue.builder().n(BoxesRunTime.boxToInteger((int)0).toString()).build());
        String string6 = (String)Predef$.MODULE$.ArrowAssoc((Object)":max");
        objectArray2[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string6, AttributeValue.builder().n(BoxesRunTime.boxToLong((long)Long.MAX_VALUE).toString()).build());
        String string7 = (String)Predef$.MODULE$.ArrowAssoc((Object)":maxTimestamp");
        objectArray2[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string7, AttributeValue.builder().n(BoxesRunTime.boxToLong((long)maxTimestamp).toString()).build());
        QueryRequest queryRequest = (QueryRequest)QueryRequest.builder().tableName(this.pluginContext.pluginConfig().tableName()).keyConditionExpression("#pid = :pid and #snr between :min and :max").filterExpression("#created <= :maxTimestamp").expressionAttributeNames(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).asJava()).expressionAttributeValues(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2))).asJava()).scanIndexForward(Predef$.MODULE$.boolean2Boolean(false)).consistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginContext.pluginConfig().consistentRead())).build();
        return (Source)Source$.MODULE$.single((Object)queryRequest).via((Graph)this.streamReadClient.queryFlow()).flatMapConcat((Function1 & Serializable)response -> {
            if (response.sdkHttpResponse().isSuccessful()) {
                return Source$.MODULE$.single((Object)((IterableOps)((IterableOps)Option$.MODULE$.apply((Object)response.items()).map((Function1 & Serializable)_$4 -> CollectionConverters$.MODULE$.ListHasAsScala(_$4).asScala()).getOrElse(V2LegacySnapshotDaoImpl::snapshotForMaxTimestamp$$anonfun$1$$anonfun$2)).map((Function1 & Serializable)_$5 -> CollectionConverters$.MODULE$.MapHasAsScala(_$5).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()))).headOption());
            }
            int statusCode = response.sdkHttpResponse().statusCode();
            Optional statusText = response.sdkHttpResponse().statusText();
            Optional optional = OptionConverters$.MODULE$.RichOptionalGeneric(statusText);
            return Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).append(OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(optional).fold(V2LegacySnapshotDaoImpl::snapshotForMaxTimestamp$$anonfun$1$$anonfun$4, (Function1 & Serializable)s -> new StringBuilder(2).append(", ").append((String)s).toString())).toString()));
        }).mapAsync(1, (Function1 & Serializable)rowOpt -> this.deserialize((Option<scala.collection.immutable.Map<String, AttributeValue>>)rowOpt, ec));
    }

    public Source<Option<Tuple2<SnapshotMetadata, Object>>, NotUsed> snapshotForMaxSequenceNr(PersistenceId persistenceId, SequenceNumber maxSequenceNr, ExecutionContext ec) {
        Object[] objectArray = new Tuple2[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"#pid");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)this.pluginContext.pluginConfig().columnsDefConfig().persistenceIdColumnName());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"#snr");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)this.pluginContext.pluginConfig().columnsDefConfig().sequenceNrColumnName());
        Object[] objectArray2 = new Tuple2[3];
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)":pid");
        objectArray2[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, AttributeValue.builder().s(persistenceId.asString()).build());
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)":min");
        objectArray2[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, AttributeValue.builder().n(BoxesRunTime.boxToInteger((int)0).toString()).build());
        String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)":max");
        objectArray2[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, AttributeValue.builder().n(maxSequenceNr.asString()).build());
        QueryRequest queryRequest = (QueryRequest)QueryRequest.builder().tableName(this.pluginContext.pluginConfig().tableName()).keyConditionExpression("#pid = :pid and #snr between :min and :max").expressionAttributeNames(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).asJava()).expressionAttributeValues(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2))).asJava()).scanIndexForward(Predef$.MODULE$.boolean2Boolean(false)).consistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginContext.pluginConfig().consistentRead())).build();
        return (Source)Source$.MODULE$.single((Object)queryRequest).via((Graph)this.streamReadClient.queryFlow()).flatMapConcat((Function1 & Serializable)response -> {
            if (response.sdkHttpResponse().isSuccessful()) {
                return Source$.MODULE$.single((Object)((IterableOps)((IterableOps)Option$.MODULE$.apply((Object)response.items()).map((Function1 & Serializable)_$6 -> CollectionConverters$.MODULE$.ListHasAsScala(_$6).asScala()).getOrElse(V2LegacySnapshotDaoImpl::snapshotForMaxSequenceNr$$anonfun$1$$anonfun$2)).map((Function1 & Serializable)_$7 -> CollectionConverters$.MODULE$.MapHasAsScala(_$7).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()))).headOption());
            }
            int statusCode = response.sdkHttpResponse().statusCode();
            Optional statusText = response.sdkHttpResponse().statusText();
            Optional optional = OptionConverters$.MODULE$.RichOptionalGeneric(statusText);
            return Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).append(OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(optional).fold(V2LegacySnapshotDaoImpl::snapshotForMaxSequenceNr$$anonfun$1$$anonfun$4, (Function1 & Serializable)s -> new StringBuilder(2).append(", ").append((String)s).toString())).toString()));
        }).mapAsync(1, (Function1 & Serializable)rowOpt -> this.deserialize((Option<scala.collection.immutable.Map<String, AttributeValue>>)rowOpt, ec));
    }

    public Source<Option<Tuple2<SnapshotMetadata, Object>>, NotUsed> snapshotForMaxSequenceNrAndMaxTimestamp(PersistenceId persistenceId, SequenceNumber maxSequenceNr, long maxTimestamp, ExecutionContext ec) {
        Object[] objectArray = new Tuple2[3];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"#pid");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)this.pluginContext.pluginConfig().columnsDefConfig().persistenceIdColumnName());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"#snr");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)this.pluginContext.pluginConfig().columnsDefConfig().sequenceNrColumnName());
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"#created");
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)this.pluginContext.pluginConfig().columnsDefConfig().createdColumnName());
        Object[] objectArray2 = new Tuple2[4];
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)":pid");
        objectArray2[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, AttributeValue.builder().s(persistenceId.asString()).build());
        String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)":min");
        objectArray2[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, AttributeValue.builder().n(BoxesRunTime.boxToInteger((int)0).toString()).build());
        String string6 = (String)Predef$.MODULE$.ArrowAssoc((Object)":max");
        objectArray2[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string6, AttributeValue.builder().n(maxSequenceNr.asString()).build());
        String string7 = (String)Predef$.MODULE$.ArrowAssoc((Object)":maxTimestamp");
        objectArray2[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string7, AttributeValue.builder().n(BoxesRunTime.boxToLong((long)maxTimestamp).toString()).build());
        QueryRequest queryRequest = (QueryRequest)QueryRequest.builder().tableName(this.pluginContext.pluginConfig().tableName()).keyConditionExpression("#pid = :pid and #snr between :min and :max").filterExpression("#created <= :maxTimestamp").expressionAttributeNames(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).asJava()).expressionAttributeValues(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2))).asJava()).scanIndexForward(Predef$.MODULE$.boolean2Boolean(false)).consistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginContext.pluginConfig().consistentRead())).build();
        return (Source)Source$.MODULE$.single((Object)queryRequest).via((Graph)this.streamReadClient.queryFlow()).flatMapConcat((Function1 & Serializable)response -> {
            if (response.sdkHttpResponse().isSuccessful()) {
                return Source$.MODULE$.single((Object)((IterableOps)((IterableOps)Option$.MODULE$.apply((Object)response.items()).map((Function1 & Serializable)_$8 -> CollectionConverters$.MODULE$.ListHasAsScala(_$8).asScala()).getOrElse(V2LegacySnapshotDaoImpl::snapshotForMaxSequenceNrAndMaxTimestamp$$anonfun$1$$anonfun$2)).map((Function1 & Serializable)_$9 -> CollectionConverters$.MODULE$.MapHasAsScala(_$9).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()))).headOption());
            }
            int statusCode = response.sdkHttpResponse().statusCode();
            Optional statusText = response.sdkHttpResponse().statusText();
            Optional optional = OptionConverters$.MODULE$.RichOptionalGeneric(statusText);
            return Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).append(OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(optional).fold(V2LegacySnapshotDaoImpl::snapshotForMaxSequenceNrAndMaxTimestamp$$anonfun$1$$anonfun$4, (Function1 & Serializable)s -> new StringBuilder(2).append(", ").append((String)s).toString())).toString()));
        }).mapAsync(1, (Function1 & Serializable)rowOpt -> this.deserialize((Option<scala.collection.immutable.Map<String, AttributeValue>>)rowOpt, ec));
    }

    public Source<BoxedUnit, NotUsed> save(SnapshotMetadata snapshotMetadata, Object snapshot, ExecutionContext ec) {
        return (Source)Source$.MODULE$.future(this.serializer.serialize(snapshotMetadata, snapshot, ec)).flatMapConcat((Function1 & Serializable)snapshotRow -> {
            Object[] objectArray = new Tuple2[4];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext.pluginConfig().columnsDefConfig().persistenceIdColumnName());
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, AttributeValue.builder().s(snapshotRow.persistenceId().asString()).build());
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext.pluginConfig().columnsDefConfig().sequenceNrColumnName());
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, AttributeValue.builder().n(snapshotRow.sequenceNumber().asString()).build());
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext.pluginConfig().columnsDefConfig().snapshotColumnName());
            objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, AttributeValue.builder().b(SdkBytes.fromByteArray((byte[])snapshotRow.snapshot())).build());
            String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext.pluginConfig().columnsDefConfig().createdColumnName());
            objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, AttributeValue.builder().n(BoxesRunTime.boxToLong((long)snapshotRow.created()).toString()).build());
            PutItemRequest req = (PutItemRequest)PutItemRequest.builder().tableName(this.pluginContext.pluginConfig().tableName()).item(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).asJava()).build();
            return (Graph)Source$.MODULE$.single((Object)req).via((Graph)this.streamWriteClient.putItemFlow()).flatMapConcat((Function1 & Serializable)response -> {
                if (response.sdkHttpResponse().isSuccessful()) {
                    return Source$.MODULE$.single((Object)BoxedUnit.UNIT);
                }
                int statusCode = response.sdkHttpResponse().statusCode();
                Optional statusText = response.sdkHttpResponse().statusText();
                Optional optional = OptionConverters$.MODULE$.RichOptionalGeneric(statusText);
                return Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).append(OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(optional).fold(V2LegacySnapshotDaoImpl::save$$anonfun$1$$anonfun$1$$anonfun$1, (Function1 & Serializable)s -> new StringBuilder(2).append(", ").append((String)s).toString())).toString()));
            });
        });
    }

    private Source<BoxedUnit, NotUsed> queryDelete(QueryRequest queryRequest) {
        return (Source)((Source)Source$.MODULE$.single((Object)queryRequest).via((Graph)this.streamReadClient.queryFlow()).map((Function1 & Serializable)response -> (Seq)Option$.MODULE$.apply((Object)response.items()).map((Function1 & Serializable)_$10 -> CollectionConverters$.MODULE$.ListHasAsScala(_$10).asScala()).getOrElse(V2LegacySnapshotDaoImpl::queryDelete$$anonfun$1$$anonfun$2)).mapConcat((Function1 & Serializable)_$11 -> _$11.toVector()).grouped(this.pluginContext.pluginConfig().clientConfig().batchWriteItemLimit()).map((Function1 & Serializable)rows -> (scala.collection.immutable.Seq)rows.map((Function1 & Serializable)javaRow -> {
            scala.collection.mutable.Map row = CollectionConverters$.MODULE$.MapHasAsScala(javaRow).asScala();
            PersistenceId persistenceId = PersistenceId$.MODULE$.apply(((AttributeValue)row.apply((Object)this.pluginContext.pluginConfig().columnsDefConfig().persistenceIdColumnName())).s());
            SequenceNumber sequenceNumber = SequenceNumber$.MODULE$.apply(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(((AttributeValue)row.apply((Object)this.pluginContext.pluginConfig().columnsDefConfig().sequenceNrColumnName())).n())));
            byte[] byArray = ((AttributeValue)row.apply((Object)this.pluginContext.pluginConfig().columnsDefConfig().snapshotColumnName())).b().asByteArray();
            long l = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(((AttributeValue)row.apply((Object)this.pluginContext.pluginConfig().columnsDefConfig().createdColumnName())).n()));
            return SnapshotRow$.MODULE$.apply(persistenceId, sequenceNumber, l, byArray);
        })).map((Function1 & Serializable)rows -> {
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext.pluginConfig().tableName());
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)rows.map((Function1 & Serializable)row -> {
                Object[] objectArray = new Tuple2[2];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext.pluginConfig().columnsDefConfig().persistenceIdColumnName());
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, AttributeValue.builder().s(row.persistenceId().asString()).build());
                String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext.pluginConfig().columnsDefConfig().sequenceNrColumnName());
                objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, AttributeValue.builder().n(row.sequenceNumber().asString()).build());
                return (WriteRequest)WriteRequest.builder().deleteRequest((DeleteRequest)DeleteRequest.builder().key(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).asJava()).build()).build();
            })).asJava());
            return (BatchWriteItemRequest)BatchWriteItemRequest.builder().requestItems(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).asJava()).build();
        })).via((Graph)this.streamWriteClient.batchWriteItemFlow()).flatMapConcat((Function1 & Serializable)response -> {
            if (response.sdkHttpResponse().isSuccessful()) {
                return Source$.MODULE$.single((Object)BoxedUnit.UNIT);
            }
            int statusCode = response.sdkHttpResponse().statusCode();
            Optional statusText = response.sdkHttpResponse().statusText();
            Optional optional = OptionConverters$.MODULE$.RichOptionalGeneric(statusText);
            return Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).append(OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(optional).fold(V2LegacySnapshotDaoImpl::queryDelete$$anonfun$5$$anonfun$1, (Function1 & Serializable)s -> new StringBuilder(2).append(", ").append((String)s).toString())).toString()));
        });
    }

    public void dispose() {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply(this.asyncClient, this.syncClient);
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (option instanceof Some) {
                DynamoDbAsyncClient a = (DynamoDbAsyncClient)((Some)option).value();
                a.close();
                return;
            }
            if (option2 instanceof Some) {
                DynamoDbClient s = (DynamoDbClient)((Some)option2).value();
                s.close();
                return;
            }
        }
    }

    private static final String delete$$anonfun$1$$anonfun$1() {
        return "";
    }

    private static final Seq latestSnapshot$$anonfun$1$$anonfun$2() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    private static final String latestSnapshot$$anonfun$1$$anonfun$4() {
        return "";
    }

    private static final Seq snapshotForMaxTimestamp$$anonfun$1$$anonfun$2() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    private static final String snapshotForMaxTimestamp$$anonfun$1$$anonfun$4() {
        return "";
    }

    private static final Seq snapshotForMaxSequenceNr$$anonfun$1$$anonfun$2() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    private static final String snapshotForMaxSequenceNr$$anonfun$1$$anonfun$4() {
        return "";
    }

    private static final Seq snapshotForMaxSequenceNrAndMaxTimestamp$$anonfun$1$$anonfun$2() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    private static final String snapshotForMaxSequenceNrAndMaxTimestamp$$anonfun$1$$anonfun$4() {
        return "";
    }

    private static final String save$$anonfun$1$$anonfun$1$$anonfun$1() {
        return "";
    }

    private static final Seq queryDelete$$anonfun$1$$anonfun$2() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    private static final String queryDelete$$anonfun$5$$anonfun$1() {
        return "";
    }
}

