/*
 * Decompiled with CFR 0.152.
 */
package com.github.j5ik2o.pekko.persistence.dynamodb.snapshot;

import com.github.j5ik2o.pekko.persistence.dynamodb.model.PersistenceId;
import com.github.j5ik2o.pekko.persistence.dynamodb.model.PersistenceId$;
import com.github.j5ik2o.pekko.persistence.dynamodb.model.SequenceNumber;
import com.github.j5ik2o.pekko.persistence.dynamodb.snapshot.PartitionKey;
import com.github.j5ik2o.pekko.persistence.dynamodb.snapshot.PersistenceIdOps;
import com.github.j5ik2o.pekko.persistence.dynamodb.snapshot.SnapshotPluginContext;
import com.github.j5ik2o.pekko.persistence.dynamodb.snapshot.ToPersistenceIdOps;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.text.DecimalFormat;
import net.ceedubs.ficus.Ficus$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\r4qAD\b\u0011\u0002G\u0005a\u0004C\u0003&\u0001\u0019\u0005aeB\u00039\u001f!\u0005\u0011HB\u0003\u000f\u001f!\u0005!\bC\u0003<\u0007\u0011\u0005AH\u0002\u0003>\u0007\tq\u0004\u0002\u0003!\u0006\u0005\u0003\u0005\u000b\u0011B!\t\u000bm*A\u0011\u0001#\t\u000b\u0015*A\u0011\t%\u0007\t-\u001b!\u0001\u0014\u0005\t\u0001&\u0011\t\u0011)A\u0005\u0003\")1(\u0003C\u0001!\")1+\u0003C!)\")Q%\u0003C!A\n!\u0002+\u0019:uSRLwN\\&fsJ+7o\u001c7wKJT!\u0001E\t\u0002\u0011Mt\u0017\r]:i_RT!AE\n\u0002\u0011\u0011Lh.Y7pI\nT!\u0001F\u000b\u0002\u0017A,'o]5ti\u0016t7-\u001a\u0006\u0003-]\tQ\u0001]3lW>T!\u0001G\r\u0002\r),\u0014n\u001b\u001ap\u0015\tQ2$\u0001\u0004hSRDWO\u0019\u0006\u00029\u0005\u00191m\\7\u0004\u0001M\u0011\u0001a\b\t\u0003A\rj\u0011!\t\u0006\u0002E\u0005)1oY1mC&\u0011A%\t\u0002\u0007\u0003:L(+\u001a4\u0002\u000fI,7o\u001c7wKR\u0019qeK\u001a\u0011\u0005!JS\"A\b\n\u0005)z!\u0001\u0004)beRLG/[8o\u0017\u0016L\b\"\u0002\u0017\u0002\u0001\u0004i\u0013!\u00049feNL7\u000f^3oG\u0016LE\r\u0005\u0002/c5\tqF\u0003\u00021#\u0005)Qn\u001c3fY&\u0011!g\f\u0002\u000e!\u0016\u00148/[:uK:\u001cW-\u00133\t\u000bQ\n\u0001\u0019A\u001b\u0002\u001dM,\u0017/^3oG\u0016tU/\u001c2feB\u0011aFN\u0005\u0003o=\u0012abU3rk\u0016t7-\u001a(v[\n,'/\u0001\u000bQCJ$\u0018\u000e^5p].+\u0017PU3t_24XM\u001d\t\u0003Q\r\u0019\"aA\u0010\u0002\rqJg.\u001b;?)\u0005I$aE*fcV,gnY3Ok6\u0014WM\u001d\"bg\u0016$7cA\u0003 \u007fA\u0011\u0001\u0006A\u0001\u000ea2,x-\u001b8D_:$X\r\u001f;\u0011\u0005!\u0012\u0015BA\"\u0010\u0005U\u0019f.\u00199tQ>$\b\u000b\\;hS:\u001cuN\u001c;fqR$\"!R$\u0011\u0005\u0019+Q\"A\u0002\t\u000b\u0001;\u0001\u0019A!\u0015\u0007\u001dJ%\nC\u0003-\u0011\u0001\u0007Q\u0006C\u00035\u0011\u0001\u0007QG\u0001\nQKJ\u001c\u0018n\u001d;f]\u000e,\u0017\n\u001a\"bg\u0016$7\u0003B\u0005 \u007f5\u0003\"\u0001\u000b(\n\u0005={!A\u0005+p!\u0016\u00148/[:uK:\u001cW-\u00133PaN$\"!\u0015*\u0011\u0005\u0019K\u0001\"\u0002!\f\u0001\u0004\t\u0015!C:fa\u0006\u0014\u0018\r^8s+\u0005)\u0006C\u0001,^\u001d\t96\f\u0005\u0002YC5\t\u0011L\u0003\u0002[;\u00051AH]8pizJ!\u0001X\u0011\u0002\rA\u0013X\rZ3g\u0013\tqvL\u0001\u0004TiJLgn\u001a\u0006\u00039\u0006\"2aJ1c\u0011\u0015aS\u00021\u0001.\u0011\u0015!T\u00021\u00016\u0001")
public interface PartitionKeyResolver {
    public PartitionKey resolve(PersistenceId var1, SequenceNumber var2);

    public static final class PersistenceIdBased
    implements PartitionKeyResolver,
    ToPersistenceIdOps {
        private final SnapshotPluginContext pluginContext;

        @Override
        public PersistenceIdOps ToPersistenceIdOps(PersistenceId self) {
            return ToPersistenceIdOps.ToPersistenceIdOps$(this, self);
        }

        @Override
        public String separator() {
            return (String)Ficus$.MODULE$.toFicusConfig(this.pluginContext.pluginConfig().sourceConfig()).getAs("persistence-id-separator", Ficus$.MODULE$.optionValueReader(Ficus$.MODULE$.stringValueReader())).getOrElse((Function0 & Serializable)() -> PersistenceId$.MODULE$.Separator());
        }

        @Override
        public PartitionKey resolve(PersistenceId persistenceId, SequenceNumber sequenceNumber) {
            String string;
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            DecimalFormat df = new DecimalFormat("0000000000000000000000000000000000000000");
            byte[] bytes = StringOps$.MODULE$.reverse$extension(Predef$.MODULE$.augmentString(persistenceId.asString())).getBytes(StandardCharsets.UTF_8);
            BigInt hash = package$.MODULE$.BigInt().apply(md5.digest(bytes));
            BigInt mod = hash.abs().$percent(BigInt$.MODULE$.int2bigInt(this.pluginContext.pluginConfig().shardCount())).$plus(BigInt$.MODULE$.int2bigInt(1));
            Option<String> modelNameOpt = this.ToPersistenceIdOps(persistenceId).prefix();
            Option<String> option = modelNameOpt;
            if (option instanceof Some) {
                Some some = (Some)option;
                String modelName = (String)some.value();
                string = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s-%s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{modelName, df.format(mod)}));
            } else if (None$.MODULE$.equals(option)) {
                string = df.format(mod);
            } else {
                throw new MatchError(option);
            }
            String pkey = string;
            return new PartitionKey(pkey);
        }

        public PersistenceIdBased(SnapshotPluginContext pluginContext) {
            this.pluginContext = pluginContext;
            ToPersistenceIdOps.$init$(this);
        }
    }

    public static final class SequenceNumberBased
    implements PartitionKeyResolver {
        private final SnapshotPluginContext pluginContext;

        @Override
        public PartitionKey resolve(PersistenceId persistenceId, SequenceNumber sequenceNumber) {
            String pkey = new StringBuilder(1).append(persistenceId.asString()).append("-").append(sequenceNumber.value() % (long)this.pluginContext.pluginConfig().shardCount()).toString();
            return new PartitionKey(pkey);
        }

        public SequenceNumberBased(SnapshotPluginContext pluginContext) {
            this.pluginContext = pluginContext;
        }
    }
}

