/*
 * Decompiled with CFR 0.152.
 */
package com.github.j5ik2o.pekko.persistence.dynamodb.journal.dao.v1;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBAsync;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.QueryRequest;
import com.github.j5ik2o.pekko.persistence.dynamodb.client.v1.StreamReadClient;
import com.github.j5ik2o.pekko.persistence.dynamodb.context.PluginContext;
import com.github.j5ik2o.pekko.persistence.dynamodb.journal.JournalPluginContext;
import com.github.j5ik2o.pekko.persistence.dynamodb.journal.JournalRow;
import com.github.j5ik2o.pekko.persistence.dynamodb.journal.JournalRow$;
import com.github.j5ik2o.pekko.persistence.dynamodb.journal.dao.JournalRowDriver;
import com.github.j5ik2o.pekko.persistence.dynamodb.journal.dao.JournalRowReadDriver;
import com.github.j5ik2o.pekko.persistence.dynamodb.model.PersistenceId;
import com.github.j5ik2o.pekko.persistence.dynamodb.model.PersistenceId$;
import com.github.j5ik2o.pekko.persistence.dynamodb.model.SequenceNumber;
import com.github.j5ik2o.pekko.persistence.dynamodb.model.SequenceNumber$;
import java.io.IOException;
import java.io.Serializable;
import org.apache.pekko.NotUsed;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.Source$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class V1JournalRowReadDriver
implements JournalRowDriver,
JournalRowReadDriver {
    private Attributes logLevels;
    private final JournalPluginContext pluginContext;
    private final Option asyncClient;
    private final Option syncClient;
    private final StreamReadClient streamClient;

    public V1JournalRowReadDriver(JournalPluginContext pluginContext, Option<AmazonDynamoDBAsync> asyncClient, Option<AmazonDynamoDB> syncClient) {
        this.pluginContext = pluginContext;
        this.asyncClient = asyncClient;
        this.syncClient = syncClient;
        JournalRowDriver.$init$((JournalRowDriver)this);
        Tuple2 tuple2 = Tuple2$.MODULE$.apply(asyncClient, syncClient);
        if (tuple2 != null && None$.MODULE$.equals(tuple2._1()) && None$.MODULE$.equals(tuple2._2())) {
            throw new IllegalArgumentException("aws clients is both None");
        }
        this.streamClient = new StreamReadClient((PluginContext)pluginContext, asyncClient, syncClient, pluginContext.pluginConfig().readBackoffConfig());
        Statics.releaseFence();
    }

    public Attributes logLevels() {
        return this.logLevels;
    }

    public void com$github$j5ik2o$pekko$persistence$dynamodb$journal$dao$JournalRowDriver$_setter_$logLevels_$eq(Attributes x$0) {
        this.logLevels = x$0;
    }

    public JournalPluginContext pluginContext() {
        return this.pluginContext;
    }

    public Option<AmazonDynamoDBAsync> asyncClient() {
        return this.asyncClient;
    }

    public Option<AmazonDynamoDB> syncClient() {
        return this.syncClient;
    }

    public ActorSystem system() {
        return this.pluginContext().system();
    }

    public void dispose() {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply(this.asyncClient(), this.syncClient());
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (option instanceof Some) {
                AmazonDynamoDBAsync a = (AmazonDynamoDBAsync)((Some)option).value();
                a.shutdown();
                return;
            }
            if (option2 instanceof Some) {
                AmazonDynamoDB s = (AmazonDynamoDB)((Some)option2).value();
                s.shutdown();
                return;
            }
        }
    }

    public Source<scala.collection.immutable.Seq<JournalRow>, NotUsed> getJournalRows(PersistenceId persistenceId, SequenceNumber toSequenceNr, boolean deleted) {
        QueryRequest queryRequest = this.createGSIRequest(persistenceId, toSequenceNr, deleted);
        return ((Source)this.streamClient.recursiveQuerySource(queryRequest, (Option)None$.MODULE$).mapConcat((Function1 & Serializable)response -> (IterableOnce)Option$.MODULE$.apply((Object)response.getItems()).map((Function1 & Serializable)_$1 -> ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(_$1).asScala().map((Function1 & Serializable)_$2 -> CollectionConverters$.MODULE$.MapHasAsScala(_$2).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()))).toVector()).getOrElse(V1JournalRowReadDriver::getJournalRows$$anonfun$1$$anonfun$2)).map((Function1 & Serializable)map -> this.convertToJournalRow((scala.collection.immutable.Map<String, AttributeValue>)map)).fold((Object)ArrayBuffer$.MODULE$.empty(), (Function2 & Serializable)(_$3, _$4) -> (ArrayBuffer)_$3.$plus$eq(_$4)).map((Function1 & Serializable)_$5 -> _$5.toVector())).withAttributes(this.logLevels());
    }

    public Source<JournalRow, NotUsed> getJournalRows(PersistenceId persistenceId, SequenceNumber fromSequenceNr, SequenceNumber toSequenceNr, long max, Option<Object> deleted) {
        if (max == 0L || fromSequenceNr.$greater((Object)toSequenceNr)) {
            return Source$.MODULE$.empty();
        }
        QueryRequest queryRequest = this.createGSIRequest(persistenceId, fromSequenceNr, toSequenceNr, deleted, this.pluginContext().pluginConfig().queryBatchSize());
        return ((Source)this.streamClient.recursiveQuerySource(queryRequest, (Option)Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)max))).mapConcat((Function1 & Serializable)response -> (IterableOnce)Option$.MODULE$.apply((Object)response.getItems()).map((Function1 & Serializable)_$6 -> ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(_$6).asScala().map((Function1 & Serializable)_$7 -> CollectionConverters$.MODULE$.MapHasAsScala(_$7).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()))).toVector()).getOrElse(V1JournalRowReadDriver::getJournalRows$$anonfun$5$$anonfun$2)).map((Function1 & Serializable)map -> this.convertToJournalRow((scala.collection.immutable.Map<String, AttributeValue>)map)).take(max)).withAttributes(this.logLevels());
    }

    public Option<Object> getJournalRows$default$5() {
        return Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    public Source<Option<Object>, NotUsed> highestSequenceNr(PersistenceId persistenceId, Option<SequenceNumber> fromSequenceNr, Option<Object> deleted) {
        QueryRequest queryRequest = this.createHighestSequenceNrRequest(persistenceId, fromSequenceNr, deleted);
        return ((Source)Source$.MODULE$.single((Object)queryRequest).via((Graph)this.streamClient.queryFlow()).flatMapConcat((Function1 & Serializable)response -> {
            if (response.getSdkHttpMetadata().getHttpStatusCode() == 200) {
                Option result = ((IterableOnceOps)Option$.MODULE$.apply((Object)response.getItems()).map((Function1 & Serializable)_$8 -> CollectionConverters$.MODULE$.ListHasAsScala(_$8).asScala()).map((Function1 & Serializable)_$9 -> (Buffer)_$9.map((Function1 & Serializable)_$10 -> CollectionConverters$.MODULE$.MapHasAsScala(_$10).asScala())).getOrElse(V1JournalRowReadDriver::$anonfun$3)).toVector().headOption().map((Function1 & Serializable)head -> StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(((AttributeValue)head.apply((Object)this.pluginContext().pluginConfig().columnsDefConfig().sequenceNrColumnName())).getN())));
                return Source$.MODULE$.single((Object)result);
            }
            int statusCode = response.getSdkHttpMetadata().getHttpStatusCode();
            return Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).toString()));
        })).withAttributes(this.logLevels());
    }

    private QueryRequest createHighestSequenceNrRequest(PersistenceId persistenceId, Option<SequenceNumber> fromSequenceNr, Option<Object> deleted) {
        int limit = BoxesRunTime.unboxToInt((Object)deleted.map((Function1 & Serializable)_$11 -> V1JournalRowReadDriver.$anonfun$5(BoxesRunTime.unboxToBoolean((Object)_$11))).getOrElse(V1JournalRowReadDriver::$anonfun$6));
        Object[] objectArray = new Tuple2[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"#pid");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)this.pluginContext().pluginConfig().columnsDefConfig().persistenceIdColumnName());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"#snr");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)this.pluginContext().pluginConfig().columnsDefConfig().sequenceNrColumnName());
        Object[] objectArray2 = new Tuple2[1];
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)":id");
        objectArray2[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)new AttributeValue().withS(persistenceId.asString()));
        return new QueryRequest().withTableName(this.pluginContext().pluginConfig().tableName()).withIndexName(this.pluginContext().pluginConfig().getJournalRowsIndexName()).withKeyConditionExpression((String)fromSequenceNr.map((Function1 & Serializable)_$12 -> "#pid = :id and #snr >= :nr").orElse(V1JournalRowReadDriver::createHighestSequenceNrRequest$$anonfun$2).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).withFilterExpression((String)deleted.map((Function1 & Serializable)_$13 -> V1JournalRowReadDriver.createHighestSequenceNrRequest$$anonfun$3(BoxesRunTime.unboxToBoolean((Object)_$13))).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).withProjectionExpression(((IterableOnceOps)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"#snr"})).$plus$plus((IterableOnce)deleted.map((Function1 & Serializable)_$14 -> V1JournalRowReadDriver.createHighestSequenceNrRequest$$anonfun$4(BoxesRunTime.unboxToBoolean((Object)_$14))))).mkString(",")).withExpressionAttributeNames(CollectionConverters$.MODULE$.MapHasAsJava((Map)((MapOps)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).$plus$plus((IterableOnce)deleted.map((Function1 & Serializable)_$15 -> this.createHighestSequenceNrRequest$$anonfun$5(BoxesRunTime.unboxToBoolean((Object)_$15))).getOrElse(V1JournalRowReadDriver::createHighestSequenceNrRequest$$anonfun$6))).asJava()).withExpressionAttributeValues(CollectionConverters$.MODULE$.MapHasAsJava((Map)((MapOps)((MapOps)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2))).$plus$plus((IterableOnce)deleted.map((Function1 & Serializable)d -> V1JournalRowReadDriver.createHighestSequenceNrRequest$$anonfun$7(BoxesRunTime.unboxToBoolean((Object)d))).getOrElse(V1JournalRowReadDriver::createHighestSequenceNrRequest$$anonfun$8))).$plus$plus((IterableOnce)fromSequenceNr.map((Function1 & Serializable)nr -> {
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)":nr");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)new AttributeValue().withN(nr.asString()));
            return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        }).getOrElse(V1JournalRowReadDriver::createHighestSequenceNrRequest$$anonfun$10))).asJava()).withScanIndexForward(Predef$.MODULE$.boolean2Boolean(false)).withLimit(Predef$.MODULE$.int2Integer(limit)).withConsistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginContext().pluginConfig().consistentRead()));
    }

    private Option<SequenceNumber> createHighestSequenceNrRequest$default$2() {
        return None$.MODULE$;
    }

    private Option<Object> createHighestSequenceNrRequest$default$3() {
        return None$.MODULE$;
    }

    private QueryRequest createGSIRequest(PersistenceId persistenceId, SequenceNumber toSequenceNr, boolean deleted) {
        Object[] objectArray = new Tuple2[3];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"#pid");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)this.pluginContext().pluginConfig().columnsDefConfig().persistenceIdColumnName());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"#snr");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)this.pluginContext().pluginConfig().columnsDefConfig().sequenceNrColumnName());
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"#d");
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)this.pluginContext().pluginConfig().columnsDefConfig().deletedColumnName());
        Object[] objectArray2 = new Tuple2[3];
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)":pid");
        objectArray2[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)new AttributeValue().withS(persistenceId.asString()));
        String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)":snr");
        objectArray2[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Object)new AttributeValue().withN(toSequenceNr.asString()));
        String string6 = (String)Predef$.MODULE$.ArrowAssoc((Object)":flg");
        objectArray2[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string6, (Object)new AttributeValue().withBOOL(Predef$.MODULE$.boolean2Boolean(deleted)));
        return new QueryRequest().withTableName(this.pluginContext().pluginConfig().tableName()).withIndexName(this.pluginContext().pluginConfig().getJournalRowsIndexName()).withKeyConditionExpression("#pid = :pid and #snr <= :snr").withFilterExpression("#d = :flg").withExpressionAttributeNames(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).asJava()).withExpressionAttributeValues(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2))).asJava()).withLimit(Predef$.MODULE$.int2Integer(this.pluginContext().pluginConfig().queryBatchSize())).withConsistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginContext().pluginConfig().consistentRead()));
    }

    private QueryRequest createGSIRequest(PersistenceId persistenceId, SequenceNumber fromSequenceNr, SequenceNumber toSequenceNr, Option<Object> deleted, int limit) {
        Object[] objectArray = new Tuple2[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"#pid");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)this.pluginContext().pluginConfig().columnsDefConfig().persistenceIdColumnName());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"#snr");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)this.pluginContext().pluginConfig().columnsDefConfig().sequenceNrColumnName());
        Object[] objectArray2 = new Tuple2[3];
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)":pid");
        objectArray2[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)new AttributeValue().withS(persistenceId.asString()));
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)":min");
        objectArray2[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)new AttributeValue().withN(fromSequenceNr.asString()));
        String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)":max");
        objectArray2[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Object)new AttributeValue().withN(toSequenceNr.asString()));
        return new QueryRequest().withTableName(this.pluginContext().pluginConfig().tableName()).withIndexName(this.pluginContext().pluginConfig().getJournalRowsIndexName()).withKeyConditionExpression("#pid = :pid and #snr between :min and :max").withFilterExpression((String)deleted.map((Function1 & Serializable)_$16 -> V1JournalRowReadDriver.createGSIRequest$$anonfun$1(BoxesRunTime.unboxToBoolean((Object)_$16))).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).withExpressionAttributeNames(CollectionConverters$.MODULE$.MapHasAsJava((Map)((MapOps)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).$plus$plus((IterableOnce)deleted.map((Function1 & Serializable)_$17 -> this.createGSIRequest$$anonfun$2(BoxesRunTime.unboxToBoolean((Object)_$17))).getOrElse(V1JournalRowReadDriver::createGSIRequest$$anonfun$3))).asJava()).withExpressionAttributeValues(CollectionConverters$.MODULE$.MapHasAsJava((Map)((MapOps)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2))).$plus$plus((IterableOnce)deleted.map((Function1 & Serializable)b -> V1JournalRowReadDriver.createGSIRequest$$anonfun$4(BoxesRunTime.unboxToBoolean((Object)b))).getOrElse(V1JournalRowReadDriver::createGSIRequest$$anonfun$5))).asJava()).withLimit(Predef$.MODULE$.int2Integer(limit)).withConsistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginContext().pluginConfig().consistentRead()));
    }

    public JournalRow convertToJournalRow(scala.collection.immutable.Map<String, AttributeValue> map) {
        return JournalRow$.MODULE$.apply(PersistenceId$.MODULE$.apply(((AttributeValue)map.apply((Object)this.pluginContext().pluginConfig().columnsDefConfig().persistenceIdColumnName())).getS()), SequenceNumber$.MODULE$.apply(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(((AttributeValue)map.apply((Object)this.pluginContext().pluginConfig().columnsDefConfig().sequenceNrColumnName())).getN()))), Predef$.MODULE$.Boolean2boolean(((AttributeValue)map.apply((Object)this.pluginContext().pluginConfig().columnsDefConfig().deletedColumnName())).getBOOL()), (byte[])map.get((Object)this.pluginContext().pluginConfig().columnsDefConfig().messageColumnName()).map((Function1 & Serializable)_$18 -> _$18.getB().array()).get(), StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(((AttributeValue)map.apply((Object)this.pluginContext().pluginConfig().columnsDefConfig().orderingColumnName())).getN())), map.get((Object)this.pluginContext().pluginConfig().columnsDefConfig().tagsColumnName()).map((Function1 & Serializable)_$19 -> _$19.getS()));
    }

    private static final Vector getJournalRows$$anonfun$1$$anonfun$2() {
        return package$.MODULE$.Vector().empty();
    }

    private static final Vector getJournalRows$$anonfun$5$$anonfun$2() {
        return package$.MODULE$.Vector().empty();
    }

    private static final Seq $anonfun$3() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    private static final /* synthetic */ int $anonfun$5(boolean _$11) {
        return Integer.MAX_VALUE;
    }

    private static final int $anonfun$6() {
        return 1;
    }

    private static final Option createHighestSequenceNrRequest$$anonfun$2() {
        return Some$.MODULE$.apply((Object)"#pid = :id");
    }

    private static final /* synthetic */ String createHighestSequenceNrRequest$$anonfun$3(boolean _$13) {
        return "#d = :flg";
    }

    private static final /* synthetic */ String createHighestSequenceNrRequest$$anonfun$4(boolean _$14) {
        return "#d";
    }

    private final /* synthetic */ scala.collection.immutable.Map createHighestSequenceNrRequest$$anonfun$5(boolean _$15) {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"#d");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)this.pluginContext().pluginConfig().columnsDefConfig().deletedColumnName());
        return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    private static final scala.collection.immutable.Map createHighestSequenceNrRequest$$anonfun$6() {
        return Predef$.MODULE$.Map().empty();
    }

    private static final /* synthetic */ scala.collection.immutable.Map createHighestSequenceNrRequest$$anonfun$7(boolean d) {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)":flg");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)new AttributeValue().withBOOL(Predef$.MODULE$.boolean2Boolean(d)));
        return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    private static final scala.collection.immutable.Map createHighestSequenceNrRequest$$anonfun$8() {
        return Predef$.MODULE$.Map().empty();
    }

    private static final scala.collection.immutable.Map createHighestSequenceNrRequest$$anonfun$10() {
        return Predef$.MODULE$.Map().empty();
    }

    private static final /* synthetic */ String createGSIRequest$$anonfun$1(boolean _$16) {
        return "#flg = :flg";
    }

    private final /* synthetic */ scala.collection.immutable.Map createGSIRequest$$anonfun$2(boolean _$17) {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"#flg");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)this.pluginContext().pluginConfig().columnsDefConfig().deletedColumnName());
        return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    private static final scala.collection.immutable.Map createGSIRequest$$anonfun$3() {
        return Predef$.MODULE$.Map().empty();
    }

    private static final /* synthetic */ scala.collection.immutable.Map createGSIRequest$$anonfun$4(boolean b) {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)":flg");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)new AttributeValue().withBOOL(Predef$.MODULE$.boolean2Boolean(b)));
        return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    private static final scala.collection.immutable.Map createGSIRequest$$anonfun$5() {
        return Predef$.MODULE$.Map().empty();
    }
}

