/*
 * Decompiled with CFR 0.152.
 */
package com.github.j5ik2o.pekko.persistence.dynamodb.journal.dao.v1;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBAsync;
import com.amazonaws.services.dynamodbv2.model.AttributeAction;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.AttributeValueUpdate;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteItemRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteRequest;
import com.amazonaws.services.dynamodbv2.model.PutItemRequest;
import com.amazonaws.services.dynamodbv2.model.PutRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateItemRequest;
import com.amazonaws.services.dynamodbv2.model.WriteRequest;
import com.github.j5ik2o.pekko.persistence.dynamodb.client.v1.StreamWriteClient;
import com.github.j5ik2o.pekko.persistence.dynamodb.context.PluginContext;
import com.github.j5ik2o.pekko.persistence.dynamodb.journal.JournalPluginContext;
import com.github.j5ik2o.pekko.persistence.dynamodb.journal.JournalRow;
import com.github.j5ik2o.pekko.persistence.dynamodb.journal.dao.JournalRowDriver;
import com.github.j5ik2o.pekko.persistence.dynamodb.journal.dao.JournalRowReadDriver;
import com.github.j5ik2o.pekko.persistence.dynamodb.journal.dao.JournalRowWriteDriver;
import com.github.j5ik2o.pekko.persistence.dynamodb.journal.dao.PersistenceIdWithSeqNr;
import com.github.j5ik2o.pekko.persistence.dynamodb.journal.dao.PersistenceIdWithSeqNr$;
import com.github.j5ik2o.pekko.persistence.dynamodb.journal.dao.v1.V1JournalRowReadDriver;
import com.github.j5ik2o.pekko.persistence.dynamodb.model.PersistenceId;
import com.github.j5ik2o.pekko.persistence.dynamodb.model.SequenceNumber;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.pekko.NotUsed;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Flow$;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.Source$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

public final class V1JournalRowWriteDriver
implements JournalRowDriver,
JournalRowReadDriver,
JournalRowWriteDriver {
    private Attributes logLevels;
    private final JournalPluginContext pluginContext;
    private final Option asyncClient;
    private final Option syncClient;
    private final Logger logger;
    private final StreamWriteClient streamClient;
    private final V1JournalRowReadDriver readDriver;

    public V1JournalRowWriteDriver(JournalPluginContext pluginContext, Option<AmazonDynamoDBAsync> asyncClient, Option<AmazonDynamoDB> syncClient) {
        this.pluginContext = pluginContext;
        this.asyncClient = asyncClient;
        this.syncClient = syncClient;
        JournalRowDriver.$init$((JournalRowDriver)this);
        Tuple2 tuple2 = Tuple2$.MODULE$.apply(asyncClient, syncClient);
        if (tuple2 != null && None$.MODULE$.equals(tuple2._1()) && None$.MODULE$.equals(tuple2._2())) {
            throw new IllegalArgumentException("aws clients is both None");
        }
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.streamClient = new StreamWriteClient((PluginContext)pluginContext, asyncClient, syncClient, pluginContext.pluginConfig().writeBackoffConfig());
        this.readDriver = new V1JournalRowReadDriver(pluginContext, asyncClient, syncClient);
        Statics.releaseFence();
    }

    public Attributes logLevels() {
        return this.logLevels;
    }

    public void com$github$j5ik2o$pekko$persistence$dynamodb$journal$dao$JournalRowDriver$_setter_$logLevels_$eq(Attributes x$0) {
        this.logLevels = x$0;
    }

    public JournalPluginContext pluginContext() {
        return this.pluginContext;
    }

    public Option<AmazonDynamoDBAsync> asyncClient() {
        return this.asyncClient;
    }

    public Option<AmazonDynamoDB> syncClient() {
        return this.syncClient;
    }

    public ActorSystem system() {
        return this.pluginContext().system();
    }

    public void dispose() {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply(this.asyncClient(), this.syncClient());
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (option instanceof Some) {
                AmazonDynamoDBAsync a = (AmazonDynamoDBAsync)((Some)option).value();
                a.shutdown();
                return;
            }
            if (option2 instanceof Some) {
                AmazonDynamoDB s = (AmazonDynamoDB)((Some)option2).value();
                s.shutdown();
                return;
            }
        }
    }

    public Source<scala.collection.immutable.Seq<JournalRow>, NotUsed> getJournalRows(PersistenceId persistenceId, SequenceNumber toSequenceNr, boolean deleted) {
        return this.readDriver.getJournalRows(persistenceId, toSequenceNr, deleted);
    }

    public Source<JournalRow, NotUsed> getJournalRows(PersistenceId persistenceId, SequenceNumber fromSequenceNr, SequenceNumber toSequenceNr, long max, Option<Object> deleted) {
        return this.readDriver.getJournalRows(persistenceId, fromSequenceNr, toSequenceNr, max, deleted);
    }

    public Option<Object> getJournalRows$default$5() {
        return Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    public Source<Option<Object>, NotUsed> highestSequenceNr(PersistenceId persistenceId, Option<SequenceNumber> fromSequenceNr, Option<Object> deleted) {
        return this.readDriver.highestSequenceNr(persistenceId, fromSequenceNr, deleted);
    }

    public Flow<JournalRow, Object, NotUsed> singlePutJournalRowFlow() {
        return (Flow)Flow$.MODULE$.apply().flatMapConcat((Function1 & Serializable)journalRow -> {
            String pkey = this.pluginContext().partitionKeyResolver().resolve(journalRow.persistenceId(), journalRow.sequenceNumber()).asString();
            String skey = this.pluginContext().sortKeyResolver().resolve(journalRow.persistenceId(), journalRow.sequenceNumber()).asString();
            Object[] objectArray = new Tuple2[7];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().partitionKeyColumnName());
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)new AttributeValue().withS(pkey));
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().sortKeyColumnName());
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)new AttributeValue().withS(skey));
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().persistenceIdColumnName());
            objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)new AttributeValue().withS(journalRow.persistenceId().asString()));
            String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().sequenceNrColumnName());
            objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)new AttributeValue().withN(journalRow.sequenceNumber().asString()));
            String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().orderingColumnName());
            objectArray[4] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Object)new AttributeValue().withN(BoxesRunTime.boxToLong((long)journalRow.ordering()).toString()));
            String string6 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().deletedColumnName());
            objectArray[5] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string6, (Object)new AttributeValue().withBOOL(Predef$.MODULE$.boolean2Boolean(journalRow.deleted())));
            String string7 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().messageColumnName());
            objectArray[6] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string7, (Object)new AttributeValue().withB(ByteBuffer.wrap(journalRow.message())));
            PutItemRequest request = new PutItemRequest().withTableName(this.pluginContext().pluginConfig().tableName()).withItem(CollectionConverters$.MODULE$.MapHasAsJava((Map)((MapOps)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).$plus$plus((IterableOnce)journalRow.tags().map((Function1 & Serializable)tag -> {
                Object[] objectArray = new Tuple2[1];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().tagsColumnName());
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)new AttributeValue().withS(tag));
                return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            }).getOrElse(V1JournalRowWriteDriver::$anonfun$2))).asJava());
            return (Graph)Source$.MODULE$.single((Object)request).via((Graph)this.streamClient.putItemFlow()).flatMapConcat((Function1 & Serializable)response -> {
                if (response.getSdkHttpMetadata().getHttpStatusCode() == 200) {
                    return Source$.MODULE$.single((Object)BoxesRunTime.boxToLong((long)1L));
                }
                int statusCode = response.getSdkHttpMetadata().getHttpStatusCode();
                return Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).toString()));
            });
        });
    }

    public Flow<scala.collection.immutable.Seq<JournalRow>, Object, NotUsed> multiPutJournalRowsFlow() {
        return (Flow)Flow$.MODULE$.apply().flatMapConcat((Function1 & Serializable)journalRows -> {
            if (journalRows.isEmpty()) {
                return Source$.MODULE$.single((Object)BoxesRunTime.boxToLong((long)0L));
            }
            Predef$.MODULE$.require(journalRows.size() == journalRows.toSet().size(), V1JournalRowWriteDriver::multiPutJournalRowsFlow$$anonfun$1$$anonfun$1);
            scala.collection.immutable.Seq journalRowWithPKeyWithSKeys = (scala.collection.immutable.Seq)journalRows.map((Function1 & Serializable)journalRow -> {
                String pkey = this.pluginContext().partitionKeyResolver().resolve(journalRow.persistenceId(), journalRow.sequenceNumber()).asString();
                String skey = this.pluginContext().sortKeyResolver().resolve(journalRow.persistenceId(), journalRow.sequenceNumber()).asString();
                return Tuple3$.MODULE$.apply(journalRow, (Object)pkey, (Object)skey);
            });
            this.logger.debug(new StringBuilder(55).append("multiPutJournalRowsFlow: journalRowWithPKeyWithSKeys = ").append(journalRowWithPKeyWithSKeys.mkString("\n", ",\n", "\n")).toString());
            Predef$.MODULE$.require(((IterableOnceOps)journalRowWithPKeyWithSKeys.map((Function1 & Serializable)x$1 -> {
                Tuple3 tuple3 = x$1;
                if (tuple3 != null) {
                    String p = (String)tuple3._2();
                    String s = (String)tuple3._3();
                    return Tuple2$.MODULE$.apply((Object)p, (Object)s);
                }
                throw new MatchError((Object)tuple3);
            })).toSet().size() == journalRows.size(), V1JournalRowWriteDriver::multiPutJournalRowsFlow$$anonfun$1$$anonfun$3);
            return ((Source)Source$.MODULE$.single(journalRowWithPKeyWithSKeys.map((Function1 & Serializable)x$1 -> {
                Tuple3 tuple3 = x$1;
                if (tuple3 != null) {
                    JournalRow journalRow = (JournalRow)tuple3._1();
                    String pkey = (String)tuple3._2();
                    String skey = (String)tuple3._3();
                    String pid = journalRow.persistenceId().asString();
                    String seqNr = journalRow.sequenceNumber().asString();
                    String ordering = BoxesRunTime.boxToLong((long)journalRow.ordering()).toString();
                    boolean deleted = journalRow.deleted();
                    ByteBuffer message = ByteBuffer.wrap(journalRow.message());
                    Option tagsOpt = journalRow.tags();
                    Object[] objectArray = new Tuple2[7];
                    String string = (String)Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().partitionKeyColumnName());
                    objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)new AttributeValue().withS(pkey));
                    String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().sortKeyColumnName());
                    objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)new AttributeValue().withS(skey));
                    String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().persistenceIdColumnName());
                    objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)new AttributeValue().withS(pid));
                    String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().sequenceNrColumnName());
                    objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)new AttributeValue().withN(seqNr));
                    String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().orderingColumnName());
                    objectArray[4] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Object)new AttributeValue().withN(ordering));
                    String string6 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().deletedColumnName());
                    objectArray[5] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string6, (Object)new AttributeValue().withBOOL(Predef$.MODULE$.boolean2Boolean(deleted)));
                    String string7 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().messageColumnName());
                    objectArray[6] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string7, (Object)new AttributeValue().withB(message));
                    return new WriteRequest().withPutRequest(new PutRequest().withItem(CollectionConverters$.MODULE$.MapHasAsJava((Map)((MapOps)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).$plus$plus((IterableOnce)tagsOpt.map((Function1 & Serializable)tags -> {
                        Object[] objectArray = new Tuple2[1];
                        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().tagsColumnName());
                        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)new AttributeValue().withS(tags));
                        return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
                    }).getOrElse(V1JournalRowWriteDriver::multiPutJournalRowsFlow$$anonfun$1$$anonfun$4$$anonfun$2))).asJava()));
                }
                throw new MatchError((Object)tuple3);
            })).flatMapConcat((Function1 & Serializable)requestItems -> {
                Object[] objectArray = new Tuple2[1];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().tableName());
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)requestItems).asJava());
                return (Graph)Source$.MODULE$.single((Object)new BatchWriteItemRequest().withRequestItems(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).asJava())).via((Graph)this.streamClient.recursiveBatchWriteItemFlow()).map((Function1 & Serializable)_$1 -> requestItems.size());
            })).withAttributes(this.logLevels());
        });
    }

    public Flow<scala.collection.immutable.Seq<PersistenceIdWithSeqNr>, Object, NotUsed> multiDeleteJournalRowsFlow() {
        return ((Flow)Flow$.MODULE$.apply().flatMapConcat((Function1 & Serializable)persistenceIdWithSeqNrs -> {
            ((IterableOnceOps)persistenceIdWithSeqNrs.map((Function1 & Serializable)x$1 -> {
                PersistenceIdWithSeqNr persistenceIdWithSeqNr = x$1;
                if (persistenceIdWithSeqNr != null) {
                    PersistenceIdWithSeqNr persistenceIdWithSeqNr2 = PersistenceIdWithSeqNr$.MODULE$.unapply(persistenceIdWithSeqNr);
                    PersistenceId persistenceId = persistenceIdWithSeqNr2._1();
                    SequenceNumber sequenceNumber = persistenceIdWithSeqNr2._2();
                    PersistenceId pid = persistenceId;
                    SequenceNumber seqNr = sequenceNumber;
                    return new StringBuilder(16).append("pid = ").append(pid).append(", seqNr = ").append(seqNr).toString();
                }
                throw new MatchError((Object)persistenceIdWithSeqNr);
            })).foreach((Function1)(JProcedure1 & Serializable)x$0 -> this.logger.debug(x$0));
            if (persistenceIdWithSeqNrs.isEmpty()) {
                return Source$.MODULE$.single((Object)BoxesRunTime.boxToLong((long)0L));
            }
            return (Graph)Source$.MODULE$.single(persistenceIdWithSeqNrs.map((Function1 & Serializable)persistenceIdWithSeqNr -> {
                String pkey = this.pluginContext().partitionKeyResolver().resolve(persistenceIdWithSeqNr.persistenceId(), persistenceIdWithSeqNr.sequenceNumber()).asString();
                String skey = this.pluginContext().sortKeyResolver().resolve(persistenceIdWithSeqNr.persistenceId(), persistenceIdWithSeqNr.sequenceNumber()).asString();
                Object[] objectArray = new Tuple2[2];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().partitionKeyColumnName());
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)new AttributeValue().withS(pkey));
                String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().sortKeyColumnName());
                objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)new AttributeValue().withS(skey));
                return new WriteRequest().withDeleteRequest(new DeleteRequest().withKey(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).asJava()));
            })).flatMapConcat((Function1 & Serializable)requestItems -> {
                Object[] objectArray = new Tuple2[1];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().tableName());
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)requestItems).asJava());
                return (Graph)Source$.MODULE$.single((Object)new BatchWriteItemRequest().withRequestItems(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).asJava())).via((Graph)this.streamClient.recursiveBatchWriteItemFlow()).map((Function1 & Serializable)_$2 -> requestItems.size());
            });
        })).withAttributes(this.logLevels());
    }

    public Flow<PersistenceIdWithSeqNr, Object, NotUsed> singleDeleteJournalRowFlow() {
        return (Flow)Flow$.MODULE$.apply().flatMapConcat((Function1 & Serializable)persistenceIdWithSeqNr -> {
            String pkey = this.pluginContext().partitionKeyResolver().resolve(persistenceIdWithSeqNr.persistenceId(), persistenceIdWithSeqNr.sequenceNumber()).asString();
            String skey = this.pluginContext().sortKeyResolver().resolve(persistenceIdWithSeqNr.persistenceId(), persistenceIdWithSeqNr.sequenceNumber()).asString();
            Object[] objectArray = new Tuple2[2];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().partitionKeyColumnName());
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)new AttributeValue().withS(pkey));
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().sortKeyColumnName());
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)new AttributeValue().withS(skey));
            DeleteItemRequest deleteRequest = new DeleteItemRequest().withKey(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).asJava());
            return (Graph)Source$.MODULE$.single((Object)deleteRequest).via((Graph)this.streamClient.deleteItemFlow()).flatMapConcat((Function1 & Serializable)response -> {
                if (response.getSdkHttpMetadata().getHttpStatusCode() == 200) {
                    return Source$.MODULE$.single((Object)BoxesRunTime.boxToLong((long)1L));
                }
                int statusCode = response.getSdkHttpMetadata().getHttpStatusCode();
                return Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).toString()));
            });
        });
    }

    public Source<BoxedUnit, NotUsed> updateMessage(JournalRow journalRow) {
        this.logger.debug(new StringBuilder(35).append("updateMessage(journalRow = ").append(journalRow).append("): start").toString());
        String pkey = journalRow.partitionKey(this.pluginContext().partitionKeyResolver()).asString();
        String skey = journalRow.sortKey(this.pluginContext().sortKeyResolver()).asString();
        return ((Source)Source$.MODULE$.single((Object)this.createUpdateRequest$1(journalRow, pkey, skey)).via((Graph)this.streamClient.updateItemFlow()).flatMapConcat((Function1 & Serializable)response -> {
            if (response.getSdkHttpMetadata().getHttpStatusCode() == 200) {
                return Source$.MODULE$.single((Object)BoxedUnit.UNIT);
            }
            int statusCode = response.getSdkHttpMetadata().getHttpStatusCode();
            this.logger.debug(new StringBuilder(38).append("updateMessage(journalRow = ").append(journalRow).append("): finished").toString());
            return Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).toString()));
        })).withAttributes(this.logLevels());
    }

    private static final scala.collection.immutable.Map $anonfun$2() {
        return Predef$.MODULE$.Map().empty();
    }

    private static final Object multiPutJournalRowsFlow$$anonfun$1$$anonfun$1() {
        return "journalRows: keys contains duplicates";
    }

    private static final Object multiPutJournalRowsFlow$$anonfun$1$$anonfun$3() {
        return "journalRowWithPKeyWithSKeys: keys contains duplicates";
    }

    private static final scala.collection.immutable.Map multiPutJournalRowsFlow$$anonfun$1$$anonfun$4$$anonfun$2() {
        return Predef$.MODULE$.Map().empty();
    }

    private static final scala.collection.immutable.Map createUpdateRequest$1$$anonfun$2() {
        return Predef$.MODULE$.Map().empty();
    }

    private final UpdateItemRequest createUpdateRequest$1(JournalRow journalRow$1, String pkey$1, String skey$1) {
        Object[] objectArray = new Tuple2[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().partitionKeyColumnName());
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)new AttributeValue().withS(pkey$1));
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().sortKeyColumnName());
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)new AttributeValue().withS(skey$1));
        Object[] objectArray2 = new Tuple2[3];
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().messageColumnName());
        objectArray2[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)new AttributeValueUpdate().withAction(AttributeAction.PUT).withValue(new AttributeValue().withB(ByteBuffer.wrap(journalRow$1.message()))));
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().orderingColumnName());
        objectArray2[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)new AttributeValueUpdate().withAction(AttributeAction.PUT).withValue(new AttributeValue().withN(BoxesRunTime.boxToLong((long)journalRow$1.ordering()).toString())));
        String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().deletedColumnName());
        objectArray2[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Object)new AttributeValueUpdate().withAction(AttributeAction.PUT).withValue(new AttributeValue().withBOOL(Predef$.MODULE$.boolean2Boolean(journalRow$1.deleted()))));
        return new UpdateItemRequest().withTableName(this.pluginContext().pluginConfig().tableName()).withKey(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).asJava()).withAttributeUpdates(CollectionConverters$.MODULE$.MapHasAsJava((Map)((MapOps)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2))).$plus$plus((IterableOnce)journalRow$1.tags().map((Function1 & Serializable)tag -> {
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().tagsColumnName());
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)new AttributeValueUpdate().withAction(AttributeAction.PUT).withValue(new AttributeValue().withS(tag)));
            return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        }).getOrElse(V1JournalRowWriteDriver::createUpdateRequest$1$$anonfun$2))).asJava());
    }
}

