/*
 * Decompiled with CFR 0.152.
 */
package com.github.j5ik2o.pekko.persistence.dynamodb.journal;

import com.github.j5ik2o.pekko.persistence.dynamodb.journal.JournalPluginContext;
import com.github.j5ik2o.pekko.persistence.dynamodb.journal.PartitionKey;
import com.github.j5ik2o.pekko.persistence.dynamodb.journal.PersistenceIdOps;
import com.github.j5ik2o.pekko.persistence.dynamodb.journal.ToPersistenceIdOps;
import com.github.j5ik2o.pekko.persistence.dynamodb.model.PersistenceId;
import com.github.j5ik2o.pekko.persistence.dynamodb.model.PersistenceId$;
import com.github.j5ik2o.pekko.persistence.dynamodb.model.SequenceNumber;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.text.DecimalFormat;
import net.ceedubs.ficus.Ficus$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\r4qAD\b\u0011\u0002G\u0005a\u0004C\u0003&\u0001\u0019\u0005aeB\u00039\u001f!\u0005\u0011HB\u0003\u000f\u001f!\u0005!\bC\u0003<\u0007\u0011\u0005AH\u0002\u0003>\u0007\tq\u0004\u0002\u0003!\u0006\u0005\u0003\u0005\u000b\u0011B!\t\u000bm*A\u0011\u0001#\t\u000b\u0015*A\u0011\t%\u0007\t-\u001b!\u0001\u0014\u0005\t\u0001&\u0011\t\u0011)A\u0005\u0003\")1(\u0003C\u0001!\")1+\u0003C!)\")Q%\u0003C!A\n!\u0002+\u0019:uSRLwN\\&fsJ+7o\u001c7wKJT!\u0001E\t\u0002\u000f)|WO\u001d8bY*\u0011!cE\u0001\tIft\u0017-\\8eE*\u0011A#F\u0001\fa\u0016\u00148/[:uK:\u001cWM\u0003\u0002\u0017/\u0005)\u0001/Z6l_*\u0011\u0001$G\u0001\u0007UVJ7NM8\u000b\u0005iY\u0012AB4ji\",(MC\u0001\u001d\u0003\r\u0019w.\\\u0002\u0001'\t\u0001q\u0004\u0005\u0002!G5\t\u0011EC\u0001#\u0003\u0015\u00198-\u00197b\u0013\t!\u0013E\u0001\u0004B]f\u0014VMZ\u0001\be\u0016\u001cx\u000e\u001c<f)\r93f\r\t\u0003Q%j\u0011aD\u0005\u0003U=\u0011A\u0002U1si&$\u0018n\u001c8LKfDQ\u0001L\u0001A\u00025\nQ\u0002]3sg&\u001cH/\u001a8dK&#\u0007C\u0001\u00182\u001b\u0005y#B\u0001\u0019\u0012\u0003\u0015iw\u000eZ3m\u0013\t\u0011tFA\u0007QKJ\u001c\u0018n\u001d;f]\u000e,\u0017\n\u001a\u0005\u0006i\u0005\u0001\r!N\u0001\u000fg\u0016\fX/\u001a8dK:+XNY3s!\tqc'\u0003\u00028_\tq1+Z9vK:\u001cWMT;nE\u0016\u0014\u0018\u0001\u0006)beRLG/[8o\u0017\u0016L(+Z:pYZ,'\u000f\u0005\u0002)\u0007M\u00111aH\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003e\u00121cU3rk\u0016t7-\u001a(v[\n,'OQ1tK\u0012\u001c2!B\u0010@!\tA\u0003!A\u0007qYV<\u0017N\\\"p]R,\u0007\u0010\u001e\t\u0003Q\tK!aQ\b\u0003)){WO\u001d8bYBcWoZ5o\u0007>tG/\u001a=u)\t)u\t\u0005\u0002G\u000b5\t1\u0001C\u0003A\u000f\u0001\u0007\u0011\tF\u0002(\u0013*CQ\u0001\f\u0005A\u00025BQ\u0001\u000e\u0005A\u0002U\u0012!\u0003U3sg&\u001cH/\u001a8dK&#')Y:fIN!\u0011bH N!\tAc*\u0003\u0002P\u001f\t\u0011Bk\u001c)feNL7\u000f^3oG\u0016LEm\u00149t)\t\t&\u000b\u0005\u0002G\u0013!)\u0001i\u0003a\u0001\u0003\u0006I1/\u001a9be\u0006$xN]\u000b\u0002+B\u0011a+\u0018\b\u0003/n\u0003\"\u0001W\u0011\u000e\u0003eS!AW\u000f\u0002\rq\u0012xn\u001c;?\u0013\ta\u0016%\u0001\u0004Qe\u0016$WMZ\u0005\u0003=~\u0013aa\u0015;sS:<'B\u0001/\")\r9\u0013M\u0019\u0005\u0006Y5\u0001\r!\f\u0005\u0006i5\u0001\r!\u000e")
public interface PartitionKeyResolver {
    public PartitionKey resolve(PersistenceId var1, SequenceNumber var2);

    public static final class PersistenceIdBased
    implements PartitionKeyResolver,
    ToPersistenceIdOps {
        private final JournalPluginContext pluginContext;

        @Override
        public PersistenceIdOps ToPersistenceIdOps(PersistenceId self) {
            return ToPersistenceIdOps.ToPersistenceIdOps$(this, self);
        }

        @Override
        public String separator() {
            return (String)Ficus$.MODULE$.toFicusConfig(this.pluginContext.pluginConfig().sourceConfig()).getAs("persistence-id-separator", Ficus$.MODULE$.optionValueReader(Ficus$.MODULE$.stringValueReader())).getOrElse((Function0 & Serializable)() -> PersistenceId$.MODULE$.Separator());
        }

        @Override
        public PartitionKey resolve(PersistenceId persistenceId, SequenceNumber sequenceNumber) {
            String string;
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            DecimalFormat df = new DecimalFormat("0000000000000000000000000000000000000000");
            byte[] bytes = StringOps$.MODULE$.reverse$extension(Predef$.MODULE$.augmentString(persistenceId.asString())).getBytes(StandardCharsets.UTF_8);
            BigInt hash = package$.MODULE$.BigInt().apply(md5.digest(bytes));
            BigInt mod = hash.abs().$percent(BigInt$.MODULE$.int2bigInt(this.pluginContext.pluginConfig().shardCount())).$plus(BigInt$.MODULE$.int2bigInt(1));
            Option<String> modelNameOpt = this.ToPersistenceIdOps(persistenceId).prefix();
            Option<String> option = modelNameOpt;
            if (option instanceof Some) {
                Some some = (Some)option;
                String modelName = (String)some.value();
                string = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s-%s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{modelName, df.format(mod)}));
            } else if (None$.MODULE$.equals(option)) {
                string = df.format(mod);
            } else {
                throw new MatchError(option);
            }
            String pkey = string;
            return new PartitionKey(pkey);
        }

        public PersistenceIdBased(JournalPluginContext pluginContext) {
            this.pluginContext = pluginContext;
            ToPersistenceIdOps.$init$(this);
        }
    }

    public static final class SequenceNumberBased
    implements PartitionKeyResolver {
        private final JournalPluginContext pluginContext;

        @Override
        public PartitionKey resolve(PersistenceId persistenceId, SequenceNumber sequenceNumber) {
            String pkey = new StringBuilder(1).append(persistenceId.asString()).append("-").append(sequenceNumber.value() % (long)this.pluginContext.pluginConfig().shardCount()).toString();
            return new PartitionKey(pkey);
        }

        public SequenceNumberBased(JournalPluginContext pluginContext) {
            this.pluginContext = pluginContext;
        }
    }
}

