/*
 * Decompiled with CFR 0.152.
 */
package com.github.j5ik2o.pekko.persistence.dynamodb.config.client.v2;

import com.github.j5ik2o.pekko.persistence.dynamodb.config.client.CommonConfigKeys$;
import com.github.j5ik2o.pekko.persistence.dynamodb.config.client.RetryMode$;
import com.github.j5ik2o.pekko.persistence.dynamodb.config.client.V2CommonConfigDefaultValues$;
import com.github.j5ik2o.pekko.persistence.dynamodb.config.client.V2CommonConfigKeys$;
import com.github.j5ik2o.pekko.persistence.dynamodb.config.client.v2.AsyncClientConfig;
import com.github.j5ik2o.pekko.persistence.dynamodb.config.client.v2.AsyncClientConfig$;
import com.github.j5ik2o.pekko.persistence.dynamodb.config.client.v2.DynamoDBClientV2Config;
import com.github.j5ik2o.pekko.persistence.dynamodb.config.client.v2.SyncClientConfig;
import com.github.j5ik2o.pekko.persistence.dynamodb.config.client.v2.SyncClientConfig$;
import com.github.j5ik2o.pekko.persistence.dynamodb.utils.ClassCheckUtils$;
import com.github.j5ik2o.pekko.persistence.dynamodb.utils.LoggingSupport;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.Serializable;
import net.ceedubs.ficus.Ficus$;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Seq$;
import scala.concurrent.duration.FiniteDuration;
import scala.deriving.Mirror;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class DynamoDBClientV2Config$
implements LoggingSupport,
Mirror.Product,
Serializable {
    private static Logger logger;
    private static final String asyncKey;
    private static final String syncKey;
    private static final String retryPolicyProviderClassNameKey;
    private static final String executionInterceptorClassNamesKey;
    private static final String executionInterceptorProviderClassNameKey;
    private static final String apiCallTimeoutKey;
    private static final String apiCallAttemptTimeoutKey;
    private static final scala.collection.immutable.Seq keyNames;
    private static final String RetryPolicyProviderClassName;
    private static final String ExecutionInterceptorsProviderClassName;
    public static final DynamoDBClientV2Config$ MODULE$;

    private DynamoDBClientV2Config$() {
    }

    static {
        MODULE$ = new DynamoDBClientV2Config$();
        LoggingSupport.$init$(MODULE$);
        asyncKey = "async";
        syncKey = "sync";
        retryPolicyProviderClassNameKey = "retry-policy-provider-class-name";
        executionInterceptorClassNamesKey = "execution-interceptor-class-names";
        executionInterceptorProviderClassNameKey = "execution-interceptor-provider-class-name";
        apiCallTimeoutKey = "api-call-timeout";
        apiCallAttemptTimeoutKey = "api-call-attempt-timeout";
        keyNames = (scala.collection.immutable.Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{CommonConfigKeys$.MODULE$.dispatcherNameKey(), MODULE$.asyncKey(), MODULE$.syncKey(), CommonConfigKeys$.MODULE$.retryModeKey(), MODULE$.apiCallTimeoutKey(), MODULE$.apiCallAttemptTimeoutKey()}));
        RetryPolicyProviderClassName = "com.github.j5ik2o.pekko.persistence.dynamodb.client.v2.RetryPolicyProvider";
        ExecutionInterceptorsProviderClassName = "com.github.j5ik2o.pekko.persistence.dynamodb.client.v2.ExecutionInterceptorsProvider";
        Statics.releaseFence();
    }

    @Override
    public Logger logger() {
        return logger;
    }

    @Override
    public void com$github$j5ik2o$pekko$persistence$dynamodb$utils$LoggingSupport$_setter_$logger_$eq(Logger x$0) {
        logger = x$0;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DynamoDBClientV2Config$.class);
    }

    public DynamoDBClientV2Config apply(Config sourceConfig, Option<String> dispatcherName, AsyncClientConfig asyncClientConfig, SyncClientConfig syncClientConfig, Map<String, Seq<String>> headers, String retryPolicyProviderClassName, Option<Enumeration.Value> retryMode, String executionInterceptorsProviderClassName, scala.collection.immutable.Seq<String> executionInterceptorClassNames, Option<FiniteDuration> apiCallTimeout, Option<FiniteDuration> apiCallAttemptTimeout, String metricPublishersProviderClassName, Seq<String> metricPublisherClassNames, String awsCredentialsProviderProviderClassName, Option<String> awsCredentialsProviderClassName) {
        return new DynamoDBClientV2Config(sourceConfig, dispatcherName, asyncClientConfig, syncClientConfig, headers, retryPolicyProviderClassName, retryMode, executionInterceptorsProviderClassName, executionInterceptorClassNames, apiCallTimeout, apiCallAttemptTimeout, metricPublishersProviderClassName, metricPublisherClassNames, awsCredentialsProviderProviderClassName, awsCredentialsProviderClassName);
    }

    public DynamoDBClientV2Config unapply(DynamoDBClientV2Config x$1) {
        return x$1;
    }

    public String toString() {
        return "DynamoDBClientV2Config";
    }

    public String asyncKey() {
        return asyncKey;
    }

    public String syncKey() {
        return syncKey;
    }

    public String retryPolicyProviderClassNameKey() {
        return retryPolicyProviderClassNameKey;
    }

    public String executionInterceptorClassNamesKey() {
        return executionInterceptorClassNamesKey;
    }

    public String executionInterceptorProviderClassNameKey() {
        return executionInterceptorProviderClassNameKey;
    }

    public String apiCallTimeoutKey() {
        return apiCallTimeoutKey;
    }

    public String apiCallAttemptTimeoutKey() {
        return apiCallAttemptTimeoutKey;
    }

    public scala.collection.immutable.Seq<String> keyNames() {
        return keyNames;
    }

    public scala.collection.immutable.Map<String, Object> existsKeyNames(Config config) {
        return ((IterableOnceOps)this.keyNames().map((Function1 & Serializable)v -> Tuple2$.MODULE$.apply(v, (Object)BoxesRunTime.boxToBoolean((boolean)config.hasPath(v))))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public String RetryPolicyProviderClassName() {
        return RetryPolicyProviderClassName;
    }

    public String ExecutionInterceptorsProviderClassName() {
        return ExecutionInterceptorsProviderClassName;
    }

    public DynamoDBClientV2Config fromConfig(Config config, boolean classNameValidation, boolean legacyConfigFormat) {
        AsyncClientConfig asyncClientConfig;
        this.logger().debug("config = {}", (Object)config);
        Option option = Ficus$.MODULE$.toFicusConfig(config).getAs(CommonConfigKeys$.MODULE$.dispatcherNameKey(), Ficus$.MODULE$.optionValueReader(Ficus$.MODULE$.stringValueReader()));
        if (legacyConfigFormat) {
            this.logger().warn(new StringBuilder(288).append("<<<!!!CAUTION: PLEASE MIGRATE TO NEW CONFIG FORMAT!!!>>>\n\tThe configuration items of AWS-SDK V2 client remain with the old key names: (j5ik2o.dynamo-db-journal.dynamo-db-client).\n\tPlease change current key name to the new key name: (j5ik2o.dynamo-db-journal.dynamo-db-client.v2.async). \n\t").append(((MapOps)AsyncClientConfig$.MODULE$.existsKeyNames(config).filter((Function1 & Serializable)_$1 -> BoxesRunTime.unboxToBoolean((Object)_$1._2()))).keys().mkString("child-keys = [ ", ", ", " ]")).toString());
            asyncClientConfig = AsyncClientConfig$.MODULE$.fromConfig(config);
        } else {
            asyncClientConfig = AsyncClientConfig$.MODULE$.fromConfig((Config)Ficus$.MODULE$.toFicusConfig(config).getAs(this.asyncKey(), Ficus$.MODULE$.optionValueReader(Ficus$.MODULE$.configValueReader())).getOrElse(this::$anonfun$2));
        }
        String className = (String)Ficus$.MODULE$.toFicusConfig(config).as(this.retryPolicyProviderClassNameKey(), Ficus$.MODULE$.stringValueReader());
        String className2 = (String)Ficus$.MODULE$.toFicusConfig(config).as(this.executionInterceptorProviderClassNameKey(), Ficus$.MODULE$.stringValueReader());
        scala.collection.immutable.Seq classNames = (scala.collection.immutable.Seq)Ficus$.MODULE$.toFicusConfig(config).getAs(this.executionInterceptorClassNamesKey(), Ficus$.MODULE$.optionValueReader(Ficus$.MODULE$.traversableReader(Ficus$.MODULE$.stringValueReader(), Seq$.MODULE$.iterableFactory()))).getOrElse(this::$anonfun$6);
        String className3 = (String)Ficus$.MODULE$.toFicusConfig(config).as(V2CommonConfigKeys$.MODULE$.metricPublisherProviderClassNameKey(), Ficus$.MODULE$.stringValueReader());
        scala.collection.immutable.Seq classNames2 = (scala.collection.immutable.Seq)Ficus$.MODULE$.toFicusConfig(config).getAs(V2CommonConfigKeys$.MODULE$.metricPublisherClassNameKey(), Ficus$.MODULE$.optionValueReader(Ficus$.MODULE$.traversableReader(Ficus$.MODULE$.stringValueReader(), Seq$.MODULE$.iterableFactory()))).getOrElse(this::$anonfun$8);
        String className4 = (String)Ficus$.MODULE$.toFicusConfig(config).as(V2CommonConfigKeys$.MODULE$.awsCredentialsProviderProviderClassNameKey(), Ficus$.MODULE$.stringValueReader());
        Option className5 = Ficus$.MODULE$.toFicusConfig(config).getAs(V2CommonConfigKeys$.MODULE$.awsCredentialsProviderClassNameKey(), Ficus$.MODULE$.optionValueReader(Ficus$.MODULE$.stringValueReader()));
        DynamoDBClientV2Config result = this.apply(config, (Option<String>)option, asyncClientConfig, SyncClientConfig$.MODULE$.fromConfig((Config)Ficus$.MODULE$.toFicusConfig(config).getAs(this.syncKey(), Ficus$.MODULE$.optionValueReader(Ficus$.MODULE$.configValueReader())).getOrElse(this::$anonfun$3)), (Map<String, Seq<String>>)((Map)Ficus$.MODULE$.toFicusConfig(config).getAs(CommonConfigKeys$.MODULE$.headersKey(), Ficus$.MODULE$.optionValueReader(Ficus$.MODULE$.mapValueReader(Ficus$.MODULE$.traversableReader(Ficus$.MODULE$.stringValueReader(), Seq$.MODULE$.iterableFactory())))).getOrElse(this::$anonfun$4)), ClassCheckUtils$.MODULE$.requireClassByName(this.RetryPolicyProviderClassName(), className, classNameValidation), (Option<Enumeration.Value>)Ficus$.MODULE$.toFicusConfig(config).getAs(CommonConfigKeys$.MODULE$.retryModeKey(), Ficus$.MODULE$.optionValueReader(Ficus$.MODULE$.stringValueReader())).map((Function1 & Serializable)s -> RetryMode$.MODULE$.withName(s.toUpperCase())), ClassCheckUtils$.MODULE$.requireClassByName(this.ExecutionInterceptorsProviderClassName(), className2, classNameValidation), (scala.collection.immutable.Seq<String>)((IterableOnceOps)classNames.map((Function1 & Serializable)s -> ClassCheckUtils$.MODULE$.requireClassByName(V2CommonConfigDefaultValues$.MODULE$.MetricPublisherClassName(), (String)s, classNameValidation))).toIndexedSeq(), (Option<FiniteDuration>)Ficus$.MODULE$.toFicusConfig(config).getAs(this.apiCallTimeoutKey(), Ficus$.MODULE$.optionValueReader(Ficus$.MODULE$.finiteDurationReader())), (Option<FiniteDuration>)Ficus$.MODULE$.toFicusConfig(config).getAs(this.apiCallAttemptTimeoutKey(), Ficus$.MODULE$.optionValueReader(Ficus$.MODULE$.finiteDurationReader())), ClassCheckUtils$.MODULE$.requireClassByName(V2CommonConfigDefaultValues$.MODULE$.MetricPublishersProviderClassName(), className3, classNameValidation), (Seq<String>)((Seq)classNames2.map((Function1 & Serializable)s -> ClassCheckUtils$.MODULE$.requireClassByName(V2CommonConfigDefaultValues$.MODULE$.MetricPublisherClassName(), (String)s, classNameValidation))), ClassCheckUtils$.MODULE$.requireClassByName(V2CommonConfigDefaultValues$.MODULE$.AwsCredentialsProviderProviderClassName(), className4, classNameValidation), ClassCheckUtils$.MODULE$.requireClassByName(V2CommonConfigDefaultValues$.MODULE$.AwsCredentialsProviderClassName(), (Option<String>)className5, classNameValidation));
        this.logger().debug("result = {}", (Object)result);
        return result;
    }

    public DynamoDBClientV2Config fromProduct(Product x$0) {
        return new DynamoDBClientV2Config((Config)x$0.productElement(0), (Option<String>)((Option)x$0.productElement(1)), (AsyncClientConfig)x$0.productElement(2), (SyncClientConfig)x$0.productElement(3), (Map<String, Seq<String>>)((Map)x$0.productElement(4)), (String)x$0.productElement(5), (Option<Enumeration.Value>)((Option)x$0.productElement(6)), (String)x$0.productElement(7), (scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)x$0.productElement(8)), (Option<FiniteDuration>)((Option)x$0.productElement(9)), (Option<FiniteDuration>)((Option)x$0.productElement(10)), (String)x$0.productElement(11), (Seq<String>)((Seq)x$0.productElement(12)), (String)x$0.productElement(13), (Option<String>)((Option)x$0.productElement(14)));
    }

    private final Config $anonfun$2() {
        return ConfigFactory.empty();
    }

    private final Config $anonfun$3() {
        return ConfigFactory.empty();
    }

    private final scala.collection.immutable.Map $anonfun$4() {
        return Map$.MODULE$.empty();
    }

    private final scala.collection.immutable.Seq $anonfun$6() {
        return (scala.collection.immutable.Seq)Seq$.MODULE$.empty();
    }

    private final scala.collection.immutable.Seq $anonfun$8() {
        return (scala.collection.immutable.Seq)Seq$.MODULE$.empty();
    }
}

