/*
 * Decompiled with CFR 0.152.
 */
package com.github.j5ik2o.pekko.persistence.dynamodb.config.client;

import com.github.j5ik2o.pekko.persistence.dynamodb.config.client.ClientType$;
import com.github.j5ik2o.pekko.persistence.dynamodb.config.client.ClientVersion$;
import com.github.j5ik2o.pekko.persistence.dynamodb.config.client.DynamoDBClientConfig;
import com.github.j5ik2o.pekko.persistence.dynamodb.config.client.v1.DynamoDBClientV1Config;
import com.github.j5ik2o.pekko.persistence.dynamodb.config.client.v1.DynamoDBClientV1Config$;
import com.github.j5ik2o.pekko.persistence.dynamodb.config.client.v1dax.DynamoDBClientV1DaxConfig;
import com.github.j5ik2o.pekko.persistence.dynamodb.config.client.v1dax.DynamoDBClientV1DaxConfig$;
import com.github.j5ik2o.pekko.persistence.dynamodb.config.client.v2.DynamoDBClientV2Config;
import com.github.j5ik2o.pekko.persistence.dynamodb.config.client.v2.DynamoDBClientV2Config$;
import com.github.j5ik2o.pekko.persistence.dynamodb.config.client.v2dax.DynamoDBClientV2DaxConfig;
import com.github.j5ik2o.pekko.persistence.dynamodb.config.client.v2dax.DynamoDBClientV2DaxConfig$;
import com.github.j5ik2o.pekko.persistence.dynamodb.utils.LoggingSupport;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.Serializable;
import net.ceedubs.ficus.Ficus$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.collection.MapOps;
import scala.deriving.Mirror;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Statics;

public final class DynamoDBClientConfig$
implements LoggingSupport,
Mirror.Product,
Serializable {
    private static Logger logger;
    private static final String accessKeyIdKeyKey;
    private static final String secretAccessKeyKey;
    private static final String endpointKey;
    private static final String regionKey;
    private static final String clientVersionKey;
    private static final String clientTypeKey;
    private static final String v1Key;
    private static final String v1DaxKey;
    private static final String v2Key;
    private static final String v2DaxKey;
    private static final String batchGetItemLimitKey;
    private static final String batchWriteItemLimitKey;
    public static final DynamoDBClientConfig$ MODULE$;

    private DynamoDBClientConfig$() {
    }

    static {
        MODULE$ = new DynamoDBClientConfig$();
        LoggingSupport.$init$(MODULE$);
        accessKeyIdKeyKey = "access-key-id";
        secretAccessKeyKey = "secret-access-key";
        endpointKey = "endpoint";
        regionKey = "region";
        clientVersionKey = "client-version";
        clientTypeKey = "client-type";
        v1Key = "v1";
        v1DaxKey = "v1-dax";
        v2Key = "v2";
        v2DaxKey = "v2-dax";
        batchGetItemLimitKey = "batch-get-item-limit";
        batchWriteItemLimitKey = "batch-write-item-limit";
        Statics.releaseFence();
    }

    @Override
    public Logger logger() {
        return logger;
    }

    @Override
    public void com$github$j5ik2o$pekko$persistence$dynamodb$utils$LoggingSupport$_setter_$logger_$eq(Logger x$0) {
        logger = x$0;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DynamoDBClientConfig$.class);
    }

    public DynamoDBClientConfig apply(Config sourceConfig, Option<String> accessKeyId, Option<String> secretAccessKey, Option<String> endpoint, Option<String> region, Enumeration.Value clientVersion, Enumeration.Value clientType, DynamoDBClientV1Config v1ClientConfig, DynamoDBClientV1DaxConfig v1DaxClientConfig, DynamoDBClientV2Config v2ClientConfig, DynamoDBClientV2DaxConfig v2DaxClientConfig, int batchGetItemLimit, int batchWriteItemLimit) {
        return new DynamoDBClientConfig(sourceConfig, accessKeyId, secretAccessKey, endpoint, region, clientVersion, clientType, v1ClientConfig, v1DaxClientConfig, v2ClientConfig, v2DaxClientConfig, batchGetItemLimit, batchWriteItemLimit);
    }

    public DynamoDBClientConfig unapply(DynamoDBClientConfig x$1) {
        return x$1;
    }

    public String toString() {
        return "DynamoDBClientConfig";
    }

    public String accessKeyIdKeyKey() {
        return accessKeyIdKeyKey;
    }

    public String secretAccessKeyKey() {
        return secretAccessKeyKey;
    }

    public String endpointKey() {
        return endpointKey;
    }

    public String regionKey() {
        return regionKey;
    }

    public String clientVersionKey() {
        return clientVersionKey;
    }

    public String clientTypeKey() {
        return clientTypeKey;
    }

    public String v1Key() {
        return v1Key;
    }

    public String v1DaxKey() {
        return v1DaxKey;
    }

    public String v2Key() {
        return v2Key;
    }

    public String v2DaxKey() {
        return v2DaxKey;
    }

    public String batchGetItemLimitKey() {
        return batchGetItemLimitKey;
    }

    public String batchWriteItemLimitKey() {
        return batchWriteItemLimitKey;
    }

    public DynamoDBClientConfig fromConfig(Config config, boolean legacyConfigFormat) {
        DynamoDBClientV2Config dynamoDBClientV2Config;
        this.logger().debug("config = {}", (Object)config);
        Enumeration.Value clientVersion = ClientVersion$.MODULE$.withName((String)Ficus$.MODULE$.toFicusConfig(config).as(this.clientVersionKey(), Ficus$.MODULE$.stringValueReader()));
        Option option = Ficus$.MODULE$.toFicusConfig(config).getAs(this.accessKeyIdKeyKey(), Ficus$.MODULE$.optionValueReader(Ficus$.MODULE$.stringValueReader()));
        Option option2 = Ficus$.MODULE$.toFicusConfig(config).getAs(this.secretAccessKeyKey(), Ficus$.MODULE$.optionValueReader(Ficus$.MODULE$.stringValueReader()));
        Option option3 = Ficus$.MODULE$.toFicusConfig(config).getAs(this.endpointKey(), Ficus$.MODULE$.optionValueReader(Ficus$.MODULE$.stringValueReader()));
        Option option4 = Ficus$.MODULE$.toFicusConfig(config).getAs(this.regionKey(), Ficus$.MODULE$.optionValueReader(Ficus$.MODULE$.stringValueReader()));
        Enumeration.Value value = ClientType$.MODULE$.withName((String)Ficus$.MODULE$.toFicusConfig(config).as(this.clientTypeKey(), Ficus$.MODULE$.stringValueReader()));
        Enumeration.Value value2 = clientVersion;
        Enumeration.Value value3 = ClientVersion$.MODULE$.V1();
        DynamoDBClientV1Config dynamoDBClientV1Config = DynamoDBClientV1Config$.MODULE$.fromConfig((Config)Ficus$.MODULE$.toFicusConfig(config).getAs(this.v1Key(), Ficus$.MODULE$.optionValueReader(Ficus$.MODULE$.configValueReader())).getOrElse(this::$anonfun$1), !(value2 != null ? !value2.equals(value3) : value3 != null));
        Enumeration.Value value4 = clientVersion;
        Enumeration.Value value5 = ClientVersion$.MODULE$.V1Dax();
        DynamoDBClientV1DaxConfig dynamoDBClientV1DaxConfig = DynamoDBClientV1DaxConfig$.MODULE$.fromConfig((Config)Ficus$.MODULE$.toFicusConfig(config).getAs(this.v1DaxKey(), Ficus$.MODULE$.optionValueReader(Ficus$.MODULE$.configValueReader())).getOrElse(this::$anonfun$2), !(value4 != null ? !value4.equals(value5) : value5 != null));
        if (legacyConfigFormat) {
            this.logger().warn(new StringBuilder(282).append("<<<!!!CAUTION: PLEASE MIGRATE TO NEW CONFIG FORMAT!!!>>>\n\tThe configuration items of AWS-SDK V2 client remain with the old key names: (j5ik2o.dynamo-db-journal.dynamo-db-client).\n\tPlease change current key name to the new key name: (j5ik2o.dynamo-db-journal.dynamo-db-client.v2). \n\t").append(((MapOps)DynamoDBClientV2Config$.MODULE$.existsKeyNames(config).filter((Function1 & Serializable)_$1 -> BoxesRunTime.unboxToBoolean((Object)_$1._2()))).keys().mkString("child-keys = [ ", ", ", " ]")).toString());
            Enumeration.Value value6 = clientVersion;
            Enumeration.Value value7 = ClientVersion$.MODULE$.V2();
            dynamoDBClientV2Config = DynamoDBClientV2Config$.MODULE$.fromConfig(config, !(value6 != null ? !value6.equals(value7) : value7 != null), legacyConfigFormat);
        } else {
            Enumeration.Value value8 = clientVersion;
            Enumeration.Value value9 = ClientVersion$.MODULE$.V2();
            dynamoDBClientV2Config = DynamoDBClientV2Config$.MODULE$.fromConfig((Config)Ficus$.MODULE$.toFicusConfig(config).getAs(this.v2Key(), Ficus$.MODULE$.optionValueReader(Ficus$.MODULE$.configValueReader())).getOrElse(this::$anonfun$4), !(value8 != null ? !value8.equals(value9) : value9 != null), legacyConfigFormat);
        }
        Enumeration.Value value10 = clientVersion;
        Enumeration.Value value11 = ClientVersion$.MODULE$.V2();
        DynamoDBClientConfig result = this.apply(config, (Option<String>)option, (Option<String>)option2, (Option<String>)option3, (Option<String>)option4, clientVersion, value, dynamoDBClientV1Config, dynamoDBClientV1DaxConfig, dynamoDBClientV2Config, DynamoDBClientV2DaxConfig$.MODULE$.fromConfig((Config)Ficus$.MODULE$.toFicusConfig(config).getAs(this.v2DaxKey(), Ficus$.MODULE$.optionValueReader(Ficus$.MODULE$.configValueReader())).getOrElse(this::$anonfun$5), !(value10 != null ? !value10.equals(value11) : value11 != null)), BoxesRunTime.unboxToInt((Object)Ficus$.MODULE$.toFicusConfig(config).as(this.batchGetItemLimitKey(), Ficus$.MODULE$.intValueReader())), BoxesRunTime.unboxToInt((Object)Ficus$.MODULE$.toFicusConfig(config).as(this.batchWriteItemLimitKey(), Ficus$.MODULE$.intValueReader())));
        this.logger().debug("result = {}", (Object)result);
        return result;
    }

    public DynamoDBClientConfig fromProduct(Product x$0) {
        return new DynamoDBClientConfig((Config)x$0.productElement(0), (Option<String>)((Option)x$0.productElement(1)), (Option<String>)((Option)x$0.productElement(2)), (Option<String>)((Option)x$0.productElement(3)), (Option<String>)((Option)x$0.productElement(4)), (Enumeration.Value)x$0.productElement(5), (Enumeration.Value)x$0.productElement(6), (DynamoDBClientV1Config)x$0.productElement(7), (DynamoDBClientV1DaxConfig)x$0.productElement(8), (DynamoDBClientV2Config)x$0.productElement(9), (DynamoDBClientV2DaxConfig)x$0.productElement(10), BoxesRunTime.unboxToInt((Object)x$0.productElement(11)), BoxesRunTime.unboxToInt((Object)x$0.productElement(12)));
    }

    private final Config $anonfun$1() {
        return ConfigFactory.empty();
    }

    private final Config $anonfun$2() {
        return ConfigFactory.empty();
    }

    private final Config $anonfun$4() {
        return ConfigFactory.empty();
    }

    private final Config $anonfun$5() {
        return ConfigFactory.empty();
    }
}

