/*
 * Decompiled with CFR 0.152.
 */
package com.github.j5ik2o.akka.persistence.dynamodb.utils;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.client.builder.AwsSyncClientBuilder;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClientBuilder;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.CreateTableResult;
import com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndex;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.KeyType;
import com.amazonaws.services.dynamodbv2.model.ListTablesResult;
import com.amazonaws.services.dynamodbv2.model.Projection;
import com.amazonaws.services.dynamodbv2.model.ProjectionType;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.ScalarAttributeType;
import com.amazonaws.services.dynamodbv2.model.StreamSpecification;
import com.amazonaws.services.dynamodbv2.model.StreamViewType;
import com.dimafeng.testcontainers.FixedHostPortGenericContainer;
import com.dimafeng.testcontainers.FixedHostPortGenericContainer$;
import com.github.j5ik2o.akka.persistence.dynamodb.utils.DynamoDBContainerHelper;
import com.github.j5ik2o.akka.persistence.dynamodb.utils.DynamoDBContainerHelper$class$lambda$$createJournalTable$1;
import com.github.j5ik2o.akka.persistence.dynamodb.utils.DynamoDBContainerHelper$class$lambda$$createLegacyJournalTable$1;
import com.github.j5ik2o.akka.persistence.dynamodb.utils.DynamoDBContainerHelper$class$lambda$$createSnapshotTable$1;
import com.github.j5ik2o.akka.persistence.dynamodb.utils.DynamoDBContainerHelper$class$lambda$$deleteJournalTable$1;
import com.github.j5ik2o.akka.persistence.dynamodb.utils.DynamoDBContainerHelper$class$lambda$$deleteJournalTable$2;
import com.github.j5ik2o.akka.persistence.dynamodb.utils.DynamoDBContainerHelper$class$lambda$$deleteSnapshotTable$1;
import com.github.j5ik2o.akka.persistence.dynamodb.utils.DynamoDBContainerHelper$class$lambda$$deleteSnapshotTable$2;
import com.github.j5ik2o.akka.persistence.dynamodb.utils.DynamoDBContainerHelper$class$lambda$$waitDynamoDBLocal$1;
import com.github.j5ik2o.akka.persistence.dynamodb.utils.RandomPortUtil$;
import java.util.Collection;
import org.slf4j.LoggerFactory;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.wait.strategy.HostPortWaitStrategy;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.Map;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class DynamoDBContainerHelper$class {
    public static Regions region(DynamoDBContainerHelper $this) {
        return Regions.AP_NORTHEAST_1;
    }

    public static String accessKeyId(DynamoDBContainerHelper $this) {
        return "x";
    }

    public static String secretAccessKey(DynamoDBContainerHelper $this) {
        return "x";
    }

    public static String dynamoDBHost(DynamoDBContainerHelper $this) {
        return DockerClientFactory.instance().dockerHostIpAddress();
    }

    public static int dynamoDBPort(DynamoDBContainerHelper $this) {
        return RandomPortUtil$.MODULE$.temporaryServerPort(RandomPortUtil$.MODULE$.temporaryServerPort$default$1());
    }

    public static String dynamoDBEndpoint(DynamoDBContainerHelper $this) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"http://", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.dynamoDBHost(), BoxesRunTime.boxToInteger((int)$this.dynamoDBPort())}));
    }

    public static String dynamoDBImageVersion(DynamoDBContainerHelper $this) {
        return "1.13.4";
    }

    public static String dynamoDBImageName(DynamoDBContainerHelper $this) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"amazon/dynamodb-local:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.dynamoDBImageVersion()}));
    }

    public static FixedHostPortGenericContainer dynamoDbLocalContainer(DynamoDBContainerHelper $this) {
        String x$8 = $this.dynamoDBImageName();
        int x$9 = $this.dynamoDBPort();
        int x$10 = 8000;
        Seq x$11 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-Xmx256m", "-jar", "DynamoDBLocal.jar", "-dbPath", ".", "-sharedDb"}));
        HostPortWaitStrategy x$12 = Wait.forListeningPort();
        Seq x$13 = FixedHostPortGenericContainer$.MODULE$.apply$default$2();
        Map x$14 = FixedHostPortGenericContainer$.MODULE$.apply$default$3();
        Seq x$15 = FixedHostPortGenericContainer$.MODULE$.apply$default$5();
        return FixedHostPortGenericContainer$.MODULE$.apply(x$8, x$13, x$14, x$11, x$15, (WaitStrategy)x$12, x$9, x$10);
    }

    public static AmazonDynamoDB dynamoDBClient(DynamoDBContainerHelper $this) {
        return (AmazonDynamoDB)((AwsSyncClientBuilder)AmazonDynamoDBClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials($this.accessKeyId(), $this.secretAccessKey()))).withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration($this.dynamoDBEndpoint(), $this.region().getName()))).build();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public static void waitDynamoDBLocal(DynamoDBContainerHelper $this, Seq tableNames) {
        boolean isWaken = false;
        int counter = 0;
        while (counter < $this.MaxCount()) {
            if (isWaken) return;
            {
                ListTablesResult listTablesResult = $this.dynamoDBClient().listTables(Predef$.MODULE$.int2Integer(2));
                if (tableNames.forall((Function1)new DynamoDBContainerHelper$class$lambda$$waitDynamoDBLocal$1($this, listTablesResult))) {
                    Predef$.MODULE$.println((Object)"finish");
                    isWaken = true;
                    continue;
                }
                Predef$.MODULE$.println((Object)"waiting...");
                Thread.sleep(1000L);
            }
        }
    }

    public static void deleteTable(DynamoDBContainerHelper $this) {
        DynamoDBContainerHelper dynamoDBContainerHelper = $this;
        synchronized (dynamoDBContainerHelper) {
            Thread.sleep(500L);
            DynamoDBContainerHelper$class.deleteJournalTable($this);
            DynamoDBContainerHelper$class.deleteSnapshotTable($this);
            Thread.sleep(500L);
            return;
        }
    }

    public static void createTable(DynamoDBContainerHelper $this) {
        DynamoDBContainerHelper dynamoDBContainerHelper = $this;
        synchronized (dynamoDBContainerHelper) {
            Thread.sleep(500L);
            if ($this.legacyJournalTable()) {
                DynamoDBContainerHelper$class.createLegacyJournalTable($this);
            } else {
                $this.createJournalTable();
            }
            $this.createSnapshotTable();
            $this.waitDynamoDBLocal((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{$this.journalTableName(), $this.snapshotTableName()}))));
            return;
        }
    }

    private static void deleteJournalTable(DynamoDBContainerHelper $this) {
        ListTablesResult listTablesResult = $this.dynamoDBClient().listTables(Predef$.MODULE$.int2Integer(2));
        Object object = ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(listTablesResult.getTableNames()).asScala()).exists((Function1)new DynamoDBContainerHelper$class$lambda$$deleteJournalTable$1($this)) ? $this.dynamoDBClient().deleteTable($this.journalTableName()) : BoxedUnit.UNIT;
        ListTablesResult result = $this.dynamoDBClient().listTables(Predef$.MODULE$.int2Integer(2));
        Predef$.MODULE$.require(!((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(result.getTableNames()).asScala()).exists((Function1)new DynamoDBContainerHelper$class$lambda$$deleteJournalTable$2($this)));
    }

    private static void deleteSnapshotTable(DynamoDBContainerHelper $this) {
        ListTablesResult listTablesResult = $this.dynamoDBClient().listTables(Predef$.MODULE$.int2Integer(2));
        Object object = ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(listTablesResult.getTableNames()).asScala()).exists((Function1)new DynamoDBContainerHelper$class$lambda$$deleteSnapshotTable$1($this)) ? $this.dynamoDBClient().deleteTable($this.snapshotTableName()) : BoxedUnit.UNIT;
        ListTablesResult result = $this.dynamoDBClient().listTables(Predef$.MODULE$.int2Integer(2));
        Predef$.MODULE$.require(!((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(result.getTableNames()).asScala()).exists((Function1)new DynamoDBContainerHelper$class$lambda$$deleteSnapshotTable$2($this)));
    }

    public static void createSnapshotTable(DynamoDBContainerHelper $this) {
        ListTablesResult listTablesResult = $this.dynamoDBClient().listTables(Predef$.MODULE$.int2Integer(2));
        if (!((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(listTablesResult.getTableNames()).asScala()).exists((Function1)new DynamoDBContainerHelper$class$lambda$$createSnapshotTable$1($this))) {
            CreateTableRequest createRequest = new CreateTableRequest().withTableName($this.snapshotTableName()).withAttributeDefinitions((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeDefinition[]{new AttributeDefinition().withAttributeName("persistence-id").withAttributeType(ScalarAttributeType.S), new AttributeDefinition().withAttributeName("sequence-nr").withAttributeType(ScalarAttributeType.N)}))).asJava()).withKeySchema((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeySchemaElement[]{new KeySchemaElement().withAttributeName("persistence-id").withKeyType(KeyType.HASH), new KeySchemaElement().withAttributeName("sequence-nr").withKeyType(KeyType.RANGE)}))).asJava()).withProvisionedThroughput(new ProvisionedThroughput().withReadCapacityUnits(Predef$.MODULE$.long2Long(10L)).withWriteCapacityUnits(Predef$.MODULE$.long2Long(10L)));
            CreateTableResult createResponse = $this.dynamoDBClient().createTable(createRequest);
            Predef$.MODULE$.require(createResponse.getSdkHttpMetadata().getHttpStatusCode() == 200);
        }
    }

    private static void createLegacyJournalTable(DynamoDBContainerHelper $this) {
        ListTablesResult listTablesResult = $this.dynamoDBClient().listTables(Predef$.MODULE$.int2Integer(2));
        if (!((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(listTablesResult.getTableNames()).asScala()).exists((Function1)new DynamoDBContainerHelper$class$lambda$$createLegacyJournalTable$1($this))) {
            CreateTableRequest createRequest = new CreateTableRequest().withTableName($this.journalTableName()).withAttributeDefinitions((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeDefinition[]{new AttributeDefinition().withAttributeName("pkey").withAttributeType(ScalarAttributeType.S), new AttributeDefinition().withAttributeName("persistence-id").withAttributeType(ScalarAttributeType.S), new AttributeDefinition().withAttributeName("sequence-nr").withAttributeType(ScalarAttributeType.N), new AttributeDefinition().withAttributeName("tags").withAttributeType(ScalarAttributeType.S)}))).asJava()).withKeySchema((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeySchemaElement[]{new KeySchemaElement().withAttributeName("pkey").withKeyType(KeyType.HASH), new KeySchemaElement().withAttributeName("sequence-nr").withKeyType(KeyType.RANGE)}))).asJava()).withProvisionedThroughput(new ProvisionedThroughput().withReadCapacityUnits(Predef$.MODULE$.long2Long(10L)).withWriteCapacityUnits(Predef$.MODULE$.long2Long(10L))).withGlobalSecondaryIndexes((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GlobalSecondaryIndex[]{new GlobalSecondaryIndex().withIndexName("TagsIndex").withKeySchema((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeySchemaElement[]{new KeySchemaElement().withAttributeName("tags").withKeyType(KeyType.HASH)}))).asJava()).withProjection(new Projection().withProjectionType(ProjectionType.ALL)).withProvisionedThroughput(new ProvisionedThroughput().withReadCapacityUnits(Predef$.MODULE$.long2Long(10L)).withWriteCapacityUnits(Predef$.MODULE$.long2Long(10L))), new GlobalSecondaryIndex().withIndexName("GetJournalRowsIndex").withKeySchema((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeySchemaElement[]{new KeySchemaElement().withAttributeName("persistence-id").withKeyType(KeyType.HASH), new KeySchemaElement().withAttributeName("sequence-nr").withKeyType(KeyType.RANGE)}))).asJava()).withProjection(new Projection().withProjectionType(ProjectionType.ALL)).withProvisionedThroughput(new ProvisionedThroughput().withReadCapacityUnits(Predef$.MODULE$.long2Long(10L)).withWriteCapacityUnits(Predef$.MODULE$.long2Long(10L)))}))).asJava()).withStreamSpecification(new StreamSpecification().withStreamEnabled(Predef$.MODULE$.boolean2Boolean(true)).withStreamViewType(StreamViewType.NEW_IMAGE));
            CreateTableResult createResponse = $this.dynamoDBClient().createTable(createRequest);
            Predef$.MODULE$.require(createResponse.getSdkHttpMetadata().getHttpStatusCode() == 200);
        }
    }

    public static void createJournalTable(DynamoDBContainerHelper $this) {
        ListTablesResult listTablesResult = $this.dynamoDBClient().listTables(Predef$.MODULE$.int2Integer(2));
        if (!((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(listTablesResult.getTableNames()).asScala()).exists((Function1)new DynamoDBContainerHelper$class$lambda$$createJournalTable$1($this))) {
            CreateTableRequest createRequest = new CreateTableRequest().withTableName($this.journalTableName()).withAttributeDefinitions((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeDefinition[]{new AttributeDefinition().withAttributeName("pkey").withAttributeType(ScalarAttributeType.S), new AttributeDefinition().withAttributeName("skey").withAttributeType(ScalarAttributeType.S), new AttributeDefinition().withAttributeName("persistence-id").withAttributeType(ScalarAttributeType.S), new AttributeDefinition().withAttributeName("sequence-nr").withAttributeType(ScalarAttributeType.N), new AttributeDefinition().withAttributeName("tags").withAttributeType(ScalarAttributeType.S)}))).asJava()).withKeySchema((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeySchemaElement[]{new KeySchemaElement().withAttributeName("pkey").withKeyType(KeyType.HASH), new KeySchemaElement().withAttributeName("skey").withKeyType(KeyType.RANGE)}))).asJava()).withProvisionedThroughput(new ProvisionedThroughput().withReadCapacityUnits(Predef$.MODULE$.long2Long(10L)).withWriteCapacityUnits(Predef$.MODULE$.long2Long(10L))).withGlobalSecondaryIndexes((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GlobalSecondaryIndex[]{new GlobalSecondaryIndex().withIndexName("TagsIndex").withKeySchema((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeySchemaElement[]{new KeySchemaElement().withAttributeName("tags").withKeyType(KeyType.HASH)}))).asJava()).withProjection(new Projection().withProjectionType(ProjectionType.ALL)).withProvisionedThroughput(new ProvisionedThroughput().withReadCapacityUnits(Predef$.MODULE$.long2Long(10L)).withWriteCapacityUnits(Predef$.MODULE$.long2Long(10L))), new GlobalSecondaryIndex().withIndexName("GetJournalRowsIndex").withKeySchema((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeySchemaElement[]{new KeySchemaElement().withAttributeName("persistence-id").withKeyType(KeyType.HASH), new KeySchemaElement().withAttributeName("sequence-nr").withKeyType(KeyType.RANGE)}))).asJava()).withProjection(new Projection().withProjectionType(ProjectionType.ALL)).withProvisionedThroughput(new ProvisionedThroughput().withReadCapacityUnits(Predef$.MODULE$.long2Long(10L)).withWriteCapacityUnits(Predef$.MODULE$.long2Long(10L)))}))).asJava()).withStreamSpecification(new StreamSpecification().withStreamEnabled(Predef$.MODULE$.boolean2Boolean(true)).withStreamViewType(StreamViewType.NEW_IMAGE));
            CreateTableResult createResponse = $this.dynamoDBClient().createTable(createRequest);
            Predef$.MODULE$.require(createResponse.getSdkHttpMetadata().getHttpStatusCode() == 200);
        }
    }

    public static final /* synthetic */ boolean com$github$j5ik2o$akka$persistence$dynamodb$utils$DynamoDBContainerHelper$class$$$anonfun$1(DynamoDBContainerHelper $this, ListTablesResult listTablesResult$1, String s) {
        return ((SeqLike)CollectionConverters$.MODULE$.asScalaBufferConverter(listTablesResult$1.getTableNames()).asScala()).contains((Object)s);
    }

    public static final /* synthetic */ boolean com$github$j5ik2o$akka$persistence$dynamodb$utils$DynamoDBContainerHelper$class$$$anonfun$2(DynamoDBContainerHelper $this, String x$1) {
        return x$1.contains($this.journalTableName());
    }

    public static final /* synthetic */ boolean com$github$j5ik2o$akka$persistence$dynamodb$utils$DynamoDBContainerHelper$class$$$anonfun$3(DynamoDBContainerHelper $this, String x$2) {
        return x$2.contains($this.journalTableName());
    }

    public static final /* synthetic */ boolean com$github$j5ik2o$akka$persistence$dynamodb$utils$DynamoDBContainerHelper$class$$$anonfun$4(DynamoDBContainerHelper $this, String x$3) {
        return x$3.contains($this.snapshotTableName());
    }

    public static final /* synthetic */ boolean com$github$j5ik2o$akka$persistence$dynamodb$utils$DynamoDBContainerHelper$class$$$anonfun$5(DynamoDBContainerHelper $this, String x$4) {
        return x$4.contains($this.snapshotTableName());
    }

    public static final /* synthetic */ boolean com$github$j5ik2o$akka$persistence$dynamodb$utils$DynamoDBContainerHelper$class$$$anonfun$6(DynamoDBContainerHelper $this, String x$5) {
        return x$5.contains($this.snapshotTableName());
    }

    public static final /* synthetic */ boolean com$github$j5ik2o$akka$persistence$dynamodb$utils$DynamoDBContainerHelper$class$$$anonfun$7(DynamoDBContainerHelper $this, String x$6) {
        return x$6.contains($this.journalTableName());
    }

    public static final /* synthetic */ boolean com$github$j5ik2o$akka$persistence$dynamodb$utils$DynamoDBContainerHelper$class$$$anonfun$8(DynamoDBContainerHelper $this, String x$7) {
        return x$7.contains($this.journalTableName());
    }

    public static void $init$(DynamoDBContainerHelper $this) {
        LoggerFactory.getLogger($this.getClass());
        $this.com$github$j5ik2o$akka$persistence$dynamodb$utils$DynamoDBContainerHelper$_setter_$journalTableName_$eq("Journal");
        $this.com$github$j5ik2o$akka$persistence$dynamodb$utils$DynamoDBContainerHelper$_setter_$snapshotTableName_$eq("Snapshot");
        $this.com$github$j5ik2o$akka$persistence$dynamodb$utils$DynamoDBContainerHelper$_setter_$waitIntervalForDynamoDBLocal_$eq(new package.DurationInt(package$.MODULE$.DurationInt(500)).milliseconds());
        $this.com$github$j5ik2o$akka$persistence$dynamodb$utils$DynamoDBContainerHelper$_setter_$MaxCount_$eq(10);
        $this.com$github$j5ik2o$akka$persistence$dynamodb$utils$DynamoDBContainerHelper$_setter_$legacyJournalTable_$eq(false);
    }
}

