/*
 * Decompiled with CFR 0.152.
 */
package com.github.j5ik2o.akka.persistence.dynamodb.state;

import com.github.j5ik2o.akka.persistence.dynamodb.model.PersistenceId;
import com.github.j5ik2o.akka.persistence.dynamodb.model.PersistenceId$;
import com.github.j5ik2o.akka.persistence.dynamodb.state.PartitionKey;
import com.github.j5ik2o.akka.persistence.dynamodb.state.PersistenceIdOps;
import com.github.j5ik2o.akka.persistence.dynamodb.state.StatePluginContext;
import com.github.j5ik2o.akka.persistence.dynamodb.state.ToPersistenceIdOps;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.text.DecimalFormat;
import net.ceedubs.ficus.Ficus$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005E3qAC\u0006\u0011\u0002G\u0005!\u0004C\u0003\"\u0001\u0019\u0005!eB\u00030\u0017!\u0005\u0001GB\u0003\u000b\u0017!\u0005\u0011\u0007C\u00033\u0007\u0011\u00051G\u0002\u00035\u0007\t)\u0004\u0002\u0003\u001e\u0006\u0005\u0003\u0005\u000b\u0011B\u001e\t\u000bI*A\u0011\u0001 \t\u000b\t+A\u0011I\"\t\u000b\u0005*A\u0011I(\u0003)A\u000b'\u000f^5uS>t7*Z=SKN|GN^3s\u0015\taQ\"A\u0003ti\u0006$XM\u0003\u0002\u000f\u001f\u0005AA-\u001f8b[>$'M\u0003\u0002\u0011#\u0005Y\u0001/\u001a:tSN$XM\\2f\u0015\t\u00112#\u0001\u0003bW.\f'B\u0001\u000b\u0016\u0003\u0019QW'[63_*\u0011acF\u0001\u0007O&$\b.\u001e2\u000b\u0003a\t1aY8n\u0007\u0001\u0019\"\u0001A\u000e\u0011\u0005qyR\"A\u000f\u000b\u0003y\tQa]2bY\u0006L!\u0001I\u000f\u0003\r\u0005s\u0017PU3g\u0003\u001d\u0011Xm]8mm\u0016$\"aI\u0014\u0011\u0005\u0011*S\"A\u0006\n\u0005\u0019Z!\u0001\u0004)beRLG/[8o\u0017\u0016L\b\"\u0002\u0015\u0002\u0001\u0004I\u0013!\u00049feNL7\u000f^3oG\u0016LE\r\u0005\u0002+[5\t1F\u0003\u0002-\u001b\u0005)Qn\u001c3fY&\u0011af\u000b\u0002\u000e!\u0016\u00148/[:uK:\u001cW-\u00133\u0002)A\u000b'\u000f^5uS>t7*Z=SKN|GN^3s!\t!3a\u0005\u0002\u00047\u00051A(\u001b8jiz\"\u0012\u0001\r\u0002\u0013!\u0016\u00148/[:uK:\u001cW-\u00133CCN,Gm\u0005\u0003\u00067Y:\u0004C\u0001\u0013\u0001!\t!\u0003(\u0003\u0002:\u0017\t\u0011Bk\u001c)feNL7\u000f^3oG\u0016LEm\u00149t\u00035\u0001H.^4j]\u000e{g\u000e^3yiB\u0011A\u0005P\u0005\u0003{-\u0011!c\u0015;bi\u0016\u0004F.^4j]\u000e{g\u000e^3yiR\u0011q(\u0011\t\u0003\u0001\u0016i\u0011a\u0001\u0005\u0006u\u001d\u0001\raO\u0001\ng\u0016\u0004\u0018M]1u_J,\u0012\u0001\u0012\t\u0003\u000b2s!A\u0012&\u0011\u0005\u001dkR\"\u0001%\u000b\u0005%K\u0012A\u0002\u001fs_>$h(\u0003\u0002L;\u00051\u0001K]3eK\u001aL!!\u0014(\u0003\rM#(/\u001b8h\u0015\tYU\u0004\u0006\u0002$!\")\u0001&\u0003a\u0001S\u0001")
public interface PartitionKeyResolver {
    public PartitionKey resolve(PersistenceId var1);

    public static final class PersistenceIdBased
    implements PartitionKeyResolver,
    ToPersistenceIdOps {
        private final StatePluginContext pluginContext;

        @Override
        public PersistenceIdOps ToPersistenceIdOps(PersistenceId self) {
            return ToPersistenceIdOps.ToPersistenceIdOps$(this, self);
        }

        @Override
        public String separator() {
            return (String)Ficus$.MODULE$.toFicusConfig(this.pluginContext.pluginConfig().sourceConfig()).getAs("persistence-id-separator", Ficus$.MODULE$.optionValueReader(Ficus$.MODULE$.stringValueReader())).getOrElse((Function0 & Serializable)() -> PersistenceId$.MODULE$.Separator());
        }

        @Override
        public PartitionKey resolve(PersistenceId persistenceId) {
            String string;
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            DecimalFormat df = new DecimalFormat("0000000000000000000000000000000000000000");
            byte[] bytes = StringOps$.MODULE$.reverse$extension(Predef$.MODULE$.augmentString(persistenceId.asString())).getBytes(StandardCharsets.UTF_8);
            BigInt hash = package$.MODULE$.BigInt().apply(md5.digest(bytes));
            BigInt mod = hash.abs().$percent(BigInt$.MODULE$.int2bigInt(this.pluginContext.pluginConfig().shardCount())).$plus(BigInt$.MODULE$.int2bigInt(1));
            Option<String> modelNameOpt = this.ToPersistenceIdOps(persistenceId).prefix();
            Option<String> option = modelNameOpt;
            if (option instanceof Some) {
                Some some = (Some)option;
                String modelName = (String)some.value();
                string = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s-%s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{modelName, df.format(mod)}));
            } else if (None$.MODULE$.equals(option)) {
                string = df.format(mod);
            } else {
                throw new MatchError(option);
            }
            String pkey = string;
            return new PartitionKey(pkey);
        }

        public PersistenceIdBased(StatePluginContext pluginContext) {
            this.pluginContext = pluginContext;
            ToPersistenceIdOps.$init$(this);
        }
    }
}

