/*
 * Decompiled with CFR 0.152.
 */
package com.github.j5ik2o.akka.persistence.dynamodb.state;

import akka.serialization.AsyncSerializer;
import akka.serialization.Serialization;
import akka.serialization.Serializer;
import akka.serialization.Serializers$;
import com.github.j5ik2o.akka.persistence.dynamodb.metrics.MetricsReporter;
import com.github.j5ik2o.akka.persistence.dynamodb.model.Context;
import com.github.j5ik2o.akka.persistence.dynamodb.model.Context$;
import com.github.j5ik2o.akka.persistence.dynamodb.model.PersistenceId;
import com.github.j5ik2o.akka.persistence.dynamodb.model.PersistenceId$;
import com.github.j5ik2o.akka.persistence.dynamodb.state.AkkaSerialized;
import com.github.j5ik2o.akka.persistence.dynamodb.trace.TraceReporter;
import java.io.Serializable;
import java.util.UUID;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001da\u0001\u0002\u0006\f\u0005iA\u0001\"\t\u0001\u0003\u0002\u0003\u0006IA\t\u0005\tQ\u0001\u0011\t\u0011)A\u0005S!A!\u0007\u0001B\u0001B\u0003%1\u0007C\u0003;\u0001\u0011\u00051\bC\u0003B\u0001\u0011\u0005!\tC\u0003e\u0001\u0011\u0005Q\rC\u0003m\u0001\u0011%Q\u000eC\u0003t\u0001\u0011%A\u000f\u0003\u0004\u0000\u0001\u0011%\u0011\u0011\u0001\u0002\u0010'R\fG/Z*fe&\fG.\u001b>fe*\u0011A\"D\u0001\u0006gR\fG/\u001a\u0006\u0003\u001d=\t\u0001\u0002Z=oC6|GM\u0019\u0006\u0003!E\t1\u0002]3sg&\u001cH/\u001a8dK*\u0011!cE\u0001\u0005C.\\\u0017M\u0003\u0002\u0015+\u00051!.N5le=T!AF\f\u0002\r\u001dLG\u000f[;c\u0015\u0005A\u0012aA2p[\u000e\u00011C\u0001\u0001\u001c!\tar$D\u0001\u001e\u0015\u0005q\u0012!B:dC2\f\u0017B\u0001\u0011\u001e\u0005\u0019\te.\u001f*fM\u0006i1/\u001a:jC2L'0\u0019;j_:\u0004\"a\t\u0014\u000e\u0003\u0011R!!I\u0013\u000b\u0003II!a\n\u0013\u0003\u001bM+'/[1mSj\fG/[8o\u0003=iW\r\u001e:jGN\u0014V\r]8si\u0016\u0014\bc\u0001\u000f+Y%\u00111&\b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u00055\u0002T\"\u0001\u0018\u000b\u0005=j\u0011aB7fiJL7m]\u0005\u0003c9\u0012q\"T3ue&\u001c7OU3q_J$XM]\u0001\u000eiJ\f7-\u001a*fa>\u0014H/\u001a:\u0011\u0007qQC\u0007\u0005\u00026q5\taG\u0003\u00028\u001b\u0005)AO]1dK&\u0011\u0011H\u000e\u0002\u000e)J\f7-\u001a*fa>\u0014H/\u001a:\u0002\rqJg.\u001b;?)\u0011adh\u0010!\u0011\u0005u\u0002Q\"A\u0006\t\u000b\u0005\"\u0001\u0019\u0001\u0012\t\u000b!\"\u0001\u0019A\u0015\t\u000bI\"\u0001\u0019A\u001a\u0002\u0013M,'/[1mSj,GcA\"S?R\u0011A)\u0014\t\u0004\u000b\"SU\"\u0001$\u000b\u0005\u001dk\u0012AC2p]\u000e,(O]3oi&\u0011\u0011J\u0012\u0002\u0007\rV$XO]3\u0011\u0005uZ\u0015B\u0001'\f\u00059\t5n[1TKJL\u0017\r\\5{K\u0012DQAT\u0003A\u0004=\u000b!!Z2\u0011\u0005\u0015\u0003\u0016BA)G\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH\u000fC\u0003T\u000b\u0001\u0007A+A\u0007qKJ\u001c\u0018n\u001d;f]\u000e,\u0017\n\u001a\t\u0003+rs!A\u0016.\u0011\u0005]kR\"\u0001-\u000b\u0005eK\u0012A\u0002\u001fs_>$h(\u0003\u0002\\;\u00051\u0001K]3eK\u001aL!!\u00180\u0003\rM#(/\u001b8h\u0015\tYV\u0004C\u0003a\u000b\u0001\u0007\u0011-A\u0004qCfdw.\u00193\u0011\u0005q\u0011\u0017BA2\u001e\u0005\r\te._\u0001\fI\u0016\u001cXM]5bY&TX\rF\u0002gS*$\"a\u001a5\u0011\u0007\u0015C5\u0004C\u0003O\r\u0001\u000fq\nC\u0003T\r\u0001\u0007A\u000bC\u0003l\r\u0001\u0007!*\u0001\u0006tKJL\u0017\r\\5{K\u0012\fqb]3sS\u0006d\u0017N_3s\u0003NLhn\u0019\u000b\u0003]J\u00042!\u0012%p!\t\u0019\u0003/\u0003\u0002rI\tQ1+\u001a:jC2L'0\u001a:\t\u000b\u0001<\u0001\u0019A\u000e\u0002\u001bQ|')\u001b8bef\f5/\u001f8d)\r)HP \t\u0004\u000b\"3\bc\u0001\u000fxs&\u0011\u00010\b\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u00039iL!a_\u000f\u0003\t\tKH/\u001a\u0005\u0006{\"\u0001\ra\\\u0001\u000bg\u0016\u0014\u0018.\u00197ju\u0016\u0014\b\"\u00021\t\u0001\u0004Y\u0012a\u00044s_6\u0014\u0015N\\1ss\u0006\u001b\u0018P\\2\u0015\u000b\u001d\f\u0019!!\u0002\t\u000buL\u0001\u0019A8\t\u000b-L\u0001\u0019\u0001&")
public final class StateSerializer {
    private final Serialization serialization;
    private final Option<MetricsReporter> metricsReporter;
    private final Option<TraceReporter> traceReporter;

    public Future<AkkaSerialized> serialize(String persistenceId, Object payload, ExecutionContext ec) {
        PersistenceId pid = PersistenceId$.MODULE$.apply(persistenceId);
        Context context = Context$.MODULE$.newContext(UUID.randomUUID(), pid, Context$.MODULE$.newContext$default$3());
        Context newContext = (Context)this.metricsReporter.fold((Function0 & Serializable & scala.Serializable)() -> context, (Function1 & Serializable & scala.Serializable)x$1 -> x$1.beforeStateStoreSerializeState(context));
        Future traced = (Future)this.traceReporter.fold((Function0 & Serializable & scala.Serializable)() -> this.future$1(payload, ec), (Function1 & Serializable & scala.Serializable)x$2 -> x$2.traceStateStoreSerializeState(context, (Function0 & Serializable & scala.Serializable)() -> this.future$1(payload, ec)));
        traced.onComplete((Function1 & Serializable & scala.Serializable)x0$1 -> {
            StateSerializer.$anonfun$serialize$9(this, newContext, x0$1);
            return BoxedUnit.UNIT;
        }, ec);
        return traced;
    }

    public Future<Object> deserialize(String persistenceId, AkkaSerialized serialized, ExecutionContext ec) {
        PersistenceId pid = PersistenceId$.MODULE$.apply(persistenceId);
        Context context = Context$.MODULE$.newContext(UUID.randomUUID(), pid, Context$.MODULE$.newContext$default$3());
        Context newContext = (Context)this.metricsReporter.fold((Function0 & Serializable & scala.Serializable)() -> context, (Function1 & Serializable & scala.Serializable)x$5 -> x$5.beforeStateStoreDeserializeState(context));
        Future traced = (Future)this.traceReporter.fold((Function0 & Serializable & scala.Serializable)() -> this.future$2(serialized, ec), (Function1 & Serializable & scala.Serializable)x$6 -> x$6.traceStateStoreDeserializeState(context, (Function0 & Serializable & scala.Serializable)() -> this.future$2(serialized, ec)));
        traced.onComplete((Function1 & Serializable & scala.Serializable)x0$1 -> {
            StateSerializer.$anonfun$deserialize$8(this, newContext, x0$1);
            return BoxedUnit.UNIT;
        }, ec);
        return traced;
    }

    private Future<Serializer> serializerAsync(Object payload) {
        Future future;
        try {
            future = Future$.MODULE$.successful((Object)this.serialization.findSerializerFor(payload));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable ex = (Throwable)option.get();
                future = Future$.MODULE$.failed(ex);
            }
            throw throwable;
        }
        return future;
    }

    private Future<byte[]> toBinaryAsync(Serializer serializer, Object payload) {
        Serializer serializer2 = serializer;
        if (serializer2 instanceof AsyncSerializer) {
            Serializer serializer3 = serializer2;
            return ((AsyncSerializer)serializer3).toBinaryAsync(payload);
        }
        Try try_ = this.serialization.serialize(payload);
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            byte[] value = (byte[])success.value();
            return Future$.MODULE$.successful((Object)value);
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable ex = failure.exception();
            return Future$.MODULE$.failed(ex);
        }
        throw new MatchError((Object)try_);
    }

    private Future<Object> fromBinaryAsync(Serializer serializer, AkkaSerialized serialized) {
        Future future;
        Serializer serializer2 = serializer;
        if (serializer2 instanceof AsyncSerializer) {
            Serializer serializer3 = serializer2;
            future = ((AsyncSerializer)serializer3).fromBinaryAsync(serialized.payload(), (String)serialized.serializerManifest().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
        } else {
            Try try_ = this.serialization.deserialize(serialized.payload(), serialized.serializerId(), (String)serialized.serializerManifest().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                Object value = success.value();
                future = Future$.MODULE$.successful(value);
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable ex = failure.exception();
                future = Future$.MODULE$.failed(ex);
            } else {
                throw new MatchError((Object)try_);
            }
        }
        Future future2 = future;
        return future2;
    }

    private final Future future$1(Object payload$1, ExecutionContext ec$1) {
        Object p2 = payload$1;
        return this.serializerAsync(p2).flatMap((Function1 & Serializable & scala.Serializable)serializer -> Future$.MODULE$.successful((Object)Serializers$.MODULE$.manifestFor(serializer, p2)).flatMap((Function1 & Serializable & scala.Serializable)serializerManifest -> this.toBinaryAsync((Serializer)serializer, p2).map((Function1 & Serializable & scala.Serializable)payload -> new AkkaSerialized(serializer.identifier(), (Option<String>)(serializerManifest.isEmpty() ? None$.MODULE$ : new Some(serializerManifest)), (byte[])payload), ec$1), ec$1), ec$1);
    }

    public static final /* synthetic */ void $anonfun$serialize$9(StateSerializer $this, Context newContext$1, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Success) {
            $this.metricsReporter.foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                x$3.afterStateStoreSerializeState(newContext$1);
                return BoxedUnit.UNIT;
            });
            return;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable ex = failure.exception();
            $this.metricsReporter.foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                x$4.errorStateStoreSerializeState(newContext$1, ex);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)try_);
    }

    private final Future future$2(AkkaSerialized serialized$1, ExecutionContext ec$2) {
        return this.serializerAsync(serialized$1.payload()).flatMap((Function1 & Serializable & scala.Serializable)serializer -> this.fromBinaryAsync((Serializer)serializer, serialized$1).map((Function1 & Serializable & scala.Serializable)result -> result, ec$2), ec$2);
    }

    public static final /* synthetic */ void $anonfun$deserialize$8(StateSerializer $this, Context newContext$2, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Success) {
            $this.metricsReporter.foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
                x$7.afterStateStoreDeserializeState(newContext$2);
                return BoxedUnit.UNIT;
            });
            return;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable ex = failure.exception();
            $this.metricsReporter.foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
                x$8.errorStateStoreDeserializeState(newContext$2, ex);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)try_);
    }

    public StateSerializer(Serialization serialization, Option<MetricsReporter> metricsReporter, Option<TraceReporter> traceReporter) {
        this.serialization = serialization;
        this.metricsReporter = metricsReporter;
        this.traceReporter = traceReporter;
    }
}

