/*
 * Decompiled with CFR 0.152.
 */
package com.github.j5ik2o.akka.persistence.dynamodb.state;

import akka.actor.ActorSystem;
import akka.actor.ExtendedActorSystem;
import akka.annotation.ApiMayChange;
import akka.event.LoggingAdapter;
import akka.persistence.state.DurableStateStoreProvider;
import akka.persistence.state.scaladsl.DurableStateUpdateStore;
import akka.stream.Materializer;
import akka.stream.SystemMaterializer;
import akka.stream.SystemMaterializer$;
import com.github.j5ik2o.akka.persistence.dynamodb.config.client.ClientVersion$;
import com.github.j5ik2o.akka.persistence.dynamodb.state.DynamoDBDurableStateStoreProvider$;
import com.github.j5ik2o.akka.persistence.dynamodb.state.StateDynamicAccessor$;
import com.github.j5ik2o.akka.persistence.dynamodb.state.StatePluginContext;
import com.github.j5ik2o.akka.persistence.dynamodb.state.config.StatePluginConfig;
import com.github.j5ik2o.akka.persistence.dynamodb.state.config.StatePluginConfig$;
import com.github.j5ik2o.akka.persistence.dynamodb.state.javadsl.JavaDynamoDBDurableStateStore;
import com.github.j5ik2o.akka.persistence.dynamodb.state.scaladsl.ScalaDurableStateUpdateStore;
import com.github.j5ik2o.akka.persistence.dynamodb.state.scaladsl.ScalaDurableStateUpdateStoreFactory;
import com.typesafe.config.Config;
import java.util.UUID;
import scala.Enumeration;
import scala.MatchError;
import scala.concurrent.ExecutionContext;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005=t!B\r\u001b\u0011\u0003Ic!B\u0016\u001b\u0011\u0003a\u0003\"B\u001a\u0002\t\u0003!\u0004bB\u001b\u0002\u0005\u0004%\tA\u000e\u0005\u0007\u007f\u0005\u0001\u000b\u0011B\u001c\u0007\t-R\"\u0001\u0011\u0005\t\u0011\u0016\u0011\t\u0011)A\u0005\u0013\")1'\u0002C\u0001\u001f\"9!+\u0002b\u0001\n\u0007\u0019\u0006B\u0002.\u0006A\u0003%A\u000bC\u0004\\\u000b\t\u0007I1\u0001/\t\r\r,\u0001\u0015!\u0003^\u0011\u001d!WA1A\u0005\n\u0015Da\u0001\\\u0003!\u0002\u00131\u0007bB7\u0006\u0005\u0004%IA\u001c\u0005\u0007m\u0016\u0001\u000b\u0011B8\t\u000f],!\u0019!C\u0005q\"1a0\u0002Q\u0001\neD\u0001b`\u0003C\u0002\u0013%\u0011\u0011\u0001\u0005\t\u0003\u0013)\u0001\u0015!\u0003\u0002\u0004!I\u00111B\u0003C\u0002\u0013\r\u0011Q\u0002\u0005\t\u00037)\u0001\u0015!\u0003\u0002\u0010!9\u0011QD\u0003\u0005\n\u0005}\u0001bBA#\u000b\u0011\u0005\u0013q\t\u0005\b\u0003'*A\u0011IA+\u0003\u0005\"\u0015P\\1n_\u0012\u0013E)\u001e:bE2,7\u000b^1uKN#xN]3Qe>4\u0018\u000eZ3s\u0015\tYB$A\u0003ti\u0006$XM\u0003\u0002\u001e=\u0005AA-\u001f8b[>$'M\u0003\u0002 A\u0005Y\u0001/\u001a:tSN$XM\\2f\u0015\t\t#%\u0001\u0003bW.\f'BA\u0012%\u0003\u0019QW'[63_*\u0011QEJ\u0001\u0007O&$\b.\u001e2\u000b\u0003\u001d\n1aY8n\u0007\u0001\u0001\"AK\u0001\u000e\u0003i\u0011\u0011\u0005R=oC6|GI\u0011#ve\u0006\u0014G.Z*uCR,7\u000b^8sKB\u0013xN^5eKJ\u001c\"!A\u0017\u0011\u00059\nT\"A\u0018\u000b\u0003A\nQa]2bY\u0006L!AM\u0018\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0011&\u0001\u0006JI\u0016tG/\u001b4jKJ,\u0012a\u000e\t\u0003quj\u0011!\u000f\u0006\u0003um\nA\u0001\\1oO*\tA(\u0001\u0003kCZ\f\u0017B\u0001 :\u0005\u0019\u0019FO]5oO\u0006Y\u0011\nZ3oi&4\u0017.\u001a:!'\r)Q&\u0011\t\u0003\u0005\u001ak\u0011a\u0011\u0006\u00037\u0011S!aH#\u000b\u0003\u0005J!aR\"\u00033\u0011+(/\u00192mKN#\u0018\r^3Ti>\u0014X\r\u0015:pm&$WM]\u0001\u0007gf\u001cH/Z7\u0011\u0005)kU\"A&\u000b\u00051+\u0015!B1di>\u0014\u0018B\u0001(L\u0005M)\u0005\u0010^3oI\u0016$\u0017i\u0019;peNK8\u000f^3n)\t\u0001\u0016\u000b\u0005\u0002+\u000b!)\u0001j\u0002a\u0001\u0013\u0006\u0019Q.\u0019;\u0016\u0003Q\u0003\"!\u0016-\u000e\u0003YS!aV#\u0002\rM$(/Z1n\u0013\tIfK\u0001\u0007NCR,'/[1mSj,'/\u0001\u0003nCR\u0004\u0013\u0001B0m_\u001e,\u0012!\u0018\t\u0003=\u0006l\u0011a\u0018\u0006\u0003A\u0016\u000bQ!\u001a<f]RL!AY0\u0003\u001d1{wmZ5oO\u0006#\u0017\r\u001d;fe\u0006)q\f\\8hA\u0005\u0011\u0011\u000eZ\u000b\u0002MB\u0011qM[\u0007\u0002Q*\u0011\u0011nO\u0001\u0005kRLG.\u0003\u0002lQ\n!Q+V%E\u0003\rIG\rI\u0001\u0007G>tg-[4\u0016\u0003=\u0004\"\u0001\u001d;\u000e\u0003ET!!\u001c:\u000b\u0005M4\u0013\u0001\u0003;za\u0016\u001c\u0018MZ3\n\u0005U\f(AB\"p]\u001aLw-A\u0004d_:4\u0017n\u001a\u0011\u0002#M$\u0018\r^3QYV<\u0017N\\\"p]\u001aLw-F\u0001z!\tQH0D\u0001|\u0015\ti'$\u0003\u0002~w\n\t2\u000b^1uKBcWoZ5o\u0007>tg-[4\u0002%M$\u0018\r^3QYV<\u0017N\\\"p]\u001aLw\rI\u0001\u0013gR\fG/\u001a)mk\u001eLgnQ8oi\u0016DH/\u0006\u0002\u0002\u0004A\u0019!&!\u0002\n\u0007\u0005\u001d!D\u0001\nTi\u0006$X\r\u00157vO&t7i\u001c8uKb$\u0018aE:uCR,\u0007\u000b\\;hS:\u001cuN\u001c;fqR\u0004\u0013AA3d+\t\ty\u0001\u0005\u0003\u0002\u0012\u0005]QBAA\n\u0015\r\t)bL\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002BA\r\u0003'\u0011\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0002\u0007\u0015\u001c\u0007%A\u0006de\u0016\fG/Z*u_J,W\u0003BA\u0011\u0003g)\"!a\t\u0011\r\u0005\u0015\u00121FA\u0018\u001b\t\t9CC\u0002\u0002*i\t\u0001b]2bY\u0006$7\u000f\\\u0005\u0005\u0003[\t9C\u0001\u000fTG\u0006d\u0017\rR;sC\ndWm\u0015;bi\u0016,\u0006\u000fZ1uKN#xN]3\u0011\t\u0005E\u00121\u0007\u0007\u0001\t\u001d\t)D\u0006b\u0001\u0003o\u0011\u0011!Q\t\u0005\u0003s\ty\u0004E\u0002/\u0003wI1!!\u00100\u0005\u001dqu\u000e\u001e5j]\u001e\u00042ALA!\u0013\r\t\u0019e\f\u0002\u0004\u0003:L\u0018!G:dC2\fGm\u001d7EkJ\f'\r\\3Ti\u0006$Xm\u0015;pe\u0016$\"!!\u0013\u0011\r\u0005-\u0013qJA \u001b\t\tiEC\u0002\u0002*\rKA!!\u0015\u0002N\t9B)\u001e:bE2,7\u000b^1uKV\u0003H-\u0019;f'R|'/Z\u0001\u0019U\u00064\u0018\rZ:m\tV\u0014\u0018M\u00197f'R\fG/Z*u_J,GCAA,!\u0015\tI&a\u0018.\u001b\t\tYFC\u0002\u0002^\r\u000bqA[1wC\u0012\u001cH.\u0003\u0003\u0002R\u0005m\u0003fA\u0003\u0002dA!\u0011QMA6\u001b\t\t9GC\u0002\u0002j\u0015\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\ti'a\u001a\u0003\u0019\u0005\u0003\u0018.T1z\u0007\"\fgnZ3")
@ApiMayChange
public final class DynamoDBDurableStateStoreProvider
implements DurableStateStoreProvider {
    private final ExtendedActorSystem system;
    private final Materializer mat;
    private final LoggingAdapter _log;
    private final UUID id;
    private final Config config;
    private final StatePluginConfig statePluginConfig;
    private final StatePluginContext statePluginContext;
    private final ExecutionContext ec;

    public static String Identifier() {
        return DynamoDBDurableStateStoreProvider$.MODULE$.Identifier();
    }

    public Materializer mat() {
        return this.mat;
    }

    public LoggingAdapter _log() {
        return this._log;
    }

    private UUID id() {
        return this.id;
    }

    private Config config() {
        return this.config;
    }

    private StatePluginConfig statePluginConfig() {
        return this.statePluginConfig;
    }

    private StatePluginContext statePluginContext() {
        return this.statePluginContext;
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    private <A> ScalaDurableStateUpdateStore<A> createStore() {
        String string;
        Enumeration.Value value = this.statePluginConfig().clientConfig().clientVersion();
        Enumeration.Value value2 = ClientVersion$.MODULE$.V2();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            string = "com.github.j5ik2o.akka.persistence.dynamodb.state.scaladsl.V2ScalaDurableStateUpdateStoreFactory";
        } else {
            Enumeration.Value value4 = ClientVersion$.MODULE$.V2Dax();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                string = "com.github.j5ik2o.akka.persistence.dynamodb.state.scaladsl.V2DaxScalaDurableStateUpdateStoreFactory";
            } else {
                Enumeration.Value value6 = ClientVersion$.MODULE$.V1();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    string = "com.github.j5ik2o.akka.persistence.dynamodb.state.scaladsl.V1ScalaDurableStateUpdateStoreFactory";
                } else {
                    Enumeration.Value value8 = ClientVersion$.MODULE$.V1Dax();
                    Enumeration.Value value9 = value;
                    if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                        string = "com.github.j5ik2o.akka.persistence.dynamodb.state.scaladsl.V1DaxScalaDurableStateUpdateStoreFactory";
                    } else {
                        throw new MatchError((Object)value);
                    }
                }
            }
        }
        String className = string;
        ScalaDurableStateUpdateStoreFactory f = (ScalaDurableStateUpdateStoreFactory)StateDynamicAccessor$.MODULE$.apply(this.statePluginContext(), ClassTag$.MODULE$.apply(ScalaDurableStateUpdateStoreFactory.class)).createThrow(className);
        return f.create();
    }

    public DurableStateUpdateStore<Object> scaladslDurableStateStore() {
        return this.createStore();
    }

    public akka.persistence.state.javadsl.DurableStateUpdateStore<Object> javadslDurableStateStore() {
        ScalaDurableStateUpdateStore store = this.createStore();
        return new JavaDynamoDBDurableStateStore<Object>((ActorSystem)this.system, this.statePluginContext().pluginExecutor(), store);
    }

    public DynamoDBDurableStateStoreProvider(ExtendedActorSystem system) {
        this.system = system;
        this.mat = ((SystemMaterializer)SystemMaterializer$.MODULE$.apply((ActorSystem)system)).materializer();
        this._log = system.log();
        this.id = UUID.randomUUID();
        this._log().debug("dynamodb state store provider: id = {}", (Object)this.id());
        system.dynamicAccess();
        this.config = system.settings().config().getConfig(DynamoDBDurableStateStoreProvider$.MODULE$.Identifier());
        this.statePluginConfig = StatePluginConfig$.MODULE$.fromConfig(this.config());
        this.statePluginContext = new StatePluginContext((ActorSystem)system, this.statePluginConfig());
        this.ec = this.statePluginContext().pluginExecutor();
    }
}

