/*
 * Decompiled with CFR 0.152.
 */
package com.github.j5ik2o.akka.persistence.dynamodb.serialization;

import akka.persistence.SnapshotMetadata;
import akka.persistence.SnapshotMetadata$;
import akka.persistence.serialization.Snapshot;
import akka.serialization.Serialization;
import com.github.j5ik2o.akka.persistence.dynamodb.metrics.Context;
import com.github.j5ik2o.akka.persistence.dynamodb.metrics.MetricsReporter;
import com.github.j5ik2o.akka.persistence.dynamodb.metrics.MetricsReporter$;
import com.github.j5ik2o.akka.persistence.dynamodb.model.PersistenceId;
import com.github.j5ik2o.akka.persistence.dynamodb.model.PersistenceId$;
import com.github.j5ik2o.akka.persistence.dynamodb.model.SequenceNumber;
import com.github.j5ik2o.akka.persistence.dynamodb.serialization.SnapshotSerializer;
import com.github.j5ik2o.akka.persistence.dynamodb.snapshot.dao.SnapshotRow;
import java.io.Serializable;
import java.util.UUID;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\t4AAB\u0004\u0001-!A\u0001\u0002\u0001B\u0001B\u0003%\u0011\u0006\u0003\u00050\u0001\t\u0005\t\u0015!\u00031\u0011\u0015I\u0004\u0001\"\u0001;\u0011\u0015q\u0004\u0001\"\u0011@\u0011\u0015Q\u0006\u0001\"\u0011\\\u0005m\u0011\u0015\u0010^3BeJ\f\u0017p\u00158baNDw\u000e^*fe&\fG.\u001b>fe*\u0011\u0001\"C\u0001\u000eg\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8\u000b\u0005)Y\u0011\u0001\u00033z]\u0006lw\u000e\u001a2\u000b\u00051i\u0011a\u00039feNL7\u000f^3oG\u0016T!AD\b\u0002\t\u0005\\7.\u0019\u0006\u0003!E\taA[\u001bjWJz'B\u0001\n\u0014\u0003\u00199\u0017\u000e\u001e5vE*\tA#A\u0002d_6\u001c\u0001aE\u0002\u0001/u\u0001\"\u0001G\u000e\u000e\u0003eQ\u0011AG\u0001\u0006g\u000e\fG.Y\u0005\u00039e\u0011a!\u00118z%\u00164\u0007c\u0001\u0010 C5\tq!\u0003\u0002!\u000f\t\u00112K\\1qg\"|GoU3sS\u0006d\u0017N_3s!\t\u0011s%D\u0001$\u0015\t!S%A\u0002eC>T!AJ\u0005\u0002\u0011Mt\u0017\r]:i_RL!\u0001K\u0012\u0003\u0017Ms\u0017\r]:i_R\u0014vn\u001e\t\u0003U5j\u0011a\u000b\u0006\u0003\u00111R\u0011AD\u0005\u0003]-\u0012QbU3sS\u0006d\u0017N_1uS>t\u0017aD7fiJL7m\u001d*fa>\u0014H/\u001a:\u0011\u0007a\t4'\u0003\u000233\t1q\n\u001d;j_:\u0004\"\u0001N\u001c\u000e\u0003UR!AN\u0005\u0002\u000f5,GO]5dg&\u0011\u0001(\u000e\u0002\u0010\u001b\u0016$(/[2t%\u0016\u0004xN\u001d;fe\u00061A(\u001b8jiz\"2a\u000f\u001f>!\tq\u0002\u0001C\u0003\t\u0007\u0001\u0007\u0011\u0006C\u00030\u0007\u0001\u0007\u0001'A\u0005tKJL\u0017\r\\5{KR\u0019\u0001i\u0014,\u0011\t\u0005KE*\t\b\u0003\u0005\u001es!a\u0011$\u000e\u0003\u0011S!!R\u000b\u0002\rq\u0012xn\u001c;?\u0013\u0005Q\u0012B\u0001%\u001a\u0003\u001d\u0001\u0018mY6bO\u0016L!AS&\u0003\r\u0015KG\u000f[3s\u0015\tA\u0015\u0004\u0005\u0002B\u001b&\u0011aj\u0013\u0002\n)\"\u0014xn^1cY\u0016DQ\u0001\u0015\u0003A\u0002E\u000b\u0001\"\\3uC\u0012\fG/\u0019\t\u0003%Rk\u0011a\u0015\u0006\u0003\u00191J!!V*\u0003!Ms\u0017\r]:i_RlU\r^1eCR\f\u0007\"\u0002\u0014\u0005\u0001\u00049\u0006C\u0001\rY\u0013\tI\u0016DA\u0002B]f\f1\u0002Z3tKJL\u0017\r\\5{KR\u0011A\f\u0019\t\u0005\u0003&cU\f\u0005\u0003\u0019=F;\u0016BA0\u001a\u0005\u0019!V\u000f\u001d7fe!)\u0011-\u0002a\u0001C\u0005Y1O\\1qg\"|GOU8x\u0001")
public class ByteArraySnapshotSerializer
implements SnapshotSerializer<SnapshotRow> {
    private final Serialization serialization;
    private final Option<MetricsReporter> metricsReporter;

    @Override
    public Either<Throwable, SnapshotRow> serialize(SnapshotMetadata metadata, Object snapshot) {
        Right right;
        PersistenceId pid = PersistenceId$.MODULE$.apply(metadata.persistenceId());
        Context context = MetricsReporter$.MODULE$.newContext(UUID.randomUUID(), pid, MetricsReporter$.MODULE$.newContext$default$3());
        Context newContext = (Context)this.metricsReporter.fold((Function0 & Serializable & scala.Serializable)() -> context, (Function1 & Serializable & scala.Serializable)x$1 -> x$1.beforeSnapshotStoreSerializeSnapshot(context));
        Try try_ = this.serialization.serialize((Object)new Snapshot(snapshot)).map((Function1 & Serializable & scala.Serializable)x$2 -> new SnapshotRow(PersistenceId$.MODULE$.apply(metadata.persistenceId()), new SequenceNumber(metadata.sequenceNr()), metadata.timestamp(), (byte[])x$2));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            SnapshotRow value = (SnapshotRow)success.value();
            this.metricsReporter.foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                x$3.afterSnapshotStoreSerializeSnapshot(newContext);
                return BoxedUnit.UNIT;
            });
            right = package$.MODULE$.Right().apply((Object)value);
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable ex = failure.exception();
            this.metricsReporter.foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                x$4.errorSnapshotStoreSerializeSnapshot(newContext, ex);
                return BoxedUnit.UNIT;
            });
            right = package$.MODULE$.Left().apply((Object)ex);
        } else {
            throw new MatchError((Object)try_);
        }
        return right;
    }

    @Override
    public Either<Throwable, Tuple2<SnapshotMetadata, Object>> deserialize(SnapshotRow snapshotRow) {
        Right right;
        Context context = MetricsReporter$.MODULE$.newContext(UUID.randomUUID(), snapshotRow.persistenceId(), MetricsReporter$.MODULE$.newContext$default$3());
        Context newContext = (Context)this.metricsReporter.fold((Function0 & Serializable & scala.Serializable)() -> context, (Function1 & Serializable & scala.Serializable)x$5 -> x$5.beforeSnapshotStoreDeserializeSnapshot(context));
        Try try_ = this.serialization.deserialize(snapshotRow.snapshot(), Snapshot.class).map((Function1 & Serializable & scala.Serializable)snapshot -> {
            SnapshotMetadata snapshotMetadata = SnapshotMetadata$.MODULE$.apply(snapshotRow.persistenceId().asString(), snapshotRow.sequenceNumber().value(), snapshotRow.created());
            return new Tuple2((Object)snapshotMetadata, snapshot.data());
        });
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Tuple2 value = (Tuple2)success.value();
            this.metricsReporter.foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
                x$6.afterSnapshotStoreDeserializeSnapshot(newContext);
                return BoxedUnit.UNIT;
            });
            right = package$.MODULE$.Right().apply((Object)value);
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable ex = failure.exception();
            this.metricsReporter.foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
                x$7.errorSnapshotStoreDeserializeSnapshot(newContext, ex);
                return BoxedUnit.UNIT;
            });
            right = package$.MODULE$.Left().apply((Object)ex);
        } else {
            throw new MatchError((Object)try_);
        }
        return right;
    }

    public ByteArraySnapshotSerializer(Serialization serialization, Option<MetricsReporter> metricsReporter) {
        this.serialization = serialization;
        this.metricsReporter = metricsReporter;
    }
}

