/*
 * Decompiled with CFR 0.152.
 */
package com.github.j5ik2o.akka.persistence.dynamodb.snapshot.dao;

import akka.NotUsed;
import akka.actor.ActorSystem;
import akka.persistence.SnapshotMetadata;
import akka.serialization.Serialization;
import akka.stream.Graph;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import com.github.j5ik2o.akka.persistence.dynamodb.client.v2.StreamReadClient;
import com.github.j5ik2o.akka.persistence.dynamodb.client.v2.StreamWriteClient;
import com.github.j5ik2o.akka.persistence.dynamodb.config.PluginConfig;
import com.github.j5ik2o.akka.persistence.dynamodb.config.SnapshotPluginConfig;
import com.github.j5ik2o.akka.persistence.dynamodb.metrics.MetricsReporter;
import com.github.j5ik2o.akka.persistence.dynamodb.model.PersistenceId;
import com.github.j5ik2o.akka.persistence.dynamodb.model.PersistenceId$;
import com.github.j5ik2o.akka.persistence.dynamodb.model.SequenceNumber;
import com.github.j5ik2o.akka.persistence.dynamodb.snapshot.dao.ByteArraySnapshotSerializer;
import com.github.j5ik2o.akka.persistence.dynamodb.snapshot.dao.SnapshotDao;
import com.github.j5ik2o.akka.persistence.dynamodb.snapshot.dao.SnapshotRow;
import java.io.IOException;
import java.io.Serializable;
import java.util.Optional;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteRequest;
import software.amazon.awssdk.services.dynamodb.model.PutItemRequest;
import software.amazon.awssdk.services.dynamodb.model.QueryRequest;
import software.amazon.awssdk.services.dynamodb.model.WriteRequest;

@ScalaSignature(bytes="\u0006\u0001\u0005=g\u0001B\r\u001b\u0001-B\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\t}\u0001\u0011\t\u0011)A\u0005\u007f!Aq\n\u0001B\u0001B\u0003%\u0001\u000b\u0003\u0005U\u0001\t\u0005\t\u0015!\u0003V\u0011!Q\u0006A!A!\u0002\u0013Y\u0006\u0002C1\u0001\u0005\u0003\u0005\u000b\u0011\u00022\t\u000b%\u0004A\u0011\u00016\t\u000fI\u0004!\u0019!C\u0005g\"1A\u0010\u0001Q\u0001\nQDq! \u0001C\u0002\u0013%a\u0010C\u0004\u0002\u0006\u0001\u0001\u000b\u0011B@\t\u0013\u0005\u001d\u0001A1A\u0005\n\u0005%\u0001\u0002CA\t\u0001\u0001\u0006I!a\u0003\t\u000f\u0005M\u0001\u0001\"\u0011\u0002\u0016!9\u0011q\n\u0001\u0005B\u0005E\u0003bBA+\u0001\u0011\u0005\u0013q\u000b\u0005\b\u0003?\u0002A\u0011IA1\u0011\u001d\ty\u0007\u0001C!\u0003cBq!!\u001f\u0001\t\u0003\nY\bC\u0004\u0002\u001a\u0002!\t%a'\t\u000f\u0005\u0005\u0006\u0001\"\u0011\u0002$\"9\u0011\u0011\u0016\u0001\u0005B\u0005-\u0006bBAZ\u0001\u0011\u0005\u0013Q\u0017\u0005\b\u0003{\u0003A\u0011BA`\u0005E1&g\u00158baNDw\u000e\u001e#b_&k\u0007\u000f\u001c\u0006\u00037q\t1\u0001Z1p\u0015\tib$\u0001\u0005t]\u0006\u00048\u000f[8u\u0015\ty\u0002%\u0001\u0005es:\fWn\u001c3c\u0015\t\t#%A\u0006qKJ\u001c\u0018n\u001d;f]\u000e,'BA\u0012%\u0003\u0011\t7n[1\u000b\u0005\u00152\u0013A\u000266S.\u0014tN\u0003\u0002(Q\u00051q-\u001b;ik\nT\u0011!K\u0001\u0004G>l7\u0001A\n\u0004\u00011\u0012\u0004CA\u00171\u001b\u0005q#\"A\u0018\u0002\u000bM\u001c\u0017\r\\1\n\u0005Er#AB!osJ+g\r\u0005\u00024i5\t!$\u0003\u000265\tY1K\\1qg\"|G\u000fR1p\u0003\u0019\u0019\u0018p\u001d;f[B\u0011\u0001\bP\u0007\u0002s)\u0011!hO\u0001\u0006C\u000e$xN\u001d\u0006\u0002G%\u0011Q(\u000f\u0002\f\u0003\u000e$xN]*zgR,W.A\u0006bgft7m\u00117jK:$\bcA\u0017A\u0005&\u0011\u0011I\f\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\rkU\"\u0001#\u000b\u0005})%B\u0001$H\u0003!\u0019XM\u001d<jG\u0016\u001c(B\u0001%J\u0003\u0019\two]:eW*\u0011!jS\u0001\u0007C6\f'p\u001c8\u000b\u00031\u000b\u0001b]8gi^\f'/Z\u0005\u0003\u001d\u0012\u00131\u0003R=oC6|GIY!ts:\u001c7\t\\5f]R\f!b]=oG\u000ec\u0017.\u001a8u!\ri\u0003)\u0015\t\u0003\u0007JK!a\u0015#\u0003\u001d\u0011Kh.Y7p\t\n\u001cE.[3oi\u0006i1/\u001a:jC2L'0\u0019;j_:\u0004\"A\u0016-\u000e\u0003]S!\u0001V\u001e\n\u0005e;&!D*fe&\fG.\u001b>bi&|g.\u0001\u0007qYV<\u0017N\\\"p]\u001aLw\r\u0005\u0002]?6\tQL\u0003\u0002_=\u000511m\u001c8gS\u001eL!\u0001Y/\u0003)Ms\u0017\r]:i_R\u0004F.^4j]\u000e{gNZ5h\u0003=iW\r\u001e:jGN\u0014V\r]8si\u0016\u0014\bcA\u0017AGB\u0011AmZ\u0007\u0002K*\u0011aMH\u0001\b[\u0016$(/[2t\u0013\tAWMA\bNKR\u0014\u0018nY:SKB|'\u000f^3s\u0003\u0019a\u0014N\\5u}Q91\u000e\\7o_B\f\bCA\u001a\u0001\u0011\u00151t\u00011\u00018\u0011\u0015qt\u00011\u0001@\u0011\u0015yu\u00011\u0001Q\u0011\u0015!v\u00011\u0001V\u0011\u0015Qv\u00011\u0001\\\u0011\u0015\tw\u00011\u0001c\u0003A\u0019HO]3b[J+\u0017\rZ\"mS\u0016tG/F\u0001u!\t)(0D\u0001w\u0015\t9\b0\u0001\u0002we)\u0011\u0011PH\u0001\u0007G2LWM\u001c;\n\u0005m4(\u0001E*ue\u0016\fWNU3bI\u000ec\u0017.\u001a8u\u0003E\u0019HO]3b[J+\u0017\rZ\"mS\u0016tG\u000fI\u0001\u0012gR\u0014X-Y7Xe&$Xm\u00117jK:$X#A@\u0011\u0007U\f\t!C\u0002\u0002\u0004Y\u0014\u0011c\u0015;sK\u0006lwK]5uK\u000ec\u0017.\u001a8u\u0003I\u0019HO]3b[^\u0013\u0018\u000e^3DY&,g\u000e\u001e\u0011\u0002\u0015M,'/[1mSj,'/\u0006\u0002\u0002\fA\u00191'!\u0004\n\u0007\u0005=!DA\u000eCsR,\u0017I\u001d:bsNs\u0017\r]:i_R\u001cVM]5bY&TXM]\u0001\fg\u0016\u0014\u0018.\u00197ju\u0016\u0014\b%\u0001\u0004eK2,G/\u001a\u000b\u0007\u0003/\t)$!\u0012\u0011\u0011\u0005e\u00111EA\u0014\u0003[i!!a\u0007\u000b\t\u0005u\u0011qD\u0001\tg\u000e\fG.\u00193tY*\u0019\u0011\u0011E\u001e\u0002\rM$(/Z1n\u0013\u0011\t)#a\u0007\u0003\rM{WO]2f!\ri\u0013\u0011F\u0005\u0004\u0003Wq#\u0001B+oSR\u0004B!a\f\u000225\t1(C\u0002\u00024m\u0012qAT8u+N,G\rC\u0004\u000289\u0001\r!!\u000f\u0002\u001bA,'o]5ti\u0016t7-Z%e!\u0011\tY$!\u0011\u000e\u0005\u0005u\"bAA =\u0005)Qn\u001c3fY&!\u00111IA\u001f\u00055\u0001VM]:jgR,gnY3JI\"9\u0011q\t\bA\u0002\u0005%\u0013AC:fcV,gnY3OeB!\u00111HA&\u0013\u0011\ti%!\u0010\u0003\u001dM+\u0017/^3oG\u0016tU/\u001c2fe\u0006\u0011B-\u001a7fi\u0016\fE\u000e\\*oCB\u001c\bn\u001c;t)\u0011\t9\"a\u0015\t\u000f\u0005]r\u00021\u0001\u0002:\u00059B-\u001a7fi\u0016,\u0006\u000fV8NCb\u001cV-];f]\u000e,gJ\u001d\u000b\u0007\u0003/\tI&a\u0017\t\u000f\u0005]\u0002\u00031\u0001\u0002:!9\u0011Q\f\tA\u0002\u0005%\u0013!D7bqN+\u0017/^3oG\u0016t%/\u0001\feK2,G/Z+q)>l\u0015\r\u001f+j[\u0016\u001cH/Y7q)\u0019\t9\"a\u0019\u0002f!9\u0011qG\tA\u0002\u0005e\u0002bBA4#\u0001\u0007\u0011\u0011N\u0001\r[\u0006DH+[7fgR\fW\u000e\u001d\t\u0004[\u0005-\u0014bAA7]\t!Aj\u001c8h\u0003\u0019\"W\r\\3uKV\u0003Hk\\'bqN+\u0017/^3oG\u0016t%/\u00118e\u001b\u0006DH+[7fgR\fW\u000e\u001d\u000b\t\u0003/\t\u0019(!\u001e\u0002x!9\u0011q\u0007\nA\u0002\u0005e\u0002bBA/%\u0001\u0007\u0011\u0011\n\u0005\b\u0003O\u0012\u0002\u0019AA5\u00039a\u0017\r^3tiNs\u0017\r]:i_R$B!! \u0002\u0018BA\u0011\u0011DA\u0012\u0003\u007f\ni\u0003\u0005\u0003.\u0001\u0006\u0005\u0005cB\u0017\u0002\u0004\u0006\u001d\u0015\u0011S\u0005\u0004\u0003\u000bs#A\u0002+va2,'\u0007\u0005\u0003\u0002\n\u00065UBAAF\u0015\t\t3(\u0003\u0003\u0002\u0010\u0006-%\u0001E*oCB\u001c\bn\u001c;NKR\fG-\u0019;b!\ri\u00131S\u0005\u0004\u0003+s#aA!os\"9\u0011qG\nA\u0002\u0005e\u0012aF:oCB\u001c\bn\u001c;G_Jl\u0015\r\u001f+j[\u0016\u001cH/Y7q)\u0019\ti(!(\u0002 \"9\u0011q\u0007\u000bA\u0002\u0005e\u0002bBA4)\u0001\u0007\u0011\u0011N\u0001\u0019g:\f\u0007o\u001d5pi\u001a{'/T1y'\u0016\fX/\u001a8dK:\u0013HCBA?\u0003K\u000b9\u000bC\u0004\u00028U\u0001\r!!\u000f\t\u000f\u0005uS\u00031\u0001\u0002J\u000593O\\1qg\"|GOR8s\u001b\u0006D8+Z9vK:\u001cWM\u0014:B]\u0012l\u0015\r\u001f+j[\u0016\u001cH/Y7q)!\ti(!,\u00020\u0006E\u0006bBA\u001c-\u0001\u0007\u0011\u0011\b\u0005\b\u0003;2\u0002\u0019AA%\u0011\u001d\t9G\u0006a\u0001\u0003S\nAa]1wKR1\u0011qCA\\\u0003wCq!!/\u0018\u0001\u0004\t9)\u0001\tt]\u0006\u00048\u000f[8u\u001b\u0016$\u0018\rZ1uC\"1Qd\u0006a\u0001\u0003#\u000b1\"];fef$U\r\\3uKR!\u0011qCAa\u0011\u001d\t\u0019\r\u0007a\u0001\u0003\u000b\fA\"];fef\u0014V-];fgR\u0004B!a2\u0002L6\u0011\u0011\u0011\u001a\u0006\u0004\u0003\u007f!\u0015\u0002BAg\u0003\u0013\u0014A\"U;fef\u0014V-];fgR\u0004")
public class V2SnapshotDaoImpl
implements SnapshotDao {
    private final SnapshotPluginConfig pluginConfig;
    private final StreamReadClient streamReadClient;
    private final StreamWriteClient streamWriteClient;
    private final ByteArraySnapshotSerializer serializer;

    private StreamReadClient streamReadClient() {
        return this.streamReadClient;
    }

    private StreamWriteClient streamWriteClient() {
        return this.streamWriteClient;
    }

    private ByteArraySnapshotSerializer serializer() {
        return this.serializer;
    }

    @Override
    public Source<BoxedUnit, NotUsed> delete(PersistenceId persistenceId, SequenceNumber sequenceNr) {
        DeleteItemRequest req = (DeleteItemRequest)DeleteItemRequest.builder().tableName(this.pluginConfig.tableName()).key((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig.columnsDefConfig().persistenceIdColumnName()), AttributeValue.builder().s(persistenceId.asString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig.columnsDefConfig().sequenceNrColumnName()), AttributeValue.builder().n(sequenceNr.asString()).build())}))).asJava()).build();
        return (Source)Source$.MODULE$.single((Object)req).via((Graph)this.streamWriteClient().deleteItemFlow()).flatMapConcat((Function1 & Serializable & scala.Serializable)response -> {
            Source source;
            if (response.sdkHttpResponse().isSuccessful()) {
                source = Source$.MODULE$.single((Object)BoxedUnit.UNIT);
            } else {
                int statusCode = response.sdkHttpResponse().statusCode();
                Optional statusText = response.sdkHttpResponse().statusText();
                source = Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).append(OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(statusText)).fold((Function0 & Serializable & scala.Serializable)() -> "", (Function1 & Serializable & scala.Serializable)s -> new StringBuilder(2).append(", ").append((String)s).toString())).toString()));
            }
            return source;
        });
    }

    @Override
    public Source<BoxedUnit, NotUsed> deleteAllSnapshots(PersistenceId persistenceId) {
        QueryRequest queryRequest = (QueryRequest)QueryRequest.builder().tableName(this.pluginConfig.tableName()).keyConditionExpression("#pid = :pid and #snr between :min and :max").expressionAttributeNames((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginConfig.columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginConfig.columnsDefConfig().sequenceNrColumnName())}))).asJava()).expressionAttributeValues((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), AttributeValue.builder().s(persistenceId.asString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), AttributeValue.builder().n(((Object)BoxesRunTime.boxToInteger((int)0)).toString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), AttributeValue.builder().n(((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString()).build())}))).asJava()).consistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginConfig.consistentRead())).build();
        return this.queryDelete(queryRequest);
    }

    @Override
    public Source<BoxedUnit, NotUsed> deleteUpToMaxSequenceNr(PersistenceId persistenceId, SequenceNumber maxSequenceNr) {
        QueryRequest queryRequest = (QueryRequest)QueryRequest.builder().tableName(this.pluginConfig.tableName()).keyConditionExpression("#pid = :pid and #snr between :min and :max").expressionAttributeNames((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginConfig.columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginConfig.columnsDefConfig().sequenceNrColumnName())}))).asJava()).expressionAttributeValues((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), AttributeValue.builder().s(persistenceId.asString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), AttributeValue.builder().n(((Object)BoxesRunTime.boxToInteger((int)0)).toString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), AttributeValue.builder().n(maxSequenceNr.asString()).build())}))).asJava()).consistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginConfig.consistentRead())).build();
        return this.queryDelete(queryRequest);
    }

    @Override
    public Source<BoxedUnit, NotUsed> deleteUpToMaxTimestamp(PersistenceId persistenceId, long maxTimestamp) {
        QueryRequest queryRequest = (QueryRequest)QueryRequest.builder().tableName(this.pluginConfig.tableName()).keyConditionExpression("#pid = :pid and #snr between :min and :max").filterExpression("#created <= :maxTimestamp").expressionAttributeNames((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginConfig.columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginConfig.columnsDefConfig().sequenceNrColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#created"), (Object)this.pluginConfig.columnsDefConfig().createdColumnName())}))).asJava()).expressionAttributeValues((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), AttributeValue.builder().s(persistenceId.asString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), AttributeValue.builder().n(((Object)BoxesRunTime.boxToInteger((int)0)).toString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), AttributeValue.builder().n(((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":maxTimestamp"), AttributeValue.builder().n(((Object)BoxesRunTime.boxToLong((long)maxTimestamp)).toString()).build())}))).asJava()).consistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginConfig.consistentRead())).build();
        return this.queryDelete(queryRequest);
    }

    @Override
    public Source<BoxedUnit, NotUsed> deleteUpToMaxSequenceNrAndMaxTimestamp(PersistenceId persistenceId, SequenceNumber maxSequenceNr, long maxTimestamp) {
        QueryRequest queryRequest = (QueryRequest)QueryRequest.builder().tableName(this.pluginConfig.tableName()).keyConditionExpression("#pid = :pid and #snr between :min and :max").filterExpression("#created <= :maxTimestamp").expressionAttributeNames((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginConfig.columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginConfig.columnsDefConfig().sequenceNrColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#created"), (Object)this.pluginConfig.columnsDefConfig().createdColumnName())}))).asJava()).expressionAttributeValues((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), AttributeValue.builder().s(persistenceId.asString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), AttributeValue.builder().n(((Object)BoxesRunTime.boxToInteger((int)0)).toString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), AttributeValue.builder().n(maxSequenceNr.asString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":maxTimestamp"), AttributeValue.builder().n(((Object)BoxesRunTime.boxToLong((long)maxTimestamp)).toString()).build())}))).asJava()).consistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginConfig.consistentRead())).build();
        return this.queryDelete(queryRequest);
    }

    @Override
    public Source<Option<Tuple2<SnapshotMetadata, Object>>, NotUsed> latestSnapshot(PersistenceId persistenceId) {
        QueryRequest queryRequest = (QueryRequest)QueryRequest.builder().tableName(this.pluginConfig.tableName()).keyConditionExpression("#pid = :pid and #snr between :min and :max").expressionAttributeNames((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginConfig.columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginConfig.columnsDefConfig().sequenceNrColumnName())}))).asJava()).expressionAttributeValues((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), AttributeValue.builder().s(persistenceId.asString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), AttributeValue.builder().n(((Object)BoxesRunTime.boxToInteger((int)0)).toString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), AttributeValue.builder().n(((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString()).build())}))).asJava()).scanIndexForward(Predef$.MODULE$.boolean2Boolean(false)).limit(Predef$.MODULE$.int2Integer(1)).consistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginConfig.consistentRead())).build();
        return (Source)Source$.MODULE$.single((Object)queryRequest).via((Graph)this.streamReadClient().queryFlow()).flatMapConcat((Function1 & Serializable & scala.Serializable)response -> {
            Source source;
            if (response.sdkHttpResponse().isSuccessful()) {
                source = Source$.MODULE$.single((Object)((TraversableLike)Option$.MODULE$.apply((Object)response.items()).map((Function1 & Serializable & scala.Serializable)x$1 -> (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(x$1).asScala()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)scala.collection.Seq$.MODULE$.empty())).headOption());
            } else {
                int statusCode = response.sdkHttpResponse().statusCode();
                Optional statusText = response.sdkHttpResponse().statusText();
                source = Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).append(OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(statusText)).fold((Function0 & Serializable & scala.Serializable)() -> "", (Function1 & Serializable & scala.Serializable)s -> new StringBuilder(2).append(", ").append((String)s).toString())).toString()));
            }
            return source;
        }).map((Function1 & Serializable & scala.Serializable)rows -> rows.map((Function1 & Serializable & scala.Serializable)javaRow -> {
            Tuple2 value;
            scala.collection.mutable.Map row = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(javaRow).asScala();
            PersistenceId x$1 = PersistenceId$.MODULE$.apply(((AttributeValue)row.apply((Object)$this.pluginConfig.columnsDefConfig().persistenceIdColumnName())).s());
            SequenceNumber x$2 = new SequenceNumber(new StringOps(Predef$.MODULE$.augmentString(((AttributeValue)row.apply((Object)$this.pluginConfig.columnsDefConfig().sequenceNrColumnName())).n())).toLong());
            byte[] x$3 = ((AttributeValue)row.apply((Object)$this.pluginConfig.columnsDefConfig().snapshotColumnName())).b().asByteArray();
            long x$4 = new StringOps(Predef$.MODULE$.augmentString(((AttributeValue)row.apply((Object)$this.pluginConfig.columnsDefConfig().createdColumnName())).n())).toLong();
            Either<Throwable, Tuple2<SnapshotMetadata, Object>> either = this.serializer().deserialize(new SnapshotRow(x$1, x$2, x$4, x$3));
            if (!(either instanceof Right)) {
                if (either instanceof Left) {
                    Left left = (Left)either;
                    Throwable ex = (Throwable)left.value();
                    throw ex;
                }
                throw new MatchError(either);
            }
            Right right = (Right)either;
            Tuple2 tuple2 = value = (Tuple2)right.value();
            return tuple2;
        }));
    }

    @Override
    public Source<Option<Tuple2<SnapshotMetadata, Object>>, NotUsed> snapshotForMaxTimestamp(PersistenceId persistenceId, long maxTimestamp) {
        QueryRequest queryRequest = (QueryRequest)QueryRequest.builder().tableName(this.pluginConfig.tableName()).keyConditionExpression("#pid = :pid and #snr between :min and :max").filterExpression("#created <= :maxTimestamp").expressionAttributeNames((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginConfig.columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginConfig.columnsDefConfig().sequenceNrColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#created"), (Object)this.pluginConfig.columnsDefConfig().createdColumnName())}))).asJava()).expressionAttributeValues((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), AttributeValue.builder().s(persistenceId.asString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), AttributeValue.builder().n(((Object)BoxesRunTime.boxToInteger((int)0)).toString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), AttributeValue.builder().n(((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":maxTimestamp"), AttributeValue.builder().n(((Object)BoxesRunTime.boxToLong((long)maxTimestamp)).toString()).build())}))).asJava()).scanIndexForward(Predef$.MODULE$.boolean2Boolean(false)).consistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginConfig.consistentRead())).build();
        return (Source)Source$.MODULE$.single((Object)queryRequest).via((Graph)this.streamReadClient().queryFlow()).flatMapConcat((Function1 & Serializable & scala.Serializable)response -> {
            Source source;
            if (response.sdkHttpResponse().isSuccessful()) {
                source = Source$.MODULE$.single((Object)((TraversableLike)Option$.MODULE$.apply((Object)response.items()).map((Function1 & Serializable & scala.Serializable)x$2 -> (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(x$2).asScala()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)scala.collection.Seq$.MODULE$.empty())).headOption());
            } else {
                int statusCode = response.sdkHttpResponse().statusCode();
                Optional statusText = response.sdkHttpResponse().statusText();
                source = Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).append(OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(statusText)).fold((Function0 & Serializable & scala.Serializable)() -> "", (Function1 & Serializable & scala.Serializable)s -> new StringBuilder(2).append(", ").append((String)s).toString())).toString()));
            }
            return source;
        }).map((Function1 & Serializable & scala.Serializable)rows -> rows.map((Function1 & Serializable & scala.Serializable)javaRow -> {
            Tuple2 value;
            scala.collection.mutable.Map row = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(javaRow).asScala();
            PersistenceId x$1 = PersistenceId$.MODULE$.apply(((AttributeValue)row.apply((Object)$this.pluginConfig.columnsDefConfig().persistenceIdColumnName())).s());
            SequenceNumber x$2 = new SequenceNumber(new StringOps(Predef$.MODULE$.augmentString(((AttributeValue)row.apply((Object)$this.pluginConfig.columnsDefConfig().sequenceNrColumnName())).n())).toLong());
            byte[] x$3 = ((AttributeValue)row.apply((Object)$this.pluginConfig.columnsDefConfig().snapshotColumnName())).b().asByteArray();
            long x$4 = new StringOps(Predef$.MODULE$.augmentString(((AttributeValue)row.apply((Object)$this.pluginConfig.columnsDefConfig().createdColumnName())).n())).toLong();
            Either<Throwable, Tuple2<SnapshotMetadata, Object>> either = this.serializer().deserialize(new SnapshotRow(x$1, x$2, x$4, x$3));
            if (!(either instanceof Right)) {
                if (either instanceof Left) {
                    Left left = (Left)either;
                    Throwable ex = (Throwable)left.value();
                    throw ex;
                }
                throw new MatchError(either);
            }
            Right right = (Right)either;
            Tuple2 tuple2 = value = (Tuple2)right.value();
            return tuple2;
        }));
    }

    @Override
    public Source<Option<Tuple2<SnapshotMetadata, Object>>, NotUsed> snapshotForMaxSequenceNr(PersistenceId persistenceId, SequenceNumber maxSequenceNr) {
        QueryRequest queryRequest = (QueryRequest)QueryRequest.builder().tableName(this.pluginConfig.tableName()).keyConditionExpression("#pid = :pid and #snr between :min and :max").expressionAttributeNames((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginConfig.columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginConfig.columnsDefConfig().sequenceNrColumnName())}))).asJava()).expressionAttributeValues((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), AttributeValue.builder().s(persistenceId.asString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), AttributeValue.builder().n(((Object)BoxesRunTime.boxToInteger((int)0)).toString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), AttributeValue.builder().n(maxSequenceNr.asString()).build())}))).asJava()).scanIndexForward(Predef$.MODULE$.boolean2Boolean(false)).consistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginConfig.consistentRead())).build();
        return (Source)Source$.MODULE$.single((Object)queryRequest).via((Graph)this.streamReadClient().queryFlow()).flatMapConcat((Function1 & Serializable & scala.Serializable)response -> {
            Source source;
            if (response.sdkHttpResponse().isSuccessful()) {
                source = Source$.MODULE$.single((Object)((TraversableLike)Option$.MODULE$.apply((Object)response.items()).map((Function1 & Serializable & scala.Serializable)x$3 -> (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(x$3).asScala()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)scala.collection.Seq$.MODULE$.empty())).headOption());
            } else {
                int statusCode = response.sdkHttpResponse().statusCode();
                Optional statusText = response.sdkHttpResponse().statusText();
                source = Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).append(OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(statusText)).fold((Function0 & Serializable & scala.Serializable)() -> "", (Function1 & Serializable & scala.Serializable)s -> new StringBuilder(2).append(", ").append((String)s).toString())).toString()));
            }
            return source;
        }).map((Function1 & Serializable & scala.Serializable)rows -> rows.map((Function1 & Serializable & scala.Serializable)javaRow -> {
            Tuple2 value;
            scala.collection.mutable.Map row = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(javaRow).asScala();
            PersistenceId x$1 = PersistenceId$.MODULE$.apply(((AttributeValue)row.apply((Object)$this.pluginConfig.columnsDefConfig().persistenceIdColumnName())).s());
            SequenceNumber x$2 = new SequenceNumber(new StringOps(Predef$.MODULE$.augmentString(((AttributeValue)row.apply((Object)$this.pluginConfig.columnsDefConfig().sequenceNrColumnName())).n())).toLong());
            byte[] x$3 = ((AttributeValue)row.apply((Object)$this.pluginConfig.columnsDefConfig().snapshotColumnName())).b().asByteArray();
            long x$4 = new StringOps(Predef$.MODULE$.augmentString(((AttributeValue)row.apply((Object)$this.pluginConfig.columnsDefConfig().createdColumnName())).n())).toLong();
            Either<Throwable, Tuple2<SnapshotMetadata, Object>> either = this.serializer().deserialize(new SnapshotRow(x$1, x$2, x$4, x$3));
            if (!(either instanceof Right)) {
                if (either instanceof Left) {
                    Left left = (Left)either;
                    Throwable ex = (Throwable)left.value();
                    throw ex;
                }
                throw new MatchError(either);
            }
            Right right = (Right)either;
            Tuple2 tuple2 = value = (Tuple2)right.value();
            return tuple2;
        }));
    }

    @Override
    public Source<Option<Tuple2<SnapshotMetadata, Object>>, NotUsed> snapshotForMaxSequenceNrAndMaxTimestamp(PersistenceId persistenceId, SequenceNumber maxSequenceNr, long maxTimestamp) {
        QueryRequest queryRequest = (QueryRequest)QueryRequest.builder().tableName(this.pluginConfig.tableName()).keyConditionExpression("#pid = :pid and #snr between :min and :max").filterExpression("#created <= :maxTimestamp").expressionAttributeNames((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginConfig.columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginConfig.columnsDefConfig().sequenceNrColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#created"), (Object)this.pluginConfig.columnsDefConfig().createdColumnName())}))).asJava()).expressionAttributeValues((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), AttributeValue.builder().s(persistenceId.asString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), AttributeValue.builder().n(((Object)BoxesRunTime.boxToInteger((int)0)).toString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), AttributeValue.builder().n(maxSequenceNr.asString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":maxTimestamp"), AttributeValue.builder().n(((Object)BoxesRunTime.boxToLong((long)maxTimestamp)).toString()).build())}))).asJava()).scanIndexForward(Predef$.MODULE$.boolean2Boolean(false)).consistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginConfig.consistentRead())).build();
        return (Source)Source$.MODULE$.single((Object)queryRequest).via((Graph)this.streamReadClient().queryFlow()).flatMapConcat((Function1 & Serializable & scala.Serializable)response -> {
            Source source;
            if (response.sdkHttpResponse().isSuccessful()) {
                source = Source$.MODULE$.single((Object)((TraversableLike)Option$.MODULE$.apply((Object)response.items()).map((Function1 & Serializable & scala.Serializable)x$4 -> (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(x$4).asScala()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)scala.collection.Seq$.MODULE$.empty())).headOption());
            } else {
                int statusCode = response.sdkHttpResponse().statusCode();
                Optional statusText = response.sdkHttpResponse().statusText();
                source = Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).append(OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(statusText)).fold((Function0 & Serializable & scala.Serializable)() -> "", (Function1 & Serializable & scala.Serializable)s -> new StringBuilder(2).append(", ").append((String)s).toString())).toString()));
            }
            return source;
        }).map((Function1 & Serializable & scala.Serializable)rows -> rows.map((Function1 & Serializable & scala.Serializable)javaRow -> {
            Tuple2 value;
            scala.collection.mutable.Map row = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(javaRow).asScala();
            PersistenceId x$1 = PersistenceId$.MODULE$.apply(((AttributeValue)row.apply((Object)$this.pluginConfig.columnsDefConfig().persistenceIdColumnName())).s());
            SequenceNumber x$2 = new SequenceNumber(new StringOps(Predef$.MODULE$.augmentString(((AttributeValue)row.apply((Object)$this.pluginConfig.columnsDefConfig().sequenceNrColumnName())).n())).toLong());
            byte[] x$3 = ((AttributeValue)row.apply((Object)$this.pluginConfig.columnsDefConfig().snapshotColumnName())).b().asByteArray();
            long x$4 = new StringOps(Predef$.MODULE$.augmentString(((AttributeValue)row.apply((Object)$this.pluginConfig.columnsDefConfig().createdColumnName())).n())).toLong();
            Either<Throwable, Tuple2<SnapshotMetadata, Object>> either = this.serializer().deserialize(new SnapshotRow(x$1, x$2, x$4, x$3));
            if (!(either instanceof Right)) {
                if (either instanceof Left) {
                    Left left = (Left)either;
                    Throwable ex = (Throwable)left.value();
                    throw ex;
                }
                throw new MatchError(either);
            }
            Right right = (Right)either;
            Tuple2 tuple2 = value = (Tuple2)right.value();
            return tuple2;
        }));
    }

    @Override
    public Source<BoxedUnit, NotUsed> save(SnapshotMetadata snapshotMetadata, Object snapshot) {
        Source source;
        Either<Throwable, SnapshotRow> either = this.serializer().serialize(snapshotMetadata, snapshot);
        if (either instanceof Right) {
            Right right = (Right)either;
            SnapshotRow snapshotRow = (SnapshotRow)right.value();
            PutItemRequest req = (PutItemRequest)PutItemRequest.builder().tableName(this.pluginConfig.tableName()).item((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig.columnsDefConfig().persistenceIdColumnName()), AttributeValue.builder().s(snapshotRow.persistenceId().asString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig.columnsDefConfig().sequenceNrColumnName()), AttributeValue.builder().n(snapshotRow.sequenceNumber().asString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig.columnsDefConfig().snapshotColumnName()), AttributeValue.builder().b(SdkBytes.fromByteArray((byte[])snapshotRow.snapshot())).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig.columnsDefConfig().createdColumnName()), AttributeValue.builder().n(((Object)BoxesRunTime.boxToLong((long)snapshotRow.created())).toString()).build())}))).asJava()).build();
            source = (Source)Source$.MODULE$.single((Object)req).via((Graph)this.streamWriteClient().putItemFlow()).flatMapConcat((Function1 & Serializable & scala.Serializable)response -> {
                Source source;
                if (response.sdkHttpResponse().isSuccessful()) {
                    source = Source$.MODULE$.single((Object)BoxedUnit.UNIT);
                } else {
                    int statusCode = response.sdkHttpResponse().statusCode();
                    Optional statusText = response.sdkHttpResponse().statusText();
                    source = Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).append(OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(statusText)).fold((Function0 & Serializable & scala.Serializable)() -> "", (Function1 & Serializable & scala.Serializable)s -> new StringBuilder(2).append(", ").append((String)s).toString())).toString()));
                }
                return source;
            });
        } else if (either instanceof Left) {
            Left left = (Left)either;
            Throwable ex = (Throwable)left.value();
            source = Source$.MODULE$.failed(ex);
        } else {
            throw new MatchError(either);
        }
        return source;
    }

    private Source<BoxedUnit, NotUsed> queryDelete(QueryRequest queryRequest) {
        return (Source)((Source)Source$.MODULE$.single((Object)queryRequest).via((Graph)this.streamReadClient().queryFlow()).map((Function1 & Serializable & scala.Serializable)response -> (Seq)Option$.MODULE$.apply((Object)response.items()).map((Function1 & Serializable & scala.Serializable)x$5 -> (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(x$5).asScala()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)scala.collection.Seq$.MODULE$.empty())).mapConcat((Function1 & Serializable & scala.Serializable)x$6 -> x$6.toVector()).grouped(this.pluginConfig.clientConfig().batchWriteItemLimit()).map((Function1 & Serializable & scala.Serializable)rows -> (scala.collection.immutable.Seq)rows.map((Function1 & Serializable & scala.Serializable)javaRow -> {
            scala.collection.mutable.Map row = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(javaRow).asScala();
            PersistenceId x$1 = PersistenceId$.MODULE$.apply(((AttributeValue)row.apply((Object)$this.pluginConfig.columnsDefConfig().persistenceIdColumnName())).s());
            SequenceNumber x$2 = new SequenceNumber(new StringOps(Predef$.MODULE$.augmentString(((AttributeValue)row.apply((Object)$this.pluginConfig.columnsDefConfig().sequenceNrColumnName())).n())).toLong());
            byte[] x$3 = ((AttributeValue)row.apply((Object)$this.pluginConfig.columnsDefConfig().snapshotColumnName())).b().asByteArray();
            long x$4 = new StringOps(Predef$.MODULE$.augmentString(((AttributeValue)row.apply((Object)$this.pluginConfig.columnsDefConfig().createdColumnName())).n())).toLong();
            return new SnapshotRow(x$1, x$2, x$4, x$3);
        }, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)rows -> (BatchWriteItemRequest)BatchWriteItemRequest.builder().requestItems((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.pluginConfig.tableName()), CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)rows.map((Function1 & Serializable & scala.Serializable)row -> (WriteRequest)WriteRequest.builder().deleteRequest((DeleteRequest)DeleteRequest.builder().key((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.pluginConfig.columnsDefConfig().persistenceIdColumnName()), AttributeValue.builder().s(row.persistenceId().asString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.pluginConfig.columnsDefConfig().sequenceNrColumnName()), AttributeValue.builder().n(row.sequenceNumber().asString()).build())}))).asJava()).build()).build(), Seq$.MODULE$.canBuildFrom())).asJava())}))).asJava()).build())).via((Graph)this.streamWriteClient().batchWriteItemFlow()).flatMapConcat((Function1 & Serializable & scala.Serializable)response -> {
            Source source;
            if (response.sdkHttpResponse().isSuccessful()) {
                source = Source$.MODULE$.single((Object)BoxedUnit.UNIT);
            } else {
                int statusCode = response.sdkHttpResponse().statusCode();
                Optional statusText = response.sdkHttpResponse().statusText();
                source = Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).append(OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(statusText)).fold((Function0 & Serializable & scala.Serializable)() -> "", (Function1 & Serializable & scala.Serializable)s -> new StringBuilder(2).append(", ").append((String)s).toString())).toString()));
            }
            return source;
        });
    }

    public V2SnapshotDaoImpl(ActorSystem system, Option<DynamoDbAsyncClient> asyncClient, Option<DynamoDbClient> syncClient, Serialization serialization, SnapshotPluginConfig pluginConfig, Option<MetricsReporter> metricsReporter) {
        this.pluginConfig = pluginConfig;
        Tuple2 tuple2 = new Tuple2(asyncClient, syncClient);
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (None$.MODULE$.equals(option) && None$.MODULE$.equals(option2)) {
                throw new IllegalArgumentException("aws clients is both None");
            }
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        this.streamReadClient = new StreamReadClient(system, asyncClient, syncClient, (PluginConfig)pluginConfig, pluginConfig.readBackoffConfig());
        this.streamWriteClient = new StreamWriteClient(system, asyncClient, syncClient, (PluginConfig)pluginConfig, pluginConfig.writeBackoffConfig());
        this.serializer = new ByteArraySnapshotSerializer(serialization);
    }
}

