/*
 * Decompiled with CFR 0.152.
 */
package com.github.j5ik2o.akka.persistence.dynamodb.snapshot.dao;

import akka.NotUsed;
import akka.actor.ActorSystem;
import akka.persistence.SnapshotMetadata;
import akka.serialization.Serialization;
import akka.stream.Graph;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBAsync;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteItemRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteRequest;
import com.amazonaws.services.dynamodbv2.model.PutItemRequest;
import com.amazonaws.services.dynamodbv2.model.QueryRequest;
import com.amazonaws.services.dynamodbv2.model.WriteRequest;
import com.github.j5ik2o.akka.persistence.dynamodb.client.v1.StreamReadClient;
import com.github.j5ik2o.akka.persistence.dynamodb.client.v1.StreamWriteClient;
import com.github.j5ik2o.akka.persistence.dynamodb.config.PluginConfig;
import com.github.j5ik2o.akka.persistence.dynamodb.config.SnapshotPluginConfig;
import com.github.j5ik2o.akka.persistence.dynamodb.model.PersistenceId;
import com.github.j5ik2o.akka.persistence.dynamodb.model.PersistenceId$;
import com.github.j5ik2o.akka.persistence.dynamodb.model.SequenceNumber;
import com.github.j5ik2o.akka.persistence.dynamodb.snapshot.dao.ByteArraySnapshotSerializer;
import com.github.j5ik2o.akka.persistence.dynamodb.snapshot.dao.SnapshotDao;
import com.github.j5ik2o.akka.persistence.dynamodb.snapshot.dao.SnapshotRow;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.concurrent.ExecutionContext;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\u0005%g\u0001B\r\u001b\u0001-B\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\t}\u0001\u0011\t\u0011)A\u0005\u007f!AA\n\u0001B\u0001B\u0003%Q\n\u0003\u0005R\u0001\t\u0005\t\u0015!\u0003S\u0011!9\u0006A!A!\u0002\u0013A\u0006\u0002\u00030\u0001\u0005\u0003\u0005\u000b1B0\t\u000b\u0015\u0004A\u0011\u00014\t\u000f=\u0004!\u0019!C\u0005a\"1\u0011\u0010\u0001Q\u0001\nEDqA\u001f\u0001C\u0002\u0013%1\u0010\u0003\u0004\u0000\u0001\u0001\u0006I\u0001 \u0005\n\u0003\u0003\u0001!\u0019!C\u0005\u0003\u0007A\u0001\"a\u0003\u0001A\u0003%\u0011Q\u0001\u0005\b\u0003\u001b\u0001A\u0011IA\b\u0011\u001d\ty\u0004\u0001C!\u0003\u0003Bq!a\u0014\u0001\t\u0003\n\t\u0006C\u0004\u0002`\u0001!\t%!\u0019\t\u000f\u0005%\u0004\u0001\"\u0011\u0002l!9\u0011\u0011\u0012\u0001\u0005B\u0005-\u0005bBAI\u0001\u0011\u0005\u00131\u0013\u0005\b\u00033\u0003A\u0011IAN\u0011\u001d\t\u0019\u000b\u0001C!\u0003KCq!!,\u0001\t\u0003\ny\u000bC\u0004\u00028\u0002!I!!/\u0003#Y\u000b4K\\1qg\"|G\u000fR1p\u00136\u0004HN\u0003\u0002\u001c9\u0005\u0019A-Y8\u000b\u0005uq\u0012\u0001C:oCB\u001c\bn\u001c;\u000b\u0005}\u0001\u0013\u0001\u00033z]\u0006lw\u000e\u001a2\u000b\u0005\u0005\u0012\u0013a\u00039feNL7\u000f^3oG\u0016T!a\t\u0013\u0002\t\u0005\\7.\u0019\u0006\u0003K\u0019\naA[\u001bjWJz'BA\u0014)\u0003\u00199\u0017\u000e\u001e5vE*\t\u0011&A\u0002d_6\u001c\u0001aE\u0002\u0001YI\u0002\"!\f\u0019\u000e\u00039R\u0011aL\u0001\u0006g\u000e\fG.Y\u0005\u0003c9\u0012a!\u00118z%\u00164\u0007CA\u001a5\u001b\u0005Q\u0012BA\u001b\u001b\u0005-\u0019f.\u00199tQ>$H)Y8\u0002\rML8\u000f^3n!\tAD(D\u0001:\u0015\tQ4(A\u0003bGR|'OC\u0001$\u0013\ti\u0014HA\u0006BGR|'oU=ti\u0016l\u0017aC1ts:\u001c7\t\\5f]R\u00042!\f!C\u0013\t\teF\u0001\u0004PaRLwN\u001c\t\u0003\u0007*k\u0011\u0001\u0012\u0006\u0003\u000b\u001a\u000b!\u0002Z=oC6|GM\u0019<3\u0015\t9\u0005*\u0001\u0005tKJ4\u0018nY3t\u0015\tI\u0005&A\u0005b[\u0006TxN\\1xg&\u00111\n\u0012\u0002\u0014\u00036\f'p\u001c8Es:\fWn\u001c#C\u0003NLhnY\u0001\u000bgft7m\u00117jK:$\bcA\u0017A\u001dB\u00111iT\u0005\u0003!\u0012\u0013a\"Q7bu>tG)\u001f8b[>$%)A\u0007tKJL\u0017\r\\5{CRLwN\u001c\t\u0003'Vk\u0011\u0001\u0016\u0006\u0003#nJ!A\u0016+\u0003\u001bM+'/[1mSj\fG/[8o\u00031\u0001H.^4j]\u000e{gNZ5h!\tIF,D\u0001[\u0015\tYf$\u0001\u0004d_:4\u0017nZ\u0005\u0003;j\u0013Ac\u00158baNDw\u000e\u001e)mk\u001eLgnQ8oM&<\u0017AA3d!\t\u00017-D\u0001b\u0015\t\u0011g&\u0001\u0006d_:\u001cWO\u001d:f]RL!\u0001Z1\u0003!\u0015CXmY;uS>t7i\u001c8uKb$\u0018A\u0002\u001fj]&$h\b\u0006\u0004hU.dWN\u001c\u000b\u0003Q&\u0004\"a\r\u0001\t\u000by;\u00019A0\t\u000bY:\u0001\u0019A\u001c\t\u000by:\u0001\u0019A \t\u000b1;\u0001\u0019A'\t\u000bE;\u0001\u0019\u0001*\t\u000b];\u0001\u0019\u0001-\u0002!M$(/Z1n%\u0016\fGm\u00117jK:$X#A9\u0011\u0005I<X\"A:\u000b\u0005Q,\u0018A\u0001<2\u0015\t1h$\u0001\u0004dY&,g\u000e^\u0005\u0003qN\u0014\u0001c\u0015;sK\u0006l'+Z1e\u00072LWM\u001c;\u0002#M$(/Z1n%\u0016\fGm\u00117jK:$\b%A\ttiJ,\u0017-\\,sSR,7\t\\5f]R,\u0012\u0001 \t\u0003evL!A`:\u0003#M#(/Z1n/JLG/Z\"mS\u0016tG/\u0001\ntiJ,\u0017-\\,sSR,7\t\\5f]R\u0004\u0013AC:fe&\fG.\u001b>feV\u0011\u0011Q\u0001\t\u0004g\u0005\u001d\u0011bAA\u00055\tY\")\u001f;f\u0003J\u0014\u0018-_*oCB\u001c\bn\u001c;TKJL\u0017\r\\5{KJ\f1b]3sS\u0006d\u0017N_3sA\u0005\u0011B-\u001a7fi\u0016\fE\u000e\\*oCB\u001c\bn\u001c;t)\u0011\t\t\"a\f\u0011\u0011\u0005M\u0011QDA\u0011\u0003Oi!!!\u0006\u000b\t\u0005]\u0011\u0011D\u0001\tg\u000e\fG.\u00193tY*\u0019\u00111D\u001e\u0002\rM$(/Z1n\u0013\u0011\ty\"!\u0006\u0003\rM{WO]2f!\ri\u00131E\u0005\u0004\u0003Kq#\u0001B+oSR\u0004B!!\u000b\u0002,5\t1(C\u0002\u0002.m\u0012qAT8u+N,G\rC\u0004\u000229\u0001\r!a\r\u0002\u001bA,'o]5ti\u0016t7-Z%e!\u0011\t)$a\u000f\u000e\u0005\u0005]\"bAA\u001d=\u0005)Qn\u001c3fY&!\u0011QHA\u001c\u00055\u0001VM]:jgR,gnY3JI\u00069B-\u001a7fi\u0016,\u0006\u000fV8NCb\u001cV-];f]\u000e,gJ\u001d\u000b\u0007\u0003#\t\u0019%!\u0012\t\u000f\u0005Er\u00021\u0001\u00024!9\u0011qI\bA\u0002\u0005%\u0013!D7bqN+\u0017/^3oG\u0016t%\u000f\u0005\u0003\u00026\u0005-\u0013\u0002BA'\u0003o\u0011abU3rk\u0016t7-\u001a(v[\n,'/\u0001\feK2,G/Z+q)>l\u0015\r\u001f+j[\u0016\u001cH/Y7q)\u0019\t\t\"a\u0015\u0002V!9\u0011\u0011\u0007\tA\u0002\u0005M\u0002bBA,!\u0001\u0007\u0011\u0011L\u0001\r[\u0006DH+[7fgR\fW\u000e\u001d\t\u0004[\u0005m\u0013bAA/]\t!Aj\u001c8h\u0003\u0019\"W\r\\3uKV\u0003Hk\\'bqN+\u0017/^3oG\u0016t%/\u00118e\u001b\u0006DH+[7fgR\fW\u000e\u001d\u000b\t\u0003#\t\u0019'!\u001a\u0002h!9\u0011\u0011G\tA\u0002\u0005M\u0002bBA$#\u0001\u0007\u0011\u0011\n\u0005\b\u0003/\n\u0002\u0019AA-\u00039a\u0017\r^3tiNs\u0017\r]:i_R$B!!\u001c\u0002\bBA\u00111CA\u000f\u0003_\n9\u0003\u0005\u0003.\u0001\u0006E\u0004cB\u0017\u0002t\u0005]\u0014\u0011Q\u0005\u0004\u0003kr#A\u0002+va2,'\u0007\u0005\u0003\u0002z\u0005uTBAA>\u0015\t\t3(\u0003\u0003\u0002\u0000\u0005m$\u0001E*oCB\u001c\bn\u001c;NKR\fG-\u0019;b!\ri\u00131Q\u0005\u0004\u0003\u000bs#aA!os\"9\u0011\u0011\u0007\nA\u0002\u0005M\u0012aF:oCB\u001c\bn\u001c;G_Jl\u0015\r\u001f+j[\u0016\u001cH/Y7q)\u0019\ti'!$\u0002\u0010\"9\u0011\u0011G\nA\u0002\u0005M\u0002bBA,'\u0001\u0007\u0011\u0011L\u0001\u0019g:\f\u0007o\u001d5pi\u001a{'/T1y'\u0016\fX/\u001a8dK:\u0013HCBA7\u0003+\u000b9\nC\u0004\u00022Q\u0001\r!a\r\t\u000f\u0005\u001dC\u00031\u0001\u0002J\u000593O\\1qg\"|GOR8s\u001b\u0006D8+Z9vK:\u001cWM\u0014:B]\u0012l\u0015\r\u001f+j[\u0016\u001cH/Y7q)!\ti'!(\u0002 \u0006\u0005\u0006bBA\u0019+\u0001\u0007\u00111\u0007\u0005\b\u0003\u000f*\u0002\u0019AA%\u0011\u001d\t9&\u0006a\u0001\u00033\na\u0001Z3mKR,GCBA\t\u0003O\u000bI\u000bC\u0004\u00022Y\u0001\r!a\r\t\u000f\u0005-f\u00031\u0001\u0002J\u0005Q1/Z9vK:\u001cWM\u0014:\u0002\tM\fg/\u001a\u000b\u0007\u0003#\t\t,!.\t\u000f\u0005Mv\u00031\u0001\u0002x\u0005\u00012O\\1qg\"|G/T3uC\u0012\fG/\u0019\u0005\u0007;]\u0001\r!!!\u0002\u0017E,XM]=EK2,G/\u001a\u000b\u0005\u0003#\tY\fC\u0004\u0002>b\u0001\r!a0\u0002\u0019E,XM]=SKF,Xm\u001d;\u0011\t\u0005\u0005\u0017QY\u0007\u0003\u0003\u0007T1!!\u000fE\u0013\u0011\t9-a1\u0003\u0019E+XM]=SKF,Xm\u001d;")
public class V1SnapshotDaoImpl
implements SnapshotDao {
    private final SnapshotPluginConfig pluginConfig;
    private final StreamReadClient streamReadClient;
    private final StreamWriteClient streamWriteClient;
    private final ByteArraySnapshotSerializer serializer;

    private StreamReadClient streamReadClient() {
        return this.streamReadClient;
    }

    private StreamWriteClient streamWriteClient() {
        return this.streamWriteClient;
    }

    private ByteArraySnapshotSerializer serializer() {
        return this.serializer;
    }

    @Override
    public Source<BoxedUnit, NotUsed> deleteAllSnapshots(PersistenceId persistenceId) {
        QueryRequest queryRequest = new QueryRequest().withTableName(this.pluginConfig.tableName()).withKeyConditionExpression("#pid = :pid and #snr between :min and :max").withExpressionAttributeNames((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginConfig.columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginConfig.columnsDefConfig().sequenceNrColumnName())}))).asJava()).withExpressionAttributeValues((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), (Object)new AttributeValue().withS(persistenceId.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), (Object)new AttributeValue().withN(((Object)BoxesRunTime.boxToInteger((int)0)).toString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), (Object)new AttributeValue().withN(((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString()))}))).asJava()).withConsistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginConfig.consistentRead()));
        return this.queryDelete(queryRequest);
    }

    @Override
    public Source<BoxedUnit, NotUsed> deleteUpToMaxSequenceNr(PersistenceId persistenceId, SequenceNumber maxSequenceNr) {
        QueryRequest queryRequest = new QueryRequest().withTableName(this.pluginConfig.tableName()).withKeyConditionExpression("#pid = :pid and #snr between :min and :max").withExpressionAttributeNames((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginConfig.columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginConfig.columnsDefConfig().sequenceNrColumnName())}))).asJava()).withExpressionAttributeValues((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), (Object)new AttributeValue().withS(persistenceId.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), (Object)new AttributeValue().withN(((Object)BoxesRunTime.boxToInteger((int)0)).toString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), (Object)new AttributeValue().withN(maxSequenceNr.asString()))}))).asJava()).withConsistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginConfig.consistentRead()));
        return this.queryDelete(queryRequest);
    }

    @Override
    public Source<BoxedUnit, NotUsed> deleteUpToMaxTimestamp(PersistenceId persistenceId, long maxTimestamp) {
        QueryRequest queryRequest = new QueryRequest().withTableName(this.pluginConfig.tableName()).withKeyConditionExpression("#pid = :pid and #snr between :min and :max").withFilterExpression("#created <= :maxTimestamp").withExpressionAttributeNames((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginConfig.columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginConfig.columnsDefConfig().sequenceNrColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#created"), (Object)this.pluginConfig.columnsDefConfig().createdColumnName())}))).asJava()).withExpressionAttributeValues((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), (Object)new AttributeValue().withS(persistenceId.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), (Object)new AttributeValue().withN(((Object)BoxesRunTime.boxToInteger((int)0)).toString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), (Object)new AttributeValue().withN(((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":maxTimestamp"), (Object)new AttributeValue().withN(((Object)BoxesRunTime.boxToLong((long)maxTimestamp)).toString()))}))).asJava()).withConsistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginConfig.consistentRead()));
        return this.queryDelete(queryRequest);
    }

    @Override
    public Source<BoxedUnit, NotUsed> deleteUpToMaxSequenceNrAndMaxTimestamp(PersistenceId persistenceId, SequenceNumber maxSequenceNr, long maxTimestamp) {
        QueryRequest queryRequest = new QueryRequest().withTableName(this.pluginConfig.tableName()).withKeyConditionExpression("#pid = :pid and #snr between :min and :max").withFilterExpression("#created <= :maxTimestamp").withExpressionAttributeNames((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginConfig.columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginConfig.columnsDefConfig().sequenceNrColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#created"), (Object)this.pluginConfig.columnsDefConfig().createdColumnName())}))).asJava()).withExpressionAttributeValues((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), (Object)new AttributeValue().withS(persistenceId.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), (Object)new AttributeValue().withN(((Object)BoxesRunTime.boxToInteger((int)0)).toString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), (Object)new AttributeValue().withN(maxSequenceNr.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":maxTimestamp"), (Object)new AttributeValue().withN(((Object)BoxesRunTime.boxToLong((long)maxTimestamp)).toString()))}))).asJava()).withConsistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginConfig.consistentRead()));
        return this.queryDelete(queryRequest);
    }

    @Override
    public Source<Option<Tuple2<SnapshotMetadata, Object>>, NotUsed> latestSnapshot(PersistenceId persistenceId) {
        QueryRequest queryRequest = new QueryRequest().withTableName(this.pluginConfig.tableName()).withKeyConditionExpression("#pid = :pid and #snr between :min and :max").withExpressionAttributeNames((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginConfig.columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginConfig.columnsDefConfig().sequenceNrColumnName())}))).asJava()).withExpressionAttributeValues((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), (Object)new AttributeValue().withS(persistenceId.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), (Object)new AttributeValue().withN(((Object)BoxesRunTime.boxToInteger((int)0)).toString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), (Object)new AttributeValue().withN(((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString()))}))).asJava()).withScanIndexForward(Predef$.MODULE$.boolean2Boolean(false)).withLimit(Predef$.MODULE$.int2Integer(1)).withConsistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginConfig.consistentRead()));
        return (Source)Source$.MODULE$.single((Object)queryRequest).via((Graph)this.streamReadClient().queryFlow()).flatMapConcat((Function1 & Serializable & scala.Serializable)response -> {
            Source source;
            if (response.getSdkHttpMetadata().getHttpStatusCode() == 200) {
                source = Source$.MODULE$.single((Object)((TraversableLike)Option$.MODULE$.apply((Object)response.getItems()).map((Function1 & Serializable & scala.Serializable)x$1 -> (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(x$1).asScala()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)scala.collection.Seq$.MODULE$.empty())).headOption());
            } else {
                int statusCode = response.getSdkHttpMetadata().getHttpStatusCode();
                source = Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).toString()));
            }
            return source;
        }).map((Function1 & Serializable & scala.Serializable)rows -> rows.map((Function1 & Serializable & scala.Serializable)row -> {
            Tuple2 value;
            scala.collection.mutable.Map _row = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(row).asScala();
            PersistenceId x$1 = PersistenceId$.MODULE$.apply(((AttributeValue)_row.apply((Object)$this.pluginConfig.columnsDefConfig().persistenceIdColumnName())).getS());
            SequenceNumber x$2 = new SequenceNumber(new StringOps(Predef$.MODULE$.augmentString(((AttributeValue)_row.apply((Object)$this.pluginConfig.columnsDefConfig().sequenceNrColumnName())).getN())).toLong());
            byte[] x$3 = ((AttributeValue)_row.apply((Object)$this.pluginConfig.columnsDefConfig().snapshotColumnName())).getB().array();
            long x$4 = new StringOps(Predef$.MODULE$.augmentString(((AttributeValue)_row.apply((Object)$this.pluginConfig.columnsDefConfig().createdColumnName())).getN())).toLong();
            Either<Throwable, Tuple2<SnapshotMetadata, Object>> either = this.serializer().deserialize(new SnapshotRow(x$1, x$2, x$4, x$3));
            if (!(either instanceof Right)) {
                if (either instanceof Left) {
                    Left left = (Left)either;
                    Throwable ex = (Throwable)left.value();
                    throw ex;
                }
                throw new MatchError(either);
            }
            Right right = (Right)either;
            Tuple2 tuple2 = value = (Tuple2)right.value();
            return tuple2;
        }));
    }

    @Override
    public Source<Option<Tuple2<SnapshotMetadata, Object>>, NotUsed> snapshotForMaxTimestamp(PersistenceId persistenceId, long maxTimestamp) {
        QueryRequest queryRequest = new QueryRequest().withTableName(this.pluginConfig.tableName()).withKeyConditionExpression("#pid = :pid and #snr between :min and :max").withFilterExpression("#created <= :maxTimestamp").withExpressionAttributeNames((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginConfig.columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginConfig.columnsDefConfig().sequenceNrColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#created"), (Object)this.pluginConfig.columnsDefConfig().createdColumnName())}))).asJava()).withExpressionAttributeValues((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), (Object)new AttributeValue().withS(persistenceId.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), (Object)new AttributeValue().withN(((Object)BoxesRunTime.boxToInteger((int)0)).toString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), (Object)new AttributeValue().withN(((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":maxTimestamp"), (Object)new AttributeValue().withN(((Object)BoxesRunTime.boxToLong((long)maxTimestamp)).toString()))}))).asJava()).withScanIndexForward(Predef$.MODULE$.boolean2Boolean(false)).withConsistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginConfig.consistentRead()));
        return (Source)Source$.MODULE$.single((Object)queryRequest).via((Graph)this.streamReadClient().queryFlow()).flatMapConcat((Function1 & Serializable & scala.Serializable)response -> {
            Source source;
            if (response.getSdkHttpMetadata().getHttpStatusCode() == 200) {
                source = Source$.MODULE$.single((Object)((TraversableLike)Option$.MODULE$.apply((Object)response.getItems()).map((Function1 & Serializable & scala.Serializable)x$2 -> (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(x$2).asScala()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)scala.collection.Seq$.MODULE$.empty())).headOption());
            } else {
                int statusCode = response.getSdkHttpMetadata().getHttpStatusCode();
                source = Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).toString()));
            }
            return source;
        }).map((Function1 & Serializable & scala.Serializable)rows -> rows.map((Function1 & Serializable & scala.Serializable)row -> {
            Tuple2 value;
            scala.collection.mutable.Map _row = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(row).asScala();
            PersistenceId x$1 = PersistenceId$.MODULE$.apply(((AttributeValue)_row.apply((Object)$this.pluginConfig.columnsDefConfig().persistenceIdColumnName())).getS());
            SequenceNumber x$2 = new SequenceNumber(new StringOps(Predef$.MODULE$.augmentString(((AttributeValue)_row.apply((Object)$this.pluginConfig.columnsDefConfig().sequenceNrColumnName())).getN())).toLong());
            byte[] x$3 = ((AttributeValue)_row.apply((Object)$this.pluginConfig.columnsDefConfig().snapshotColumnName())).getB().array();
            long x$4 = new StringOps(Predef$.MODULE$.augmentString(((AttributeValue)_row.apply((Object)$this.pluginConfig.columnsDefConfig().createdColumnName())).getN())).toLong();
            Either<Throwable, Tuple2<SnapshotMetadata, Object>> either = this.serializer().deserialize(new SnapshotRow(x$1, x$2, x$4, x$3));
            if (!(either instanceof Right)) {
                if (either instanceof Left) {
                    Left left = (Left)either;
                    Throwable ex = (Throwable)left.value();
                    throw ex;
                }
                throw new MatchError(either);
            }
            Right right = (Right)either;
            Tuple2 tuple2 = value = (Tuple2)right.value();
            return tuple2;
        }));
    }

    @Override
    public Source<Option<Tuple2<SnapshotMetadata, Object>>, NotUsed> snapshotForMaxSequenceNr(PersistenceId persistenceId, SequenceNumber maxSequenceNr) {
        QueryRequest queryRequest = new QueryRequest().withTableName(this.pluginConfig.tableName()).withKeyConditionExpression("#pid = :pid and #snr between :min and :max").withExpressionAttributeNames((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginConfig.columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginConfig.columnsDefConfig().sequenceNrColumnName())}))).asJava()).withExpressionAttributeValues((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), (Object)new AttributeValue().withS(persistenceId.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), (Object)new AttributeValue().withN(((Object)BoxesRunTime.boxToInteger((int)0)).toString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), (Object)new AttributeValue().withN(maxSequenceNr.asString()))}))).asJava()).withScanIndexForward(Predef$.MODULE$.boolean2Boolean(false)).withConsistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginConfig.consistentRead()));
        return (Source)Source$.MODULE$.single((Object)queryRequest).via((Graph)this.streamReadClient().queryFlow()).flatMapConcat((Function1 & Serializable & scala.Serializable)response -> {
            Source source;
            if (response.getSdkHttpMetadata().getHttpStatusCode() == 200) {
                source = Source$.MODULE$.single((Object)((TraversableLike)Option$.MODULE$.apply((Object)response.getItems()).map((Function1 & Serializable & scala.Serializable)x$3 -> (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(x$3).asScala()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)scala.collection.Seq$.MODULE$.empty())).headOption());
            } else {
                int statusCode = response.getSdkHttpMetadata().getHttpStatusCode();
                source = Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).toString()));
            }
            return source;
        }).map((Function1 & Serializable & scala.Serializable)rows -> rows.map((Function1 & Serializable & scala.Serializable)row -> {
            Tuple2 value;
            scala.collection.mutable.Map _row = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(row).asScala();
            PersistenceId x$1 = PersistenceId$.MODULE$.apply(((AttributeValue)_row.apply((Object)$this.pluginConfig.columnsDefConfig().persistenceIdColumnName())).getS());
            SequenceNumber x$2 = new SequenceNumber(new StringOps(Predef$.MODULE$.augmentString(((AttributeValue)_row.apply((Object)$this.pluginConfig.columnsDefConfig().sequenceNrColumnName())).getN())).toLong());
            byte[] x$3 = ((AttributeValue)_row.apply((Object)$this.pluginConfig.columnsDefConfig().snapshotColumnName())).getB().array();
            long x$4 = new StringOps(Predef$.MODULE$.augmentString(((AttributeValue)_row.apply((Object)$this.pluginConfig.columnsDefConfig().createdColumnName())).getN())).toLong();
            Either<Throwable, Tuple2<SnapshotMetadata, Object>> either = this.serializer().deserialize(new SnapshotRow(x$1, x$2, x$4, x$3));
            if (!(either instanceof Right)) {
                if (either instanceof Left) {
                    Left left = (Left)either;
                    Throwable ex = (Throwable)left.value();
                    throw ex;
                }
                throw new MatchError(either);
            }
            Right right = (Right)either;
            Tuple2 tuple2 = value = (Tuple2)right.value();
            return tuple2;
        }));
    }

    @Override
    public Source<Option<Tuple2<SnapshotMetadata, Object>>, NotUsed> snapshotForMaxSequenceNrAndMaxTimestamp(PersistenceId persistenceId, SequenceNumber maxSequenceNr, long maxTimestamp) {
        QueryRequest queryRequest = new QueryRequest().withTableName(this.pluginConfig.tableName()).withKeyConditionExpression("#pid = :pid and #snr between :min and :max").withFilterExpression("#created <= :maxTimestamp").withExpressionAttributeNames((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginConfig.columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginConfig.columnsDefConfig().sequenceNrColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#created"), (Object)this.pluginConfig.columnsDefConfig().createdColumnName())}))).asJava()).withExpressionAttributeValues((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), (Object)new AttributeValue().withS(persistenceId.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), (Object)new AttributeValue().withN(((Object)BoxesRunTime.boxToInteger((int)0)).toString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), (Object)new AttributeValue().withN(maxSequenceNr.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":maxTimestamp"), (Object)new AttributeValue().withN(((Object)BoxesRunTime.boxToLong((long)maxTimestamp)).toString()))}))).asJava()).withScanIndexForward(Predef$.MODULE$.boolean2Boolean(false)).withConsistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginConfig.consistentRead()));
        return (Source)Source$.MODULE$.single((Object)queryRequest).via((Graph)this.streamReadClient().queryFlow()).flatMapConcat((Function1 & Serializable & scala.Serializable)response -> {
            Source source;
            if (response.getSdkHttpMetadata().getHttpStatusCode() == 200) {
                source = Source$.MODULE$.single((Object)((TraversableLike)Option$.MODULE$.apply((Object)response.getItems()).map((Function1 & Serializable & scala.Serializable)x$4 -> (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(x$4).asScala()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)scala.collection.Seq$.MODULE$.empty())).headOption());
            } else {
                int statusCode = response.getSdkHttpMetadata().getHttpStatusCode();
                source = Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).toString()));
            }
            return source;
        }).map((Function1 & Serializable & scala.Serializable)rows -> rows.map((Function1 & Serializable & scala.Serializable)row -> {
            Tuple2 value;
            scala.collection.mutable.Map _row = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(row).asScala();
            PersistenceId x$1 = PersistenceId$.MODULE$.apply(((AttributeValue)_row.apply((Object)$this.pluginConfig.columnsDefConfig().persistenceIdColumnName())).getS());
            SequenceNumber x$2 = new SequenceNumber(new StringOps(Predef$.MODULE$.augmentString(((AttributeValue)_row.apply((Object)$this.pluginConfig.columnsDefConfig().sequenceNrColumnName())).getN())).toLong());
            byte[] x$3 = ((AttributeValue)_row.apply((Object)$this.pluginConfig.columnsDefConfig().snapshotColumnName())).getB().array();
            long x$4 = new StringOps(Predef$.MODULE$.augmentString(((AttributeValue)_row.apply((Object)$this.pluginConfig.columnsDefConfig().createdColumnName())).getN())).toLong();
            Either<Throwable, Tuple2<SnapshotMetadata, Object>> either = this.serializer().deserialize(new SnapshotRow(x$1, x$2, x$4, x$3));
            if (!(either instanceof Right)) {
                if (either instanceof Left) {
                    Left left = (Left)either;
                    Throwable ex = (Throwable)left.value();
                    throw ex;
                }
                throw new MatchError(either);
            }
            Right right = (Right)either;
            Tuple2 tuple2 = value = (Tuple2)right.value();
            return tuple2;
        }));
    }

    @Override
    public Source<BoxedUnit, NotUsed> delete(PersistenceId persistenceId, SequenceNumber sequenceNr) {
        DeleteItemRequest req = new DeleteItemRequest().withTableName(this.pluginConfig.tableName()).withKey((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig.columnsDefConfig().persistenceIdColumnName()), (Object)new AttributeValue().withS(persistenceId.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig.columnsDefConfig().sequenceNrColumnName()), (Object)new AttributeValue().withN(sequenceNr.asString()))}))).asJava());
        return (Source)Source$.MODULE$.single((Object)req).via((Graph)this.streamWriteClient().deleteItemFlow()).flatMapConcat((Function1 & Serializable & scala.Serializable)response -> {
            Source source;
            if (response.getSdkHttpMetadata().getHttpStatusCode() == 200) {
                source = Source$.MODULE$.single((Object)BoxedUnit.UNIT);
            } else {
                int statusCode = response.getSdkHttpMetadata().getHttpStatusCode();
                source = Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).toString()));
            }
            return source;
        });
    }

    @Override
    public Source<BoxedUnit, NotUsed> save(SnapshotMetadata snapshotMetadata, Object snapshot) {
        Source source;
        Either<Throwable, SnapshotRow> either = this.serializer().serialize(snapshotMetadata, snapshot);
        if (either instanceof Right) {
            Right right = (Right)either;
            SnapshotRow snapshotRow = (SnapshotRow)right.value();
            PutItemRequest req = new PutItemRequest().withTableName(this.pluginConfig.tableName()).withItem((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig.columnsDefConfig().persistenceIdColumnName()), (Object)new AttributeValue().withS(snapshotRow.persistenceId().asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig.columnsDefConfig().sequenceNrColumnName()), (Object)new AttributeValue().withN(snapshotRow.sequenceNumber().asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig.columnsDefConfig().snapshotColumnName()), (Object)new AttributeValue().withB(ByteBuffer.wrap(snapshotRow.snapshot()))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig.columnsDefConfig().createdColumnName()), (Object)new AttributeValue().withN(((Object)BoxesRunTime.boxToLong((long)snapshotRow.created())).toString()))}))).asJava());
            source = (Source)Source$.MODULE$.single((Object)req).via((Graph)this.streamWriteClient().putItemFlow()).flatMapConcat((Function1 & Serializable & scala.Serializable)response -> {
                Source source;
                if (response.getSdkHttpMetadata().getHttpStatusCode() == 200) {
                    source = Source$.MODULE$.single((Object)BoxedUnit.UNIT);
                } else {
                    int statusCode = response.getSdkHttpMetadata().getHttpStatusCode();
                    source = Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).toString()));
                }
                return source;
            });
        } else if (either instanceof Left) {
            Left left = (Left)either;
            Throwable ex = (Throwable)left.value();
            source = Source$.MODULE$.failed(ex);
        } else {
            throw new MatchError(either);
        }
        return source;
    }

    private Source<BoxedUnit, NotUsed> queryDelete(QueryRequest queryRequest) {
        return (Source)((Source)Source$.MODULE$.single((Object)queryRequest).via((Graph)this.streamReadClient().queryFlow()).map((Function1 & Serializable & scala.Serializable)v -> (Seq)Option$.MODULE$.apply((Object)v.getItems()).map((Function1 & Serializable & scala.Serializable)x$5 -> (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(x$5).asScala()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)scala.collection.Seq$.MODULE$.empty())).mapConcat((Function1 & Serializable & scala.Serializable)x$6 -> x$6.toVector()).grouped(this.pluginConfig.clientConfig().batchWriteItemLimit()).map((Function1 & Serializable & scala.Serializable)rows -> (scala.collection.immutable.Seq)rows.map((Function1 & Serializable & scala.Serializable)row -> {
            scala.collection.mutable.Map _row = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(row).asScala();
            PersistenceId x$1 = PersistenceId$.MODULE$.apply(((AttributeValue)_row.apply((Object)$this.pluginConfig.columnsDefConfig().persistenceIdColumnName())).getS());
            SequenceNumber x$2 = new SequenceNumber(new StringOps(Predef$.MODULE$.augmentString(((AttributeValue)_row.apply((Object)$this.pluginConfig.columnsDefConfig().sequenceNrColumnName())).getN())).toLong());
            byte[] x$3 = ((AttributeValue)_row.apply((Object)$this.pluginConfig.columnsDefConfig().snapshotColumnName())).getB().array();
            long x$4 = new StringOps(Predef$.MODULE$.augmentString(((AttributeValue)_row.apply((Object)$this.pluginConfig.columnsDefConfig().createdColumnName())).getN())).toLong();
            return new SnapshotRow(x$1, x$2, x$4, x$3);
        }, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)rows -> new BatchWriteItemRequest().withRequestItems((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.pluginConfig.tableName()), CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)rows.map((Function1 & Serializable & scala.Serializable)row -> new WriteRequest().withDeleteRequest(new DeleteRequest().withKey((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.pluginConfig.columnsDefConfig().persistenceIdColumnName()), (Object)new AttributeValue().withS(row.persistenceId().asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.pluginConfig.columnsDefConfig().sequenceNrColumnName()), (Object)new AttributeValue().withN(row.sequenceNumber().asString()))}))).asJava())), Seq$.MODULE$.canBuildFrom())).asJava())}))).asJava()))).via((Graph)this.streamWriteClient().batchWriteItemFlow()).flatMapConcat((Function1 & Serializable & scala.Serializable)response -> {
            Source source;
            if (response.getSdkHttpMetadata().getHttpStatusCode() == 200) {
                source = Source$.MODULE$.single((Object)BoxedUnit.UNIT);
            } else {
                int statusCode = response.getSdkHttpMetadata().getHttpStatusCode();
                source = Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).toString()));
            }
            return source;
        });
    }

    public V1SnapshotDaoImpl(ActorSystem system, Option<AmazonDynamoDBAsync> asyncClient, Option<AmazonDynamoDB> syncClient, Serialization serialization, SnapshotPluginConfig pluginConfig, ExecutionContext ec) {
        this.pluginConfig = pluginConfig;
        Tuple2 tuple2 = new Tuple2(asyncClient, syncClient);
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (None$.MODULE$.equals(option) && None$.MODULE$.equals(option2)) {
                throw new IllegalArgumentException("aws clients is both None");
            }
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        this.streamReadClient = new StreamReadClient(system, asyncClient, syncClient, (PluginConfig)pluginConfig, pluginConfig.readBackoffConfig());
        this.streamWriteClient = new StreamWriteClient(system, asyncClient, syncClient, (PluginConfig)pluginConfig, pluginConfig.writeBackoffConfig());
        this.serializer = new ByteArraySnapshotSerializer(serialization);
    }
}

