/*
 * Decompiled with CFR 0.152.
 */
package com.github.j5ik2o.akka.persistence.dynamodb.snapshot.dao;

import akka.NotUsed;
import akka.actor.ActorSystem;
import akka.persistence.SnapshotMetadata;
import akka.serialization.Serialization;
import akka.stream.Graph;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import com.github.j5ik2o.akka.persistence.dynamodb.client.v2.StreamReadClient;
import com.github.j5ik2o.akka.persistence.dynamodb.client.v2.StreamWriteClient;
import com.github.j5ik2o.akka.persistence.dynamodb.config.PluginConfig;
import com.github.j5ik2o.akka.persistence.dynamodb.config.SnapshotPluginConfig;
import com.github.j5ik2o.akka.persistence.dynamodb.metrics.MetricsReporter;
import com.github.j5ik2o.akka.persistence.dynamodb.model.PersistenceId;
import com.github.j5ik2o.akka.persistence.dynamodb.model.PersistenceId$;
import com.github.j5ik2o.akka.persistence.dynamodb.model.SequenceNumber;
import com.github.j5ik2o.akka.persistence.dynamodb.serialization.ByteArraySnapshotSerializer;
import com.github.j5ik2o.akka.persistence.dynamodb.snapshot.dao.SnapshotDao;
import com.github.j5ik2o.akka.persistence.dynamodb.snapshot.dao.SnapshotRow;
import java.io.IOException;
import java.io.Serializable;
import java.util.Optional;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteRequest;
import software.amazon.awssdk.services.dynamodb.model.PutItemRequest;
import software.amazon.awssdk.services.dynamodb.model.QueryRequest;
import software.amazon.awssdk.services.dynamodb.model.WriteRequest;

@ScalaSignature(bytes="\u0006\u0001\tub\u0001\u0002\u000e\u001c\u00051B\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005\u0001\"A\u0001\u000b\u0001B\u0001B\u0003%\u0011\u000b\u0003\u0005V\u0001\t\u0005\t\u0015!\u0003W\u0011!Y\u0006A!A!\u0002\u0013a\u0006\u0002\u00032\u0001\u0005\u0003\u0005\u000b\u0011B2\t\u000b)\u0004A\u0011A6\t\u000fM\u0004!\u0019!C\u0005i\"1Q\u0010\u0001Q\u0001\nUDqA \u0001C\u0002\u0013%q\u0010\u0003\u0005\u0002\b\u0001\u0001\u000b\u0011BA\u0001\u0011%\tI\u0001\u0001b\u0001\n\u0013\tY\u0001\u0003\u0005\u0002\u0018\u0001\u0001\u000b\u0011BA\u0007\u0011\u001d\tI\u0002\u0001C!\u00037Aq!!\u0016\u0001\t\u0003\n9\u0006C\u0004\u0002n\u0001!\t%a\u001c\t\u000f\u0005m\u0004\u0001\"\u0011\u0002~!9\u0011q\u0012\u0001\u0005B\u0005E\u0005bBAO\u0001\u0011%\u0011q\u0014\u0005\b\u0003_\u0004A\u0011IAy\u0011\u001d\tY\u0010\u0001C!\u0003{DqAa\u0002\u0001\t\u0003\u0012I\u0001C\u0004\u0003\u0014\u0001!\tE!\u0006\t\u000f\t\u0005\u0002\u0001\"\u0011\u0003$!9!q\u0006\u0001\u0005\n\tE\"!\u0005,3':\f\u0007o\u001d5pi\u0012\u000bw.S7qY*\u0011A$H\u0001\u0004I\u0006|'B\u0001\u0010 \u0003!\u0019h.\u00199tQ>$(B\u0001\u0011\"\u0003!!\u0017P\\1n_\u0012\u0014'B\u0001\u0012$\u0003-\u0001XM]:jgR,gnY3\u000b\u0005\u0011*\u0013\u0001B1lW\u0006T!AJ\u0014\u0002\r),\u0014n\u001b\u001ap\u0015\tA\u0013&\u0001\u0004hSRDWO\u0019\u0006\u0002U\u0005\u00191m\\7\u0004\u0001M\u0019\u0001!L\u001a\u0011\u00059\nT\"A\u0018\u000b\u0003A\nQa]2bY\u0006L!AM\u0018\u0003\r\u0005s\u0017PU3g!\t!T'D\u0001\u001c\u0013\t14DA\u0006T]\u0006\u00048\u000f[8u\t\u0006|\u0017AB:zgR,W\u000e\u0005\u0002:{5\t!H\u0003\u0002<y\u0005)\u0011m\u0019;pe*\tA%\u0003\u0002?u\tY\u0011i\u0019;peNK8\u000f^3n\u0003-\t7/\u001f8d\u00072LWM\u001c;\u0011\u00079\n5)\u0003\u0002C_\t1q\n\u001d;j_:\u0004\"\u0001\u0012(\u000e\u0003\u0015S!\u0001\t$\u000b\u0005\u001dC\u0015\u0001C:feZL7-Z:\u000b\u0005%S\u0015AB1xgN$7N\u0003\u0002L\u0019\u00061\u0011-\\1{_:T\u0011!T\u0001\tg>4Go^1sK&\u0011q*\u0012\u0002\u0014\tft\u0017-\\8EE\u0006\u001b\u0018P\\2DY&,g\u000e^\u0001\u000bgft7m\u00117jK:$\bc\u0001\u0018B%B\u0011AiU\u0005\u0003)\u0016\u0013a\u0002R=oC6|GIY\"mS\u0016tG/A\u0007tKJL\u0017\r\\5{CRLwN\u001c\t\u0003/fk\u0011\u0001\u0017\u0006\u0003+rJ!A\u0017-\u0003\u001bM+'/[1mSj\fG/[8o\u00031\u0001H.^4j]\u000e{gNZ5h!\ti\u0006-D\u0001_\u0015\tyv$\u0001\u0004d_:4\u0017nZ\u0005\u0003Cz\u0013Ac\u00158baNDw\u000e\u001e)mk\u001eLgnQ8oM&<\u0017aD7fiJL7m\u001d*fa>\u0014H/\u001a:\u0011\u00079\nE\r\u0005\u0002fQ6\taM\u0003\u0002h?\u00059Q.\u001a;sS\u000e\u001c\u0018BA5g\u0005=iU\r\u001e:jGN\u0014V\r]8si\u0016\u0014\u0018A\u0002\u001fj]&$h\bF\u0004m[:|\u0007/\u001d:\u0011\u0005Q\u0002\u0001\"B\u001c\b\u0001\u0004A\u0004\"B \b\u0001\u0004\u0001\u0005\"\u0002)\b\u0001\u0004\t\u0006\"B+\b\u0001\u00041\u0006\"B.\b\u0001\u0004a\u0006\"\u00022\b\u0001\u0004\u0019\u0017\u0001E:ue\u0016\fWNU3bI\u000ec\u0017.\u001a8u+\u0005)\bC\u0001<|\u001b\u00059(B\u0001=z\u0003\t1(G\u0003\u0002{?\u000511\r\\5f]RL!\u0001`<\u0003!M#(/Z1n%\u0016\fGm\u00117jK:$\u0018!E:ue\u0016\fWNU3bI\u000ec\u0017.\u001a8uA\u0005\t2\u000f\u001e:fC6<&/\u001b;f\u00072LWM\u001c;\u0016\u0005\u0005\u0005\u0001c\u0001<\u0002\u0004%\u0019\u0011QA<\u0003#M#(/Z1n/JLG/Z\"mS\u0016tG/\u0001\ntiJ,\u0017-\\,sSR,7\t\\5f]R\u0004\u0013AC:fe&\fG.\u001b>feV\u0011\u0011Q\u0002\t\u0005\u0003\u001f\t\u0019\"\u0004\u0002\u0002\u0012)\u0011QkH\u0005\u0005\u0003+\t\tBA\u000eCsR,\u0017I\u001d:bsNs\u0017\r]:i_R\u001cVM]5bY&TXM]\u0001\fg\u0016\u0014\u0018.\u00197ju\u0016\u0014\b%\u0001\u0004eK2,G/\u001a\u000b\u0007\u0003;\tY$a\u0013\u0011\u0011\u0005}\u0011\u0011FA\u0017\u0003gi!!!\t\u000b\t\u0005\r\u0012QE\u0001\tg\u000e\fG.\u00193tY*\u0019\u0011q\u0005\u001f\u0002\rM$(/Z1n\u0013\u0011\tY#!\t\u0003\rM{WO]2f!\rq\u0013qF\u0005\u0004\u0003cy#\u0001B+oSR\u0004B!!\u000e\u000285\tA(C\u0002\u0002:q\u0012qAT8u+N,G\rC\u0004\u0002>9\u0001\r!a\u0010\u0002\u001bA,'o]5ti\u0016t7-Z%e!\u0011\t\t%a\u0012\u000e\u0005\u0005\r#bAA#?\u0005)Qn\u001c3fY&!\u0011\u0011JA\"\u00055\u0001VM]:jgR,gnY3JI\"9\u0011Q\n\bA\u0002\u0005=\u0013AC:fcV,gnY3OeB!\u0011\u0011IA)\u0013\u0011\t\u0019&a\u0011\u0003\u001dM+\u0017/^3oG\u0016tU/\u001c2fe\u0006\u0011B-\u001a7fi\u0016\fE\u000e\\*oCB\u001c\bn\u001c;t)\u0011\tI&a\u001b\u0015\t\u0005u\u00111\f\u0005\b\u0003;z\u00019AA0\u0003\t)7\r\u0005\u0003\u0002b\u0005\u001dTBAA2\u0015\r\t)gL\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002BA5\u0003G\u0012\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\t\u000f\u0005ur\u00021\u0001\u0002@\u00059B-\u001a7fi\u0016,\u0006\u000fV8NCb\u001cV-];f]\u000e,gJ\u001d\u000b\u0007\u0003c\n)(a\u001e\u0015\t\u0005u\u00111\u000f\u0005\b\u0003;\u0002\u00029AA0\u0011\u001d\ti\u0004\u0005a\u0001\u0003\u007fAq!!\u001f\u0011\u0001\u0004\ty%A\u0007nCb\u001cV-];f]\u000e,gJ]\u0001\u0017I\u0016dW\r^3VaR{W*\u0019=US6,7\u000f^1naR1\u0011qPAB\u0003\u000b#B!!\b\u0002\u0002\"9\u0011QL\tA\u0004\u0005}\u0003bBA\u001f#\u0001\u0007\u0011q\b\u0005\b\u0003\u000f\u000b\u0002\u0019AAE\u00031i\u0017\r\u001f+j[\u0016\u001cH/Y7q!\rq\u00131R\u0005\u0004\u0003\u001b{#\u0001\u0002'p]\u001e\fa\u0005Z3mKR,W\u000b\u001d+p\u001b\u0006D8+Z9vK:\u001cWM\u0014:B]\u0012l\u0015\r\u001f+j[\u0016\u001cH/Y7q)!\t\u0019*a&\u0002\u001a\u0006mE\u0003BA\u000f\u0003+Cq!!\u0018\u0013\u0001\b\ty\u0006C\u0004\u0002>I\u0001\r!a\u0010\t\u000f\u0005e$\u00031\u0001\u0002P!9\u0011q\u0011\nA\u0002\u0005%\u0015a\u00033fg\u0016\u0014\u0018.\u00197ju\u0016$B!!)\u0002DR!\u00111UAa!\u0019\t\t'!*\u0002*&!\u0011qUA2\u0005\u00191U\u000f^;sKB!a&QAV!\u001dq\u0013QVAY\u0003wK1!a,0\u0005\u0019!V\u000f\u001d7feA!\u00111WA\\\u001b\t\t)L\u0003\u0002#y%!\u0011\u0011XA[\u0005A\u0019f.\u00199tQ>$X*\u001a;bI\u0006$\u0018\rE\u0002/\u0003{K1!a00\u0005\r\te.\u001f\u0005\b\u0003;\u001a\u00029AA0\u0011\u001d\t)m\u0005a\u0001\u0003\u000f\faA]8x\u001fB$\b\u0003\u0002\u0018B\u0003\u0013\u0004\u0002\"a3\u0002Z\u0006}\u0017Q\u001d\b\u0005\u0003\u001b\f)\u000eE\u0002\u0002P>j!!!5\u000b\u0007\u0005M7&\u0001\u0004=e>|GOP\u0005\u0004\u0003/|\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002\\\u0006u'aA'ba*\u0019\u0011q[\u0018\u0011\t\u0005-\u0017\u0011]\u0005\u0005\u0003G\fiN\u0001\u0004TiJLgn\u001a\t\u0005\u0003O\fY/\u0004\u0002\u0002j*\u0019\u0011QI#\n\t\u00055\u0018\u0011\u001e\u0002\u000f\u0003R$(/\u001b2vi\u00164\u0016\r\\;f\u00039a\u0017\r^3tiNs\u0017\r]:i_R$B!a=\u0002zR!\u0011Q_A|!!\ty\"!\u000b\u0002*\u0006M\u0002bBA/)\u0001\u000f\u0011q\f\u0005\b\u0003{!\u0002\u0019AA \u0003]\u0019h.\u00199tQ>$hi\u001c:NCb$\u0016.\\3ti\u0006l\u0007\u000f\u0006\u0004\u0002\u0000\n\r!Q\u0001\u000b\u0005\u0003k\u0014\t\u0001C\u0004\u0002^U\u0001\u001d!a\u0018\t\u000f\u0005uR\u00031\u0001\u0002@!9\u0011qQ\u000bA\u0002\u0005%\u0015\u0001G:oCB\u001c\bn\u001c;G_Jl\u0015\r_*fcV,gnY3OeR1!1\u0002B\b\u0005#!B!!>\u0003\u000e!9\u0011Q\f\fA\u0004\u0005}\u0003bBA\u001f-\u0001\u0007\u0011q\b\u0005\b\u0003s2\u0002\u0019AA(\u0003\u001d\u001ah.\u00199tQ>$hi\u001c:NCb\u001cV-];f]\u000e,gJ]!oI6\u000b\u0007\u0010V5nKN$\u0018-\u001c9\u0015\u0011\t]!1\u0004B\u000f\u0005?!B!!>\u0003\u001a!9\u0011QL\fA\u0004\u0005}\u0003bBA\u001f/\u0001\u0007\u0011q\b\u0005\b\u0003s:\u0002\u0019AA(\u0011\u001d\t9i\u0006a\u0001\u0003\u0013\u000bAa]1wKR1!Q\u0005B\u0015\u0005[!B!!\b\u0003(!9\u0011Q\f\rA\u0004\u0005}\u0003b\u0002B\u00161\u0001\u0007\u0011\u0011W\u0001\u0011g:\f\u0007o\u001d5pi6+G/\u00193bi\u0006DaA\b\rA\u0002\u0005m\u0016aC9vKJLH)\u001a7fi\u0016$B!!\b\u00034!9!QG\rA\u0002\t]\u0012\u0001D9vKJL(+Z9vKN$\b\u0003BAt\u0005sIAAa\u000f\u0002j\na\u0011+^3ssJ+\u0017/^3ti\u0002")
public final class V2SnapshotDaoImpl
implements SnapshotDao {
    private final SnapshotPluginConfig pluginConfig;
    private final StreamReadClient streamReadClient;
    private final StreamWriteClient streamWriteClient;
    private final ByteArraySnapshotSerializer serializer;

    private StreamReadClient streamReadClient() {
        return this.streamReadClient;
    }

    private StreamWriteClient streamWriteClient() {
        return this.streamWriteClient;
    }

    private ByteArraySnapshotSerializer serializer() {
        return this.serializer;
    }

    @Override
    public Source<BoxedUnit, NotUsed> delete(PersistenceId persistenceId, SequenceNumber sequenceNr) {
        DeleteItemRequest req = (DeleteItemRequest)DeleteItemRequest.builder().tableName(this.pluginConfig.tableName()).key((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig.columnsDefConfig().persistenceIdColumnName()), AttributeValue.builder().s(persistenceId.asString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig.columnsDefConfig().sequenceNrColumnName()), AttributeValue.builder().n(sequenceNr.asString()).build())}))).asJava()).build();
        return (Source)Source$.MODULE$.single((Object)req).via((Graph)this.streamWriteClient().deleteItemFlow()).flatMapConcat((Function1 & Serializable & scala.Serializable)response -> {
            Source source;
            if (response.sdkHttpResponse().isSuccessful()) {
                source = Source$.MODULE$.single((Object)BoxedUnit.UNIT);
            } else {
                int statusCode = response.sdkHttpResponse().statusCode();
                Optional statusText = response.sdkHttpResponse().statusText();
                source = Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).append(OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(statusText)).fold((Function0 & Serializable & scala.Serializable)() -> "", (Function1 & Serializable & scala.Serializable)s -> new StringBuilder(2).append(", ").append((String)s).toString())).toString()));
            }
            return source;
        });
    }

    @Override
    public Source<BoxedUnit, NotUsed> deleteAllSnapshots(PersistenceId persistenceId, ExecutionContext ec) {
        QueryRequest queryRequest = (QueryRequest)QueryRequest.builder().tableName(this.pluginConfig.tableName()).keyConditionExpression("#pid = :pid and #snr between :min and :max").expressionAttributeNames((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginConfig.columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginConfig.columnsDefConfig().sequenceNrColumnName())}))).asJava()).expressionAttributeValues((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), AttributeValue.builder().s(persistenceId.asString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), AttributeValue.builder().n(((Object)BoxesRunTime.boxToInteger((int)0)).toString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), AttributeValue.builder().n(((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString()).build())}))).asJava()).consistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginConfig.consistentRead())).build();
        return this.queryDelete(queryRequest);
    }

    @Override
    public Source<BoxedUnit, NotUsed> deleteUpToMaxSequenceNr(PersistenceId persistenceId, SequenceNumber maxSequenceNr, ExecutionContext ec) {
        QueryRequest queryRequest = (QueryRequest)QueryRequest.builder().tableName(this.pluginConfig.tableName()).keyConditionExpression("#pid = :pid and #snr between :min and :max").expressionAttributeNames((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginConfig.columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginConfig.columnsDefConfig().sequenceNrColumnName())}))).asJava()).expressionAttributeValues((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), AttributeValue.builder().s(persistenceId.asString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), AttributeValue.builder().n(((Object)BoxesRunTime.boxToInteger((int)0)).toString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), AttributeValue.builder().n(maxSequenceNr.asString()).build())}))).asJava()).consistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginConfig.consistentRead())).build();
        return this.queryDelete(queryRequest);
    }

    @Override
    public Source<BoxedUnit, NotUsed> deleteUpToMaxTimestamp(PersistenceId persistenceId, long maxTimestamp, ExecutionContext ec) {
        QueryRequest queryRequest = (QueryRequest)QueryRequest.builder().tableName(this.pluginConfig.tableName()).keyConditionExpression("#pid = :pid and #snr between :min and :max").filterExpression("#created <= :maxTimestamp").expressionAttributeNames((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginConfig.columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginConfig.columnsDefConfig().sequenceNrColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#created"), (Object)this.pluginConfig.columnsDefConfig().createdColumnName())}))).asJava()).expressionAttributeValues((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), AttributeValue.builder().s(persistenceId.asString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), AttributeValue.builder().n(((Object)BoxesRunTime.boxToInteger((int)0)).toString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), AttributeValue.builder().n(((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":maxTimestamp"), AttributeValue.builder().n(((Object)BoxesRunTime.boxToLong((long)maxTimestamp)).toString()).build())}))).asJava()).consistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginConfig.consistentRead())).build();
        return this.queryDelete(queryRequest);
    }

    @Override
    public Source<BoxedUnit, NotUsed> deleteUpToMaxSequenceNrAndMaxTimestamp(PersistenceId persistenceId, SequenceNumber maxSequenceNr, long maxTimestamp, ExecutionContext ec) {
        QueryRequest queryRequest = (QueryRequest)QueryRequest.builder().tableName(this.pluginConfig.tableName()).keyConditionExpression("#pid = :pid and #snr between :min and :max").filterExpression("#created <= :maxTimestamp").expressionAttributeNames((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginConfig.columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginConfig.columnsDefConfig().sequenceNrColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#created"), (Object)this.pluginConfig.columnsDefConfig().createdColumnName())}))).asJava()).expressionAttributeValues((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), AttributeValue.builder().s(persistenceId.asString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), AttributeValue.builder().n(((Object)BoxesRunTime.boxToInteger((int)0)).toString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), AttributeValue.builder().n(maxSequenceNr.asString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":maxTimestamp"), AttributeValue.builder().n(((Object)BoxesRunTime.boxToLong((long)maxTimestamp)).toString()).build())}))).asJava()).consistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginConfig.consistentRead())).build();
        return this.queryDelete(queryRequest);
    }

    private Future<Option<Tuple2<SnapshotMetadata, Object>>> deserialize(Option<scala.collection.immutable.Map<String, AttributeValue>> rowOpt, ExecutionContext ec) {
        Future future;
        Option<scala.collection.immutable.Map<String, AttributeValue>> option = rowOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            scala.collection.immutable.Map row = (scala.collection.immutable.Map)some.value();
            PersistenceId x$12 = PersistenceId$.MODULE$.apply(((AttributeValue)row.apply((Object)this.pluginConfig.columnsDefConfig().persistenceIdColumnName())).s());
            SequenceNumber x$2 = new SequenceNumber(new StringOps(Predef$.MODULE$.augmentString(((AttributeValue)row.apply((Object)this.pluginConfig.columnsDefConfig().sequenceNrColumnName())).n())).toLong());
            byte[] x$3 = ((AttributeValue)row.apply((Object)this.pluginConfig.columnsDefConfig().snapshotColumnName())).b().asByteArray();
            long x$4 = new StringOps(Predef$.MODULE$.augmentString(((AttributeValue)row.apply((Object)this.pluginConfig.columnsDefConfig().createdColumnName())).n())).toLong();
            future = this.serializer().deserialize(new SnapshotRow(x$12, x$2, x$4, x$3), ec).map((Function1 & Serializable & scala.Serializable)x$1 -> new Some(x$1), ec);
        } else if (None$.MODULE$.equals(option)) {
            future = Future$.MODULE$.successful((Object)None$.MODULE$);
        } else {
            throw new MatchError(option);
        }
        return future;
    }

    @Override
    public Source<Option<Tuple2<SnapshotMetadata, Object>>, NotUsed> latestSnapshot(PersistenceId persistenceId, ExecutionContext ec) {
        QueryRequest queryRequest = (QueryRequest)QueryRequest.builder().tableName(this.pluginConfig.tableName()).keyConditionExpression("#pid = :pid and #snr between :min and :max").expressionAttributeNames((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginConfig.columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginConfig.columnsDefConfig().sequenceNrColumnName())}))).asJava()).expressionAttributeValues((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), AttributeValue.builder().s(persistenceId.asString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), AttributeValue.builder().n(((Object)BoxesRunTime.boxToInteger((int)0)).toString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), AttributeValue.builder().n(((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString()).build())}))).asJava()).scanIndexForward(Predef$.MODULE$.boolean2Boolean(false)).limit(Predef$.MODULE$.int2Integer(1)).consistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginConfig.consistentRead())).build();
        return (Source)Source$.MODULE$.single((Object)queryRequest).via((Graph)this.streamReadClient().queryFlow()).flatMapConcat((Function1 & Serializable & scala.Serializable)response -> {
            Source source;
            if (response.sdkHttpResponse().isSuccessful()) {
                source = Source$.MODULE$.single((Object)((TraversableLike)((TraversableLike)Option$.MODULE$.apply((Object)response.items()).map((Function1 & Serializable & scala.Serializable)x$2 -> (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(x$2).asScala()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)scala.collection.Seq$.MODULE$.empty())).map((Function1 & Serializable & scala.Serializable)x$3 -> ((TraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter(x$3).asScala()).toMap(Predef$.MODULE$.$conforms()), scala.collection.Seq$.MODULE$.canBuildFrom())).headOption());
            } else {
                int statusCode = response.sdkHttpResponse().statusCode();
                Optional statusText = response.sdkHttpResponse().statusText();
                source = Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).append(OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(statusText)).fold((Function0 & Serializable & scala.Serializable)() -> "", (Function1 & Serializable & scala.Serializable)s -> new StringBuilder(2).append(", ").append((String)s).toString())).toString()));
            }
            return source;
        }).mapAsync(1, (Function1 & Serializable & scala.Serializable)rowOpt -> this.deserialize((Option<scala.collection.immutable.Map<String, AttributeValue>>)rowOpt, ec));
    }

    @Override
    public Source<Option<Tuple2<SnapshotMetadata, Object>>, NotUsed> snapshotForMaxTimestamp(PersistenceId persistenceId, long maxTimestamp, ExecutionContext ec) {
        QueryRequest queryRequest = (QueryRequest)QueryRequest.builder().tableName(this.pluginConfig.tableName()).keyConditionExpression("#pid = :pid and #snr between :min and :max").filterExpression("#created <= :maxTimestamp").expressionAttributeNames((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginConfig.columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginConfig.columnsDefConfig().sequenceNrColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#created"), (Object)this.pluginConfig.columnsDefConfig().createdColumnName())}))).asJava()).expressionAttributeValues((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), AttributeValue.builder().s(persistenceId.asString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), AttributeValue.builder().n(((Object)BoxesRunTime.boxToInteger((int)0)).toString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), AttributeValue.builder().n(((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":maxTimestamp"), AttributeValue.builder().n(((Object)BoxesRunTime.boxToLong((long)maxTimestamp)).toString()).build())}))).asJava()).scanIndexForward(Predef$.MODULE$.boolean2Boolean(false)).consistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginConfig.consistentRead())).build();
        return (Source)Source$.MODULE$.single((Object)queryRequest).via((Graph)this.streamReadClient().queryFlow()).flatMapConcat((Function1 & Serializable & scala.Serializable)response -> {
            Source source;
            if (response.sdkHttpResponse().isSuccessful()) {
                source = Source$.MODULE$.single((Object)((TraversableLike)((TraversableLike)Option$.MODULE$.apply((Object)response.items()).map((Function1 & Serializable & scala.Serializable)x$4 -> (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(x$4).asScala()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)scala.collection.Seq$.MODULE$.empty())).map((Function1 & Serializable & scala.Serializable)x$5 -> ((TraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter(x$5).asScala()).toMap(Predef$.MODULE$.$conforms()), scala.collection.Seq$.MODULE$.canBuildFrom())).headOption());
            } else {
                int statusCode = response.sdkHttpResponse().statusCode();
                Optional statusText = response.sdkHttpResponse().statusText();
                source = Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).append(OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(statusText)).fold((Function0 & Serializable & scala.Serializable)() -> "", (Function1 & Serializable & scala.Serializable)s -> new StringBuilder(2).append(", ").append((String)s).toString())).toString()));
            }
            return source;
        }).mapAsync(1, (Function1 & Serializable & scala.Serializable)rowOpt -> this.deserialize((Option<scala.collection.immutable.Map<String, AttributeValue>>)rowOpt, ec));
    }

    @Override
    public Source<Option<Tuple2<SnapshotMetadata, Object>>, NotUsed> snapshotForMaxSequenceNr(PersistenceId persistenceId, SequenceNumber maxSequenceNr, ExecutionContext ec) {
        QueryRequest queryRequest = (QueryRequest)QueryRequest.builder().tableName(this.pluginConfig.tableName()).keyConditionExpression("#pid = :pid and #snr between :min and :max").expressionAttributeNames((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginConfig.columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginConfig.columnsDefConfig().sequenceNrColumnName())}))).asJava()).expressionAttributeValues((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), AttributeValue.builder().s(persistenceId.asString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), AttributeValue.builder().n(((Object)BoxesRunTime.boxToInteger((int)0)).toString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), AttributeValue.builder().n(maxSequenceNr.asString()).build())}))).asJava()).scanIndexForward(Predef$.MODULE$.boolean2Boolean(false)).consistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginConfig.consistentRead())).build();
        return (Source)Source$.MODULE$.single((Object)queryRequest).via((Graph)this.streamReadClient().queryFlow()).flatMapConcat((Function1 & Serializable & scala.Serializable)response -> {
            Source source;
            if (response.sdkHttpResponse().isSuccessful()) {
                source = Source$.MODULE$.single((Object)((TraversableLike)((TraversableLike)Option$.MODULE$.apply((Object)response.items()).map((Function1 & Serializable & scala.Serializable)x$6 -> (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(x$6).asScala()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)scala.collection.Seq$.MODULE$.empty())).map((Function1 & Serializable & scala.Serializable)x$7 -> ((TraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter(x$7).asScala()).toMap(Predef$.MODULE$.$conforms()), scala.collection.Seq$.MODULE$.canBuildFrom())).headOption());
            } else {
                int statusCode = response.sdkHttpResponse().statusCode();
                Optional statusText = response.sdkHttpResponse().statusText();
                source = Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).append(OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(statusText)).fold((Function0 & Serializable & scala.Serializable)() -> "", (Function1 & Serializable & scala.Serializable)s -> new StringBuilder(2).append(", ").append((String)s).toString())).toString()));
            }
            return source;
        }).mapAsync(1, (Function1 & Serializable & scala.Serializable)rowOpt -> this.deserialize((Option<scala.collection.immutable.Map<String, AttributeValue>>)rowOpt, ec));
    }

    @Override
    public Source<Option<Tuple2<SnapshotMetadata, Object>>, NotUsed> snapshotForMaxSequenceNrAndMaxTimestamp(PersistenceId persistenceId, SequenceNumber maxSequenceNr, long maxTimestamp, ExecutionContext ec) {
        QueryRequest queryRequest = (QueryRequest)QueryRequest.builder().tableName(this.pluginConfig.tableName()).keyConditionExpression("#pid = :pid and #snr between :min and :max").filterExpression("#created <= :maxTimestamp").expressionAttributeNames((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginConfig.columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginConfig.columnsDefConfig().sequenceNrColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#created"), (Object)this.pluginConfig.columnsDefConfig().createdColumnName())}))).asJava()).expressionAttributeValues((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), AttributeValue.builder().s(persistenceId.asString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), AttributeValue.builder().n(((Object)BoxesRunTime.boxToInteger((int)0)).toString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), AttributeValue.builder().n(maxSequenceNr.asString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":maxTimestamp"), AttributeValue.builder().n(((Object)BoxesRunTime.boxToLong((long)maxTimestamp)).toString()).build())}))).asJava()).scanIndexForward(Predef$.MODULE$.boolean2Boolean(false)).consistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginConfig.consistentRead())).build();
        return (Source)Source$.MODULE$.single((Object)queryRequest).via((Graph)this.streamReadClient().queryFlow()).flatMapConcat((Function1 & Serializable & scala.Serializable)response -> {
            Source source;
            if (response.sdkHttpResponse().isSuccessful()) {
                source = Source$.MODULE$.single((Object)((TraversableLike)((TraversableLike)Option$.MODULE$.apply((Object)response.items()).map((Function1 & Serializable & scala.Serializable)x$8 -> (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(x$8).asScala()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)scala.collection.Seq$.MODULE$.empty())).map((Function1 & Serializable & scala.Serializable)x$9 -> ((TraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter(x$9).asScala()).toMap(Predef$.MODULE$.$conforms()), scala.collection.Seq$.MODULE$.canBuildFrom())).headOption());
            } else {
                int statusCode = response.sdkHttpResponse().statusCode();
                Optional statusText = response.sdkHttpResponse().statusText();
                source = Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).append(OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(statusText)).fold((Function0 & Serializable & scala.Serializable)() -> "", (Function1 & Serializable & scala.Serializable)s -> new StringBuilder(2).append(", ").append((String)s).toString())).toString()));
            }
            return source;
        }).mapAsync(1, (Function1 & Serializable & scala.Serializable)rowOpt -> this.deserialize((Option<scala.collection.immutable.Map<String, AttributeValue>>)rowOpt, ec));
    }

    @Override
    public Source<BoxedUnit, NotUsed> save(SnapshotMetadata snapshotMetadata, Object snapshot, ExecutionContext ec) {
        return (Source)Source$.MODULE$.future(this.serializer().serialize(snapshotMetadata, snapshot, ec)).flatMapConcat((Function1 & Serializable & scala.Serializable)snapshotRow -> {
            PutItemRequest req = (PutItemRequest)PutItemRequest.builder().tableName($this.pluginConfig.tableName()).item((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.pluginConfig.columnsDefConfig().persistenceIdColumnName()), AttributeValue.builder().s(snapshotRow.persistenceId().asString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.pluginConfig.columnsDefConfig().sequenceNrColumnName()), AttributeValue.builder().n(snapshotRow.sequenceNumber().asString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.pluginConfig.columnsDefConfig().snapshotColumnName()), AttributeValue.builder().b(SdkBytes.fromByteArray((byte[])snapshotRow.snapshot())).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.pluginConfig.columnsDefConfig().createdColumnName()), AttributeValue.builder().n(((Object)BoxesRunTime.boxToLong((long)snapshotRow.created())).toString()).build())}))).asJava()).build();
            return (Source)Source$.MODULE$.single((Object)req).via((Graph)this.streamWriteClient().putItemFlow()).flatMapConcat((Function1 & Serializable & scala.Serializable)response -> {
                Source source;
                if (response.sdkHttpResponse().isSuccessful()) {
                    source = Source$.MODULE$.single((Object)BoxedUnit.UNIT);
                } else {
                    int statusCode = response.sdkHttpResponse().statusCode();
                    Optional statusText = response.sdkHttpResponse().statusText();
                    source = Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).append(OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(statusText)).fold((Function0 & Serializable & scala.Serializable)() -> "", (Function1 & Serializable & scala.Serializable)s -> new StringBuilder(2).append(", ").append((String)s).toString())).toString()));
                }
                return source;
            });
        });
    }

    private Source<BoxedUnit, NotUsed> queryDelete(QueryRequest queryRequest) {
        return (Source)((Source)Source$.MODULE$.single((Object)queryRequest).via((Graph)this.streamReadClient().queryFlow()).map((Function1 & Serializable & scala.Serializable)response -> (Seq)Option$.MODULE$.apply((Object)response.items()).map((Function1 & Serializable & scala.Serializable)x$10 -> (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(x$10).asScala()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)scala.collection.Seq$.MODULE$.empty())).mapConcat((Function1 & Serializable & scala.Serializable)x$11 -> x$11.toVector()).grouped(this.pluginConfig.clientConfig().batchWriteItemLimit()).map((Function1 & Serializable & scala.Serializable)rows -> (scala.collection.immutable.Seq)rows.map((Function1 & Serializable & scala.Serializable)javaRow -> {
            scala.collection.mutable.Map row = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(javaRow).asScala();
            PersistenceId x$1 = PersistenceId$.MODULE$.apply(((AttributeValue)row.apply((Object)$this.pluginConfig.columnsDefConfig().persistenceIdColumnName())).s());
            SequenceNumber x$2 = new SequenceNumber(new StringOps(Predef$.MODULE$.augmentString(((AttributeValue)row.apply((Object)$this.pluginConfig.columnsDefConfig().sequenceNrColumnName())).n())).toLong());
            byte[] x$3 = ((AttributeValue)row.apply((Object)$this.pluginConfig.columnsDefConfig().snapshotColumnName())).b().asByteArray();
            long x$4 = new StringOps(Predef$.MODULE$.augmentString(((AttributeValue)row.apply((Object)$this.pluginConfig.columnsDefConfig().createdColumnName())).n())).toLong();
            return new SnapshotRow(x$1, x$2, x$4, x$3);
        }, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)rows -> (BatchWriteItemRequest)BatchWriteItemRequest.builder().requestItems((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.pluginConfig.tableName()), CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)rows.map((Function1 & Serializable & scala.Serializable)row -> (WriteRequest)WriteRequest.builder().deleteRequest((DeleteRequest)DeleteRequest.builder().key((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.pluginConfig.columnsDefConfig().persistenceIdColumnName()), AttributeValue.builder().s(row.persistenceId().asString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.pluginConfig.columnsDefConfig().sequenceNrColumnName()), AttributeValue.builder().n(row.sequenceNumber().asString()).build())}))).asJava()).build()).build(), Seq$.MODULE$.canBuildFrom())).asJava())}))).asJava()).build())).via((Graph)this.streamWriteClient().batchWriteItemFlow()).flatMapConcat((Function1 & Serializable & scala.Serializable)response -> {
            Source source;
            if (response.sdkHttpResponse().isSuccessful()) {
                source = Source$.MODULE$.single((Object)BoxedUnit.UNIT);
            } else {
                int statusCode = response.sdkHttpResponse().statusCode();
                Optional statusText = response.sdkHttpResponse().statusText();
                source = Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).append(OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(statusText)).fold((Function0 & Serializable & scala.Serializable)() -> "", (Function1 & Serializable & scala.Serializable)s -> new StringBuilder(2).append(", ").append((String)s).toString())).toString()));
            }
            return source;
        });
    }

    public V2SnapshotDaoImpl(ActorSystem system, Option<DynamoDbAsyncClient> asyncClient, Option<DynamoDbClient> syncClient, Serialization serialization, SnapshotPluginConfig pluginConfig, Option<MetricsReporter> metricsReporter) {
        this.pluginConfig = pluginConfig;
        Tuple2 tuple2 = new Tuple2(asyncClient, syncClient);
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (None$.MODULE$.equals(option) && None$.MODULE$.equals(option2)) {
                throw new IllegalArgumentException("aws clients is both None");
            }
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        this.streamReadClient = new StreamReadClient(system, asyncClient, syncClient, (PluginConfig)pluginConfig, pluginConfig.readBackoffConfig());
        this.streamWriteClient = new StreamWriteClient(system, asyncClient, syncClient, (PluginConfig)pluginConfig, pluginConfig.writeBackoffConfig());
        this.serializer = new ByteArraySnapshotSerializer(serialization, metricsReporter);
    }
}

