/*
 * Decompiled with CFR 0.152.
 */
package com.github.j5ik2o.akka.persistence.dynamodb.snapshot.dao;

import akka.NotUsed;
import akka.actor.ActorSystem;
import akka.persistence.SnapshotMetadata;
import akka.serialization.Serialization;
import akka.stream.Graph;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBAsync;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteItemRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteRequest;
import com.amazonaws.services.dynamodbv2.model.PutItemRequest;
import com.amazonaws.services.dynamodbv2.model.QueryRequest;
import com.amazonaws.services.dynamodbv2.model.WriteRequest;
import com.github.j5ik2o.akka.persistence.dynamodb.client.v1.StreamReadClient;
import com.github.j5ik2o.akka.persistence.dynamodb.client.v1.StreamWriteClient;
import com.github.j5ik2o.akka.persistence.dynamodb.config.PluginConfig;
import com.github.j5ik2o.akka.persistence.dynamodb.config.SnapshotPluginConfig;
import com.github.j5ik2o.akka.persistence.dynamodb.metrics.MetricsReporter;
import com.github.j5ik2o.akka.persistence.dynamodb.model.PersistenceId;
import com.github.j5ik2o.akka.persistence.dynamodb.model.PersistenceId$;
import com.github.j5ik2o.akka.persistence.dynamodb.model.SequenceNumber;
import com.github.j5ik2o.akka.persistence.dynamodb.serialization.ByteArraySnapshotSerializer;
import com.github.j5ik2o.akka.persistence.dynamodb.snapshot.dao.SnapshotDao;
import com.github.j5ik2o.akka.persistence.dynamodb.snapshot.dao.SnapshotRow;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t]b\u0001\u0002\u000e\u001c\u00051B\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005\u0001\"AQ\n\u0001B\u0001B\u0003%a\n\u0003\u0005S\u0001\t\u0005\t\u0015!\u0003T\u0011!A\u0006A!A!\u0002\u0013I\u0006\u0002C0\u0001\u0005\u0003\u0005\u000b\u0011\u00021\t\u000b\u001d\u0004A\u0011\u00015\t\u000fA\u0004!\u0019!C\u0005c\"1!\u0010\u0001Q\u0001\nIDqa\u001f\u0001C\u0002\u0013%A\u0010C\u0004\u0002\u0002\u0001\u0001\u000b\u0011B?\t\u0013\u0005\r\u0001A1A\u0005\n\u0005\u0015\u0001\u0002CA\t\u0001\u0001\u0006I!a\u0002\t\u000f\u0005M\u0001\u0001\"\u0011\u0002\u0016!9\u0011q\u000b\u0001\u0005B\u0005e\u0003bBA6\u0001\u0011\u0005\u0013Q\u000e\u0005\b\u0003\u007f\u0002A\u0011IAA\u0011\u001d\ti\t\u0001C\u0005\u0003\u001fCq!a8\u0001\t\u0003\n\t\u000fC\u0004\u0002l\u0002!\t%!<\t\u000f\u0005]\b\u0001\"\u0011\u0002z\"9!1\u0001\u0001\u0005B\t\u0015\u0001b\u0002B\t\u0001\u0011\u0005#1\u0003\u0005\b\u00057\u0001A\u0011\tB\u000f\u0011\u001d\u0011I\u0003\u0001C\u0005\u0005W\u0011\u0011CV\u0019T]\u0006\u00048\u000f[8u\t\u0006|\u0017*\u001c9m\u0015\taR$A\u0002eC>T!AH\u0010\u0002\u0011Mt\u0017\r]:i_RT!\u0001I\u0011\u0002\u0011\u0011Lh.Y7pI\nT!AI\u0012\u0002\u0017A,'o]5ti\u0016t7-\u001a\u0006\u0003I\u0015\nA!Y6lC*\u0011aeJ\u0001\u0007UVJ7NM8\u000b\u0005!J\u0013AB4ji\",(MC\u0001+\u0003\r\u0019w.\\\u0002\u0001'\r\u0001Qf\r\t\u0003]Ej\u0011a\f\u0006\u0002a\u0005)1oY1mC&\u0011!g\f\u0002\u0007\u0003:L(+\u001a4\u0011\u0005Q*T\"A\u000e\n\u0005YZ\"aC*oCB\u001c\bn\u001c;EC>\faa]=ti\u0016l\u0007CA\u001d>\u001b\u0005Q$BA\u001e=\u0003\u0015\t7\r^8s\u0015\u0005!\u0013B\u0001 ;\u0005-\t5\r^8s'f\u001cH/Z7\u0002\u0017\u0005\u001c\u0018P\\2DY&,g\u000e\u001e\t\u0004]\u0005\u001b\u0015B\u0001\"0\u0005\u0019y\u0005\u000f^5p]B\u0011AiS\u0007\u0002\u000b*\u0011aiR\u0001\u000bIft\u0017-\\8eEZ\u0014$B\u0001%J\u0003!\u0019XM\u001d<jG\u0016\u001c(B\u0001&*\u0003%\tW.\u0019>p]\u0006<8/\u0003\u0002M\u000b\n\u0019\u0012)\\1{_:$\u0015P\\1n_\u0012\u0013\u0015i]=oG\u0006Q1/\u001f8d\u00072LWM\u001c;\u0011\u00079\nu\n\u0005\u0002E!&\u0011\u0011+\u0012\u0002\u000f\u00036\f'p\u001c8Es:\fWn\u001c#C\u00035\u0019XM]5bY&T\u0018\r^5p]B\u0011AKV\u0007\u0002+*\u0011!\u000bP\u0005\u0003/V\u0013QbU3sS\u0006d\u0017N_1uS>t\u0017\u0001\u00049mk\u001eLgnQ8oM&<\u0007C\u0001.^\u001b\u0005Y&B\u0001/ \u0003\u0019\u0019wN\u001c4jO&\u0011al\u0017\u0002\u0015':\f\u0007o\u001d5piBcWoZ5o\u0007>tg-[4\u0002\u001f5,GO]5dgJ+\u0007o\u001c:uKJ\u00042AL!b!\t\u0011W-D\u0001d\u0015\t!w$A\u0004nKR\u0014\u0018nY:\n\u0005\u0019\u001c'aD'fiJL7m\u001d*fa>\u0014H/\u001a:\u0002\rqJg.\u001b;?)\u001dI'n\u001b7n]>\u0004\"\u0001\u000e\u0001\t\u000b]:\u0001\u0019\u0001\u001d\t\u000b}:\u0001\u0019\u0001!\t\u000b5;\u0001\u0019\u0001(\t\u000bI;\u0001\u0019A*\t\u000ba;\u0001\u0019A-\t\u000b};\u0001\u0019\u00011\u0002!M$(/Z1n%\u0016\fGm\u00117jK:$X#\u0001:\u0011\u0005MDX\"\u0001;\u000b\u0005U4\u0018A\u0001<2\u0015\t9x$\u0001\u0004dY&,g\u000e^\u0005\u0003sR\u0014\u0001c\u0015;sK\u0006l'+Z1e\u00072LWM\u001c;\u0002#M$(/Z1n%\u0016\fGm\u00117jK:$\b%A\ttiJ,\u0017-\\,sSR,7\t\\5f]R,\u0012! \t\u0003gzL!a ;\u0003#M#(/Z1n/JLG/Z\"mS\u0016tG/\u0001\ntiJ,\u0017-\\,sSR,7\t\\5f]R\u0004\u0013AC:fe&\fG.\u001b>feV\u0011\u0011q\u0001\t\u0005\u0003\u0013\ti!\u0004\u0002\u0002\f)\u0011!kH\u0005\u0005\u0003\u001f\tYAA\u000eCsR,\u0017I\u001d:bsNs\u0017\r]:i_R\u001cVM]5bY&TXM]\u0001\fg\u0016\u0014\u0018.\u00197ju\u0016\u0014\b%\u0001\neK2,G/Z!mYNs\u0017\r]:i_R\u001cH\u0003BA\f\u0003\u000f\"B!!\u0007\u00028AA\u00111DA\u0013\u0003S\ty#\u0004\u0002\u0002\u001e)!\u0011qDA\u0011\u0003!\u00198-\u00197bINd'bAA\u0012y\u000511\u000f\u001e:fC6LA!a\n\u0002\u001e\t11k\\;sG\u0016\u00042ALA\u0016\u0013\r\tic\f\u0002\u0005+:LG\u000f\u0005\u0003\u00022\u0005MR\"\u0001\u001f\n\u0007\u0005UBHA\u0004O_R,6/\u001a3\t\u000f\u0005eb\u0002q\u0001\u0002<\u0005\u0011Qm\u0019\t\u0005\u0003{\t\u0019%\u0004\u0002\u0002@)\u0019\u0011\u0011I\u0018\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u0002F\u0005}\"\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0011\u001d\tIE\u0004a\u0001\u0003\u0017\nQ\u0002]3sg&\u001cH/\u001a8dK&#\u0007\u0003BA'\u0003'j!!a\u0014\u000b\u0007\u0005Es$A\u0003n_\u0012,G.\u0003\u0003\u0002V\u0005=#!\u0004)feNL7\u000f^3oG\u0016LE-A\feK2,G/Z+q)>l\u0015\r_*fcV,gnY3OeR1\u00111LA0\u0003C\"B!!\u0007\u0002^!9\u0011\u0011H\bA\u0004\u0005m\u0002bBA%\u001f\u0001\u0007\u00111\n\u0005\b\u0003Gz\u0001\u0019AA3\u00035i\u0017\r_*fcV,gnY3OeB!\u0011QJA4\u0013\u0011\tI'a\u0014\u0003\u001dM+\u0017/^3oG\u0016tU/\u001c2fe\u00061B-\u001a7fi\u0016,\u0006\u000fV8NCb$\u0016.\\3ti\u0006l\u0007\u000f\u0006\u0004\u0002p\u0005M\u0014Q\u000f\u000b\u0005\u00033\t\t\bC\u0004\u0002:A\u0001\u001d!a\u000f\t\u000f\u0005%\u0003\u00031\u0001\u0002L!9\u0011q\u000f\tA\u0002\u0005e\u0014\u0001D7bqRKW.Z:uC6\u0004\bc\u0001\u0018\u0002|%\u0019\u0011QP\u0018\u0003\t1{gnZ\u0001'I\u0016dW\r^3VaR{W*\u0019=TKF,XM\\2f\u001dJ\fe\u000eZ'bqRKW.Z:uC6\u0004H\u0003CAB\u0003\u000f\u000bI)a#\u0015\t\u0005e\u0011Q\u0011\u0005\b\u0003s\t\u00029AA\u001e\u0011\u001d\tI%\u0005a\u0001\u0003\u0017Bq!a\u0019\u0012\u0001\u0004\t)\u0007C\u0004\u0002xE\u0001\r!!\u001f\u0002\u0017\u0011,7/\u001a:jC2L'0\u001a\u000b\u0005\u0003#\u000b\u0019\f\u0006\u0003\u0002\u0014\u0006E\u0006CBA\u001f\u0003+\u000bI*\u0003\u0003\u0002\u0018\u0006}\"A\u0002$viV\u0014X\r\u0005\u0003/\u0003\u0006m\u0005c\u0002\u0018\u0002\u001e\u0006\u0005\u00161V\u0005\u0004\u0003?{#A\u0002+va2,'\u0007\u0005\u0003\u0002$\u0006\u001dVBAAS\u0015\t\u0011C(\u0003\u0003\u0002*\u0006\u0015&\u0001E*oCB\u001c\bn\u001c;NKR\fG-\u0019;b!\rq\u0013QV\u0005\u0004\u0003_{#aA!os\"9\u0011\u0011\b\nA\u0004\u0005m\u0002bBA[%\u0001\u0007\u0011qW\u0001\u0007e><x\n\u001d;\u0011\t9\n\u0015\u0011\u0018\t\t\u0003w\u000bI-a4\u0002V:!\u0011QXAc!\r\tylL\u0007\u0003\u0003\u0003T1!a1,\u0003\u0019a$o\\8u}%\u0019\u0011qY\u0018\u0002\rA\u0013X\rZ3g\u0013\u0011\tY-!4\u0003\u00075\u000b\u0007OC\u0002\u0002H>\u0002B!a/\u0002R&!\u00111[Ag\u0005\u0019\u0019FO]5oOB!\u0011q[An\u001b\t\tINC\u0002\u0002R\u0015KA!!8\u0002Z\nq\u0011\t\u001e;sS\n,H/\u001a,bYV,\u0017A\u00047bi\u0016\u001cHo\u00158baNDw\u000e\u001e\u000b\u0005\u0003G\fI\u000f\u0006\u0003\u0002f\u0006\u001d\b\u0003CA\u000e\u0003K\tI*a\f\t\u000f\u0005e2\u0003q\u0001\u0002<!9\u0011\u0011J\nA\u0002\u0005-\u0013aF:oCB\u001c\bn\u001c;G_Jl\u0015\r\u001f+j[\u0016\u001cH/Y7q)\u0019\ty/a=\u0002vR!\u0011Q]Ay\u0011\u001d\tI\u0004\u0006a\u0002\u0003wAq!!\u0013\u0015\u0001\u0004\tY\u0005C\u0004\u0002xQ\u0001\r!!\u001f\u00021Mt\u0017\r]:i_R4uN]'bqN+\u0017/^3oG\u0016t%\u000f\u0006\u0004\u0002|\u0006}(\u0011\u0001\u000b\u0005\u0003K\fi\u0010C\u0004\u0002:U\u0001\u001d!a\u000f\t\u000f\u0005%S\u00031\u0001\u0002L!9\u00111M\u000bA\u0002\u0005\u0015\u0014aJ:oCB\u001c\bn\u001c;G_Jl\u0015\r_*fcV,gnY3Oe\u0006sG-T1y)&lWm\u001d;b[B$\u0002Ba\u0002\u0003\f\t5!q\u0002\u000b\u0005\u0003K\u0014I\u0001C\u0004\u0002:Y\u0001\u001d!a\u000f\t\u000f\u0005%c\u00031\u0001\u0002L!9\u00111\r\fA\u0002\u0005\u0015\u0004bBA<-\u0001\u0007\u0011\u0011P\u0001\u0007I\u0016dW\r^3\u0015\r\u0005e!Q\u0003B\f\u0011\u001d\tIe\u0006a\u0001\u0003\u0017BqA!\u0007\u0018\u0001\u0004\t)'\u0001\u0006tKF,XM\\2f\u001dJ\fAa]1wKR1!q\u0004B\u0012\u0005O!B!!\u0007\u0003\"!9\u0011\u0011\b\rA\u0004\u0005m\u0002b\u0002B\u00131\u0001\u0007\u0011\u0011U\u0001\u0011g:\f\u0007o\u001d5pi6+G/\u00193bi\u0006DaA\b\rA\u0002\u0005-\u0016aC9vKJLH)\u001a7fi\u0016$B!!\u0007\u0003.!9!qF\rA\u0002\tE\u0012\u0001D9vKJL(+Z9vKN$\b\u0003BAl\u0005gIAA!\u000e\u0002Z\na\u0011+^3ssJ+\u0017/^3ti\u0002")
public final class V1SnapshotDaoImpl
implements SnapshotDao {
    private final SnapshotPluginConfig pluginConfig;
    private final StreamReadClient streamReadClient;
    private final StreamWriteClient streamWriteClient;
    private final ByteArraySnapshotSerializer serializer;

    private StreamReadClient streamReadClient() {
        return this.streamReadClient;
    }

    private StreamWriteClient streamWriteClient() {
        return this.streamWriteClient;
    }

    private ByteArraySnapshotSerializer serializer() {
        return this.serializer;
    }

    @Override
    public Source<BoxedUnit, NotUsed> deleteAllSnapshots(PersistenceId persistenceId, ExecutionContext ec) {
        QueryRequest queryRequest = new QueryRequest().withTableName(this.pluginConfig.tableName()).withKeyConditionExpression("#pid = :pid and #snr between :min and :max").withExpressionAttributeNames((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginConfig.columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginConfig.columnsDefConfig().sequenceNrColumnName())}))).asJava()).withExpressionAttributeValues((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), (Object)new AttributeValue().withS(persistenceId.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), (Object)new AttributeValue().withN(((Object)BoxesRunTime.boxToInteger((int)0)).toString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), (Object)new AttributeValue().withN(((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString()))}))).asJava()).withConsistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginConfig.consistentRead()));
        return this.queryDelete(queryRequest);
    }

    @Override
    public Source<BoxedUnit, NotUsed> deleteUpToMaxSequenceNr(PersistenceId persistenceId, SequenceNumber maxSequenceNr, ExecutionContext ec) {
        QueryRequest queryRequest = new QueryRequest().withTableName(this.pluginConfig.tableName()).withKeyConditionExpression("#pid = :pid and #snr between :min and :max").withExpressionAttributeNames((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginConfig.columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginConfig.columnsDefConfig().sequenceNrColumnName())}))).asJava()).withExpressionAttributeValues((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), (Object)new AttributeValue().withS(persistenceId.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), (Object)new AttributeValue().withN(((Object)BoxesRunTime.boxToInteger((int)0)).toString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), (Object)new AttributeValue().withN(maxSequenceNr.asString()))}))).asJava()).withConsistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginConfig.consistentRead()));
        return this.queryDelete(queryRequest);
    }

    @Override
    public Source<BoxedUnit, NotUsed> deleteUpToMaxTimestamp(PersistenceId persistenceId, long maxTimestamp, ExecutionContext ec) {
        QueryRequest queryRequest = new QueryRequest().withTableName(this.pluginConfig.tableName()).withKeyConditionExpression("#pid = :pid and #snr between :min and :max").withFilterExpression("#created <= :maxTimestamp").withExpressionAttributeNames((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginConfig.columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginConfig.columnsDefConfig().sequenceNrColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#created"), (Object)this.pluginConfig.columnsDefConfig().createdColumnName())}))).asJava()).withExpressionAttributeValues((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), (Object)new AttributeValue().withS(persistenceId.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), (Object)new AttributeValue().withN(((Object)BoxesRunTime.boxToInteger((int)0)).toString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), (Object)new AttributeValue().withN(((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":maxTimestamp"), (Object)new AttributeValue().withN(((Object)BoxesRunTime.boxToLong((long)maxTimestamp)).toString()))}))).asJava()).withConsistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginConfig.consistentRead()));
        return this.queryDelete(queryRequest);
    }

    @Override
    public Source<BoxedUnit, NotUsed> deleteUpToMaxSequenceNrAndMaxTimestamp(PersistenceId persistenceId, SequenceNumber maxSequenceNr, long maxTimestamp, ExecutionContext ec) {
        QueryRequest queryRequest = new QueryRequest().withTableName(this.pluginConfig.tableName()).withKeyConditionExpression("#pid = :pid and #snr between :min and :max").withFilterExpression("#created <= :maxTimestamp").withExpressionAttributeNames((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginConfig.columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginConfig.columnsDefConfig().sequenceNrColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#created"), (Object)this.pluginConfig.columnsDefConfig().createdColumnName())}))).asJava()).withExpressionAttributeValues((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), (Object)new AttributeValue().withS(persistenceId.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), (Object)new AttributeValue().withN(((Object)BoxesRunTime.boxToInteger((int)0)).toString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), (Object)new AttributeValue().withN(maxSequenceNr.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":maxTimestamp"), (Object)new AttributeValue().withN(((Object)BoxesRunTime.boxToLong((long)maxTimestamp)).toString()))}))).asJava()).withConsistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginConfig.consistentRead()));
        return this.queryDelete(queryRequest);
    }

    private Future<Option<Tuple2<SnapshotMetadata, Object>>> deserialize(Option<scala.collection.immutable.Map<String, AttributeValue>> rowOpt, ExecutionContext ec) {
        Future future;
        Option<scala.collection.immutable.Map<String, AttributeValue>> option = rowOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            scala.collection.immutable.Map row = (scala.collection.immutable.Map)some.value();
            PersistenceId x$12 = PersistenceId$.MODULE$.apply(((AttributeValue)row.apply((Object)this.pluginConfig.columnsDefConfig().persistenceIdColumnName())).getS());
            SequenceNumber x$2 = new SequenceNumber(new StringOps(Predef$.MODULE$.augmentString(((AttributeValue)row.apply((Object)this.pluginConfig.columnsDefConfig().sequenceNrColumnName())).getN())).toLong());
            byte[] x$3 = ((AttributeValue)row.apply((Object)this.pluginConfig.columnsDefConfig().snapshotColumnName())).getB().array();
            long x$4 = new StringOps(Predef$.MODULE$.augmentString(((AttributeValue)row.apply((Object)this.pluginConfig.columnsDefConfig().createdColumnName())).getN())).toLong();
            future = this.serializer().deserialize(new SnapshotRow(x$12, x$2, x$4, x$3), ec).map((Function1 & Serializable & scala.Serializable)x$1 -> new Some(x$1), ec);
        } else if (None$.MODULE$.equals(option)) {
            future = Future$.MODULE$.successful((Object)None$.MODULE$);
        } else {
            throw new MatchError(option);
        }
        return future;
    }

    @Override
    public Source<Option<Tuple2<SnapshotMetadata, Object>>, NotUsed> latestSnapshot(PersistenceId persistenceId, ExecutionContext ec) {
        QueryRequest queryRequest = new QueryRequest().withTableName(this.pluginConfig.tableName()).withKeyConditionExpression("#pid = :pid and #snr between :min and :max").withExpressionAttributeNames((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginConfig.columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginConfig.columnsDefConfig().sequenceNrColumnName())}))).asJava()).withExpressionAttributeValues((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), (Object)new AttributeValue().withS(persistenceId.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), (Object)new AttributeValue().withN(((Object)BoxesRunTime.boxToInteger((int)0)).toString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), (Object)new AttributeValue().withN(((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString()))}))).asJava()).withScanIndexForward(Predef$.MODULE$.boolean2Boolean(false)).withLimit(Predef$.MODULE$.int2Integer(1)).withConsistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginConfig.consistentRead()));
        return (Source)Source$.MODULE$.single((Object)queryRequest).via((Graph)this.streamReadClient().queryFlow()).flatMapConcat((Function1 & Serializable & scala.Serializable)response -> {
            Source source;
            if (response.getSdkHttpMetadata().getHttpStatusCode() == 200) {
                source = Source$.MODULE$.single((Object)((TraversableLike)((TraversableLike)Option$.MODULE$.apply((Object)response.getItems()).map((Function1 & Serializable & scala.Serializable)x$2 -> (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(x$2).asScala()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)scala.collection.Seq$.MODULE$.empty())).map((Function1 & Serializable & scala.Serializable)x$3 -> ((TraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter(x$3).asScala()).toMap(Predef$.MODULE$.$conforms()), scala.collection.Seq$.MODULE$.canBuildFrom())).headOption());
            } else {
                int statusCode = response.getSdkHttpMetadata().getHttpStatusCode();
                source = Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).toString()));
            }
            return source;
        }).mapAsync(1, (Function1 & Serializable & scala.Serializable)rowOpt -> this.deserialize((Option<scala.collection.immutable.Map<String, AttributeValue>>)rowOpt, ec));
    }

    @Override
    public Source<Option<Tuple2<SnapshotMetadata, Object>>, NotUsed> snapshotForMaxTimestamp(PersistenceId persistenceId, long maxTimestamp, ExecutionContext ec) {
        QueryRequest queryRequest = new QueryRequest().withTableName(this.pluginConfig.tableName()).withKeyConditionExpression("#pid = :pid and #snr between :min and :max").withFilterExpression("#created <= :maxTimestamp").withExpressionAttributeNames((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginConfig.columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginConfig.columnsDefConfig().sequenceNrColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#created"), (Object)this.pluginConfig.columnsDefConfig().createdColumnName())}))).asJava()).withExpressionAttributeValues((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), (Object)new AttributeValue().withS(persistenceId.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), (Object)new AttributeValue().withN(((Object)BoxesRunTime.boxToInteger((int)0)).toString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), (Object)new AttributeValue().withN(((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":maxTimestamp"), (Object)new AttributeValue().withN(((Object)BoxesRunTime.boxToLong((long)maxTimestamp)).toString()))}))).asJava()).withScanIndexForward(Predef$.MODULE$.boolean2Boolean(false)).withConsistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginConfig.consistentRead()));
        return (Source)Source$.MODULE$.single((Object)queryRequest).via((Graph)this.streamReadClient().queryFlow()).flatMapConcat((Function1 & Serializable & scala.Serializable)response -> {
            Source source;
            if (response.getSdkHttpMetadata().getHttpStatusCode() == 200) {
                source = Source$.MODULE$.single((Object)((TraversableLike)((TraversableLike)Option$.MODULE$.apply((Object)response.getItems()).map((Function1 & Serializable & scala.Serializable)x$4 -> (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(x$4).asScala()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)scala.collection.Seq$.MODULE$.empty())).map((Function1 & Serializable & scala.Serializable)x$5 -> ((TraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter(x$5).asScala()).toMap(Predef$.MODULE$.$conforms()), scala.collection.Seq$.MODULE$.canBuildFrom())).headOption());
            } else {
                int statusCode = response.getSdkHttpMetadata().getHttpStatusCode();
                source = Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).toString()));
            }
            return source;
        }).mapAsync(1, (Function1 & Serializable & scala.Serializable)rowOpt -> this.deserialize((Option<scala.collection.immutable.Map<String, AttributeValue>>)rowOpt, ec));
    }

    @Override
    public Source<Option<Tuple2<SnapshotMetadata, Object>>, NotUsed> snapshotForMaxSequenceNr(PersistenceId persistenceId, SequenceNumber maxSequenceNr, ExecutionContext ec) {
        QueryRequest queryRequest = new QueryRequest().withTableName(this.pluginConfig.tableName()).withKeyConditionExpression("#pid = :pid and #snr between :min and :max").withExpressionAttributeNames((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginConfig.columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginConfig.columnsDefConfig().sequenceNrColumnName())}))).asJava()).withExpressionAttributeValues((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), (Object)new AttributeValue().withS(persistenceId.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), (Object)new AttributeValue().withN(((Object)BoxesRunTime.boxToInteger((int)0)).toString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), (Object)new AttributeValue().withN(maxSequenceNr.asString()))}))).asJava()).withScanIndexForward(Predef$.MODULE$.boolean2Boolean(false)).withConsistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginConfig.consistentRead()));
        return (Source)Source$.MODULE$.single((Object)queryRequest).via((Graph)this.streamReadClient().queryFlow()).flatMapConcat((Function1 & Serializable & scala.Serializable)response -> {
            Source source;
            if (response.getSdkHttpMetadata().getHttpStatusCode() == 200) {
                source = Source$.MODULE$.single((Object)((TraversableLike)((TraversableLike)Option$.MODULE$.apply((Object)response.getItems()).map((Function1 & Serializable & scala.Serializable)x$6 -> (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(x$6).asScala()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)scala.collection.Seq$.MODULE$.empty())).map((Function1 & Serializable & scala.Serializable)x$7 -> ((TraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter(x$7).asScala()).toMap(Predef$.MODULE$.$conforms()), scala.collection.Seq$.MODULE$.canBuildFrom())).headOption());
            } else {
                int statusCode = response.getSdkHttpMetadata().getHttpStatusCode();
                source = Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).toString()));
            }
            return source;
        }).mapAsync(1, (Function1 & Serializable & scala.Serializable)rowOpt -> this.deserialize((Option<scala.collection.immutable.Map<String, AttributeValue>>)rowOpt, ec));
    }

    @Override
    public Source<Option<Tuple2<SnapshotMetadata, Object>>, NotUsed> snapshotForMaxSequenceNrAndMaxTimestamp(PersistenceId persistenceId, SequenceNumber maxSequenceNr, long maxTimestamp, ExecutionContext ec) {
        QueryRequest queryRequest = new QueryRequest().withTableName(this.pluginConfig.tableName()).withKeyConditionExpression("#pid = :pid and #snr between :min and :max").withFilterExpression("#created <= :maxTimestamp").withExpressionAttributeNames((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginConfig.columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginConfig.columnsDefConfig().sequenceNrColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#created"), (Object)this.pluginConfig.columnsDefConfig().createdColumnName())}))).asJava()).withExpressionAttributeValues((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), (Object)new AttributeValue().withS(persistenceId.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), (Object)new AttributeValue().withN(((Object)BoxesRunTime.boxToInteger((int)0)).toString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), (Object)new AttributeValue().withN(maxSequenceNr.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":maxTimestamp"), (Object)new AttributeValue().withN(((Object)BoxesRunTime.boxToLong((long)maxTimestamp)).toString()))}))).asJava()).withScanIndexForward(Predef$.MODULE$.boolean2Boolean(false)).withConsistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginConfig.consistentRead()));
        return (Source)Source$.MODULE$.single((Object)queryRequest).via((Graph)this.streamReadClient().queryFlow()).flatMapConcat((Function1 & Serializable & scala.Serializable)response -> {
            Source source;
            if (response.getSdkHttpMetadata().getHttpStatusCode() == 200) {
                source = Source$.MODULE$.single((Object)((TraversableLike)((TraversableLike)Option$.MODULE$.apply((Object)response.getItems()).map((Function1 & Serializable & scala.Serializable)x$8 -> (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(x$8).asScala()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)scala.collection.Seq$.MODULE$.empty())).map((Function1 & Serializable & scala.Serializable)x$9 -> ((TraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter(x$9).asScala()).toMap(Predef$.MODULE$.$conforms()), scala.collection.Seq$.MODULE$.canBuildFrom())).headOption());
            } else {
                int statusCode = response.getSdkHttpMetadata().getHttpStatusCode();
                source = Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).toString()));
            }
            return source;
        }).mapAsync(1, (Function1 & Serializable & scala.Serializable)rowOpt -> this.deserialize((Option<scala.collection.immutable.Map<String, AttributeValue>>)rowOpt, ec));
    }

    @Override
    public Source<BoxedUnit, NotUsed> delete(PersistenceId persistenceId, SequenceNumber sequenceNr) {
        DeleteItemRequest req = new DeleteItemRequest().withTableName(this.pluginConfig.tableName()).withKey((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig.columnsDefConfig().persistenceIdColumnName()), (Object)new AttributeValue().withS(persistenceId.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig.columnsDefConfig().sequenceNrColumnName()), (Object)new AttributeValue().withN(sequenceNr.asString()))}))).asJava());
        return (Source)Source$.MODULE$.single((Object)req).via((Graph)this.streamWriteClient().deleteItemFlow()).flatMapConcat((Function1 & Serializable & scala.Serializable)response -> {
            Source source;
            if (response.getSdkHttpMetadata().getHttpStatusCode() == 200) {
                source = Source$.MODULE$.single((Object)BoxedUnit.UNIT);
            } else {
                int statusCode = response.getSdkHttpMetadata().getHttpStatusCode();
                source = Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).toString()));
            }
            return source;
        });
    }

    @Override
    public Source<BoxedUnit, NotUsed> save(SnapshotMetadata snapshotMetadata, Object snapshot, ExecutionContext ec) {
        return (Source)Source$.MODULE$.future(this.serializer().serialize(snapshotMetadata, snapshot, ec)).flatMapConcat((Function1 & Serializable & scala.Serializable)snapshotRow -> {
            PutItemRequest req = new PutItemRequest().withTableName($this.pluginConfig.tableName()).withItem((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.pluginConfig.columnsDefConfig().persistenceIdColumnName()), (Object)new AttributeValue().withS(snapshotRow.persistenceId().asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.pluginConfig.columnsDefConfig().sequenceNrColumnName()), (Object)new AttributeValue().withN(snapshotRow.sequenceNumber().asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.pluginConfig.columnsDefConfig().snapshotColumnName()), (Object)new AttributeValue().withB(ByteBuffer.wrap(snapshotRow.snapshot()))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.pluginConfig.columnsDefConfig().createdColumnName()), (Object)new AttributeValue().withN(((Object)BoxesRunTime.boxToLong((long)snapshotRow.created())).toString()))}))).asJava());
            return (Source)Source$.MODULE$.single((Object)req).via((Graph)this.streamWriteClient().putItemFlow()).flatMapConcat((Function1 & Serializable & scala.Serializable)response -> {
                Source source;
                if (response.getSdkHttpMetadata().getHttpStatusCode() == 200) {
                    source = Source$.MODULE$.single((Object)BoxedUnit.UNIT);
                } else {
                    int statusCode = response.getSdkHttpMetadata().getHttpStatusCode();
                    source = Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).toString()));
                }
                return source;
            });
        });
    }

    private Source<BoxedUnit, NotUsed> queryDelete(QueryRequest queryRequest) {
        return (Source)((Source)Source$.MODULE$.single((Object)queryRequest).via((Graph)this.streamReadClient().queryFlow()).map((Function1 & Serializable & scala.Serializable)v -> (Seq)Option$.MODULE$.apply((Object)v.getItems()).map((Function1 & Serializable & scala.Serializable)x$10 -> (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(x$10).asScala()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)scala.collection.Seq$.MODULE$.empty())).mapConcat((Function1 & Serializable & scala.Serializable)x$11 -> x$11.toVector()).grouped(this.pluginConfig.clientConfig().batchWriteItemLimit()).map((Function1 & Serializable & scala.Serializable)rows -> (scala.collection.immutable.Seq)rows.map((Function1 & Serializable & scala.Serializable)row -> {
            scala.collection.mutable.Map _row = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(row).asScala();
            PersistenceId x$1 = PersistenceId$.MODULE$.apply(((AttributeValue)_row.apply((Object)$this.pluginConfig.columnsDefConfig().persistenceIdColumnName())).getS());
            SequenceNumber x$2 = new SequenceNumber(new StringOps(Predef$.MODULE$.augmentString(((AttributeValue)_row.apply((Object)$this.pluginConfig.columnsDefConfig().sequenceNrColumnName())).getN())).toLong());
            byte[] x$3 = ((AttributeValue)_row.apply((Object)$this.pluginConfig.columnsDefConfig().snapshotColumnName())).getB().array();
            long x$4 = new StringOps(Predef$.MODULE$.augmentString(((AttributeValue)_row.apply((Object)$this.pluginConfig.columnsDefConfig().createdColumnName())).getN())).toLong();
            return new SnapshotRow(x$1, x$2, x$4, x$3);
        }, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)rows -> new BatchWriteItemRequest().withRequestItems((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.pluginConfig.tableName()), CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)rows.map((Function1 & Serializable & scala.Serializable)row -> new WriteRequest().withDeleteRequest(new DeleteRequest().withKey((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.pluginConfig.columnsDefConfig().persistenceIdColumnName()), (Object)new AttributeValue().withS(row.persistenceId().asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.pluginConfig.columnsDefConfig().sequenceNrColumnName()), (Object)new AttributeValue().withN(row.sequenceNumber().asString()))}))).asJava())), Seq$.MODULE$.canBuildFrom())).asJava())}))).asJava()))).via((Graph)this.streamWriteClient().batchWriteItemFlow()).flatMapConcat((Function1 & Serializable & scala.Serializable)response -> {
            Source source;
            if (response.getSdkHttpMetadata().getHttpStatusCode() == 200) {
                source = Source$.MODULE$.single((Object)BoxedUnit.UNIT);
            } else {
                int statusCode = response.getSdkHttpMetadata().getHttpStatusCode();
                source = Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).toString()));
            }
            return source;
        });
    }

    public V1SnapshotDaoImpl(ActorSystem system, Option<AmazonDynamoDBAsync> asyncClient, Option<AmazonDynamoDB> syncClient, Serialization serialization, SnapshotPluginConfig pluginConfig, Option<MetricsReporter> metricsReporter) {
        this.pluginConfig = pluginConfig;
        Tuple2 tuple2 = new Tuple2(asyncClient, syncClient);
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (None$.MODULE$.equals(option) && None$.MODULE$.equals(option2)) {
                throw new IllegalArgumentException("aws clients is both None");
            }
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        this.streamReadClient = new StreamReadClient(system, asyncClient, syncClient, (PluginConfig)pluginConfig, pluginConfig.readBackoffConfig());
        this.streamWriteClient = new StreamWriteClient(system, asyncClient, syncClient, (PluginConfig)pluginConfig, pluginConfig.writeBackoffConfig());
        this.serializer = new ByteArraySnapshotSerializer(serialization, metricsReporter);
    }
}

