/*
 * Decompiled with CFR 0.152.
 */
package com.github.j5ik2o.akka.persistence.dynamodb.serialization;

import akka.persistence.SnapshotMetadata;
import akka.persistence.SnapshotMetadata$;
import akka.persistence.serialization.Snapshot;
import akka.serialization.AsyncSerializer;
import akka.serialization.Serialization;
import akka.serialization.Serializer;
import com.github.j5ik2o.akka.persistence.dynamodb.metrics.Context;
import com.github.j5ik2o.akka.persistence.dynamodb.metrics.MetricsReporter;
import com.github.j5ik2o.akka.persistence.dynamodb.metrics.MetricsReporter$;
import com.github.j5ik2o.akka.persistence.dynamodb.model.PersistenceId;
import com.github.j5ik2o.akka.persistence.dynamodb.model.PersistenceId$;
import com.github.j5ik2o.akka.persistence.dynamodb.model.SequenceNumber;
import com.github.j5ik2o.akka.persistence.dynamodb.serialization.SnapshotSerializer;
import com.github.j5ik2o.akka.persistence.dynamodb.snapshot.dao.SnapshotRow;
import java.io.Serializable;
import java.util.UUID;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001da\u0001B\u0005\u000b\u0005eA\u0001b\u0003\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\te\u0001\u0011\t\u0011)A\u0005g!)A\b\u0001C\u0001{!)\u0011\t\u0001C\u0005\u0005\")A\n\u0001C\u0005\u001b\")a\f\u0001C\u0005?\")!\u000e\u0001C!W\")\u0011\u0010\u0001C!u\nY\")\u001f;f\u0003J\u0014\u0018-_*oCB\u001c\bn\u001c;TKJL\u0017\r\\5{KJT!a\u0003\u0007\u0002\u001bM,'/[1mSj\fG/[8o\u0015\tia\"\u0001\u0005es:\fWn\u001c3c\u0015\ty\u0001#A\u0006qKJ\u001c\u0018n\u001d;f]\u000e,'BA\t\u0013\u0003\u0011\t7n[1\u000b\u0005M!\u0012A\u000266S.\u0014tN\u0003\u0002\u0016-\u00051q-\u001b;ik\nT\u0011aF\u0001\u0004G>l7\u0001A\n\u0004\u0001i\u0001\u0003CA\u000e\u001f\u001b\u0005a\"\"A\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}a\"AB!osJ+g\rE\u0002\"E\u0011j\u0011AC\u0005\u0003G)\u0011!c\u00158baNDw\u000e^*fe&\fG.\u001b>feB\u0011QEK\u0007\u0002M)\u0011q\u0005K\u0001\u0004I\u0006|'BA\u0015\r\u0003!\u0019h.\u00199tQ>$\u0018BA\u0016'\u0005-\u0019f.\u00199tQ>$(k\\<\u0011\u00055\u0002T\"\u0001\u0018\u000b\u0005-y#\"A\t\n\u0005Er#!D*fe&\fG.\u001b>bi&|g.A\bnKR\u0014\u0018nY:SKB|'\u000f^3s!\rYBGN\u0005\u0003kq\u0011aa\u00149uS>t\u0007CA\u001c;\u001b\u0005A$BA\u001d\r\u0003\u001diW\r\u001e:jGNL!a\u000f\u001d\u0003\u001f5+GO]5dgJ+\u0007o\u001c:uKJ\fa\u0001P5oSRtDc\u0001 @\u0001B\u0011\u0011\u0005\u0001\u0005\u0006\u0017\r\u0001\r\u0001\f\u0005\u0006e\r\u0001\raM\u0001\u0010g\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018i]=oGV\t1\tE\u0002E\u000f&k\u0011!\u0012\u0006\u0003\rr\t!bY8oGV\u0014(/\u001a8u\u0013\tAUI\u0001\u0004GkR,(/\u001a\t\u0003[)K!a\u0013\u0018\u0003\u0015M+'/[1mSj,'/A\u0007u_\nKg.\u0019:z\u0003NLhn\u0019\u000b\u0004\u001dV;\u0006c\u0001#H\u001fB\u00191\u0004\u0015*\n\u0005Ec\"!B!se\u0006L\bCA\u000eT\u0013\t!FD\u0001\u0003CsR,\u0007\"\u0002,\u0006\u0001\u0004I\u0015AC:fe&\fG.\u001b>fe\")\u0011&\u0002a\u00011B\u0011\u0011\fX\u0007\u00025*\u00111b\u0017\u0006\u0003\u001f=J!!\u0018.\u0003\u0011Ms\u0017\r]:i_R\fqB\u001a:p[\nKg.\u0019:z\u0003NLhn\u0019\u000b\u0004A\u001eDGCA1c!\r!u\t\u0017\u0005\u0006G\u001a\u0001\u001d\u0001Z\u0001\u0003K\u000e\u0004\"\u0001R3\n\u0005\u0019,%\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0011\u00151f\u00011\u0001J\u0011\u0015Ig\u00011\u0001P\u0003\u0011!\u0017\r^1\u0002\u0013M,'/[1mSj,Gc\u00017pkR\u0011QN\u001c\t\u0004\t\u001e#\u0003\"B2\b\u0001\b!\u0007\"\u00029\b\u0001\u0004\t\u0018\u0001C7fi\u0006$\u0017\r^1\u0011\u0005I\u001cX\"A.\n\u0005Q\\&\u0001E*oCB\u001c\bn\u001c;NKR\fG-\u0019;b\u0011\u0015Is\u00011\u0001w!\tYr/\u0003\u0002y9\t\u0019\u0011I\\=\u0002\u0017\u0011,7/\u001a:jC2L'0\u001a\u000b\u0004w\u0006\rAc\u0001?\u0002\u0002A\u0019AiR?\u0011\tmq\u0018O^\u0005\u0003\u007fr\u0011a\u0001V;qY\u0016\u0014\u0004\"B2\t\u0001\b!\u0007BBA\u0003\u0011\u0001\u0007A%A\u0006t]\u0006\u00048\u000f[8u%><\b")
public final class ByteArraySnapshotSerializer
implements SnapshotSerializer<SnapshotRow> {
    private final Serialization serialization;
    private final Option<MetricsReporter> metricsReporter;

    private Future<Serializer> serializerAsync() {
        Future future;
        try {
            future = Future$.MODULE$.successful((Object)this.serialization.serializerFor(Snapshot.class));
        }
        catch (Throwable ex) {
            future = Future$.MODULE$.failed(ex);
        }
        return future;
    }

    private Future<byte[]> toBinaryAsync(Serializer serializer, Snapshot snapshot) {
        Future future;
        Serializer serializer2 = serializer;
        if (serializer2 instanceof AsyncSerializer) {
            Serializer serializer3 = serializer2;
            future = ((AsyncSerializer)serializer3).toBinaryAsync((Object)snapshot);
        } else {
            Future future2;
            try {
                future2 = Future$.MODULE$.successful((Object)serializer2.toBinary((Object)snapshot));
            }
            catch (Throwable ex) {
                future2 = Future$.MODULE$.failed(ex);
            }
            future = future2;
        }
        return future;
    }

    private Future<Snapshot> fromBinaryAsync(Serializer serializer, byte[] data, ExecutionContext ec) {
        Future future;
        Serializer serializer2 = serializer;
        if (serializer2 instanceof AsyncSerializer) {
            Serializer serializer3 = serializer2;
            future = ((AsyncSerializer)serializer3).fromBinaryAsync(data, Snapshot.class.getName());
        } else {
            Future future2;
            try {
                future2 = Future$.MODULE$.successful(serializer2.fromBinary(data, Snapshot.class));
            }
            catch (Throwable ex) {
                future2 = Future$.MODULE$.failed(ex);
            }
            future = future2;
        }
        Future future3 = future;
        return future3.map((Function1 & Serializable & scala.Serializable)x$1 -> (Snapshot)x$1, ec);
    }

    @Override
    public Future<SnapshotRow> serialize(SnapshotMetadata metadata, Object snapshot, ExecutionContext ec) {
        PersistenceId pid = PersistenceId$.MODULE$.apply(metadata.persistenceId());
        Context context = MetricsReporter$.MODULE$.newContext(UUID.randomUUID(), pid, MetricsReporter$.MODULE$.newContext$default$3());
        Context newContext = (Context)this.metricsReporter.fold((Function0 & Serializable & scala.Serializable)() -> context, (Function1 & Serializable & scala.Serializable)x$2 -> x$2.beforeSnapshotStoreSerializeSnapshot(context));
        Future future = this.serializerAsync().flatMap((Function1 & Serializable & scala.Serializable)serializer -> this.toBinaryAsync((Serializer)serializer, new Snapshot(snapshot)).map((Function1 & Serializable & scala.Serializable)serialized -> new SnapshotRow(PersistenceId$.MODULE$.apply(metadata.persistenceId()), new SequenceNumber(metadata.sequenceNr()), metadata.timestamp(), (byte[])serialized), ec), ec);
        future.onComplete((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ByteArraySnapshotSerializer.$anonfun$serialize$5(this, newContext, x0$1);
            return BoxedUnit.UNIT;
        }, ec);
        return future;
    }

    @Override
    public Future<Tuple2<SnapshotMetadata, Object>> deserialize(SnapshotRow snapshotRow, ExecutionContext ec) {
        Context context = MetricsReporter$.MODULE$.newContext(UUID.randomUUID(), snapshotRow.persistenceId(), MetricsReporter$.MODULE$.newContext$default$3());
        Context newContext = (Context)this.metricsReporter.fold((Function0 & Serializable & scala.Serializable)() -> context, (Function1 & Serializable & scala.Serializable)x$5 -> x$5.beforeSnapshotStoreDeserializeSnapshot(context));
        Future future = this.serializerAsync().flatMap((Function1 & Serializable & scala.Serializable)serializer -> this.fromBinaryAsync((Serializer)serializer, snapshotRow.snapshot(), ec).map((Function1 & Serializable & scala.Serializable)deserialized -> {
            SnapshotMetadata snapshotMetadata = SnapshotMetadata$.MODULE$.apply(snapshotRow.persistenceId().asString(), snapshotRow.sequenceNumber().value(), snapshotRow.created());
            return new Tuple2((Object)snapshotMetadata, deserialized.data());
        }, ec), ec);
        future.onComplete((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ByteArraySnapshotSerializer.$anonfun$deserialize$5(this, newContext, x0$1);
            return BoxedUnit.UNIT;
        }, ec);
        return future;
    }

    public static final /* synthetic */ void $anonfun$serialize$5(ByteArraySnapshotSerializer $this, Context newContext$1, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Success) {
            $this.metricsReporter.foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                x$3.afterSnapshotStoreSerializeSnapshot(newContext$1);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable ex = failure.exception();
            $this.metricsReporter.foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                x$4.errorSnapshotStoreSerializeSnapshot(newContext$1, ex);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    public static final /* synthetic */ void $anonfun$deserialize$5(ByteArraySnapshotSerializer $this, Context newContext$2, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Success) {
            $this.metricsReporter.foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
                x$6.afterSnapshotStoreDeserializeSnapshot(newContext$2);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable ex = failure.exception();
            $this.metricsReporter.foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
                x$7.errorSnapshotStoreDeserializeSnapshot(newContext$2, ex);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    public ByteArraySnapshotSerializer(Serialization serialization, Option<MetricsReporter> metricsReporter) {
        this.serialization = serialization;
        this.metricsReporter = metricsReporter;
    }
}

