/*
 * Decompiled with CFR 0.152.
 */
package com.github.j5ik2o.akka.persistence.dynamodb.snapshot.dao;

import akka.NotUsed;
import akka.actor.ActorSystem;
import akka.persistence.SnapshotMetadata;
import akka.serialization.Serialization;
import akka.stream.Graph;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import com.github.j5ik2o.akka.persistence.dynamodb.client.v2.StreamReadClient;
import com.github.j5ik2o.akka.persistence.dynamodb.client.v2.StreamWriteClient;
import com.github.j5ik2o.akka.persistence.dynamodb.config.PluginConfig;
import com.github.j5ik2o.akka.persistence.dynamodb.metrics.MetricsReporter;
import com.github.j5ik2o.akka.persistence.dynamodb.model.PersistenceId;
import com.github.j5ik2o.akka.persistence.dynamodb.model.PersistenceId$;
import com.github.j5ik2o.akka.persistence.dynamodb.model.SequenceNumber;
import com.github.j5ik2o.akka.persistence.dynamodb.snapshot.config.SnapshotPluginConfig;
import com.github.j5ik2o.akka.persistence.dynamodb.snapshot.dao.SnapshotDao;
import com.github.j5ik2o.akka.persistence.dynamodb.snapshot.dao.SnapshotRow;
import com.github.j5ik2o.akka.persistence.dynamodb.snapshot.serialization.ByteArraySnapshotSerializer;
import com.github.j5ik2o.akka.persistence.dynamodb.trace.TraceReporter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Optional;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteRequest;
import software.amazon.awssdk.services.dynamodb.model.PutItemRequest;
import software.amazon.awssdk.services.dynamodb.model.QueryRequest;
import software.amazon.awssdk.services.dynamodb.model.WriteRequest;

@ScalaSignature(bytes="\u0006\u0001\t]c\u0001\u0002\u000f\u001e\u00059B\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IA\u000f\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005\u0005\"A!\u000b\u0001B\u0001B\u0003%1\u000b\u0003\u0005X\u0001\t\u0005\t\u0015!\u0003Y\u0011!i\u0006A!A!\u0002\u0013q\u0006\u0002\u00033\u0001\u0005\u0003\u0005\u000b\u0011B3\t\u00111\u0004!\u0011!Q\u0001\n5DQ\u0001\u001e\u0001\u0005\u0002UDqA \u0001C\u0002\u0013%q\u0010\u0003\u0005\u0002\u0012\u0001\u0001\u000b\u0011BA\u0001\u0011%\t\u0019\u0002\u0001b\u0001\n\u0013\t)\u0002\u0003\u0005\u0002\u001e\u0001\u0001\u000b\u0011BA\f\u0011%\ty\u0002\u0001b\u0001\n\u0013\t\t\u0003\u0003\u0005\u0002.\u0001\u0001\u000b\u0011BA\u0012\u0011\u001d\ty\u0003\u0001C!\u0003cAq!a\u001b\u0001\t\u0003\ni\u0007C\u0004\u0002\u0004\u0002!\t%!\"\t\u000f\u0005E\u0005\u0001\"\u0011\u0002\u0014\"9\u0011Q\u0015\u0001\u0005B\u0005\u001d\u0006bBAZ\u0001\u0011%\u0011Q\u0017\u0005\b\u0005\u000b\u0001A\u0011\tB\u0004\u0011\u001d\u0011\t\u0002\u0001C!\u0005'AqA!\b\u0001\t\u0003\u0012y\u0002C\u0004\u0003*\u0001!\tEa\u000b\t\u000f\t]\u0002\u0001\"\u0011\u0003:!9!Q\t\u0001\u0005\n\t\u001d\u0003b\u0002B*\u0001\u0011\u0005#Q\u000b\u0002\u0012-J\u001af.\u00199tQ>$H)Y8J[Bd'B\u0001\u0010 \u0003\r!\u0017m\u001c\u0006\u0003A\u0005\n\u0001b\u001d8baNDw\u000e\u001e\u0006\u0003E\r\n\u0001\u0002Z=oC6|GM\u0019\u0006\u0003I\u0015\n1\u0002]3sg&\u001cH/\u001a8dK*\u0011aeJ\u0001\u0005C.\\\u0017M\u0003\u0002)S\u00051!.N5le=T!AK\u0016\u0002\r\u001dLG\u000f[;c\u0015\u0005a\u0013aA2p[\u000e\u00011c\u0001\u00010kA\u0011\u0001gM\u0007\u0002c)\t!'A\u0003tG\u0006d\u0017-\u0003\u00025c\t1\u0011I\\=SK\u001a\u0004\"AN\u001c\u000e\u0003uI!\u0001O\u000f\u0003\u0017Ms\u0017\r]:i_R$\u0015m\\\u0001\u0007gf\u001cH/Z7\u0011\u0005mzT\"\u0001\u001f\u000b\u0005ur\u0014!B1di>\u0014(\"\u0001\u0014\n\u0005\u0001c$aC!di>\u00148+_:uK6\f1\"Y:z]\u000e\u001cE.[3oiB\u0019\u0001gQ#\n\u0005\u0011\u000b$AB(qi&|g\u000e\u0005\u0002G!6\tqI\u0003\u0002#\u0011*\u0011\u0011JS\u0001\tg\u0016\u0014h/[2fg*\u00111\nT\u0001\u0007C^\u001c8\u000fZ6\u000b\u00055s\u0015AB1nCj|gNC\u0001P\u0003!\u0019xN\u001a;xCJ,\u0017BA)H\u0005M!\u0015P\\1n_\u0012\u0013\u0017i]=oG\u000ec\u0017.\u001a8u\u0003)\u0019\u0018P\\2DY&,g\u000e\u001e\t\u0004a\r#\u0006C\u0001$V\u0013\t1vI\u0001\bEs:\fWn\u001c#c\u00072LWM\u001c;\u0002\u001bM,'/[1mSj\fG/[8o!\tI6,D\u0001[\u0015\t9f(\u0003\u0002]5\ni1+\u001a:jC2L'0\u0019;j_:\fA\u0002\u001d7vO&t7i\u001c8gS\u001e\u0004\"a\u00182\u000e\u0003\u0001T!!Y\u0010\u0002\r\r|gNZ5h\u0013\t\u0019\u0007M\u0001\u000bT]\u0006\u00048\u000f[8u!2,x-\u001b8D_:4\u0017nZ\u0001\u0010[\u0016$(/[2t%\u0016\u0004xN\u001d;feB\u0019\u0001g\u00114\u0011\u0005\u001dTW\"\u00015\u000b\u0005%\f\u0013aB7fiJL7m]\u0005\u0003W\"\u0014q\"T3ue&\u001c7OU3q_J$XM]\u0001\u000eiJ\f7-\u001a*fa>\u0014H/\u001a:\u0011\u0007A\u001ae\u000e\u0005\u0002pe6\t\u0001O\u0003\u0002rC\u0005)AO]1dK&\u00111\u000f\u001d\u0002\u000e)J\f7-\u001a*fa>\u0014H/\u001a:\u0002\rqJg.\u001b;?)!1x\u000f_={wrl\bC\u0001\u001c\u0001\u0011\u0015I\u0004\u00021\u0001;\u0011\u0015\t\u0005\u00021\u0001C\u0011\u0015\u0011\u0006\u00021\u0001T\u0011\u00159\u0006\u00021\u0001Y\u0011\u0015i\u0006\u00021\u0001_\u0011\u0015!\u0007\u00021\u0001f\u0011\u0015a\u0007\u00021\u0001n\u0003A\u0019HO]3b[J+\u0017\rZ\"mS\u0016tG/\u0006\u0002\u0002\u0002A!\u00111AA\u0007\u001b\t\t)A\u0003\u0003\u0002\b\u0005%\u0011A\u0001<3\u0015\r\tY!I\u0001\u0007G2LWM\u001c;\n\t\u0005=\u0011Q\u0001\u0002\u0011'R\u0014X-Y7SK\u0006$7\t\\5f]R\f\u0011c\u001d;sK\u0006l'+Z1e\u00072LWM\u001c;!\u0003E\u0019HO]3b[^\u0013\u0018\u000e^3DY&,g\u000e^\u000b\u0003\u0003/\u0001B!a\u0001\u0002\u001a%!\u00111DA\u0003\u0005E\u0019FO]3b[^\u0013\u0018\u000e^3DY&,g\u000e^\u0001\u0013gR\u0014X-Y7Xe&$Xm\u00117jK:$\b%\u0001\u0006tKJL\u0017\r\\5{KJ,\"!a\t\u0011\t\u0005\u0015\u0012\u0011F\u0007\u0003\u0003OQ!aV\u0010\n\t\u0005-\u0012q\u0005\u0002\u001c\u0005f$X-\u0011:sCf\u001cf.\u00199tQ>$8+\u001a:jC2L'0\u001a:\u0002\u0017M,'/[1mSj,'\u000fI\u0001\u0007I\u0016dW\r^3\u0015\r\u0005M\u0012\u0011KA1!!\t)$a\u0010\u0002D\u0005%SBAA\u001c\u0015\u0011\tI$a\u000f\u0002\u0011M\u001c\u0017\r\\1eg2T1!!\u0010?\u0003\u0019\u0019HO]3b[&!\u0011\u0011IA\u001c\u0005\u0019\u0019v.\u001e:dKB\u0019\u0001'!\u0012\n\u0007\u0005\u001d\u0013G\u0001\u0003V]&$\b\u0003BA&\u0003\u001bj\u0011AP\u0005\u0004\u0003\u001fr$a\u0002(piV\u001bX\r\u001a\u0005\b\u0003'z\u0001\u0019AA+\u00035\u0001XM]:jgR,gnY3JIB!\u0011qKA/\u001b\t\tIFC\u0002\u0002\\\u0005\nQ!\\8eK2LA!a\u0018\u0002Z\ti\u0001+\u001a:tSN$XM\\2f\u0013\u0012Dq!a\u0019\u0010\u0001\u0004\t)'\u0001\u0006tKF,XM\\2f\u001dJ\u0004B!a\u0016\u0002h%!\u0011\u0011NA-\u00059\u0019V-];f]\u000e,g*^7cKJ\f!\u0003Z3mKR,\u0017\t\u001c7T]\u0006\u00048\u000f[8ugR!\u0011qNAA)\u0011\t\u0019$!\u001d\t\u000f\u0005M\u0004\u0003q\u0001\u0002v\u0005\u0011Qm\u0019\t\u0005\u0003o\ni(\u0004\u0002\u0002z)\u0019\u00111P\u0019\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u0002\u0000\u0005e$\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0011\u001d\t\u0019\u0006\u0005a\u0001\u0003+\nq\u0003Z3mKR,W\u000b\u001d+p\u001b\u0006D8+Z9vK:\u001cWM\u0014:\u0015\r\u0005\u001d\u00151RAG)\u0011\t\u0019$!#\t\u000f\u0005M\u0014\u0003q\u0001\u0002v!9\u00111K\tA\u0002\u0005U\u0003bBAH#\u0001\u0007\u0011QM\u0001\u000e[\u0006D8+Z9vK:\u001cWM\u0014:\u0002-\u0011,G.\u001a;f+B$v.T1y)&lWm\u001d;b[B$b!!&\u0002\u001a\u0006mE\u0003BA\u001a\u0003/Cq!a\u001d\u0013\u0001\b\t)\bC\u0004\u0002TI\u0001\r!!\u0016\t\u000f\u0005u%\u00031\u0001\u0002 \u0006aQ.\u0019=US6,7\u000f^1naB\u0019\u0001'!)\n\u0007\u0005\r\u0016G\u0001\u0003M_:<\u0017A\n3fY\u0016$X-\u00169U_6\u000b\u0007pU3rk\u0016t7-\u001a(s\u0003:$W*\u0019=US6,7\u000f^1naRA\u0011\u0011VAW\u0003_\u000b\t\f\u0006\u0003\u00024\u0005-\u0006bBA:'\u0001\u000f\u0011Q\u000f\u0005\b\u0003'\u001a\u0002\u0019AA+\u0011\u001d\tyi\u0005a\u0001\u0003KBq!!(\u0014\u0001\u0004\ty*A\u0006eKN,'/[1mSj,G\u0003BA\\\u00033$B!!/\u0002XB1\u0011qOA^\u0003\u007fKA!!0\u0002z\t1a)\u001e;ve\u0016\u0004B\u0001M\"\u0002BB9\u0001'a1\u0002H\u0006E\u0017bAAcc\t1A+\u001e9mKJ\u0002B!!3\u0002N6\u0011\u00111\u001a\u0006\u0003IyJA!a4\u0002L\n\u00012K\\1qg\"|G/T3uC\u0012\fG/\u0019\t\u0004a\u0005M\u0017bAAkc\t\u0019\u0011I\\=\t\u000f\u0005MD\u0003q\u0001\u0002v!9\u00111\u001c\u000bA\u0002\u0005u\u0017A\u0002:po>\u0003H\u000f\u0005\u00031\u0007\u0006}\u0007\u0003CAq\u0003_\f)0a?\u000f\t\u0005\r\u00181\u001e\t\u0004\u0003K\fTBAAt\u0015\r\tI/L\u0001\u0007yI|w\u000e\u001e \n\u0007\u00055\u0018'\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003c\f\u0019PA\u0002NCBT1!!<2!\u0011\t\t/a>\n\t\u0005e\u00181\u001f\u0002\u0007'R\u0014\u0018N\\4\u0011\t\u0005u(\u0011A\u0007\u0003\u0003\u007fT1!a\u0017H\u0013\u0011\u0011\u0019!a@\u0003\u001d\u0005#HO]5ckR,g+\u00197vK\u0006qA.\u0019;fgR\u001cf.\u00199tQ>$H\u0003\u0002B\u0005\u0005\u001f!BAa\u0003\u0003\u000eAA\u0011QGA \u0003\u007f\u000bI\u0005C\u0004\u0002tU\u0001\u001d!!\u001e\t\u000f\u0005MS\u00031\u0001\u0002V\u000592O\\1qg\"|GOR8s\u001b\u0006DH+[7fgR\fW\u000e\u001d\u000b\u0007\u0005+\u0011IBa\u0007\u0015\t\t-!q\u0003\u0005\b\u0003g2\u00029AA;\u0011\u001d\t\u0019F\u0006a\u0001\u0003+Bq!!(\u0017\u0001\u0004\ty*\u0001\rt]\u0006\u00048\u000f[8u\r>\u0014X*\u0019=TKF,XM\\2f\u001dJ$bA!\t\u0003&\t\u001dB\u0003\u0002B\u0006\u0005GAq!a\u001d\u0018\u0001\b\t)\bC\u0004\u0002T]\u0001\r!!\u0016\t\u000f\u0005=u\u00031\u0001\u0002f\u000593O\\1qg\"|GOR8s\u001b\u0006D8+Z9vK:\u001cWM\u0014:B]\u0012l\u0015\r\u001f+j[\u0016\u001cH/Y7q)!\u0011iC!\r\u00034\tUB\u0003\u0002B\u0006\u0005_Aq!a\u001d\u0019\u0001\b\t)\bC\u0004\u0002Ta\u0001\r!!\u0016\t\u000f\u0005=\u0005\u00041\u0001\u0002f!9\u0011Q\u0014\rA\u0002\u0005}\u0015\u0001B:bm\u0016$bAa\u000f\u0003@\t\rC\u0003BA\u001a\u0005{Aq!a\u001d\u001a\u0001\b\t)\bC\u0004\u0003Be\u0001\r!a2\u0002!Mt\u0017\r]:i_RlU\r^1eCR\f\u0007B\u0002\u0011\u001a\u0001\u0004\t\t.A\u0006rk\u0016\u0014\u0018\u0010R3mKR,G\u0003BA\u001a\u0005\u0013BqAa\u0013\u001b\u0001\u0004\u0011i%\u0001\u0007rk\u0016\u0014\u0018PU3rk\u0016\u001cH\u000f\u0005\u0003\u0002~\n=\u0013\u0002\u0002B)\u0003\u007f\u0014A\"U;fef\u0014V-];fgR\fq\u0001Z5ta>\u001cX\r\u0006\u0002\u0002D\u0001")
public final class V2SnapshotDaoImpl
implements SnapshotDao {
    private final Option<DynamoDbAsyncClient> asyncClient;
    private final Option<DynamoDbClient> syncClient;
    private final SnapshotPluginConfig pluginConfig;
    private final StreamReadClient streamReadClient;
    private final StreamWriteClient streamWriteClient;
    private final ByteArraySnapshotSerializer serializer;

    private StreamReadClient streamReadClient() {
        return this.streamReadClient;
    }

    private StreamWriteClient streamWriteClient() {
        return this.streamWriteClient;
    }

    private ByteArraySnapshotSerializer serializer() {
        return this.serializer;
    }

    public Source<BoxedUnit, NotUsed> delete(PersistenceId persistenceId, SequenceNumber sequenceNr) {
        DeleteItemRequest req = (DeleteItemRequest)DeleteItemRequest.builder().tableName(this.pluginConfig.tableName()).key((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig.columnsDefConfig().persistenceIdColumnName()), AttributeValue.builder().s(persistenceId.asString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig.columnsDefConfig().sequenceNrColumnName()), AttributeValue.builder().n(sequenceNr.asString()).build())}))).asJava()).build();
        return (Source)Source$.MODULE$.single((Object)req).via((Graph)this.streamWriteClient().deleteItemFlow()).flatMapConcat((Function1 & Serializable & scala.Serializable)response -> {
            Source source;
            if (response.sdkHttpResponse().isSuccessful()) {
                source = Source$.MODULE$.single((Object)BoxedUnit.UNIT);
            } else {
                int statusCode = response.sdkHttpResponse().statusCode();
                Optional statusText = response.sdkHttpResponse().statusText();
                source = Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).append(OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(statusText)).fold((Function0 & Serializable & scala.Serializable)() -> "", (Function1 & Serializable & scala.Serializable)s -> new StringBuilder(2).append(", ").append((String)s).toString())).toString()));
            }
            return source;
        });
    }

    public Source<BoxedUnit, NotUsed> deleteAllSnapshots(PersistenceId persistenceId, ExecutionContext ec) {
        QueryRequest queryRequest = (QueryRequest)QueryRequest.builder().tableName(this.pluginConfig.tableName()).keyConditionExpression("#pid = :pid and #snr between :min and :max").expressionAttributeNames((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginConfig.columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginConfig.columnsDefConfig().sequenceNrColumnName())}))).asJava()).expressionAttributeValues((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), AttributeValue.builder().s(persistenceId.asString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), AttributeValue.builder().n(((Object)BoxesRunTime.boxToInteger((int)0)).toString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), AttributeValue.builder().n(((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString()).build())}))).asJava()).consistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginConfig.consistentRead())).build();
        return this.queryDelete(queryRequest);
    }

    public Source<BoxedUnit, NotUsed> deleteUpToMaxSequenceNr(PersistenceId persistenceId, SequenceNumber maxSequenceNr, ExecutionContext ec) {
        QueryRequest queryRequest = (QueryRequest)QueryRequest.builder().tableName(this.pluginConfig.tableName()).keyConditionExpression("#pid = :pid and #snr between :min and :max").expressionAttributeNames((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginConfig.columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginConfig.columnsDefConfig().sequenceNrColumnName())}))).asJava()).expressionAttributeValues((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), AttributeValue.builder().s(persistenceId.asString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), AttributeValue.builder().n(((Object)BoxesRunTime.boxToInteger((int)0)).toString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), AttributeValue.builder().n(maxSequenceNr.asString()).build())}))).asJava()).consistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginConfig.consistentRead())).build();
        return this.queryDelete(queryRequest);
    }

    public Source<BoxedUnit, NotUsed> deleteUpToMaxTimestamp(PersistenceId persistenceId, long maxTimestamp, ExecutionContext ec) {
        QueryRequest queryRequest = (QueryRequest)QueryRequest.builder().tableName(this.pluginConfig.tableName()).keyConditionExpression("#pid = :pid and #snr between :min and :max").filterExpression("#created <= :maxTimestamp").expressionAttributeNames((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginConfig.columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginConfig.columnsDefConfig().sequenceNrColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#created"), (Object)this.pluginConfig.columnsDefConfig().createdColumnName())}))).asJava()).expressionAttributeValues((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), AttributeValue.builder().s(persistenceId.asString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), AttributeValue.builder().n(((Object)BoxesRunTime.boxToInteger((int)0)).toString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), AttributeValue.builder().n(((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":maxTimestamp"), AttributeValue.builder().n(((Object)BoxesRunTime.boxToLong((long)maxTimestamp)).toString()).build())}))).asJava()).consistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginConfig.consistentRead())).build();
        return this.queryDelete(queryRequest);
    }

    public Source<BoxedUnit, NotUsed> deleteUpToMaxSequenceNrAndMaxTimestamp(PersistenceId persistenceId, SequenceNumber maxSequenceNr, long maxTimestamp, ExecutionContext ec) {
        QueryRequest queryRequest = (QueryRequest)QueryRequest.builder().tableName(this.pluginConfig.tableName()).keyConditionExpression("#pid = :pid and #snr between :min and :max").filterExpression("#created <= :maxTimestamp").expressionAttributeNames((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginConfig.columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginConfig.columnsDefConfig().sequenceNrColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#created"), (Object)this.pluginConfig.columnsDefConfig().createdColumnName())}))).asJava()).expressionAttributeValues((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), AttributeValue.builder().s(persistenceId.asString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), AttributeValue.builder().n(((Object)BoxesRunTime.boxToInteger((int)0)).toString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), AttributeValue.builder().n(maxSequenceNr.asString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":maxTimestamp"), AttributeValue.builder().n(((Object)BoxesRunTime.boxToLong((long)maxTimestamp)).toString()).build())}))).asJava()).consistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginConfig.consistentRead())).build();
        return this.queryDelete(queryRequest);
    }

    private Future<Option<Tuple2<SnapshotMetadata, Object>>> deserialize(Option<scala.collection.immutable.Map<String, AttributeValue>> rowOpt, ExecutionContext ec) {
        Future future;
        Option<scala.collection.immutable.Map<String, AttributeValue>> option = rowOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            scala.collection.immutable.Map row = (scala.collection.immutable.Map)some.value();
            PersistenceId x$12 = PersistenceId$.MODULE$.apply(((AttributeValue)row.apply((Object)this.pluginConfig.columnsDefConfig().persistenceIdColumnName())).s());
            SequenceNumber x$2 = new SequenceNumber(new StringOps(Predef$.MODULE$.augmentString(((AttributeValue)row.apply((Object)this.pluginConfig.columnsDefConfig().sequenceNrColumnName())).n())).toLong());
            byte[] x$3 = ((AttributeValue)row.apply((Object)this.pluginConfig.columnsDefConfig().snapshotColumnName())).b().asByteArray();
            long x$4 = new StringOps(Predef$.MODULE$.augmentString(((AttributeValue)row.apply((Object)this.pluginConfig.columnsDefConfig().createdColumnName())).n())).toLong();
            future = this.serializer().deserialize(new SnapshotRow(x$12, x$2, x$4, x$3), ec).map((Function1 & Serializable & scala.Serializable)x$1 -> new Some(x$1), ec);
        } else if (None$.MODULE$.equals(option)) {
            future = Future$.MODULE$.successful((Object)None$.MODULE$);
        } else {
            throw new MatchError(option);
        }
        return future;
    }

    public Source<Option<Tuple2<SnapshotMetadata, Object>>, NotUsed> latestSnapshot(PersistenceId persistenceId, ExecutionContext ec) {
        QueryRequest queryRequest = (QueryRequest)QueryRequest.builder().tableName(this.pluginConfig.tableName()).keyConditionExpression("#pid = :pid and #snr between :min and :max").expressionAttributeNames((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginConfig.columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginConfig.columnsDefConfig().sequenceNrColumnName())}))).asJava()).expressionAttributeValues((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), AttributeValue.builder().s(persistenceId.asString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), AttributeValue.builder().n(((Object)BoxesRunTime.boxToInteger((int)0)).toString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), AttributeValue.builder().n(((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString()).build())}))).asJava()).scanIndexForward(Predef$.MODULE$.boolean2Boolean(false)).limit(Predef$.MODULE$.int2Integer(1)).consistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginConfig.consistentRead())).build();
        return (Source)Source$.MODULE$.single((Object)queryRequest).via((Graph)this.streamReadClient().queryFlow()).flatMapConcat((Function1 & Serializable & scala.Serializable)response -> {
            Source source;
            if (response.sdkHttpResponse().isSuccessful()) {
                source = Source$.MODULE$.single((Object)((TraversableLike)((TraversableLike)Option$.MODULE$.apply((Object)response.items()).map((Function1 & Serializable & scala.Serializable)x$2 -> (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(x$2).asScala()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)scala.collection.Seq$.MODULE$.empty())).map((Function1 & Serializable & scala.Serializable)x$3 -> ((TraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter(x$3).asScala()).toMap(Predef$.MODULE$.$conforms()), scala.collection.Seq$.MODULE$.canBuildFrom())).headOption());
            } else {
                int statusCode = response.sdkHttpResponse().statusCode();
                Optional statusText = response.sdkHttpResponse().statusText();
                source = Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).append(OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(statusText)).fold((Function0 & Serializable & scala.Serializable)() -> "", (Function1 & Serializable & scala.Serializable)s -> new StringBuilder(2).append(", ").append((String)s).toString())).toString()));
            }
            return source;
        }).mapAsync(1, (Function1 & Serializable & scala.Serializable)rowOpt -> this.deserialize((Option<scala.collection.immutable.Map<String, AttributeValue>>)rowOpt, ec));
    }

    public Source<Option<Tuple2<SnapshotMetadata, Object>>, NotUsed> snapshotForMaxTimestamp(PersistenceId persistenceId, long maxTimestamp, ExecutionContext ec) {
        QueryRequest queryRequest = (QueryRequest)QueryRequest.builder().tableName(this.pluginConfig.tableName()).keyConditionExpression("#pid = :pid and #snr between :min and :max").filterExpression("#created <= :maxTimestamp").expressionAttributeNames((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginConfig.columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginConfig.columnsDefConfig().sequenceNrColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#created"), (Object)this.pluginConfig.columnsDefConfig().createdColumnName())}))).asJava()).expressionAttributeValues((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), AttributeValue.builder().s(persistenceId.asString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), AttributeValue.builder().n(((Object)BoxesRunTime.boxToInteger((int)0)).toString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), AttributeValue.builder().n(((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":maxTimestamp"), AttributeValue.builder().n(((Object)BoxesRunTime.boxToLong((long)maxTimestamp)).toString()).build())}))).asJava()).scanIndexForward(Predef$.MODULE$.boolean2Boolean(false)).consistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginConfig.consistentRead())).build();
        return (Source)Source$.MODULE$.single((Object)queryRequest).via((Graph)this.streamReadClient().queryFlow()).flatMapConcat((Function1 & Serializable & scala.Serializable)response -> {
            Source source;
            if (response.sdkHttpResponse().isSuccessful()) {
                source = Source$.MODULE$.single((Object)((TraversableLike)((TraversableLike)Option$.MODULE$.apply((Object)response.items()).map((Function1 & Serializable & scala.Serializable)x$4 -> (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(x$4).asScala()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)scala.collection.Seq$.MODULE$.empty())).map((Function1 & Serializable & scala.Serializable)x$5 -> ((TraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter(x$5).asScala()).toMap(Predef$.MODULE$.$conforms()), scala.collection.Seq$.MODULE$.canBuildFrom())).headOption());
            } else {
                int statusCode = response.sdkHttpResponse().statusCode();
                Optional statusText = response.sdkHttpResponse().statusText();
                source = Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).append(OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(statusText)).fold((Function0 & Serializable & scala.Serializable)() -> "", (Function1 & Serializable & scala.Serializable)s -> new StringBuilder(2).append(", ").append((String)s).toString())).toString()));
            }
            return source;
        }).mapAsync(1, (Function1 & Serializable & scala.Serializable)rowOpt -> this.deserialize((Option<scala.collection.immutable.Map<String, AttributeValue>>)rowOpt, ec));
    }

    public Source<Option<Tuple2<SnapshotMetadata, Object>>, NotUsed> snapshotForMaxSequenceNr(PersistenceId persistenceId, SequenceNumber maxSequenceNr, ExecutionContext ec) {
        QueryRequest queryRequest = (QueryRequest)QueryRequest.builder().tableName(this.pluginConfig.tableName()).keyConditionExpression("#pid = :pid and #snr between :min and :max").expressionAttributeNames((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginConfig.columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginConfig.columnsDefConfig().sequenceNrColumnName())}))).asJava()).expressionAttributeValues((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), AttributeValue.builder().s(persistenceId.asString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), AttributeValue.builder().n(((Object)BoxesRunTime.boxToInteger((int)0)).toString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), AttributeValue.builder().n(maxSequenceNr.asString()).build())}))).asJava()).scanIndexForward(Predef$.MODULE$.boolean2Boolean(false)).consistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginConfig.consistentRead())).build();
        return (Source)Source$.MODULE$.single((Object)queryRequest).via((Graph)this.streamReadClient().queryFlow()).flatMapConcat((Function1 & Serializable & scala.Serializable)response -> {
            Source source;
            if (response.sdkHttpResponse().isSuccessful()) {
                source = Source$.MODULE$.single((Object)((TraversableLike)((TraversableLike)Option$.MODULE$.apply((Object)response.items()).map((Function1 & Serializable & scala.Serializable)x$6 -> (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(x$6).asScala()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)scala.collection.Seq$.MODULE$.empty())).map((Function1 & Serializable & scala.Serializable)x$7 -> ((TraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter(x$7).asScala()).toMap(Predef$.MODULE$.$conforms()), scala.collection.Seq$.MODULE$.canBuildFrom())).headOption());
            } else {
                int statusCode = response.sdkHttpResponse().statusCode();
                Optional statusText = response.sdkHttpResponse().statusText();
                source = Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).append(OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(statusText)).fold((Function0 & Serializable & scala.Serializable)() -> "", (Function1 & Serializable & scala.Serializable)s -> new StringBuilder(2).append(", ").append((String)s).toString())).toString()));
            }
            return source;
        }).mapAsync(1, (Function1 & Serializable & scala.Serializable)rowOpt -> this.deserialize((Option<scala.collection.immutable.Map<String, AttributeValue>>)rowOpt, ec));
    }

    public Source<Option<Tuple2<SnapshotMetadata, Object>>, NotUsed> snapshotForMaxSequenceNrAndMaxTimestamp(PersistenceId persistenceId, SequenceNumber maxSequenceNr, long maxTimestamp, ExecutionContext ec) {
        QueryRequest queryRequest = (QueryRequest)QueryRequest.builder().tableName(this.pluginConfig.tableName()).keyConditionExpression("#pid = :pid and #snr between :min and :max").filterExpression("#created <= :maxTimestamp").expressionAttributeNames((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginConfig.columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginConfig.columnsDefConfig().sequenceNrColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#created"), (Object)this.pluginConfig.columnsDefConfig().createdColumnName())}))).asJava()).expressionAttributeValues((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), AttributeValue.builder().s(persistenceId.asString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), AttributeValue.builder().n(((Object)BoxesRunTime.boxToInteger((int)0)).toString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), AttributeValue.builder().n(maxSequenceNr.asString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":maxTimestamp"), AttributeValue.builder().n(((Object)BoxesRunTime.boxToLong((long)maxTimestamp)).toString()).build())}))).asJava()).scanIndexForward(Predef$.MODULE$.boolean2Boolean(false)).consistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginConfig.consistentRead())).build();
        return (Source)Source$.MODULE$.single((Object)queryRequest).via((Graph)this.streamReadClient().queryFlow()).flatMapConcat((Function1 & Serializable & scala.Serializable)response -> {
            Source source;
            if (response.sdkHttpResponse().isSuccessful()) {
                source = Source$.MODULE$.single((Object)((TraversableLike)((TraversableLike)Option$.MODULE$.apply((Object)response.items()).map((Function1 & Serializable & scala.Serializable)x$8 -> (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(x$8).asScala()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)scala.collection.Seq$.MODULE$.empty())).map((Function1 & Serializable & scala.Serializable)x$9 -> ((TraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter(x$9).asScala()).toMap(Predef$.MODULE$.$conforms()), scala.collection.Seq$.MODULE$.canBuildFrom())).headOption());
            } else {
                int statusCode = response.sdkHttpResponse().statusCode();
                Optional statusText = response.sdkHttpResponse().statusText();
                source = Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).append(OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(statusText)).fold((Function0 & Serializable & scala.Serializable)() -> "", (Function1 & Serializable & scala.Serializable)s -> new StringBuilder(2).append(", ").append((String)s).toString())).toString()));
            }
            return source;
        }).mapAsync(1, (Function1 & Serializable & scala.Serializable)rowOpt -> this.deserialize((Option<scala.collection.immutable.Map<String, AttributeValue>>)rowOpt, ec));
    }

    public Source<BoxedUnit, NotUsed> save(SnapshotMetadata snapshotMetadata, Object snapshot, ExecutionContext ec) {
        return (Source)Source$.MODULE$.future(this.serializer().serialize(snapshotMetadata, snapshot, ec)).flatMapConcat((Function1 & Serializable & scala.Serializable)snapshotRow -> {
            PutItemRequest req = (PutItemRequest)PutItemRequest.builder().tableName($this.pluginConfig.tableName()).item((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.pluginConfig.columnsDefConfig().persistenceIdColumnName()), AttributeValue.builder().s(snapshotRow.persistenceId().asString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.pluginConfig.columnsDefConfig().sequenceNrColumnName()), AttributeValue.builder().n(snapshotRow.sequenceNumber().asString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.pluginConfig.columnsDefConfig().snapshotColumnName()), AttributeValue.builder().b(SdkBytes.fromByteArray((byte[])snapshotRow.snapshot())).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.pluginConfig.columnsDefConfig().createdColumnName()), AttributeValue.builder().n(((Object)BoxesRunTime.boxToLong((long)snapshotRow.created())).toString()).build())}))).asJava()).build();
            return (Source)Source$.MODULE$.single((Object)req).via((Graph)this.streamWriteClient().putItemFlow()).flatMapConcat((Function1 & Serializable & scala.Serializable)response -> {
                Source source;
                if (response.sdkHttpResponse().isSuccessful()) {
                    source = Source$.MODULE$.single((Object)BoxedUnit.UNIT);
                } else {
                    int statusCode = response.sdkHttpResponse().statusCode();
                    Optional statusText = response.sdkHttpResponse().statusText();
                    source = Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).append(OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(statusText)).fold((Function0 & Serializable & scala.Serializable)() -> "", (Function1 & Serializable & scala.Serializable)s -> new StringBuilder(2).append(", ").append((String)s).toString())).toString()));
                }
                return source;
            });
        });
    }

    private Source<BoxedUnit, NotUsed> queryDelete(QueryRequest queryRequest) {
        return (Source)((Source)Source$.MODULE$.single((Object)queryRequest).via((Graph)this.streamReadClient().queryFlow()).map((Function1 & Serializable & scala.Serializable)response -> (Seq)Option$.MODULE$.apply((Object)response.items()).map((Function1 & Serializable & scala.Serializable)x$10 -> (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(x$10).asScala()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)scala.collection.Seq$.MODULE$.empty())).mapConcat((Function1 & Serializable & scala.Serializable)x$11 -> x$11.toVector()).grouped(this.pluginConfig.clientConfig().batchWriteItemLimit()).map((Function1 & Serializable & scala.Serializable)rows -> (scala.collection.immutable.Seq)rows.map((Function1 & Serializable & scala.Serializable)javaRow -> {
            scala.collection.mutable.Map row = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(javaRow).asScala();
            PersistenceId x$1 = PersistenceId$.MODULE$.apply(((AttributeValue)row.apply((Object)$this.pluginConfig.columnsDefConfig().persistenceIdColumnName())).s());
            SequenceNumber x$2 = new SequenceNumber(new StringOps(Predef$.MODULE$.augmentString(((AttributeValue)row.apply((Object)$this.pluginConfig.columnsDefConfig().sequenceNrColumnName())).n())).toLong());
            byte[] x$3 = ((AttributeValue)row.apply((Object)$this.pluginConfig.columnsDefConfig().snapshotColumnName())).b().asByteArray();
            long x$4 = new StringOps(Predef$.MODULE$.augmentString(((AttributeValue)row.apply((Object)$this.pluginConfig.columnsDefConfig().createdColumnName())).n())).toLong();
            return new SnapshotRow(x$1, x$2, x$4, x$3);
        }, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)rows -> (BatchWriteItemRequest)BatchWriteItemRequest.builder().requestItems((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.pluginConfig.tableName()), CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)rows.map((Function1 & Serializable & scala.Serializable)row -> (WriteRequest)WriteRequest.builder().deleteRequest((DeleteRequest)DeleteRequest.builder().key((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.pluginConfig.columnsDefConfig().persistenceIdColumnName()), AttributeValue.builder().s(row.persistenceId().asString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.pluginConfig.columnsDefConfig().sequenceNrColumnName()), AttributeValue.builder().n(row.sequenceNumber().asString()).build())}))).asJava()).build()).build(), Seq$.MODULE$.canBuildFrom())).asJava())}))).asJava()).build())).via((Graph)this.streamWriteClient().batchWriteItemFlow()).flatMapConcat((Function1 & Serializable & scala.Serializable)response -> {
            Source source;
            if (response.sdkHttpResponse().isSuccessful()) {
                source = Source$.MODULE$.single((Object)BoxedUnit.UNIT);
            } else {
                int statusCode = response.sdkHttpResponse().statusCode();
                Optional statusText = response.sdkHttpResponse().statusText();
                source = Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).append(OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(statusText)).fold((Function0 & Serializable & scala.Serializable)() -> "", (Function1 & Serializable & scala.Serializable)s -> new StringBuilder(2).append(", ").append((String)s).toString())).toString()));
            }
            return source;
        });
    }

    public void dispose() {
        Option option;
        Option option2;
        Tuple2 tuple2 = new Tuple2(this.asyncClient, this.syncClient);
        if (tuple2 != null && (option2 = (Option)tuple2._1()) instanceof Some) {
            Some some = (Some)option2;
            DynamoDbAsyncClient a = (DynamoDbAsyncClient)some.value();
            a.close();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (tuple2 != null && (option = (Option)tuple2._2()) instanceof Some) {
            Some some = (Some)option;
            DynamoDbClient s = (DynamoDbClient)some.value();
            s.close();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public V2SnapshotDaoImpl(ActorSystem system, Option<DynamoDbAsyncClient> asyncClient, Option<DynamoDbClient> syncClient, Serialization serialization, SnapshotPluginConfig pluginConfig, Option<MetricsReporter> metricsReporter, Option<TraceReporter> traceReporter) {
        this.asyncClient = asyncClient;
        this.syncClient = syncClient;
        this.pluginConfig = pluginConfig;
        Tuple2 tuple2 = new Tuple2(asyncClient, syncClient);
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (None$.MODULE$.equals(option) && None$.MODULE$.equals(option2)) {
                throw new IllegalArgumentException("aws clients is both None");
            }
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        this.streamReadClient = new StreamReadClient(system, asyncClient, syncClient, (PluginConfig)pluginConfig, pluginConfig.readBackoffConfig());
        this.streamWriteClient = new StreamWriteClient(system, asyncClient, syncClient, (PluginConfig)pluginConfig, pluginConfig.writeBackoffConfig());
        this.serializer = new ByteArraySnapshotSerializer(serialization, metricsReporter, traceReporter);
    }
}

