/*
 * Decompiled with CFR 0.152.
 */
package com.github.j5ik2o.akka.persistence.dynamodb.snapshot.dao;

import akka.NotUsed;
import akka.persistence.SnapshotMetadata;
import akka.serialization.Serialization;
import akka.stream.Graph;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBAsync;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteItemRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteRequest;
import com.amazonaws.services.dynamodbv2.model.PutItemRequest;
import com.amazonaws.services.dynamodbv2.model.QueryRequest;
import com.amazonaws.services.dynamodbv2.model.WriteRequest;
import com.github.j5ik2o.akka.persistence.dynamodb.client.v1.StreamReadClient;
import com.github.j5ik2o.akka.persistence.dynamodb.client.v1.StreamWriteClient;
import com.github.j5ik2o.akka.persistence.dynamodb.context.PluginContext;
import com.github.j5ik2o.akka.persistence.dynamodb.model.PersistenceId;
import com.github.j5ik2o.akka.persistence.dynamodb.model.PersistenceId$;
import com.github.j5ik2o.akka.persistence.dynamodb.model.SequenceNumber;
import com.github.j5ik2o.akka.persistence.dynamodb.snapshot.SnapshotPluginContext;
import com.github.j5ik2o.akka.persistence.dynamodb.snapshot.dao.SnapshotDao;
import com.github.j5ik2o.akka.persistence.dynamodb.snapshot.dao.SnapshotRow;
import com.github.j5ik2o.akka.persistence.dynamodb.snapshot.serialization.ByteArraySnapshotSerializer;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t5b\u0001B\u000e\u001d\u00055B\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!\u000f\u0005\t{\u0001\u0011\t\u0011)A\u0005}!A1\n\u0001B\u0001B\u0003%A\n\u0003\u0005Q\u0001\t\u0005\t\u0015!\u0003R\u0011\u00159\u0006\u0001\"\u0001Y\u0011\u001dq\u0006A1A\u0005\n}Ca\u0001\u001b\u0001!\u0002\u0013\u0001\u0007bB5\u0001\u0005\u0004%IA\u001b\u0005\u0007g\u0002\u0001\u000b\u0011B6\t\u000fQ\u0004!\u0019!C\u0005k\"1\u0011\u0010\u0001Q\u0001\nYDqA\u001f\u0001C\u0002\u0013%1\u0010C\u0004\u0002\u0004\u0001\u0001\u000b\u0011\u0002?\t\u000f\u0005\u0015\u0001\u0001\"\u0011\u0002\b!9\u0011\u0011\n\u0001\u0005B\u0005-\u0003bBA/\u0001\u0011\u0005\u0013q\f\u0005\b\u0003c\u0002A\u0011IA:\u0011\u001d\ty\b\u0001C\u0005\u0003\u0003Cq!!5\u0001\t\u0003\n\u0019\u000eC\u0004\u0002^\u0002!\t%a8\t\u000f\u0005%\b\u0001\"\u0011\u0002l\"9\u0011Q\u001f\u0001\u0005B\u0005]\bb\u0002B\u0002\u0001\u0011\u0005#Q\u0001\u0005\b\u0005\u001b\u0001A\u0011\tB\b\u0011\u001d\u0011Y\u0002\u0001C\u0005\u0005;AqA!\u000b\u0001\t\u0003\u0012YCA\fWc1+w-Y2z':\f\u0007o\u001d5pi\u0012\u000bw.S7qY*\u0011QDH\u0001\u0004I\u0006|'BA\u0010!\u0003!\u0019h.\u00199tQ>$(BA\u0011#\u0003!!\u0017P\\1n_\u0012\u0014'BA\u0012%\u0003-\u0001XM]:jgR,gnY3\u000b\u0005\u00152\u0013\u0001B1lW\u0006T!a\n\u0015\u0002\r),\u0014n\u001b\u001ap\u0015\tI#&\u0001\u0004hSRDWO\u0019\u0006\u0002W\u0005\u00191m\\7\u0004\u0001M\u0019\u0001A\f\u001b\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0003E\nQa]2bY\u0006L!a\r\u0019\u0003\r\u0005s\u0017PU3g!\t)d'D\u0001\u001d\u0013\t9DDA\u0006T]\u0006\u00048\u000f[8u\t\u0006|\u0017!\u00049mk\u001eLgnQ8oi\u0016DH\u000f\u0005\u0002;w5\ta$\u0003\u0002==\t)2K\\1qg\"|G\u000f\u00157vO&t7i\u001c8uKb$\u0018aC1ts:\u001c7\t\\5f]R\u00042aL B\u0013\t\u0001\u0005G\u0001\u0004PaRLwN\u001c\t\u0003\u0005&k\u0011a\u0011\u0006\u0003\t\u0016\u000b!\u0002Z=oC6|GM\u0019<3\u0015\t1u)\u0001\u0005tKJ4\u0018nY3t\u0015\tA%&A\u0005b[\u0006TxN\\1xg&\u0011!j\u0011\u0002\u0014\u00036\f'p\u001c8Es:\fWn\u001c#C\u0003NLhnY\u0001\u000bgft7m\u00117jK:$\bcA\u0018@\u001bB\u0011!IT\u0005\u0003\u001f\u000e\u0013a\"Q7bu>tG)\u001f8b[>$%)A\u0007tKJL\u0017\r\\5{CRLwN\u001c\t\u0003%Vk\u0011a\u0015\u0006\u0003!RS\u0011!J\u0005\u0003-N\u0013QbU3sS\u0006d\u0017N_1uS>t\u0017A\u0002\u001fj]&$h\bF\u0003Z5ncV\f\u0005\u00026\u0001!)\u0001(\u0002a\u0001s!)Q(\u0002a\u0001}!)1*\u0002a\u0001\u0019\")\u0001+\u0002a\u0001#\u00061An\\4hKJ,\u0012\u0001\u0019\t\u0003C\u001al\u0011A\u0019\u0006\u0003G\u0012\fQa\u001d7gi)T\u0011!Z\u0001\u0004_J<\u0017BA4c\u0005\u0019aunZ4fe\u00069An\\4hKJ\u0004\u0013\u0001E:ue\u0016\fWNU3bI\u000ec\u0017.\u001a8u+\u0005Y\u0007C\u00017r\u001b\u0005i'B\u00018p\u0003\t1\u0018G\u0003\u0002qA\u000511\r\\5f]RL!A]7\u0003!M#(/Z1n%\u0016\fGm\u00117jK:$\u0018!E:ue\u0016\fWNU3bI\u000ec\u0017.\u001a8uA\u0005\t2\u000f\u001e:fC6<&/\u001b;f\u00072LWM\u001c;\u0016\u0003Y\u0004\"\u0001\\<\n\u0005al'!E*ue\u0016\fWn\u0016:ji\u0016\u001cE.[3oi\u0006\u00112\u000f\u001e:fC6<&/\u001b;f\u00072LWM\u001c;!\u0003)\u0019XM]5bY&TXM]\u000b\u0002yB\u0011Qp`\u0007\u0002}*\u0011\u0001KH\u0005\u0004\u0003\u0003q(a\u0007\"zi\u0016\f%O]1z':\f\u0007o\u001d5piN+'/[1mSj,'/A\u0006tKJL\u0017\r\\5{KJ\u0004\u0013A\u00053fY\u0016$X-\u00117m':\f\u0007o\u001d5piN$B!!\u0003\u0002:Q!\u00111BA\u0015!!\ti!a\u0006\u0002\u001c\u0005\u0005RBAA\b\u0015\u0011\t\t\"a\u0005\u0002\u0011M\u001c\u0017\r\\1eg2T1!!\u0006U\u0003\u0019\u0019HO]3b[&!\u0011\u0011DA\b\u0005\u0019\u0019v.\u001e:dKB\u0019q&!\b\n\u0007\u0005}\u0001G\u0001\u0003V]&$\b\u0003BA\u0012\u0003Ki\u0011\u0001V\u0005\u0004\u0003O!&a\u0002(piV\u001bX\r\u001a\u0005\b\u0003Wq\u00019AA\u0017\u0003\t)7\r\u0005\u0003\u00020\u0005URBAA\u0019\u0015\r\t\u0019\u0004M\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002BA\u001c\u0003c\u0011\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\t\u000f\u0005mb\u00021\u0001\u0002>\u0005i\u0001/\u001a:tSN$XM\\2f\u0013\u0012\u0004B!a\u0010\u0002F5\u0011\u0011\u0011\t\u0006\u0004\u0003\u0007\u0002\u0013!B7pI\u0016d\u0017\u0002BA$\u0003\u0003\u0012Q\u0002U3sg&\u001cH/\u001a8dK&#\u0017a\u00063fY\u0016$X-\u00169U_6\u000b\u0007pU3rk\u0016t7-\u001a(s)\u0019\ti%!\u0015\u0002TQ!\u00111BA(\u0011\u001d\tYc\u0004a\u0002\u0003[Aq!a\u000f\u0010\u0001\u0004\ti\u0004C\u0004\u0002V=\u0001\r!a\u0016\u0002\u001b5\f\u0007pU3rk\u0016t7-\u001a(s!\u0011\ty$!\u0017\n\t\u0005m\u0013\u0011\t\u0002\u000f'\u0016\fX/\u001a8dK:+XNY3s\u0003Y!W\r\\3uKV\u0003Hk\\'bqRKW.Z:uC6\u0004HCBA1\u0003K\n9\u0007\u0006\u0003\u0002\f\u0005\r\u0004bBA\u0016!\u0001\u000f\u0011Q\u0006\u0005\b\u0003w\u0001\u0002\u0019AA\u001f\u0011\u001d\tI\u0007\u0005a\u0001\u0003W\nA\"\\1y)&lWm\u001d;b[B\u00042aLA7\u0013\r\ty\u0007\r\u0002\u0005\u0019>tw-\u0001\u0014eK2,G/Z+q)>l\u0015\r_*fcV,gnY3Oe\u0006sG-T1y)&lWm\u001d;b[B$\u0002\"!\u001e\u0002z\u0005m\u0014Q\u0010\u000b\u0005\u0003\u0017\t9\bC\u0004\u0002,E\u0001\u001d!!\f\t\u000f\u0005m\u0012\u00031\u0001\u0002>!9\u0011QK\tA\u0002\u0005]\u0003bBA5#\u0001\u0007\u00111N\u0001\fI\u0016\u001cXM]5bY&TX\r\u0006\u0003\u0002\u0004\u0006\u0015F\u0003BAC\u0003G\u0003b!a\f\u0002\b\u0006-\u0015\u0002BAE\u0003c\u0011aAR;ukJ,\u0007\u0003B\u0018@\u0003\u001b\u0003raLAH\u0003'\u000bi*C\u0002\u0002\u0012B\u0012a\u0001V;qY\u0016\u0014\u0004\u0003BAK\u00033k!!a&\u000b\u0005\r\"\u0016\u0002BAN\u0003/\u0013\u0001c\u00158baNDw\u000e^'fi\u0006$\u0017\r^1\u0011\u0007=\ny*C\u0002\u0002\"B\u00121!\u00118z\u0011\u001d\tYC\u0005a\u0002\u0003[Aq!a*\u0013\u0001\u0004\tI+\u0001\u0004s_^|\u0005\u000f\u001e\t\u0005_}\nY\u000b\u0005\u0005\u0002.\u0006m\u0016\u0011YAd\u001d\u0011\ty+a.\u0011\u0007\u0005E\u0006'\u0004\u0002\u00024*\u0019\u0011Q\u0017\u0017\u0002\rq\u0012xn\u001c;?\u0013\r\tI\fM\u0001\u0007!J,G-\u001a4\n\t\u0005u\u0016q\u0018\u0002\u0004\u001b\u0006\u0004(bAA]aA!\u0011QVAb\u0013\u0011\t)-a0\u0003\rM#(/\u001b8h!\u0011\tI-!4\u000e\u0005\u0005-'bAA\"\u0007&!\u0011qZAf\u00059\tE\u000f\u001e:jEV$XMV1mk\u0016\fa\u0002\\1uKN$8K\\1qg\"|G\u000f\u0006\u0003\u0002V\u0006mG\u0003BAl\u00033\u0004\u0002\"!\u0004\u0002\u0018\u0005-\u0015\u0011\u0005\u0005\b\u0003W\u0019\u00029AA\u0017\u0011\u001d\tYd\u0005a\u0001\u0003{\tqc\u001d8baNDw\u000e\u001e$pe6\u000b\u0007\u0010V5nKN$\u0018-\u001c9\u0015\r\u0005\u0005\u0018Q]At)\u0011\t9.a9\t\u000f\u0005-B\u0003q\u0001\u0002.!9\u00111\b\u000bA\u0002\u0005u\u0002bBA5)\u0001\u0007\u00111N\u0001\u0019g:\f\u0007o\u001d5pi\u001a{'/T1y'\u0016\fX/\u001a8dK:\u0013HCBAw\u0003c\f\u0019\u0010\u0006\u0003\u0002X\u0006=\bbBA\u0016+\u0001\u000f\u0011Q\u0006\u0005\b\u0003w)\u0002\u0019AA\u001f\u0011\u001d\t)&\u0006a\u0001\u0003/\nqe\u001d8baNDw\u000e\u001e$pe6\u000b\u0007pU3rk\u0016t7-\u001a(s\u0003:$W*\u0019=US6,7\u000f^1naRA\u0011\u0011`A\u007f\u0003\u007f\u0014\t\u0001\u0006\u0003\u0002X\u0006m\bbBA\u0016-\u0001\u000f\u0011Q\u0006\u0005\b\u0003w1\u0002\u0019AA\u001f\u0011\u001d\t)F\u0006a\u0001\u0003/Bq!!\u001b\u0017\u0001\u0004\tY'\u0001\u0004eK2,G/\u001a\u000b\u0007\u0003\u0017\u00119A!\u0003\t\u000f\u0005mr\u00031\u0001\u0002>!9!1B\fA\u0002\u0005]\u0013AC:fcV,gnY3Oe\u0006!1/\u0019<f)\u0019\u0011\tB!\u0006\u0003\u001aQ!\u00111\u0002B\n\u0011\u001d\tY\u0003\u0007a\u0002\u0003[AqAa\u0006\u0019\u0001\u0004\t\u0019*\u0001\tt]\u0006\u00048\u000f[8u\u001b\u0016$\u0018\rZ1uC\"1q\u0004\u0007a\u0001\u0003;\u000b1\"];fef$U\r\\3uKR!\u00111\u0002B\u0010\u0011\u001d\u0011\t#\u0007a\u0001\u0005G\tA\"];fef\u0014V-];fgR\u0004B!!3\u0003&%!!qEAf\u00051\tV/\u001a:z%\u0016\fX/Z:u\u0003\u001d!\u0017n\u001d9pg\u0016$\"!a\u0007")
public final class V1LegacySnapshotDaoImpl
implements SnapshotDao {
    private final SnapshotPluginContext pluginContext;
    private final Option<AmazonDynamoDBAsync> asyncClient;
    private final Option<AmazonDynamoDB> syncClient;
    private final Logger logger;
    private final StreamReadClient streamReadClient;
    private final StreamWriteClient streamWriteClient;
    private final ByteArraySnapshotSerializer serializer;

    private Logger logger() {
        return this.logger;
    }

    private StreamReadClient streamReadClient() {
        return this.streamReadClient;
    }

    private StreamWriteClient streamWriteClient() {
        return this.streamWriteClient;
    }

    private ByteArraySnapshotSerializer serializer() {
        return this.serializer;
    }

    public Source<BoxedUnit, NotUsed> deleteAllSnapshots(PersistenceId persistenceId, ExecutionContext ec) {
        this.logger().debug(new StringBuilder(27).append("deleteAllSnapshots(").append(persistenceId).append("): start").toString());
        this.logger().debug(new StringBuilder(14).append("pluginConfig: ").append(this.pluginContext.pluginConfig()).toString());
        QueryRequest queryRequest = new QueryRequest().withTableName(this.pluginContext.pluginConfig().tableName()).withKeyConditionExpression("#pid = :pid and #snr between :min and :max").withExpressionAttributeNames(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().sequenceNrColumnName())}))).asJava()).withExpressionAttributeValues(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), (Object)new AttributeValue().withS(persistenceId.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), (Object)new AttributeValue().withN(Integer.toString(0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), (Object)new AttributeValue().withN(Long.toString(Long.MAX_VALUE)))}))).asJava()).withConsistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginContext.pluginConfig().consistentRead()));
        Source<BoxedUnit, NotUsed> result = this.queryDelete(queryRequest);
        this.logger().debug(new StringBuilder(29).append("deleteAllSnapshots(").append(persistenceId).append("):").append(result).append(": finish").toString());
        return result;
    }

    public Source<BoxedUnit, NotUsed> deleteUpToMaxSequenceNr(PersistenceId persistenceId, SequenceNumber maxSequenceNr, ExecutionContext ec) {
        this.logger().debug(new StringBuilder(34).append("deleteUpToMaxSequenceNr(").append(persistenceId).append(", ").append(maxSequenceNr).append("): start").toString());
        this.logger().debug(new StringBuilder(14).append("pluginConfig: ").append(this.pluginContext.pluginConfig()).toString());
        QueryRequest queryRequest = new QueryRequest().withTableName(this.pluginContext.pluginConfig().tableName()).withKeyConditionExpression("#pid = :pid and #snr between :min and :max").withExpressionAttributeNames(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().sequenceNrColumnName())}))).asJava()).withExpressionAttributeValues(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), (Object)new AttributeValue().withS(persistenceId.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), (Object)new AttributeValue().withN(Integer.toString(0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), (Object)new AttributeValue().withN(maxSequenceNr.asString()))}))).asJava()).withConsistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginContext.pluginConfig().consistentRead()));
        Source<BoxedUnit, NotUsed> result = this.queryDelete(queryRequest);
        this.logger().debug(new StringBuilder(36).append("deleteUpToMaxSequenceNr(").append(persistenceId).append(", ").append(maxSequenceNr).append("):").append(result).append(": finish").toString());
        return result;
    }

    public Source<BoxedUnit, NotUsed> deleteUpToMaxTimestamp(PersistenceId persistenceId, long maxTimestamp, ExecutionContext ec) {
        this.logger().debug(new StringBuilder(33).append("deleteUpToMaxTimestamp(").append(persistenceId).append(", ").append(maxTimestamp).append("): start").toString());
        this.logger().debug(new StringBuilder(14).append("pluginConfig: ").append(this.pluginContext.pluginConfig()).toString());
        QueryRequest queryRequest = new QueryRequest().withTableName(this.pluginContext.pluginConfig().tableName()).withKeyConditionExpression("#pid = :pid and #snr between :min and :max").withFilterExpression("#created <= :maxTimestamp").withExpressionAttributeNames(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().sequenceNrColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#created"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().createdColumnName())}))).asJava()).withExpressionAttributeValues(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), (Object)new AttributeValue().withS(persistenceId.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), (Object)new AttributeValue().withN(Integer.toString(0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), (Object)new AttributeValue().withN(Long.toString(Long.MAX_VALUE))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":maxTimestamp"), (Object)new AttributeValue().withN(Long.toString(maxTimestamp)))}))).asJava()).withConsistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginContext.pluginConfig().consistentRead()));
        Source<BoxedUnit, NotUsed> result = this.queryDelete(queryRequest);
        this.logger().debug(new StringBuilder(34).append("deleteUpToMaxTimestamp(").append(persistenceId).append(", ").append(maxTimestamp).append("): finish").toString());
        return result;
    }

    public Source<BoxedUnit, NotUsed> deleteUpToMaxSequenceNrAndMaxTimestamp(PersistenceId persistenceId, SequenceNumber maxSequenceNr, long maxTimestamp, ExecutionContext ec) {
        this.logger().debug(new StringBuilder(51).append("deleteUpToMaxSequenceNrAndMaxTimestamp(").append(persistenceId).append(", ").append(maxTimestamp).append(", ").append(maxTimestamp).append("): start").toString());
        this.logger().debug(new StringBuilder(14).append("pluginConfig: ").append(this.pluginContext.pluginConfig()).toString());
        QueryRequest queryRequest = new QueryRequest().withTableName(this.pluginContext.pluginConfig().tableName()).withKeyConditionExpression("#pid = :pid and #snr between :min and :max").withFilterExpression("#created <= :maxTimestamp").withExpressionAttributeNames(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().sequenceNrColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#created"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().createdColumnName())}))).asJava()).withExpressionAttributeValues(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), (Object)new AttributeValue().withS(persistenceId.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), (Object)new AttributeValue().withN(Integer.toString(0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), (Object)new AttributeValue().withN(maxSequenceNr.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":maxTimestamp"), (Object)new AttributeValue().withN(Long.toString(maxTimestamp)))}))).asJava()).withConsistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginContext.pluginConfig().consistentRead()));
        Source<BoxedUnit, NotUsed> result = this.queryDelete(queryRequest);
        this.logger().debug(new StringBuilder(53).append("deleteUpToMaxSequenceNrAndMaxTimestamp(").append(persistenceId).append(", ").append(maxTimestamp).append(", ").append(maxTimestamp).append("):").append(result).append(": finish").toString());
        return result;
    }

    private Future<Option<Tuple2<SnapshotMetadata, Object>>> deserialize(Option<scala.collection.immutable.Map<String, AttributeValue>> rowOpt, ExecutionContext ec) {
        Option<scala.collection.immutable.Map<String, AttributeValue>> option = rowOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            scala.collection.immutable.Map row = (scala.collection.immutable.Map)some.value();
            PersistenceId x$12 = PersistenceId$.MODULE$.apply(((AttributeValue)row.apply((Object)this.pluginContext.pluginConfig().columnsDefConfig().persistenceIdColumnName())).getS());
            SequenceNumber x$2 = new SequenceNumber(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(((AttributeValue)row.apply((Object)this.pluginContext.pluginConfig().columnsDefConfig().sequenceNrColumnName())).getN())));
            byte[] x$3 = ((AttributeValue)row.apply((Object)this.pluginContext.pluginConfig().columnsDefConfig().snapshotColumnName())).getB().array();
            long x$4 = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(((AttributeValue)row.apply((Object)this.pluginContext.pluginConfig().columnsDefConfig().createdColumnName())).getN()));
            return this.serializer().deserialize(new SnapshotRow(x$12, x$2, x$4, x$3), ec).map((Function1 & Serializable)x$1 -> new Some(x$1), ec);
        }
        if (None$.MODULE$.equals(option)) {
            return Future$.MODULE$.successful((Object)None$.MODULE$);
        }
        throw new MatchError(option);
    }

    public Source<Option<Tuple2<SnapshotMetadata, Object>>, NotUsed> latestSnapshot(PersistenceId persistenceId, ExecutionContext ec) {
        this.logger().debug(new StringBuilder(23).append("latestSnapshot(").append(persistenceId).append("): start").toString());
        this.logger().debug(new StringBuilder(14).append("pluginConfig: ").append(this.pluginContext.pluginConfig()).toString());
        QueryRequest queryRequest = new QueryRequest().withTableName(this.pluginContext.pluginConfig().tableName()).withKeyConditionExpression("#pid = :pid and #snr between :min and :max").withExpressionAttributeNames(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().sequenceNrColumnName())}))).asJava()).withExpressionAttributeValues(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), (Object)new AttributeValue().withS(persistenceId.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), (Object)new AttributeValue().withN(Integer.toString(0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), (Object)new AttributeValue().withN(Long.toString(Long.MAX_VALUE)))}))).asJava()).withScanIndexForward(Predef$.MODULE$.boolean2Boolean(false)).withLimit(Predef$.MODULE$.int2Integer(1)).withConsistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginContext.pluginConfig().consistentRead()));
        Source result = (Source)Source$.MODULE$.single((Object)queryRequest).via((Graph)this.streamReadClient().queryFlow()).flatMapConcat((Function1 & Serializable)response -> {
            if (response.getSdkHttpMetadata().getHttpStatusCode() == 200) {
                return Source$.MODULE$.single((Object)((IterableOps)((IterableOps)Option$.MODULE$.apply((Object)response.getItems()).map((Function1 & Serializable)x$2 -> CollectionConverters$.MODULE$.ListHasAsScala(x$2).asScala()).getOrElse((Function0 & Serializable)() -> (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty())).map((Function1 & Serializable)x$3 -> CollectionConverters$.MODULE$.MapHasAsScala(x$3).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()))).headOption());
            }
            int statusCode = response.getSdkHttpMetadata().getHttpStatusCode();
            return Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).toString()));
        }).mapAsync(1, (Function1 & Serializable)rowOpt -> this.deserialize((Option<scala.collection.immutable.Map<String, AttributeValue>>)rowOpt, ec));
        this.logger().debug(new StringBuilder(24).append("latestSnapshot(").append(persistenceId).append("): finish").toString());
        return result;
    }

    public Source<Option<Tuple2<SnapshotMetadata, Object>>, NotUsed> snapshotForMaxTimestamp(PersistenceId persistenceId, long maxTimestamp, ExecutionContext ec) {
        this.logger().debug(new StringBuilder(34).append("snapshotForMaxTimestamp(").append(persistenceId).append(", ").append(maxTimestamp).append("): start").toString());
        this.logger().debug(new StringBuilder(14).append("pluginConfig: ").append(this.pluginContext.pluginConfig()).toString());
        QueryRequest queryRequest = new QueryRequest().withTableName(this.pluginContext.pluginConfig().tableName()).withKeyConditionExpression("#pid = :pid and #snr between :min and :max").withFilterExpression("#created <= :maxTimestamp").withExpressionAttributeNames(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().sequenceNrColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#created"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().createdColumnName())}))).asJava()).withExpressionAttributeValues(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), (Object)new AttributeValue().withS(persistenceId.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), (Object)new AttributeValue().withN(Integer.toString(0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), (Object)new AttributeValue().withN(Long.toString(Long.MAX_VALUE))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":maxTimestamp"), (Object)new AttributeValue().withN(Long.toString(maxTimestamp)))}))).asJava()).withScanIndexForward(Predef$.MODULE$.boolean2Boolean(false)).withConsistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginContext.pluginConfig().consistentRead()));
        Source result = (Source)Source$.MODULE$.single((Object)queryRequest).via((Graph)this.streamReadClient().queryFlow()).flatMapConcat((Function1 & Serializable)response -> {
            if (response.getSdkHttpMetadata().getHttpStatusCode() == 200) {
                return Source$.MODULE$.single((Object)((IterableOps)((IterableOps)Option$.MODULE$.apply((Object)response.getItems()).map((Function1 & Serializable)x$4 -> CollectionConverters$.MODULE$.ListHasAsScala(x$4).asScala()).getOrElse((Function0 & Serializable)() -> (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty())).map((Function1 & Serializable)x$5 -> CollectionConverters$.MODULE$.MapHasAsScala(x$5).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()))).headOption());
            }
            int statusCode = response.getSdkHttpMetadata().getHttpStatusCode();
            return Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).toString()));
        }).mapAsync(1, (Function1 & Serializable)rowOpt -> this.deserialize((Option<scala.collection.immutable.Map<String, AttributeValue>>)rowOpt, ec));
        this.logger().debug(new StringBuilder(36).append("snapshotForMaxTimestamp(").append(persistenceId).append(", ").append(maxTimestamp).append("):").append(result).append(": finish").toString());
        return result;
    }

    public Source<Option<Tuple2<SnapshotMetadata, Object>>, NotUsed> snapshotForMaxSequenceNr(PersistenceId persistenceId, SequenceNumber maxSequenceNr, ExecutionContext ec) {
        this.logger().debug(new StringBuilder(35).append("snapshotForMaxSequenceNr(").append(persistenceId).append(", ").append(maxSequenceNr).append("): start").toString());
        this.logger().debug(new StringBuilder(14).append("pluginConfig: ").append(this.pluginContext.pluginConfig()).toString());
        QueryRequest queryRequest = new QueryRequest().withTableName(this.pluginContext.pluginConfig().tableName()).withKeyConditionExpression("#pid = :pid and #snr between :min and :max").withExpressionAttributeNames(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().sequenceNrColumnName())}))).asJava()).withExpressionAttributeValues(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), (Object)new AttributeValue().withS(persistenceId.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), (Object)new AttributeValue().withN(Integer.toString(0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), (Object)new AttributeValue().withN(maxSequenceNr.asString()))}))).asJava()).withScanIndexForward(Predef$.MODULE$.boolean2Boolean(false)).withConsistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginContext.pluginConfig().consistentRead()));
        Source result = (Source)Source$.MODULE$.single((Object)queryRequest).via((Graph)this.streamReadClient().queryFlow()).flatMapConcat((Function1 & Serializable)response -> {
            if (response.getSdkHttpMetadata().getHttpStatusCode() == 200) {
                return Source$.MODULE$.single((Object)((IterableOps)((IterableOps)Option$.MODULE$.apply((Object)response.getItems()).map((Function1 & Serializable)x$6 -> CollectionConverters$.MODULE$.ListHasAsScala(x$6).asScala()).getOrElse((Function0 & Serializable)() -> (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty())).map((Function1 & Serializable)x$7 -> CollectionConverters$.MODULE$.MapHasAsScala(x$7).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()))).headOption());
            }
            int statusCode = response.getSdkHttpMetadata().getHttpStatusCode();
            return Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).toString()));
        }).mapAsync(1, (Function1 & Serializable)rowOpt -> this.deserialize((Option<scala.collection.immutable.Map<String, AttributeValue>>)rowOpt, ec));
        this.logger().debug(new StringBuilder(37).append("snapshotForMaxSequenceNr(").append(persistenceId).append(", ").append(maxSequenceNr).append("):").append(result).append(": finish").toString());
        return result;
    }

    public Source<Option<Tuple2<SnapshotMetadata, Object>>, NotUsed> snapshotForMaxSequenceNrAndMaxTimestamp(PersistenceId persistenceId, SequenceNumber maxSequenceNr, long maxTimestamp, ExecutionContext ec) {
        this.logger().debug(new StringBuilder(52).append("snapshotForMaxSequenceNrAndMaxTimestamp(").append(persistenceId).append(", ").append(maxSequenceNr).append(", ").append(maxTimestamp).append("): start").toString());
        this.logger().debug(new StringBuilder(14).append("pluginConfig: ").append(this.pluginContext.pluginConfig()).toString());
        QueryRequest queryRequest = new QueryRequest().withTableName(this.pluginContext.pluginConfig().tableName()).withKeyConditionExpression("#pid = :pid and #snr between :min and :max").withFilterExpression("#created <= :maxTimestamp").withExpressionAttributeNames(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().sequenceNrColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#created"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().createdColumnName())}))).asJava()).withExpressionAttributeValues(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), (Object)new AttributeValue().withS(persistenceId.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), (Object)new AttributeValue().withN(Integer.toString(0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), (Object)new AttributeValue().withN(maxSequenceNr.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":maxTimestamp"), (Object)new AttributeValue().withN(Long.toString(maxTimestamp)))}))).asJava()).withScanIndexForward(Predef$.MODULE$.boolean2Boolean(false)).withConsistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginContext.pluginConfig().consistentRead()));
        Source result = (Source)Source$.MODULE$.single((Object)queryRequest).via((Graph)this.streamReadClient().queryFlow()).flatMapConcat((Function1 & Serializable)response -> {
            if (response.getSdkHttpMetadata().getHttpStatusCode() == 200) {
                return Source$.MODULE$.single((Object)((IterableOps)((IterableOps)Option$.MODULE$.apply((Object)response.getItems()).map((Function1 & Serializable)x$8 -> CollectionConverters$.MODULE$.ListHasAsScala(x$8).asScala()).getOrElse((Function0 & Serializable)() -> (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty())).map((Function1 & Serializable)x$9 -> CollectionConverters$.MODULE$.MapHasAsScala(x$9).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()))).headOption());
            }
            int statusCode = response.getSdkHttpMetadata().getHttpStatusCode();
            return Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).toString()));
        }).mapAsync(1, (Function1 & Serializable)rowOpt -> this.deserialize((Option<scala.collection.immutable.Map<String, AttributeValue>>)rowOpt, ec));
        this.logger().debug(new StringBuilder(54).append("snapshotForMaxSequenceNrAndMaxTimestamp(").append(persistenceId).append(", ").append(maxSequenceNr).append(", ").append(maxTimestamp).append("):").append(result).append(": finish").toString());
        return result;
    }

    public Source<BoxedUnit, NotUsed> delete(PersistenceId persistenceId, SequenceNumber sequenceNr) {
        this.logger().debug(new StringBuilder(50).append("snapshotForMaxSequenceNrAndMaxTimestamp(").append(persistenceId).append(", ").append(sequenceNr).append("): start").toString());
        this.logger().debug(new StringBuilder(14).append("pluginConfig: ").append(this.pluginContext.pluginConfig()).toString());
        DeleteItemRequest req = new DeleteItemRequest().withTableName(this.pluginContext.pluginConfig().tableName()).withKey(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext.pluginConfig().columnsDefConfig().persistenceIdColumnName()), (Object)new AttributeValue().withS(persistenceId.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext.pluginConfig().columnsDefConfig().sequenceNrColumnName()), (Object)new AttributeValue().withN(sequenceNr.asString()))}))).asJava());
        Source result = (Source)Source$.MODULE$.single((Object)req).via((Graph)this.streamWriteClient().deleteItemFlow()).flatMapConcat((Function1 & Serializable)response -> {
            if (response.getSdkHttpMetadata().getHttpStatusCode() == 200) {
                return Source$.MODULE$.single((Object)BoxedUnit.UNIT);
            }
            int statusCode = response.getSdkHttpMetadata().getHttpStatusCode();
            return Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).toString()));
        });
        this.logger().debug(new StringBuilder(51).append("snapshotForMaxSequenceNrAndMaxTimestamp(").append(persistenceId).append(", ").append(sequenceNr).append("): finish").toString());
        return result;
    }

    public Source<BoxedUnit, NotUsed> save(SnapshotMetadata snapshotMetadata, Object snapshot, ExecutionContext ec) {
        this.logger().debug(new StringBuilder(13).append("save(").append(snapshotMetadata).append("): start").toString());
        this.logger().debug(new StringBuilder(14).append("pluginConfig: ").append(this.pluginContext.pluginConfig()).toString());
        Source result = (Source)Source$.MODULE$.future(this.serializer().serialize(snapshotMetadata, snapshot, ec)).flatMapConcat((Function1 & Serializable)snapshotRow -> {
            PutItemRequest req = new PutItemRequest().withTableName($this.pluginContext.pluginConfig().tableName()).withItem(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.pluginContext.pluginConfig().columnsDefConfig().persistenceIdColumnName()), (Object)new AttributeValue().withS(snapshotRow.persistenceId().asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.pluginContext.pluginConfig().columnsDefConfig().sequenceNrColumnName()), (Object)new AttributeValue().withN(snapshotRow.sequenceNumber().asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.pluginContext.pluginConfig().columnsDefConfig().snapshotColumnName()), (Object)new AttributeValue().withB(ByteBuffer.wrap(snapshotRow.snapshot()))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.pluginContext.pluginConfig().columnsDefConfig().createdColumnName()), (Object)new AttributeValue().withN(Long.toString(snapshotRow.created())))}))).asJava());
            return (Source)Source$.MODULE$.single((Object)req).via((Graph)this.streamWriteClient().putItemFlow()).flatMapConcat((Function1 & Serializable)response -> {
                if (response.getSdkHttpMetadata().getHttpStatusCode() == 200) {
                    return Source$.MODULE$.single((Object)BoxedUnit.UNIT);
                }
                int statusCode = response.getSdkHttpMetadata().getHttpStatusCode();
                return Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).toString()));
            });
        });
        this.logger().debug(new StringBuilder(15).append("save(").append(snapshotMetadata).append("):").append(result).append(": finish").toString());
        return result;
    }

    private Source<BoxedUnit, NotUsed> queryDelete(QueryRequest queryRequest) {
        return (Source)((Source)Source$.MODULE$.single((Object)queryRequest).via((Graph)this.streamReadClient().queryFlow()).map((Function1 & Serializable)v -> (Seq)Option$.MODULE$.apply((Object)v.getItems()).map((Function1 & Serializable)x$10 -> CollectionConverters$.MODULE$.ListHasAsScala(x$10).asScala()).getOrElse((Function0 & Serializable)() -> (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty())).mapConcat((Function1 & Serializable)x$11 -> x$11.toVector()).grouped(this.pluginContext.pluginConfig().clientConfig().batchWriteItemLimit()).map((Function1 & Serializable)rows -> (scala.collection.immutable.Seq)rows.map((Function1 & Serializable)row -> {
            scala.collection.mutable.Map _row = CollectionConverters$.MODULE$.MapHasAsScala(row).asScala();
            PersistenceId x$1 = PersistenceId$.MODULE$.apply(((AttributeValue)_row.apply((Object)$this.pluginContext.pluginConfig().columnsDefConfig().persistenceIdColumnName())).getS());
            SequenceNumber x$2 = new SequenceNumber(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(((AttributeValue)_row.apply((Object)$this.pluginContext.pluginConfig().columnsDefConfig().sequenceNrColumnName())).getN())));
            byte[] x$3 = ((AttributeValue)_row.apply((Object)$this.pluginContext.pluginConfig().columnsDefConfig().snapshotColumnName())).getB().array();
            long x$4 = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(((AttributeValue)_row.apply((Object)$this.pluginContext.pluginConfig().columnsDefConfig().createdColumnName())).getN()));
            return new SnapshotRow(x$1, x$2, x$4, x$3);
        })).map((Function1 & Serializable)rows -> new BatchWriteItemRequest().withRequestItems(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.pluginContext.pluginConfig().tableName()), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)rows.map((Function1 & Serializable)row -> new WriteRequest().withDeleteRequest(new DeleteRequest().withKey(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.pluginContext.pluginConfig().columnsDefConfig().persistenceIdColumnName()), (Object)new AttributeValue().withS(row.persistenceId().asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.pluginContext.pluginConfig().columnsDefConfig().sequenceNrColumnName()), (Object)new AttributeValue().withN(row.sequenceNumber().asString()))}))).asJava())))).asJava())}))).asJava()))).via((Graph)this.streamWriteClient().batchWriteItemFlow()).flatMapConcat((Function1 & Serializable)response -> {
            if (response.getSdkHttpMetadata().getHttpStatusCode() == 200) {
                return Source$.MODULE$.single((Object)BoxedUnit.UNIT);
            }
            int statusCode = response.getSdkHttpMetadata().getHttpStatusCode();
            return Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).toString()));
        });
    }

    public void dispose() {
        Option option;
        Option option2;
        Tuple2 tuple2 = new Tuple2(this.asyncClient, this.syncClient);
        if (tuple2 != null && (option2 = (Option)tuple2._1()) instanceof Some) {
            Some some = (Some)option2;
            AmazonDynamoDBAsync a = (AmazonDynamoDBAsync)some.value();
            a.shutdown();
            return;
        }
        if (tuple2 != null && (option = (Option)tuple2._2()) instanceof Some) {
            Some some = (Some)option;
            AmazonDynamoDB s = (AmazonDynamoDB)some.value();
            s.shutdown();
            return;
        }
    }

    public V1LegacySnapshotDaoImpl(SnapshotPluginContext pluginContext, Option<AmazonDynamoDBAsync> asyncClient, Option<AmazonDynamoDB> syncClient, Serialization serialization) {
        this.pluginContext = pluginContext;
        this.asyncClient = asyncClient;
        this.syncClient = syncClient;
        Tuple2 tuple2 = new Tuple2(asyncClient, syncClient);
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (None$.MODULE$.equals(option) && None$.MODULE$.equals(option2)) {
                throw new IllegalArgumentException("aws clients is both None");
            }
        }
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.streamReadClient = new StreamReadClient((PluginContext)pluginContext, asyncClient, syncClient, pluginContext.pluginConfig().readBackoffConfig());
        this.streamWriteClient = new StreamWriteClient((PluginContext)pluginContext, asyncClient, syncClient, pluginContext.pluginConfig().writeBackoffConfig());
        this.serializer = new ByteArraySnapshotSerializer(serialization, pluginContext.metricsReporter(), pluginContext.traceReporter());
    }
}

