/*
 * Decompiled with CFR 0.152.
 */
package com.github.j5ik2o.akka.persistence.dynamodb.snapshot.dao;

import akka.NotUsed;
import akka.persistence.SnapshotMetadata;
import akka.serialization.Serialization;
import akka.stream.Graph;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBAsync;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteRequest;
import com.amazonaws.services.dynamodbv2.model.PutItemRequest;
import com.amazonaws.services.dynamodbv2.model.QueryRequest;
import com.amazonaws.services.dynamodbv2.model.WriteRequest;
import com.github.j5ik2o.akka.persistence.dynamodb.client.v1.StreamReadClient;
import com.github.j5ik2o.akka.persistence.dynamodb.client.v1.StreamWriteClient;
import com.github.j5ik2o.akka.persistence.dynamodb.context.PluginContext;
import com.github.j5ik2o.akka.persistence.dynamodb.model.PersistenceId;
import com.github.j5ik2o.akka.persistence.dynamodb.model.PersistenceId$;
import com.github.j5ik2o.akka.persistence.dynamodb.model.SequenceNumber;
import com.github.j5ik2o.akka.persistence.dynamodb.snapshot.PartitionKey;
import com.github.j5ik2o.akka.persistence.dynamodb.snapshot.SnapshotPluginContext;
import com.github.j5ik2o.akka.persistence.dynamodb.snapshot.SortKey;
import com.github.j5ik2o.akka.persistence.dynamodb.snapshot.dao.SnapshotDao;
import com.github.j5ik2o.akka.persistence.dynamodb.snapshot.dao.SnapshotRow;
import com.github.j5ik2o.akka.persistence.dynamodb.snapshot.serialization.ByteArraySnapshotSerializer;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t5b\u0001B\u000e\u001d\u00055B\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!\u000f\u0005\t{\u0001\u0011\t\u0011)A\u0005}!A1\n\u0001B\u0001B\u0003%A\n\u0003\u0005Q\u0001\t\u0005\t\u0015!\u0003R\u0011\u00159\u0006\u0001\"\u0001Y\u0011\u001dq\u0006A1A\u0005\n}Ca\u0001\u001b\u0001!\u0002\u0013\u0001\u0007bB5\u0001\u0005\u0004%IA\u001b\u0005\u0007g\u0002\u0001\u000b\u0011B6\t\u000fQ\u0004!\u0019!C\u0005k\"1\u0011\u0010\u0001Q\u0001\nYDqA\u001f\u0001C\u0002\u0013%1\u0010C\u0004\u0002\u0004\u0001\u0001\u000b\u0011\u0002?\t\u000f\u0005\u0015\u0001\u0001\"\u0011\u0002\b!9\u0011\u0011\t\u0001\u0005B\u0005\r\u0003bBA-\u0001\u0011\u0005\u00131\f\u0005\b\u0003O\u0002A\u0011IA5\u0011\u001d\tY\b\u0001C!\u0003{Bq!!#\u0001\t\u0003\nY\tC\u0004\u0002.\u0002!\t%a,\t\u000f\u0005e\u0006\u0001\"\u0011\u0002<\"9\u0011Q\u0019\u0001\u0005B\u0005\u001d\u0007bBAj\u0001\u0011\u0005\u0013Q\u001b\u0005\b\u0003C\u0004A\u0011BAr\u0011\u001d\t\u0019\u0010\u0001C\u0005\u0003kDqA!\u000b\u0001\t\u0003\u0012YC\u0001\u000bWc9+wo\u00158baNDw\u000e\u001e#b_&k\u0007\u000f\u001c\u0006\u0003;y\t1\u0001Z1p\u0015\ty\u0002%\u0001\u0005t]\u0006\u00048\u000f[8u\u0015\t\t#%\u0001\u0005es:\fWn\u001c3c\u0015\t\u0019C%A\u0006qKJ\u001c\u0018n\u001d;f]\u000e,'BA\u0013'\u0003\u0011\t7n[1\u000b\u0005\u001dB\u0013A\u000266S.\u0014tN\u0003\u0002*U\u00051q-\u001b;ik\nT\u0011aK\u0001\u0004G>l7\u0001A\n\u0004\u00019\"\u0004CA\u00183\u001b\u0005\u0001$\"A\u0019\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0002$AB!osJ+g\r\u0005\u00026m5\tA$\u0003\u000289\tY1K\\1qg\"|G\u000fR1p\u00035\u0001H.^4j]\u000e{g\u000e^3yiB\u0011!hO\u0007\u0002=%\u0011AH\b\u0002\u0016':\f\u0007o\u001d5piBcWoZ5o\u0007>tG/\u001a=u\u0003-\t7/\u001f8d\u00072LWM\u001c;\u0011\u0007=z\u0014)\u0003\u0002Aa\t1q\n\u001d;j_:\u0004\"AQ%\u000e\u0003\rS!\u0001R#\u0002\u0015\u0011Lh.Y7pI\n4(G\u0003\u0002G\u000f\u0006A1/\u001a:wS\u000e,7O\u0003\u0002IU\u0005I\u0011-\\1{_:\fwo]\u0005\u0003\u0015\u000e\u00131#Q7bu>tG)\u001f8b[>$%)Q:z]\u000e\f!b]=oG\u000ec\u0017.\u001a8u!\rys(\u0014\t\u0003\u0005:K!aT\"\u0003\u001d\u0005k\u0017M_8o\tft\u0017-\\8E\u0005\u0006i1/\u001a:jC2L'0\u0019;j_:\u0004\"AU+\u000e\u0003MS!\u0001\u0015+\u000b\u0003\u0015J!AV*\u0003\u001bM+'/[1mSj\fG/[8o\u0003\u0019a\u0014N\\5u}Q)\u0011LW.];B\u0011Q\u0007\u0001\u0005\u0006q\u0015\u0001\r!\u000f\u0005\u0006{\u0015\u0001\rA\u0010\u0005\u0006\u0017\u0016\u0001\r\u0001\u0014\u0005\u0006!\u0016\u0001\r!U\u0001\u0007Y><w-\u001a:\u0016\u0003\u0001\u0004\"!\u00194\u000e\u0003\tT!a\u00193\u0002\u000bMdg\r\u000e6\u000b\u0003\u0015\f1a\u001c:h\u0013\t9'M\u0001\u0004M_\u001e<WM]\u0001\bY><w-\u001a:!\u0003A\u0019HO]3b[J+\u0017\rZ\"mS\u0016tG/F\u0001l!\ta\u0017/D\u0001n\u0015\tqw.\u0001\u0002wc)\u0011\u0001\u000fI\u0001\u0007G2LWM\u001c;\n\u0005Il'\u0001E*ue\u0016\fWNU3bI\u000ec\u0017.\u001a8u\u0003E\u0019HO]3b[J+\u0017\rZ\"mS\u0016tG\u000fI\u0001\u0012gR\u0014X-Y7Xe&$Xm\u00117jK:$X#\u0001<\u0011\u00051<\u0018B\u0001=n\u0005E\u0019FO]3b[^\u0013\u0018\u000e^3DY&,g\u000e^\u0001\u0013gR\u0014X-Y7Xe&$Xm\u00117jK:$\b%\u0001\u0006tKJL\u0017\r\\5{KJ,\u0012\u0001 \t\u0003{~l\u0011A \u0006\u0003!zI1!!\u0001\u007f\u0005m\u0011\u0015\u0010^3BeJ\f\u0017p\u00158baNDw\u000e^*fe&\fG.\u001b>fe\u0006Y1/\u001a:jC2L'0\u001a:!\u0003\u0019!W\r\\3uKR1\u0011\u0011BA\u0014\u0003o\u0001\u0002\"a\u0003\u0002\u0016\u0005e\u0011qD\u0007\u0003\u0003\u001bQA!a\u0004\u0002\u0012\u0005A1oY1mC\u0012\u001cHNC\u0002\u0002\u0014Q\u000baa\u001d;sK\u0006l\u0017\u0002BA\f\u0003\u001b\u0011aaU8ve\u000e,\u0007cA\u0018\u0002\u001c%\u0019\u0011Q\u0004\u0019\u0003\tUs\u0017\u000e\u001e\t\u0005\u0003C\t\u0019#D\u0001U\u0013\r\t)\u0003\u0016\u0002\b\u001d>$Xk]3e\u0011\u001d\tIC\u0004a\u0001\u0003W\tQ\u0002]3sg&\u001cH/\u001a8dK&#\u0007\u0003BA\u0017\u0003gi!!a\f\u000b\u0007\u0005E\u0002%A\u0003n_\u0012,G.\u0003\u0003\u00026\u0005=\"!\u0004)feNL7\u000f^3oG\u0016LE\rC\u0004\u0002:9\u0001\r!a\u000f\u0002\u0015M,\u0017/^3oG\u0016t%\u000f\u0005\u0003\u0002.\u0005u\u0012\u0002BA \u0003_\u0011abU3rk\u0016t7-\u001a(v[\n,'/\u0001\neK2,G/Z!mYNs\u0017\r]:i_R\u001cH\u0003BA#\u0003/\"B!!\u0003\u0002H!9\u0011\u0011J\bA\u0004\u0005-\u0013AA3d!\u0011\ti%a\u0015\u000e\u0005\u0005=#bAA)a\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005U\u0013q\n\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqRDq!!\u000b\u0010\u0001\u0004\tY#A\feK2,G/Z+q)>l\u0015\r_*fcV,gnY3OeR1\u0011QLA1\u0003G\"B!!\u0003\u0002`!9\u0011\u0011\n\tA\u0004\u0005-\u0003bBA\u0015!\u0001\u0007\u00111\u0006\u0005\b\u0003K\u0002\u0002\u0019AA\u001e\u00035i\u0017\r_*fcV,gnY3Oe\u00061B-\u001a7fi\u0016,\u0006\u000fV8NCb$\u0016.\\3ti\u0006l\u0007\u000f\u0006\u0004\u0002l\u0005=\u0014\u0011\u000f\u000b\u0005\u0003\u0013\ti\u0007C\u0004\u0002JE\u0001\u001d!a\u0013\t\u000f\u0005%\u0012\u00031\u0001\u0002,!9\u00111O\tA\u0002\u0005U\u0014\u0001D7bqRKW.Z:uC6\u0004\bcA\u0018\u0002x%\u0019\u0011\u0011\u0010\u0019\u0003\t1{gnZ\u0001'I\u0016dW\r^3VaR{W*\u0019=TKF,XM\\2f\u001dJ\fe\u000eZ'bqRKW.Z:uC6\u0004H\u0003CA@\u0003\u0007\u000b))a\"\u0015\t\u0005%\u0011\u0011\u0011\u0005\b\u0003\u0013\u0012\u00029AA&\u0011\u001d\tIC\u0005a\u0001\u0003WAq!!\u001a\u0013\u0001\u0004\tY\u0004C\u0004\u0002tI\u0001\r!!\u001e\u0002\u001d1\fG/Z:u':\f\u0007o\u001d5piR!\u0011QRAV)\u0011\ty)!+\u0011\u0011\u0005-\u0011QCAI\u0003?\u0001BaL \u0002\u0014B9q&!&\u0002\u001a\u0006\r\u0016bAALa\t1A+\u001e9mKJ\u0002B!a'\u0002 6\u0011\u0011Q\u0014\u0006\u0003GQKA!!)\u0002\u001e\n\u00012K\\1qg\"|G/T3uC\u0012\fG/\u0019\t\u0004_\u0005\u0015\u0016bAATa\t\u0019\u0011I\\=\t\u000f\u0005%3\u0003q\u0001\u0002L!9\u0011\u0011F\nA\u0002\u0005-\u0012aF:oCB\u001c\bn\u001c;G_Jl\u0015\r\u001f+j[\u0016\u001cH/Y7q)\u0019\t\t,!.\u00028R!\u0011qRAZ\u0011\u001d\tI\u0005\u0006a\u0002\u0003\u0017Bq!!\u000b\u0015\u0001\u0004\tY\u0003C\u0004\u0002tQ\u0001\r!!\u001e\u00021Mt\u0017\r]:i_R4uN]'bqN+\u0017/^3oG\u0016t%\u000f\u0006\u0004\u0002>\u0006\u0005\u00171\u0019\u000b\u0005\u0003\u001f\u000by\fC\u0004\u0002JU\u0001\u001d!a\u0013\t\u000f\u0005%R\u00031\u0001\u0002,!9\u0011QM\u000bA\u0002\u0005m\u0012aJ:oCB\u001c\bn\u001c;G_Jl\u0015\r_*fcV,gnY3Oe\u0006sG-T1y)&lWm\u001d;b[B$\u0002\"!3\u0002N\u0006=\u0017\u0011\u001b\u000b\u0005\u0003\u001f\u000bY\rC\u0004\u0002JY\u0001\u001d!a\u0013\t\u000f\u0005%b\u00031\u0001\u0002,!9\u0011Q\r\fA\u0002\u0005m\u0002bBA:-\u0001\u0007\u0011QO\u0001\u0005g\u00064X\r\u0006\u0004\u0002X\u0006m\u0017q\u001c\u000b\u0005\u0003\u0013\tI\u000eC\u0004\u0002J]\u0001\u001d!a\u0013\t\u000f\u0005uw\u00031\u0001\u0002\u001a\u0006\u00012O\\1qg\"|G/T3uC\u0012\fG/\u0019\u0005\u0007?]\u0001\r!a)\u0002\u0017E,XM]=EK2,G/\u001a\u000b\u0005\u0003\u0013\t)\u000fC\u0004\u0002hb\u0001\r!!;\u0002\u0019E,XM]=SKF,Xm\u001d;\u0011\t\u0005-\u0018q^\u0007\u0003\u0003[T1!!\rD\u0013\u0011\t\t0!<\u0003\u0019E+XM]=SKF,Xm\u001d;\u0002\u0017\u0011,7/\u001a:jC2L'0\u001a\u000b\u0005\u0003o\u0014\t\u0001\u0006\u0003\u0002z\u0006}\bCBA'\u0003w\f\t*\u0003\u0003\u0002~\u0006=#A\u0002$viV\u0014X\rC\u0004\u0002Je\u0001\u001d!a\u0013\t\u000f\t\r\u0011\u00041\u0001\u0003\u0006\u00051!o\\<PaR\u0004BaL \u0003\bAA!\u0011\u0002B\f\u0005;\u0011\u0019C\u0004\u0003\u0003\f\tM\u0001c\u0001B\u0007a5\u0011!q\u0002\u0006\u0004\u0005#a\u0013A\u0002\u001fs_>$h(C\u0002\u0003\u0016A\na\u0001\u0015:fI\u00164\u0017\u0002\u0002B\r\u00057\u00111!T1q\u0015\r\u0011)\u0002\r\t\u0005\u0005\u0013\u0011y\"\u0003\u0003\u0003\"\tm!AB*ue&tw\r\u0005\u0003\u0002l\n\u0015\u0012\u0002\u0002B\u0014\u0003[\u0014a\"\u0011;ue&\u0014W\u000f^3WC2,X-A\u0004eSN\u0004xn]3\u0015\u0005\u0005e\u0001")
public final class V1NewSnapshotDaoImpl
implements SnapshotDao {
    private final SnapshotPluginContext pluginContext;
    private final Option<AmazonDynamoDBAsync> asyncClient;
    private final Option<AmazonDynamoDB> syncClient;
    private final Logger logger;
    private final StreamReadClient streamReadClient;
    private final StreamWriteClient streamWriteClient;
    private final ByteArraySnapshotSerializer serializer;

    private Logger logger() {
        return this.logger;
    }

    private StreamReadClient streamReadClient() {
        return this.streamReadClient;
    }

    private StreamWriteClient streamWriteClient() {
        return this.streamWriteClient;
    }

    private ByteArraySnapshotSerializer serializer() {
        return this.serializer;
    }

    public Source<BoxedUnit, NotUsed> delete(PersistenceId persistenceId, SequenceNumber sequenceNr) {
        this.logger().debug(new StringBuilder(17).append("delete(").append(persistenceId).append(", ").append(sequenceNr).append("): start").toString());
        this.logger().debug(new StringBuilder(14).append("pluginConfig: ").append(this.pluginContext.pluginConfig()).toString());
        QueryRequest queryRequest = new QueryRequest().withTableName(this.pluginContext.pluginConfig().tableName()).withIndexName(this.pluginContext.pluginConfig().getSnapshotRowsIndexName()).withKeyConditionExpression("#pid = :pid and #snr = :snr").withExpressionAttributeNames(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().sequenceNrColumnName())}))).asJava()).withExpressionAttributeValues(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), (Object)new AttributeValue().withS(persistenceId.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":snr"), (Object)new AttributeValue().withN(sequenceNr.asString()))}))).asJava()).withConsistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginContext.pluginConfig().consistentRead()));
        Source<BoxedUnit, NotUsed> result = this.queryDelete(queryRequest);
        this.logger().debug(new StringBuilder(19).append("delete(").append(persistenceId).append(", ").append(sequenceNr).append("):").append(result).append(": finish").toString());
        return result;
    }

    public Source<BoxedUnit, NotUsed> deleteAllSnapshots(PersistenceId persistenceId, ExecutionContext ec) {
        this.logger().debug(new StringBuilder(27).append("deleteAllSnapshots(").append(persistenceId).append("): start").toString());
        this.logger().debug(new StringBuilder(14).append("pluginConfig: ").append(this.pluginContext.pluginConfig()).toString());
        QueryRequest queryRequest = new QueryRequest().withTableName(this.pluginContext.pluginConfig().tableName()).withIndexName(this.pluginContext.pluginConfig().getSnapshotRowsIndexName()).withKeyConditionExpression("#pid = :pid and #snr between :min and :max").withExpressionAttributeNames(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().sequenceNrColumnName())}))).asJava()).withExpressionAttributeValues(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), (Object)new AttributeValue().withS(persistenceId.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), (Object)new AttributeValue().withN(Integer.toString(0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), (Object)new AttributeValue().withN(Long.toString(Long.MAX_VALUE)))}))).asJava()).withConsistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginContext.pluginConfig().consistentRead()));
        Source<BoxedUnit, NotUsed> result = this.queryDelete(queryRequest);
        this.logger().debug(new StringBuilder(29).append("deleteAllSnapshots(").append(persistenceId).append("):").append(result).append(": finish").toString());
        return result;
    }

    public Source<BoxedUnit, NotUsed> deleteUpToMaxSequenceNr(PersistenceId persistenceId, SequenceNumber maxSequenceNr, ExecutionContext ec) {
        this.logger().debug(new StringBuilder(34).append("deleteUpToMaxSequenceNr(").append(persistenceId).append(", ").append(maxSequenceNr).append("): start").toString());
        this.logger().debug(new StringBuilder(14).append("pluginConfig: ").append(this.pluginContext.pluginConfig()).toString());
        QueryRequest queryRequest = new QueryRequest().withTableName(this.pluginContext.pluginConfig().tableName()).withIndexName(this.pluginContext.pluginConfig().getSnapshotRowsIndexName()).withKeyConditionExpression("#pid = :pid and #snr between :min and :max").withExpressionAttributeNames(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().sequenceNrColumnName())}))).asJava()).withExpressionAttributeValues(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), (Object)new AttributeValue().withS(persistenceId.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), (Object)new AttributeValue().withN(Integer.toString(0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), (Object)new AttributeValue().withN(maxSequenceNr.asString()))}))).asJava()).withConsistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginContext.pluginConfig().consistentRead()));
        Source<BoxedUnit, NotUsed> result = this.queryDelete(queryRequest);
        this.logger().debug(new StringBuilder(34).append("deleteUpToMaxSequenceNr(").append(persistenceId).append("):").append(result).append(": finish").toString());
        return result;
    }

    public Source<BoxedUnit, NotUsed> deleteUpToMaxTimestamp(PersistenceId persistenceId, long maxTimestamp, ExecutionContext ec) {
        this.logger().debug(new StringBuilder(31).append("deleteUpToMaxTimestamp(").append(persistenceId).append("): start").toString());
        this.logger().debug(new StringBuilder(14).append("pluginConfig: ").append(this.pluginContext.pluginConfig()).toString());
        QueryRequest queryRequest = new QueryRequest().withTableName(this.pluginContext.pluginConfig().tableName()).withIndexName(this.pluginContext.pluginConfig().getSnapshotRowsIndexName()).withKeyConditionExpression("#pid = :pid and #snr between :min and :max").withFilterExpression("#created <= :maxTimestamp").withExpressionAttributeNames(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().sequenceNrColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#created"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().createdColumnName())}))).asJava()).withExpressionAttributeValues(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), (Object)new AttributeValue().withS(persistenceId.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), (Object)new AttributeValue().withN(Integer.toString(0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), (Object)new AttributeValue().withN(Long.toString(Long.MAX_VALUE))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":maxTimestamp"), (Object)new AttributeValue().withN(Long.toString(maxTimestamp)))}))).asJava()).withConsistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginContext.pluginConfig().consistentRead()));
        Source<BoxedUnit, NotUsed> result = this.queryDelete(queryRequest);
        this.logger().debug(new StringBuilder(33).append("deleteUpToMaxTimestamp(").append(persistenceId).append("):").append(result).append(": finish").toString());
        return result;
    }

    public Source<BoxedUnit, NotUsed> deleteUpToMaxSequenceNrAndMaxTimestamp(PersistenceId persistenceId, SequenceNumber maxSequenceNr, long maxTimestamp, ExecutionContext ec) {
        this.logger().debug(new StringBuilder(51).append("deleteUpToMaxSequenceNrAndMaxTimestamp(").append(persistenceId).append(", ").append(maxSequenceNr).append(", ").append(maxTimestamp).append("): start").toString());
        this.logger().debug(new StringBuilder(14).append("pluginConfig: ").append(this.pluginContext.pluginConfig()).toString());
        QueryRequest queryRequest = new QueryRequest().withTableName(this.pluginContext.pluginConfig().tableName()).withIndexName(this.pluginContext.pluginConfig().getSnapshotRowsIndexName()).withKeyConditionExpression("#pid = :pid and #snr between :min and :max").withFilterExpression("#created <= :maxTimestamp").withExpressionAttributeNames(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().sequenceNrColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#created"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().createdColumnName())}))).asJava()).withExpressionAttributeValues(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), (Object)new AttributeValue().withS(persistenceId.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), (Object)new AttributeValue().withN(Integer.toString(0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), (Object)new AttributeValue().withN(maxSequenceNr.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":maxTimestamp"), (Object)new AttributeValue().withN(Long.toString(maxTimestamp)))}))).asJava()).withConsistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginContext.pluginConfig().consistentRead()));
        Source<BoxedUnit, NotUsed> result = this.queryDelete(queryRequest);
        this.logger().debug(new StringBuilder(53).append("deleteUpToMaxSequenceNrAndMaxTimestamp(").append(persistenceId).append(", ").append(maxSequenceNr).append(", ").append(maxTimestamp).append("):").append(result).append(": finish").toString());
        return result;
    }

    public Source<Option<Tuple2<SnapshotMetadata, Object>>, NotUsed> latestSnapshot(PersistenceId persistenceId, ExecutionContext ec) {
        this.logger().debug(new StringBuilder(23).append("latestSnapshot(").append(persistenceId).append("): start").toString());
        this.logger().debug(new StringBuilder(14).append("pluginConfig: ").append(this.pluginContext.pluginConfig()).toString());
        QueryRequest queryRequest = new QueryRequest().withTableName(this.pluginContext.pluginConfig().tableName()).withIndexName(this.pluginContext.pluginConfig().getSnapshotRowsIndexName()).withKeyConditionExpression("#pid = :pid and #snr between :min and :max").withExpressionAttributeNames(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().sequenceNrColumnName())}))).asJava()).withExpressionAttributeValues(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), (Object)new AttributeValue().withS(persistenceId.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), (Object)new AttributeValue().withN(Integer.toString(0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), (Object)new AttributeValue().withN(Long.toString(Long.MAX_VALUE)))}))).asJava()).withScanIndexForward(Predef$.MODULE$.boolean2Boolean(false)).withLimit(Predef$.MODULE$.int2Integer(1)).withConsistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginContext.pluginConfig().consistentRead()));
        Source result = (Source)Source$.MODULE$.single((Object)queryRequest).via((Graph)this.streamReadClient().queryFlow()).flatMapConcat((Function1 & Serializable)response -> {
            if (response.getSdkHttpMetadata().getHttpStatusCode() == 200) {
                return Source$.MODULE$.single((Object)((IterableOps)((IterableOps)Option$.MODULE$.apply((Object)response.getItems()).map((Function1 & Serializable)x$1 -> CollectionConverters$.MODULE$.ListHasAsScala(x$1).asScala()).getOrElse((Function0 & Serializable)() -> (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty())).map((Function1 & Serializable)x$2 -> CollectionConverters$.MODULE$.MapHasAsScala(x$2).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()))).headOption());
            }
            int statusCode = response.getSdkHttpMetadata().getHttpStatusCode();
            return Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).toString()));
        }).mapAsync(1, (Function1 & Serializable)rowOpt -> this.deserialize((Option<scala.collection.immutable.Map<String, AttributeValue>>)rowOpt, ec));
        this.logger().debug(new StringBuilder(25).append("latestSnapshot(").append(persistenceId).append("):").append(result).append(": finish").toString());
        return result;
    }

    public Source<Option<Tuple2<SnapshotMetadata, Object>>, NotUsed> snapshotForMaxTimestamp(PersistenceId persistenceId, long maxTimestamp, ExecutionContext ec) {
        this.logger().debug(new StringBuilder(34).append("snapshotForMaxTimestamp(").append(persistenceId).append(", ").append(maxTimestamp).append("): start").toString());
        this.logger().debug(new StringBuilder(14).append("pluginConfig: ").append(this.pluginContext.pluginConfig()).toString());
        QueryRequest queryRequest = new QueryRequest().withTableName(this.pluginContext.pluginConfig().tableName()).withIndexName(this.pluginContext.pluginConfig().getSnapshotRowsIndexName()).withKeyConditionExpression("#pid = :pid and #snr between :min and :max").withFilterExpression("#created <= :maxTimestamp").withExpressionAttributeNames(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().sequenceNrColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#created"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().createdColumnName())}))).asJava()).withExpressionAttributeValues(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), (Object)new AttributeValue().withS(persistenceId.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), (Object)new AttributeValue().withN(Integer.toString(0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), (Object)new AttributeValue().withN(Long.toString(Long.MAX_VALUE))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":maxTimestamp"), (Object)new AttributeValue().withN(Long.toString(maxTimestamp)))}))).asJava()).withScanIndexForward(Predef$.MODULE$.boolean2Boolean(false)).withConsistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginContext.pluginConfig().consistentRead()));
        Source result = (Source)Source$.MODULE$.single((Object)queryRequest).via((Graph)this.streamReadClient().queryFlow()).flatMapConcat((Function1 & Serializable)response -> {
            if (response.getSdkHttpMetadata().getHttpStatusCode() == 200) {
                return Source$.MODULE$.single((Object)((IterableOps)((IterableOps)Option$.MODULE$.apply((Object)response.getItems()).map((Function1 & Serializable)x$3 -> CollectionConverters$.MODULE$.ListHasAsScala(x$3).asScala()).getOrElse((Function0 & Serializable)() -> (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty())).map((Function1 & Serializable)x$4 -> CollectionConverters$.MODULE$.MapHasAsScala(x$4).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()))).headOption());
            }
            int statusCode = response.getSdkHttpMetadata().getHttpStatusCode();
            return Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).toString()));
        }).mapAsync(1, (Function1 & Serializable)rowOpt -> this.deserialize((Option<scala.collection.immutable.Map<String, AttributeValue>>)rowOpt, ec));
        this.logger().debug(new StringBuilder(36).append("snapshotForMaxTimestamp(").append(persistenceId).append(", ").append(maxTimestamp).append("):").append(result).append(": finish").toString());
        return result;
    }

    public Source<Option<Tuple2<SnapshotMetadata, Object>>, NotUsed> snapshotForMaxSequenceNr(PersistenceId persistenceId, SequenceNumber maxSequenceNr, ExecutionContext ec) {
        this.logger().debug(new StringBuilder(35).append("snapshotForMaxSequenceNr(").append(persistenceId).append(", ").append(maxSequenceNr).append("): start").toString());
        this.logger().debug(new StringBuilder(14).append("pluginConfig: ").append(this.pluginContext.pluginConfig()).toString());
        QueryRequest queryRequest = new QueryRequest().withTableName(this.pluginContext.pluginConfig().tableName()).withIndexName(this.pluginContext.pluginConfig().getSnapshotRowsIndexName()).withKeyConditionExpression("#pid = :pid and #snr between :min and :max").withExpressionAttributeNames(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().sequenceNrColumnName())}))).asJava()).withExpressionAttributeValues(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), (Object)new AttributeValue().withS(persistenceId.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), (Object)new AttributeValue().withN(Integer.toString(0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), (Object)new AttributeValue().withN(maxSequenceNr.asString()))}))).asJava()).withScanIndexForward(Predef$.MODULE$.boolean2Boolean(false)).withConsistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginContext.pluginConfig().consistentRead()));
        Source result = (Source)Source$.MODULE$.single((Object)queryRequest).via((Graph)this.streamReadClient().queryFlow()).flatMapConcat((Function1 & Serializable)response -> {
            if (response.getSdkHttpMetadata().getHttpStatusCode() == 200) {
                return Source$.MODULE$.single((Object)((IterableOps)((IterableOps)Option$.MODULE$.apply((Object)response.getItems()).map((Function1 & Serializable)x$5 -> CollectionConverters$.MODULE$.ListHasAsScala(x$5).asScala()).getOrElse((Function0 & Serializable)() -> (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty())).map((Function1 & Serializable)x$6 -> CollectionConverters$.MODULE$.MapHasAsScala(x$6).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()))).headOption());
            }
            int statusCode = response.getSdkHttpMetadata().getHttpStatusCode();
            return Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).toString()));
        }).mapAsync(1, (Function1 & Serializable)rowOpt -> this.deserialize((Option<scala.collection.immutable.Map<String, AttributeValue>>)rowOpt, ec));
        this.logger().debug(new StringBuilder(37).append("snapshotForMaxSequenceNr(").append(persistenceId).append(", ").append(maxSequenceNr).append("):").append(result).append(": finish").toString());
        return result;
    }

    public Source<Option<Tuple2<SnapshotMetadata, Object>>, NotUsed> snapshotForMaxSequenceNrAndMaxTimestamp(PersistenceId persistenceId, SequenceNumber maxSequenceNr, long maxTimestamp, ExecutionContext ec) {
        this.logger().debug(new StringBuilder(52).append("snapshotForMaxSequenceNrAndMaxTimestamp(").append(persistenceId).append(", ").append(maxSequenceNr).append(", ").append(maxTimestamp).append("): start").toString());
        this.logger().debug(new StringBuilder(14).append("pluginConfig: ").append(this.pluginContext.pluginConfig()).toString());
        QueryRequest queryRequest = new QueryRequest().withTableName(this.pluginContext.pluginConfig().tableName()).withIndexName(this.pluginContext.pluginConfig().getSnapshotRowsIndexName()).withKeyConditionExpression("#pid = :pid and #snr between :min and :max").withFilterExpression("#created <= :maxTimestamp").withExpressionAttributeNames(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().sequenceNrColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#created"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().createdColumnName())}))).asJava()).withExpressionAttributeValues(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), (Object)new AttributeValue().withS(persistenceId.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), (Object)new AttributeValue().withN(Integer.toString(0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), (Object)new AttributeValue().withN(maxSequenceNr.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":maxTimestamp"), (Object)new AttributeValue().withN(Long.toString(maxTimestamp)))}))).asJava()).withScanIndexForward(Predef$.MODULE$.boolean2Boolean(false)).withConsistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginContext.pluginConfig().consistentRead()));
        Source result = (Source)Source$.MODULE$.single((Object)queryRequest).via((Graph)this.streamReadClient().queryFlow()).flatMapConcat((Function1 & Serializable)response -> {
            if (response.getSdkHttpMetadata().getHttpStatusCode() == 200) {
                return Source$.MODULE$.single((Object)((IterableOps)((IterableOps)Option$.MODULE$.apply((Object)response.getItems()).map((Function1 & Serializable)x$7 -> CollectionConverters$.MODULE$.ListHasAsScala(x$7).asScala()).getOrElse((Function0 & Serializable)() -> (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty())).map((Function1 & Serializable)x$8 -> CollectionConverters$.MODULE$.MapHasAsScala(x$8).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()))).headOption());
            }
            int statusCode = response.getSdkHttpMetadata().getHttpStatusCode();
            return Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).toString()));
        }).mapAsync(1, (Function1 & Serializable)rowOpt -> this.deserialize((Option<scala.collection.immutable.Map<String, AttributeValue>>)rowOpt, ec));
        this.logger().debug(new StringBuilder(53).append("snapshotForMaxSequenceNrAndMaxTimestamp(").append(persistenceId).append(", ").append(maxSequenceNr).append(", ").append(maxTimestamp).append("): finish").toString());
        return result;
    }

    public Source<BoxedUnit, NotUsed> save(SnapshotMetadata snapshotMetadata, Object snapshot, ExecutionContext ec) {
        this.logger().debug(new StringBuilder(15).append("save(").append(snapshotMetadata).append(", ").append(snapshot).append("): start").toString());
        this.logger().debug(new StringBuilder(14).append("pluginConfig: ").append(this.pluginContext.pluginConfig()).toString());
        Source result = (Source)Source$.MODULE$.future(this.serializer().serialize(snapshotMetadata, snapshot, ec)).flatMapConcat((Function1 & Serializable)snapshotRow -> {
            PartitionKey pkey = $this.pluginContext.partitionKeyResolver().resolve(snapshotRow.persistenceId(), snapshotRow.sequenceNumber());
            SortKey skey = $this.pluginContext.sortKeyResolver().resolve(snapshotRow.persistenceId(), snapshotRow.sequenceNumber());
            PutItemRequest req = new PutItemRequest().withTableName($this.pluginContext.pluginConfig().tableName()).withItem(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.pluginContext.pluginConfig().columnsDefConfig().partitionKeyColumnName()), (Object)new AttributeValue().withS(pkey.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.pluginContext.pluginConfig().columnsDefConfig().sortKeyColumnName()), (Object)new AttributeValue().withS(skey.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.pluginContext.pluginConfig().columnsDefConfig().persistenceIdColumnName()), (Object)new AttributeValue().withS(snapshotRow.persistenceId().asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.pluginContext.pluginConfig().columnsDefConfig().sequenceNrColumnName()), (Object)new AttributeValue().withN(snapshotRow.sequenceNumber().asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.pluginContext.pluginConfig().columnsDefConfig().snapshotColumnName()), (Object)new AttributeValue().withB(ByteBuffer.wrap(snapshotRow.snapshot()))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.pluginContext.pluginConfig().columnsDefConfig().createdColumnName()), (Object)new AttributeValue().withN(Long.toString(snapshotRow.created())))}))).asJava());
            return (Source)Source$.MODULE$.single((Object)req).via((Graph)this.streamWriteClient().putItemFlow()).flatMapConcat((Function1 & Serializable)response -> {
                if (response.getSdkHttpMetadata().getHttpStatusCode() == 200) {
                    return Source$.MODULE$.single((Object)BoxedUnit.UNIT);
                }
                int statusCode = response.getSdkHttpMetadata().getHttpStatusCode();
                return Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).toString()));
            });
        });
        this.logger().debug(new StringBuilder(17).append("save(").append(snapshotMetadata).append(", ").append(snapshot).append("):").append(result).append(": finish").toString());
        return result;
    }

    private Source<BoxedUnit, NotUsed> queryDelete(QueryRequest queryRequest) {
        return (Source)((Source)Source$.MODULE$.single((Object)queryRequest).via((Graph)this.streamReadClient().queryFlow()).map((Function1 & Serializable)response -> (Seq)Option$.MODULE$.apply((Object)response.getItems()).map((Function1 & Serializable)x$9 -> CollectionConverters$.MODULE$.ListHasAsScala(x$9).asScala()).getOrElse((Function0 & Serializable)() -> (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty())).mapConcat((Function1 & Serializable)x$10 -> x$10.toVector()).grouped(this.pluginContext.pluginConfig().clientConfig().batchWriteItemLimit()).map((Function1 & Serializable)rows -> (scala.collection.immutable.Seq)rows.map((Function1 & Serializable)javaRow -> {
            scala.collection.mutable.Map row = CollectionConverters$.MODULE$.MapHasAsScala(javaRow).asScala();
            PersistenceId x$1 = PersistenceId$.MODULE$.apply(((AttributeValue)row.apply((Object)$this.pluginContext.pluginConfig().columnsDefConfig().persistenceIdColumnName())).getS());
            SequenceNumber x$2 = new SequenceNumber(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(((AttributeValue)row.apply((Object)$this.pluginContext.pluginConfig().columnsDefConfig().sequenceNrColumnName())).getN())));
            byte[] x$3 = ((AttributeValue)row.apply((Object)$this.pluginContext.pluginConfig().columnsDefConfig().snapshotColumnName())).getB().array();
            long x$4 = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(((AttributeValue)row.apply((Object)$this.pluginContext.pluginConfig().columnsDefConfig().createdColumnName())).getN()));
            return new SnapshotRow(x$1, x$2, x$4, x$3);
        })).map((Function1 & Serializable)rows -> new BatchWriteItemRequest().withRequestItems(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.pluginContext.pluginConfig().tableName()), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)rows.map((Function1 & Serializable)row -> {
            PartitionKey pkey = $this.pluginContext.partitionKeyResolver().resolve(row.persistenceId(), row.sequenceNumber());
            SortKey skey = $this.pluginContext.sortKeyResolver().resolve(row.persistenceId(), row.sequenceNumber());
            return new WriteRequest().withDeleteRequest(new DeleteRequest().withKey(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.pluginContext.pluginConfig().columnsDefConfig().partitionKeyColumnName()), (Object)new AttributeValue().withS(pkey.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.pluginContext.pluginConfig().columnsDefConfig().sortKeyColumnName()), (Object)new AttributeValue().withS(skey.asString()))}))).asJava()));
        })).asJava())}))).asJava()))).via((Graph)this.streamWriteClient().batchWriteItemFlow()).flatMapConcat((Function1 & Serializable)response -> {
            if (response.getSdkHttpMetadata().getHttpStatusCode() == 200) {
                return Source$.MODULE$.single((Object)BoxedUnit.UNIT);
            }
            int statusCode = response.getSdkHttpMetadata().getHttpStatusCode();
            return Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).toString()));
        });
    }

    private Future<Option<Tuple2<SnapshotMetadata, Object>>> deserialize(Option<scala.collection.immutable.Map<String, AttributeValue>> rowOpt, ExecutionContext ec) {
        Option<scala.collection.immutable.Map<String, AttributeValue>> option = rowOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            scala.collection.immutable.Map row = (scala.collection.immutable.Map)some.value();
            PersistenceId x$1 = PersistenceId$.MODULE$.apply(((AttributeValue)row.apply((Object)this.pluginContext.pluginConfig().columnsDefConfig().persistenceIdColumnName())).getS());
            SequenceNumber x$2 = new SequenceNumber(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(((AttributeValue)row.apply((Object)this.pluginContext.pluginConfig().columnsDefConfig().sequenceNrColumnName())).getN())));
            byte[] x$3 = ((AttributeValue)row.apply((Object)this.pluginContext.pluginConfig().columnsDefConfig().snapshotColumnName())).getB().array();
            long x$4 = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(((AttributeValue)row.apply((Object)this.pluginContext.pluginConfig().columnsDefConfig().createdColumnName())).getN()));
            return this.serializer().deserialize(new SnapshotRow(x$1, x$2, x$4, x$3), ec).map((Function1 & Serializable)x$11 -> new Some(x$11), ec);
        }
        if (None$.MODULE$.equals(option)) {
            return Future$.MODULE$.successful((Object)None$.MODULE$);
        }
        throw new MatchError(option);
    }

    public void dispose() {
        Option option;
        Option option2;
        Tuple2 tuple2 = new Tuple2(this.asyncClient, this.syncClient);
        if (tuple2 != null && (option2 = (Option)tuple2._1()) instanceof Some) {
            Some some = (Some)option2;
            AmazonDynamoDBAsync a = (AmazonDynamoDBAsync)some.value();
            a.shutdown();
            return;
        }
        if (tuple2 != null && (option = (Option)tuple2._2()) instanceof Some) {
            Some some = (Some)option;
            AmazonDynamoDB s = (AmazonDynamoDB)some.value();
            s.shutdown();
            return;
        }
    }

    public V1NewSnapshotDaoImpl(SnapshotPluginContext pluginContext, Option<AmazonDynamoDBAsync> asyncClient, Option<AmazonDynamoDB> syncClient, Serialization serialization) {
        this.pluginContext = pluginContext;
        this.asyncClient = asyncClient;
        this.syncClient = syncClient;
        Tuple2 tuple2 = new Tuple2(asyncClient, syncClient);
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (None$.MODULE$.equals(option) && None$.MODULE$.equals(option2)) {
                throw new IllegalArgumentException("aws clients is both None");
            }
        }
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.streamReadClient = new StreamReadClient((PluginContext)pluginContext, asyncClient, syncClient, pluginContext.pluginConfig().readBackoffConfig());
        this.streamWriteClient = new StreamWriteClient((PluginContext)pluginContext, asyncClient, syncClient, pluginContext.pluginConfig().writeBackoffConfig());
        this.serializer = new ByteArraySnapshotSerializer(serialization, pluginContext.metricsReporter(), pluginContext.traceReporter());
    }
}

