/*
 * Decompiled with CFR 0.152.
 */
package com.github.j5ik2o.akka.persistence.dynamodb.snapshot.dao;

import akka.NotUsed;
import akka.persistence.SnapshotMetadata;
import akka.serialization.Serialization;
import akka.stream.Graph;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBAsync;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteRequest;
import com.amazonaws.services.dynamodbv2.model.PutItemRequest;
import com.amazonaws.services.dynamodbv2.model.QueryRequest;
import com.amazonaws.services.dynamodbv2.model.WriteRequest;
import com.github.j5ik2o.akka.persistence.dynamodb.client.v1.StreamReadClient;
import com.github.j5ik2o.akka.persistence.dynamodb.client.v1.StreamWriteClient;
import com.github.j5ik2o.akka.persistence.dynamodb.context.PluginContext;
import com.github.j5ik2o.akka.persistence.dynamodb.model.PersistenceId;
import com.github.j5ik2o.akka.persistence.dynamodb.model.PersistenceId$;
import com.github.j5ik2o.akka.persistence.dynamodb.model.SequenceNumber;
import com.github.j5ik2o.akka.persistence.dynamodb.snapshot.PartitionKey;
import com.github.j5ik2o.akka.persistence.dynamodb.snapshot.SnapshotPluginContext;
import com.github.j5ik2o.akka.persistence.dynamodb.snapshot.SortKey;
import com.github.j5ik2o.akka.persistence.dynamodb.snapshot.dao.SnapshotDao;
import com.github.j5ik2o.akka.persistence.dynamodb.snapshot.dao.SnapshotRow;
import com.github.j5ik2o.akka.persistence.dynamodb.snapshot.serialization.ByteArraySnapshotSerializer;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\tMa\u0001B\r\u001b\u0005-B\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\tw\u0001\u0011\t\u0011)A\u0005y!A\u0011\n\u0001B\u0001B\u0003%!\n\u0003\u0005O\u0001\t\u0005\t\u0015!\u0003P\u0011\u0015)\u0006\u0001\"\u0001W\u0011\u001da\u0006A1A\u0005\nuCaA\u001a\u0001!\u0002\u0013q\u0006bB4\u0001\u0005\u0004%I\u0001\u001b\u0005\u0007Y\u0002\u0001\u000b\u0011B5\t\u000f5\u0004!\u0019!C\u0005]\"1A\u000f\u0001Q\u0001\n=DQ!\u001e\u0001\u0005BYDq!a\n\u0001\t\u0003\nI\u0003C\u0004\u0002@\u0001!\t%!\u0011\t\u000f\u00055\u0003\u0001\"\u0011\u0002P!9\u0011\u0011\r\u0001\u0005B\u0005\r\u0004bBA8\u0001\u0011\u0005\u0013\u0011\u000f\u0005\b\u0003'\u0003A\u0011IAK\u0011\u001d\ty\n\u0001C!\u0003CCq!a+\u0001\t\u0003\ni\u000bC\u0004\u0002:\u0002!\t%a/\t\u000f\u0005\u001d\u0007\u0001\"\u0003\u0002J\"9\u0011\u0011\u001c\u0001\u0005\n\u0005m\u0007b\u0002B\b\u0001\u0011\u0005#\u0011\u0003\u0002\u0015-FrUm^*oCB\u001c\bn\u001c;EC>LU\u000e\u001d7\u000b\u0005ma\u0012a\u00013b_*\u0011QDH\u0001\tg:\f\u0007o\u001d5pi*\u0011q\u0004I\u0001\tIft\u0017-\\8eE*\u0011\u0011EI\u0001\fa\u0016\u00148/[:uK:\u001cWM\u0003\u0002$I\u0005!\u0011m[6b\u0015\t)c%\u0001\u0004kk%\\'g\u001c\u0006\u0003O!\naaZ5uQV\u0014'\"A\u0015\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001a#\u0007\u0005\u0002.a5\taFC\u00010\u0003\u0015\u00198-\u00197b\u0013\t\tdF\u0001\u0004B]f\u0014VM\u001a\t\u0003gQj\u0011AG\u0005\u0003ki\u00111b\u00158baNDw\u000e\u001e#b_\u0006i\u0001\u000f\\;hS:\u001cuN\u001c;fqR\u0004\"\u0001O\u001d\u000e\u0003qI!A\u000f\u000f\u0003+Ms\u0017\r]:i_R\u0004F.^4j]\u000e{g\u000e^3yi\u0006Y\u0011m]=oG\u000ec\u0017.\u001a8u!\riShP\u0005\u0003}9\u0012aa\u00149uS>t\u0007C\u0001!H\u001b\u0005\t%B\u0001\"D\u0003)!\u0017P\\1n_\u0012\u0014gO\r\u0006\u0003\t\u0016\u000b\u0001b]3sm&\u001cWm\u001d\u0006\u0003\r\"\n\u0011\"Y7bu>t\u0017m^:\n\u0005!\u000b%aE!nCj|g\u000eR=oC6|GIQ!ts:\u001c\u0017AC:z]\u000e\u001cE.[3oiB\u0019Q&P&\u0011\u0005\u0001c\u0015BA'B\u00059\tU.\u0019>p]\u0012Kh.Y7p\t\n\u000bQb]3sS\u0006d\u0017N_1uS>t\u0007C\u0001)T\u001b\u0005\t&B\u0001(S\u0015\u0005\u0019\u0013B\u0001+R\u00055\u0019VM]5bY&T\u0018\r^5p]\u00061A(\u001b8jiz\"Ra\u0016-Z5n\u0003\"a\r\u0001\t\u000bY*\u0001\u0019A\u001c\t\u000bm*\u0001\u0019\u0001\u001f\t\u000b%+\u0001\u0019\u0001&\t\u000b9+\u0001\u0019A(\u0002!M$(/Z1n%\u0016\fGm\u00117jK:$X#\u00010\u0011\u0005}#W\"\u00011\u000b\u0005\u0005\u0014\u0017A\u0001<2\u0015\t\u0019g$\u0001\u0004dY&,g\u000e^\u0005\u0003K\u0002\u0014\u0001c\u0015;sK\u0006l'+Z1e\u00072LWM\u001c;\u0002#M$(/Z1n%\u0016\fGm\u00117jK:$\b%A\ttiJ,\u0017-\\,sSR,7\t\\5f]R,\u0012!\u001b\t\u0003?*L!a\u001b1\u0003#M#(/Z1n/JLG/Z\"mS\u0016tG/\u0001\ntiJ,\u0017-\\,sSR,7\t\\5f]R\u0004\u0013AC:fe&\fG.\u001b>feV\tq\u000e\u0005\u0002qe6\t\u0011O\u0003\u0002O9%\u00111/\u001d\u0002\u001c\u0005f$X-\u0011:sCf\u001cf.\u00199tQ>$8+\u001a:jC2L'0\u001a:\u0002\u0017M,'/[1mSj,'\u000fI\u0001\u0007I\u0016dW\r^3\u0015\u000b]\fi!!\b\u0011\u000balx0!\u0002\u000e\u0003eT!A_>\u0002\u0011M\u001c\u0017\r\\1eg2T!\u0001 *\u0002\rM$(/Z1n\u0013\tq\u0018P\u0001\u0004T_V\u00148-\u001a\t\u0004[\u0005\u0005\u0011bAA\u0002]\t!QK\\5u!\u0011\t9!!\u0003\u000e\u0003IK1!a\u0003S\u0005\u001dqu\u000e^+tK\u0012Dq!a\u0004\r\u0001\u0004\t\t\"A\u0007qKJ\u001c\u0018n\u001d;f]\u000e,\u0017\n\u001a\t\u0005\u0003'\tI\"\u0004\u0002\u0002\u0016)\u0019\u0011q\u0003\u0010\u0002\u000b5|G-\u001a7\n\t\u0005m\u0011Q\u0003\u0002\u000e!\u0016\u00148/[:uK:\u001cW-\u00133\t\u000f\u0005}A\u00021\u0001\u0002\"\u0005Q1/Z9vK:\u001cWM\u0014:\u0011\t\u0005M\u00111E\u0005\u0005\u0003K\t)B\u0001\bTKF,XM\\2f\u001dVl'-\u001a:\u0002%\u0011,G.\u001a;f\u00032d7K\\1qg\"|Go\u001d\u000b\u0005\u0003W\ti\u0004F\u0002x\u0003[Aq!a\f\u000e\u0001\b\t\t$\u0001\u0002fGB!\u00111GA\u001d\u001b\t\t)DC\u0002\u000289\n!bY8oGV\u0014(/\u001a8u\u0013\u0011\tY$!\u000e\u0003!\u0015CXmY;uS>t7i\u001c8uKb$\bbBA\b\u001b\u0001\u0007\u0011\u0011C\u0001\u0018I\u0016dW\r^3VaR{W*\u0019=TKF,XM\\2f\u001dJ$b!a\u0011\u0002H\u0005%CcA<\u0002F!9\u0011q\u0006\bA\u0004\u0005E\u0002bBA\b\u001d\u0001\u0007\u0011\u0011\u0003\u0005\b\u0003\u0017r\u0001\u0019AA\u0011\u00035i\u0017\r_*fcV,gnY3Oe\u00061B-\u001a7fi\u0016,\u0006\u000fV8NCb$\u0016.\\3ti\u0006l\u0007\u000f\u0006\u0004\u0002R\u0005U\u0013q\u000b\u000b\u0004o\u0006M\u0003bBA\u0018\u001f\u0001\u000f\u0011\u0011\u0007\u0005\b\u0003\u001fy\u0001\u0019AA\t\u0011\u001d\tIf\u0004a\u0001\u00037\nA\"\\1y)&lWm\u001d;b[B\u00042!LA/\u0013\r\tyF\f\u0002\u0005\u0019>tw-\u0001\u0014eK2,G/Z+q)>l\u0015\r_*fcV,gnY3Oe\u0006sG-T1y)&lWm\u001d;b[B$\u0002\"!\u001a\u0002j\u0005-\u0014Q\u000e\u000b\u0004o\u0006\u001d\u0004bBA\u0018!\u0001\u000f\u0011\u0011\u0007\u0005\b\u0003\u001f\u0001\u0002\u0019AA\t\u0011\u001d\tY\u0005\u0005a\u0001\u0003CAq!!\u0017\u0011\u0001\u0004\tY&\u0001\bmCR,7\u000f^*oCB\u001c\bn\u001c;\u0015\t\u0005M\u0014\u0011\u0013\u000b\u0005\u0003k\ny\t\u0005\u0004y{\u0006]\u0014Q\u0001\t\u0005[u\nI\bE\u0004.\u0003w\ny(!#\n\u0007\u0005udF\u0001\u0004UkBdWM\r\t\u0005\u0003\u0003\u000b))\u0004\u0002\u0002\u0004*\u0011\u0011EU\u0005\u0005\u0003\u000f\u000b\u0019I\u0001\tT]\u0006\u00048\u000f[8u\u001b\u0016$\u0018\rZ1uCB\u0019Q&a#\n\u0007\u00055eFA\u0002B]fDq!a\f\u0012\u0001\b\t\t\u0004C\u0004\u0002\u0010E\u0001\r!!\u0005\u0002/Mt\u0017\r]:i_R4uN]'bqRKW.Z:uC6\u0004HCBAL\u00037\u000bi\n\u0006\u0003\u0002v\u0005e\u0005bBA\u0018%\u0001\u000f\u0011\u0011\u0007\u0005\b\u0003\u001f\u0011\u0002\u0019AA\t\u0011\u001d\tIF\u0005a\u0001\u00037\n\u0001d\u001d8baNDw\u000e\u001e$pe6\u000b\u0007pU3rk\u0016t7-\u001a(s)\u0019\t\u0019+a*\u0002*R!\u0011QOAS\u0011\u001d\tyc\u0005a\u0002\u0003cAq!a\u0004\u0014\u0001\u0004\t\t\u0002C\u0004\u0002LM\u0001\r!!\t\u0002OMt\u0017\r]:i_R4uN]'bqN+\u0017/^3oG\u0016t%/\u00118e\u001b\u0006DH+[7fgR\fW\u000e\u001d\u000b\t\u0003_\u000b\u0019,!.\u00028R!\u0011QOAY\u0011\u001d\ty\u0003\u0006a\u0002\u0003cAq!a\u0004\u0015\u0001\u0004\t\t\u0002C\u0004\u0002LQ\u0001\r!!\t\t\u000f\u0005eC\u00031\u0001\u0002\\\u0005!1/\u0019<f)\u0019\ti,!1\u0002FR\u0019q/a0\t\u000f\u0005=R\u0003q\u0001\u00022!9\u00111Y\u000bA\u0002\u0005}\u0014\u0001E:oCB\u001c\bn\u001c;NKR\fG-\u0019;b\u0011\u0019iR\u00031\u0001\u0002\n\u0006Y\u0011/^3ss\u0012+G.\u001a;f)\r9\u00181\u001a\u0005\b\u0003\u001b4\u0002\u0019AAh\u00031\tX/\u001a:z%\u0016\fX/Z:u!\u0011\t\t.!6\u000e\u0005\u0005M'bAA\f\u0003&!\u0011q[Aj\u00051\tV/\u001a:z%\u0016\fX/Z:u\u0003-!Wm]3sS\u0006d\u0017N_3\u0015\t\u0005u\u0017q\u001d\u000b\u0005\u0003?\f)\u000f\u0005\u0004\u00024\u0005\u0005\u0018qO\u0005\u0005\u0003G\f)D\u0001\u0004GkR,(/\u001a\u0005\b\u0003_9\u00029AA\u0019\u0011\u001d\tIo\u0006a\u0001\u0003W\faA]8x\u001fB$\b\u0003B\u0017>\u0003[\u0004\u0002\"a<\u0002~\n\r!\u0011\u0002\b\u0005\u0003c\fI\u0010E\u0002\u0002t:j!!!>\u000b\u0007\u0005](&\u0001\u0004=e>|GOP\u0005\u0004\u0003wt\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0000\n\u0005!aA'ba*\u0019\u00111 \u0018\u0011\t\u0005=(QA\u0005\u0005\u0005\u000f\u0011\tA\u0001\u0004TiJLgn\u001a\t\u0005\u0003#\u0014Y!\u0003\u0003\u0003\u000e\u0005M'AD!uiJL'-\u001e;f-\u0006dW/Z\u0001\bI&\u001c\bo\\:f)\u0005y\b")
public final class V1NewSnapshotDaoImpl
implements SnapshotDao {
    private final SnapshotPluginContext pluginContext;
    private final Option<AmazonDynamoDBAsync> asyncClient;
    private final Option<AmazonDynamoDB> syncClient;
    private final StreamReadClient streamReadClient;
    private final StreamWriteClient streamWriteClient;
    private final ByteArraySnapshotSerializer serializer;

    private StreamReadClient streamReadClient() {
        return this.streamReadClient;
    }

    private StreamWriteClient streamWriteClient() {
        return this.streamWriteClient;
    }

    private ByteArraySnapshotSerializer serializer() {
        return this.serializer;
    }

    public Source<BoxedUnit, NotUsed> delete(PersistenceId persistenceId, SequenceNumber sequenceNr) {
        QueryRequest queryRequest = new QueryRequest().withTableName(this.pluginContext.pluginConfig().tableName()).withIndexName(this.pluginContext.pluginConfig().getSnapshotRowsIndexName()).withKeyConditionExpression("#pid = :pid and #snr = :snr").withExpressionAttributeNames((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().sequenceNrColumnName())}))).asJava()).withExpressionAttributeValues((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), (Object)new AttributeValue().withS(persistenceId.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":snr"), (Object)new AttributeValue().withN(sequenceNr.asString()))}))).asJava()).withConsistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginContext.pluginConfig().consistentRead()));
        return this.queryDelete(queryRequest);
    }

    public Source<BoxedUnit, NotUsed> deleteAllSnapshots(PersistenceId persistenceId, ExecutionContext ec) {
        QueryRequest queryRequest = new QueryRequest().withTableName(this.pluginContext.pluginConfig().tableName()).withIndexName(this.pluginContext.pluginConfig().getSnapshotRowsIndexName()).withKeyConditionExpression("#pid = :pid and #snr between :min and :max").withExpressionAttributeNames((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().sequenceNrColumnName())}))).asJava()).withExpressionAttributeValues((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), (Object)new AttributeValue().withS(persistenceId.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), (Object)new AttributeValue().withN(Integer.toString(0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), (Object)new AttributeValue().withN(Long.toString(Long.MAX_VALUE)))}))).asJava()).withConsistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginContext.pluginConfig().consistentRead()));
        return this.queryDelete(queryRequest);
    }

    public Source<BoxedUnit, NotUsed> deleteUpToMaxSequenceNr(PersistenceId persistenceId, SequenceNumber maxSequenceNr, ExecutionContext ec) {
        QueryRequest queryRequest = new QueryRequest().withTableName(this.pluginContext.pluginConfig().tableName()).withIndexName(this.pluginContext.pluginConfig().getSnapshotRowsIndexName()).withKeyConditionExpression("#pid = :pid and #snr between :min and :max").withExpressionAttributeNames((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().sequenceNrColumnName())}))).asJava()).withExpressionAttributeValues((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), (Object)new AttributeValue().withS(persistenceId.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), (Object)new AttributeValue().withN(Integer.toString(0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), (Object)new AttributeValue().withN(maxSequenceNr.asString()))}))).asJava()).withConsistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginContext.pluginConfig().consistentRead()));
        return this.queryDelete(queryRequest);
    }

    public Source<BoxedUnit, NotUsed> deleteUpToMaxTimestamp(PersistenceId persistenceId, long maxTimestamp, ExecutionContext ec) {
        QueryRequest queryRequest = new QueryRequest().withTableName(this.pluginContext.pluginConfig().tableName()).withIndexName(this.pluginContext.pluginConfig().getSnapshotRowsIndexName()).withKeyConditionExpression("#pid = :pid and #snr between :min and :max").withFilterExpression("#created <= :maxTimestamp").withExpressionAttributeNames((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().sequenceNrColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#created"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().createdColumnName())}))).asJava()).withExpressionAttributeValues((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), (Object)new AttributeValue().withS(persistenceId.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), (Object)new AttributeValue().withN(Integer.toString(0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), (Object)new AttributeValue().withN(Long.toString(Long.MAX_VALUE))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":maxTimestamp"), (Object)new AttributeValue().withN(Long.toString(maxTimestamp)))}))).asJava()).withConsistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginContext.pluginConfig().consistentRead()));
        return this.queryDelete(queryRequest);
    }

    public Source<BoxedUnit, NotUsed> deleteUpToMaxSequenceNrAndMaxTimestamp(PersistenceId persistenceId, SequenceNumber maxSequenceNr, long maxTimestamp, ExecutionContext ec) {
        QueryRequest queryRequest = new QueryRequest().withTableName(this.pluginContext.pluginConfig().tableName()).withIndexName(this.pluginContext.pluginConfig().getSnapshotRowsIndexName()).withKeyConditionExpression("#pid = :pid and #snr between :min and :max").withFilterExpression("#created <= :maxTimestamp").withExpressionAttributeNames((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().sequenceNrColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#created"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().createdColumnName())}))).asJava()).withExpressionAttributeValues((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), (Object)new AttributeValue().withS(persistenceId.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), (Object)new AttributeValue().withN(Integer.toString(0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), (Object)new AttributeValue().withN(maxSequenceNr.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":maxTimestamp"), (Object)new AttributeValue().withN(Long.toString(maxTimestamp)))}))).asJava()).withConsistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginContext.pluginConfig().consistentRead()));
        return this.queryDelete(queryRequest);
    }

    public Source<Option<Tuple2<SnapshotMetadata, Object>>, NotUsed> latestSnapshot(PersistenceId persistenceId, ExecutionContext ec) {
        QueryRequest queryRequest = new QueryRequest().withTableName(this.pluginContext.pluginConfig().tableName()).withIndexName(this.pluginContext.pluginConfig().getSnapshotRowsIndexName()).withKeyConditionExpression("#pid = :pid and #snr between :min and :max").withExpressionAttributeNames((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().sequenceNrColumnName())}))).asJava()).withExpressionAttributeValues((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), (Object)new AttributeValue().withS(persistenceId.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), (Object)new AttributeValue().withN(Integer.toString(0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), (Object)new AttributeValue().withN(Long.toString(Long.MAX_VALUE)))}))).asJava()).withScanIndexForward(Predef$.MODULE$.boolean2Boolean(false)).withLimit(Predef$.MODULE$.int2Integer(1)).withConsistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginContext.pluginConfig().consistentRead()));
        return (Source)Source$.MODULE$.single((Object)queryRequest).via((Graph)this.streamReadClient().queryFlow()).flatMapConcat((Function1 & Serializable & scala.Serializable)response -> {
            if (response.getSdkHttpMetadata().getHttpStatusCode() == 200) {
                return Source$.MODULE$.single((Object)((TraversableLike)((TraversableLike)Option$.MODULE$.apply((Object)response.getItems()).map((Function1 & Serializable & scala.Serializable)x$1 -> (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(x$1).asScala()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$2 -> ((TraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter(x$2).asScala()).toMap(Predef$.MODULE$.$conforms()), scala.collection.Seq$.MODULE$.canBuildFrom())).headOption());
            }
            int statusCode = response.getSdkHttpMetadata().getHttpStatusCode();
            return Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).toString()));
        }).mapAsync(1, (Function1 & Serializable & scala.Serializable)rowOpt -> this.deserialize((Option<scala.collection.immutable.Map<String, AttributeValue>>)rowOpt, ec));
    }

    public Source<Option<Tuple2<SnapshotMetadata, Object>>, NotUsed> snapshotForMaxTimestamp(PersistenceId persistenceId, long maxTimestamp, ExecutionContext ec) {
        QueryRequest queryRequest = new QueryRequest().withTableName(this.pluginContext.pluginConfig().tableName()).withIndexName(this.pluginContext.pluginConfig().getSnapshotRowsIndexName()).withKeyConditionExpression("#pid = :pid and #snr between :min and :max").withFilterExpression("#created <= :maxTimestamp").withExpressionAttributeNames((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().sequenceNrColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#created"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().createdColumnName())}))).asJava()).withExpressionAttributeValues((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), (Object)new AttributeValue().withS(persistenceId.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), (Object)new AttributeValue().withN(Integer.toString(0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), (Object)new AttributeValue().withN(Long.toString(Long.MAX_VALUE))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":maxTimestamp"), (Object)new AttributeValue().withN(Long.toString(maxTimestamp)))}))).asJava()).withScanIndexForward(Predef$.MODULE$.boolean2Boolean(false)).withConsistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginContext.pluginConfig().consistentRead()));
        return (Source)Source$.MODULE$.single((Object)queryRequest).via((Graph)this.streamReadClient().queryFlow()).flatMapConcat((Function1 & Serializable & scala.Serializable)response -> {
            if (response.getSdkHttpMetadata().getHttpStatusCode() == 200) {
                return Source$.MODULE$.single((Object)((TraversableLike)((TraversableLike)Option$.MODULE$.apply((Object)response.getItems()).map((Function1 & Serializable & scala.Serializable)x$3 -> (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(x$3).asScala()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$4 -> ((TraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter(x$4).asScala()).toMap(Predef$.MODULE$.$conforms()), scala.collection.Seq$.MODULE$.canBuildFrom())).headOption());
            }
            int statusCode = response.getSdkHttpMetadata().getHttpStatusCode();
            return Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).toString()));
        }).mapAsync(1, (Function1 & Serializable & scala.Serializable)rowOpt -> this.deserialize((Option<scala.collection.immutable.Map<String, AttributeValue>>)rowOpt, ec));
    }

    public Source<Option<Tuple2<SnapshotMetadata, Object>>, NotUsed> snapshotForMaxSequenceNr(PersistenceId persistenceId, SequenceNumber maxSequenceNr, ExecutionContext ec) {
        QueryRequest queryRequest = new QueryRequest().withTableName(this.pluginContext.pluginConfig().tableName()).withIndexName(this.pluginContext.pluginConfig().getSnapshotRowsIndexName()).withKeyConditionExpression("#pid = :pid and #snr between :min and :max").withExpressionAttributeNames((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().sequenceNrColumnName())}))).asJava()).withExpressionAttributeValues((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), (Object)new AttributeValue().withS(persistenceId.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), (Object)new AttributeValue().withN(Integer.toString(0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), (Object)new AttributeValue().withN(maxSequenceNr.asString()))}))).asJava()).withScanIndexForward(Predef$.MODULE$.boolean2Boolean(false)).withConsistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginContext.pluginConfig().consistentRead()));
        return (Source)Source$.MODULE$.single((Object)queryRequest).via((Graph)this.streamReadClient().queryFlow()).flatMapConcat((Function1 & Serializable & scala.Serializable)response -> {
            if (response.getSdkHttpMetadata().getHttpStatusCode() == 200) {
                return Source$.MODULE$.single((Object)((TraversableLike)((TraversableLike)Option$.MODULE$.apply((Object)response.getItems()).map((Function1 & Serializable & scala.Serializable)x$5 -> (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(x$5).asScala()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$6 -> ((TraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter(x$6).asScala()).toMap(Predef$.MODULE$.$conforms()), scala.collection.Seq$.MODULE$.canBuildFrom())).headOption());
            }
            int statusCode = response.getSdkHttpMetadata().getHttpStatusCode();
            return Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).toString()));
        }).mapAsync(1, (Function1 & Serializable & scala.Serializable)rowOpt -> this.deserialize((Option<scala.collection.immutable.Map<String, AttributeValue>>)rowOpt, ec));
    }

    public Source<Option<Tuple2<SnapshotMetadata, Object>>, NotUsed> snapshotForMaxSequenceNrAndMaxTimestamp(PersistenceId persistenceId, SequenceNumber maxSequenceNr, long maxTimestamp, ExecutionContext ec) {
        QueryRequest queryRequest = new QueryRequest().withTableName(this.pluginContext.pluginConfig().tableName()).withIndexName(this.pluginContext.pluginConfig().getSnapshotRowsIndexName()).withKeyConditionExpression("#pid = :pid and #snr between :min and :max").withFilterExpression("#created <= :maxTimestamp").withExpressionAttributeNames((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().sequenceNrColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#created"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().createdColumnName())}))).asJava()).withExpressionAttributeValues((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), (Object)new AttributeValue().withS(persistenceId.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), (Object)new AttributeValue().withN(Integer.toString(0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), (Object)new AttributeValue().withN(maxSequenceNr.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":maxTimestamp"), (Object)new AttributeValue().withN(Long.toString(maxTimestamp)))}))).asJava()).withScanIndexForward(Predef$.MODULE$.boolean2Boolean(false)).withConsistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginContext.pluginConfig().consistentRead()));
        return (Source)Source$.MODULE$.single((Object)queryRequest).via((Graph)this.streamReadClient().queryFlow()).flatMapConcat((Function1 & Serializable & scala.Serializable)response -> {
            if (response.getSdkHttpMetadata().getHttpStatusCode() == 200) {
                return Source$.MODULE$.single((Object)((TraversableLike)((TraversableLike)Option$.MODULE$.apply((Object)response.getItems()).map((Function1 & Serializable & scala.Serializable)x$7 -> (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(x$7).asScala()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$8 -> ((TraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter(x$8).asScala()).toMap(Predef$.MODULE$.$conforms()), scala.collection.Seq$.MODULE$.canBuildFrom())).headOption());
            }
            int statusCode = response.getSdkHttpMetadata().getHttpStatusCode();
            return Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).toString()));
        }).mapAsync(1, (Function1 & Serializable & scala.Serializable)rowOpt -> this.deserialize((Option<scala.collection.immutable.Map<String, AttributeValue>>)rowOpt, ec));
    }

    public Source<BoxedUnit, NotUsed> save(SnapshotMetadata snapshotMetadata, Object snapshot, ExecutionContext ec) {
        return (Source)Source$.MODULE$.future(this.serializer().serialize(snapshotMetadata, snapshot, ec)).flatMapConcat((Function1 & Serializable & scala.Serializable)snapshotRow -> {
            PartitionKey pkey = $this.pluginContext.partitionKeyResolver().resolve(snapshotRow.persistenceId(), snapshotRow.sequenceNumber());
            SortKey skey = $this.pluginContext.sortKeyResolver().resolve(snapshotRow.persistenceId(), snapshotRow.sequenceNumber());
            PutItemRequest req = new PutItemRequest().withTableName($this.pluginContext.pluginConfig().tableName()).withItem((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.pluginContext.pluginConfig().columnsDefConfig().partitionKeyColumnName()), (Object)new AttributeValue().withS(pkey.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.pluginContext.pluginConfig().columnsDefConfig().sortKeyColumnName()), (Object)new AttributeValue().withS(skey.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.pluginContext.pluginConfig().columnsDefConfig().persistenceIdColumnName()), (Object)new AttributeValue().withS(snapshotRow.persistenceId().asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.pluginContext.pluginConfig().columnsDefConfig().sequenceNrColumnName()), (Object)new AttributeValue().withN(snapshotRow.sequenceNumber().asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.pluginContext.pluginConfig().columnsDefConfig().snapshotColumnName()), (Object)new AttributeValue().withB(ByteBuffer.wrap(snapshotRow.snapshot()))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.pluginContext.pluginConfig().columnsDefConfig().createdColumnName()), (Object)new AttributeValue().withN(Long.toString(snapshotRow.created())))}))).asJava());
            return (Source)Source$.MODULE$.single((Object)req).via((Graph)this.streamWriteClient().putItemFlow()).flatMapConcat((Function1 & Serializable & scala.Serializable)response -> {
                if (response.getSdkHttpMetadata().getHttpStatusCode() == 200) {
                    return Source$.MODULE$.single((Object)BoxedUnit.UNIT);
                }
                int statusCode = response.getSdkHttpMetadata().getHttpStatusCode();
                return Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).toString()));
            });
        });
    }

    private Source<BoxedUnit, NotUsed> queryDelete(QueryRequest queryRequest) {
        return (Source)((Source)Source$.MODULE$.single((Object)queryRequest).via((Graph)this.streamReadClient().queryFlow()).map((Function1 & Serializable & scala.Serializable)response -> (Seq)Option$.MODULE$.apply((Object)response.getItems()).map((Function1 & Serializable & scala.Serializable)x$9 -> (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(x$9).asScala()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$)).mapConcat((Function1 & Serializable & scala.Serializable)x$10 -> x$10.toVector()).grouped(this.pluginContext.pluginConfig().clientConfig().batchWriteItemLimit()).map((Function1 & Serializable & scala.Serializable)rows -> (scala.collection.immutable.Seq)rows.map((Function1 & Serializable & scala.Serializable)javaRow -> {
            scala.collection.mutable.Map row = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(javaRow).asScala();
            PersistenceId x$1 = PersistenceId$.MODULE$.apply(((AttributeValue)row.apply((Object)$this.pluginContext.pluginConfig().columnsDefConfig().persistenceIdColumnName())).getS());
            SequenceNumber x$2 = new SequenceNumber(new StringOps(Predef$.MODULE$.augmentString(((AttributeValue)row.apply((Object)$this.pluginContext.pluginConfig().columnsDefConfig().sequenceNrColumnName())).getN())).toLong());
            byte[] x$3 = ((AttributeValue)row.apply((Object)$this.pluginContext.pluginConfig().columnsDefConfig().snapshotColumnName())).getB().array();
            long x$4 = new StringOps(Predef$.MODULE$.augmentString(((AttributeValue)row.apply((Object)$this.pluginContext.pluginConfig().columnsDefConfig().createdColumnName())).getN())).toLong();
            return new SnapshotRow(x$1, x$2, x$4, x$3);
        }, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)rows -> new BatchWriteItemRequest().withRequestItems((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.pluginContext.pluginConfig().tableName()), CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)rows.map((Function1 & Serializable & scala.Serializable)row -> {
            PartitionKey pkey = $this.pluginContext.partitionKeyResolver().resolve(row.persistenceId(), row.sequenceNumber());
            SortKey skey = $this.pluginContext.sortKeyResolver().resolve(row.persistenceId(), row.sequenceNumber());
            return new WriteRequest().withDeleteRequest(new DeleteRequest().withKey((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.pluginContext.pluginConfig().columnsDefConfig().partitionKeyColumnName()), (Object)new AttributeValue().withS(pkey.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.pluginContext.pluginConfig().columnsDefConfig().sortKeyColumnName()), (Object)new AttributeValue().withS(skey.asString()))}))).asJava()));
        }, Seq$.MODULE$.canBuildFrom())).asJava())}))).asJava()))).via((Graph)this.streamWriteClient().batchWriteItemFlow()).flatMapConcat((Function1 & Serializable & scala.Serializable)response -> {
            if (response.getSdkHttpMetadata().getHttpStatusCode() == 200) {
                return Source$.MODULE$.single((Object)BoxedUnit.UNIT);
            }
            int statusCode = response.getSdkHttpMetadata().getHttpStatusCode();
            return Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).toString()));
        });
    }

    private Future<Option<Tuple2<SnapshotMetadata, Object>>> deserialize(Option<scala.collection.immutable.Map<String, AttributeValue>> rowOpt, ExecutionContext ec) {
        Option<scala.collection.immutable.Map<String, AttributeValue>> option = rowOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            scala.collection.immutable.Map row = (scala.collection.immutable.Map)some.value();
            PersistenceId x$1 = PersistenceId$.MODULE$.apply(((AttributeValue)row.apply((Object)this.pluginContext.pluginConfig().columnsDefConfig().persistenceIdColumnName())).getS());
            SequenceNumber x$2 = new SequenceNumber(new StringOps(Predef$.MODULE$.augmentString(((AttributeValue)row.apply((Object)this.pluginContext.pluginConfig().columnsDefConfig().sequenceNrColumnName())).getN())).toLong());
            byte[] x$3 = ((AttributeValue)row.apply((Object)this.pluginContext.pluginConfig().columnsDefConfig().snapshotColumnName())).getB().array();
            long x$4 = new StringOps(Predef$.MODULE$.augmentString(((AttributeValue)row.apply((Object)this.pluginContext.pluginConfig().columnsDefConfig().createdColumnName())).getN())).toLong();
            return this.serializer().deserialize(new SnapshotRow(x$1, x$2, x$4, x$3), ec).map((Function1 & Serializable & scala.Serializable)x$11 -> new Some(x$11), ec);
        }
        if (None$.MODULE$.equals(option)) {
            return Future$.MODULE$.successful((Object)None$.MODULE$);
        }
        throw new MatchError(option);
    }

    public void dispose() {
        Option option;
        Option option2;
        Tuple2 tuple2 = new Tuple2(this.asyncClient, this.syncClient);
        if (tuple2 != null && (option2 = (Option)tuple2._1()) instanceof Some) {
            Some some = (Some)option2;
            AmazonDynamoDBAsync a = (AmazonDynamoDBAsync)some.value();
            a.shutdown();
            return;
        }
        if (tuple2 != null && (option = (Option)tuple2._2()) instanceof Some) {
            Some some = (Some)option;
            AmazonDynamoDB s = (AmazonDynamoDB)some.value();
            s.shutdown();
            return;
        }
    }

    public V1NewSnapshotDaoImpl(SnapshotPluginContext pluginContext, Option<AmazonDynamoDBAsync> asyncClient, Option<AmazonDynamoDB> syncClient, Serialization serialization) {
        this.pluginContext = pluginContext;
        this.asyncClient = asyncClient;
        this.syncClient = syncClient;
        Tuple2 tuple2 = new Tuple2(asyncClient, syncClient);
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (None$.MODULE$.equals(option) && None$.MODULE$.equals(option2)) {
                throw new IllegalArgumentException("aws clients is both None");
            }
        }
        this.streamReadClient = new StreamReadClient((PluginContext)pluginContext, asyncClient, syncClient, pluginContext.pluginConfig().readBackoffConfig());
        this.streamWriteClient = new StreamWriteClient((PluginContext)pluginContext, asyncClient, syncClient, pluginContext.pluginConfig().writeBackoffConfig());
        this.serializer = new ByteArraySnapshotSerializer(serialization, pluginContext.metricsReporter(), pluginContext.traceReporter());
    }
}

