/*
 * Decompiled with CFR 0.152.
 */
package com.github.j5ik2o.akka.persistence.dynamodb.snapshot.dao;

import akka.NotUsed;
import akka.persistence.SnapshotMetadata;
import akka.serialization.Serialization;
import akka.stream.Graph;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBAsync;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteItemRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteRequest;
import com.amazonaws.services.dynamodbv2.model.PutItemRequest;
import com.amazonaws.services.dynamodbv2.model.QueryRequest;
import com.amazonaws.services.dynamodbv2.model.WriteRequest;
import com.github.j5ik2o.akka.persistence.dynamodb.client.v1.StreamReadClient;
import com.github.j5ik2o.akka.persistence.dynamodb.client.v1.StreamWriteClient;
import com.github.j5ik2o.akka.persistence.dynamodb.context.PluginContext;
import com.github.j5ik2o.akka.persistence.dynamodb.model.PersistenceId;
import com.github.j5ik2o.akka.persistence.dynamodb.model.PersistenceId$;
import com.github.j5ik2o.akka.persistence.dynamodb.model.SequenceNumber;
import com.github.j5ik2o.akka.persistence.dynamodb.snapshot.SnapshotPluginContext;
import com.github.j5ik2o.akka.persistence.dynamodb.snapshot.dao.SnapshotDao;
import com.github.j5ik2o.akka.persistence.dynamodb.snapshot.dao.SnapshotRow;
import com.github.j5ik2o.akka.persistence.dynamodb.snapshot.serialization.ByteArraySnapshotSerializer;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\tMa\u0001B\r\u001b\u0005-B\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\tw\u0001\u0011\t\u0011)A\u0005y!A\u0011\n\u0001B\u0001B\u0003%!\n\u0003\u0005O\u0001\t\u0005\t\u0015!\u0003P\u0011\u0015)\u0006\u0001\"\u0001W\u0011\u001da\u0006A1A\u0005\nuCaA\u001a\u0001!\u0002\u0013q\u0006bB4\u0001\u0005\u0004%I\u0001\u001b\u0005\u0007Y\u0002\u0001\u000b\u0011B5\t\u000f5\u0004!\u0019!C\u0005]\"1A\u000f\u0001Q\u0001\n=DQ!\u001e\u0001\u0005BYDq!a\f\u0001\t\u0003\n\t\u0004C\u0004\u0002D\u0001!\t%!\u0012\t\u000f\u0005]\u0003\u0001\"\u0011\u0002Z!9\u0011Q\r\u0001\u0005\n\u0005\u001d\u0004bBA\\\u0001\u0011\u0005\u0013\u0011\u0018\u0005\b\u0003\u0007\u0004A\u0011IAc\u0011\u001d\ty\r\u0001C!\u0003#Dq!a7\u0001\t\u0003\ni\u000eC\u0004\u0002j\u0002!\t%a;\t\u000f\u0005M\b\u0001\"\u0011\u0002v\"9!\u0011\u0001\u0001\u0005\n\t\r\u0001b\u0002B\b\u0001\u0011\u0005#\u0011\u0003\u0002\u0018-FbUmZ1dsNs\u0017\r]:i_R$\u0015m\\%na2T!a\u0007\u000f\u0002\u0007\u0011\fwN\u0003\u0002\u001e=\u0005A1O\\1qg\"|GO\u0003\u0002 A\u0005AA-\u001f8b[>$'M\u0003\u0002\"E\u0005Y\u0001/\u001a:tSN$XM\\2f\u0015\t\u0019C%\u0001\u0003bW.\f'BA\u0013'\u0003\u0019QW'[63_*\u0011q\u0005K\u0001\u0007O&$\b.\u001e2\u000b\u0003%\n1aY8n\u0007\u0001\u00192\u0001\u0001\u00173!\ti\u0003'D\u0001/\u0015\u0005y\u0013!B:dC2\f\u0017BA\u0019/\u0005\u0019\te.\u001f*fMB\u00111\u0007N\u0007\u00025%\u0011QG\u0007\u0002\f':\f\u0007o\u001d5pi\u0012\u000bw.A\u0007qYV<\u0017N\\\"p]R,\u0007\u0010\u001e\t\u0003qej\u0011\u0001H\u0005\u0003uq\u0011Qc\u00158baNDw\u000e\u001e)mk\u001eLgnQ8oi\u0016DH/A\u0006bgft7m\u00117jK:$\bcA\u0017>\u007f%\u0011aH\f\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\u0001;U\"A!\u000b\u0005\t\u001b\u0015A\u00033z]\u0006lw\u000e\u001a2we)\u0011A)R\u0001\tg\u0016\u0014h/[2fg*\u0011a\tK\u0001\nC6\f'p\u001c8boNL!\u0001S!\u0003'\u0005k\u0017M_8o\tft\u0017-\\8E\u0005\u0006\u001b\u0018P\\2\u0002\u0015MLhnY\"mS\u0016tG\u000fE\u0002.{-\u0003\"\u0001\u0011'\n\u00055\u000b%AD!nCj|g\u000eR=oC6|GIQ\u0001\u000eg\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8\u0011\u0005A\u001bV\"A)\u000b\u00059\u0013&\"A\u0012\n\u0005Q\u000b&!D*fe&\fG.\u001b>bi&|g.\u0001\u0004=S:LGO\u0010\u000b\u0006/bK&l\u0017\t\u0003g\u0001AQAN\u0003A\u0002]BQaO\u0003A\u0002qBQ!S\u0003A\u0002)CQAT\u0003A\u0002=\u000b\u0001c\u001d;sK\u0006l'+Z1e\u00072LWM\u001c;\u0016\u0003y\u0003\"a\u00183\u000e\u0003\u0001T!!\u00192\u0002\u0005Y\f$BA2\u001f\u0003\u0019\u0019G.[3oi&\u0011Q\r\u0019\u0002\u0011'R\u0014X-Y7SK\u0006$7\t\\5f]R\f\u0011c\u001d;sK\u0006l'+Z1e\u00072LWM\u001c;!\u0003E\u0019HO]3b[^\u0013\u0018\u000e^3DY&,g\u000e^\u000b\u0002SB\u0011qL[\u0005\u0003W\u0002\u0014\u0011c\u0015;sK\u0006lwK]5uK\u000ec\u0017.\u001a8u\u0003I\u0019HO]3b[^\u0013\u0018\u000e^3DY&,g\u000e\u001e\u0011\u0002\u0015M,'/[1mSj,'/F\u0001p!\t\u0001(/D\u0001r\u0015\tqE$\u0003\u0002tc\nY\")\u001f;f\u0003J\u0014\u0018-_*oCB\u001c\bn\u001c;TKJL\u0017\r\\5{KJ\f1b]3sS\u0006d\u0017N_3sA\u0005\u0011B-\u001a7fi\u0016\fE\u000e\\*oCB\u001c\bn\u001c;t)\r9\u0018q\u0004\u000b\u0004q\u0006=\u0001CB=\u007f\u0003\u0003\t9!D\u0001{\u0015\tYH0\u0001\u0005tG\u0006d\u0017\rZ:m\u0015\ti(+\u0001\u0004tiJ,\u0017-\\\u0005\u0003\u007fj\u0014aaU8ve\u000e,\u0007cA\u0017\u0002\u0004%\u0019\u0011Q\u0001\u0018\u0003\tUs\u0017\u000e\u001e\t\u0005\u0003\u0013\tY!D\u0001S\u0013\r\tiA\u0015\u0002\b\u001d>$Xk]3e\u0011\u001d\t\t\u0002\u0004a\u0002\u0003'\t!!Z2\u0011\t\u0005U\u00111D\u0007\u0003\u0003/Q1!!\u0007/\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0003;\t9B\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\"9\u0011\u0011\u0005\u0007A\u0002\u0005\r\u0012!\u00049feNL7\u000f^3oG\u0016LE\r\u0005\u0003\u0002&\u0005-RBAA\u0014\u0015\r\tICH\u0001\u0006[>$W\r\\\u0005\u0005\u0003[\t9CA\u0007QKJ\u001c\u0018n\u001d;f]\u000e,\u0017\nZ\u0001\u0018I\u0016dW\r^3VaR{W*\u0019=TKF,XM\\2f\u001dJ$b!a\r\u00028\u0005eBc\u0001=\u00026!9\u0011\u0011C\u0007A\u0004\u0005M\u0001bBA\u0011\u001b\u0001\u0007\u00111\u0005\u0005\b\u0003wi\u0001\u0019AA\u001f\u00035i\u0017\r_*fcV,gnY3OeB!\u0011QEA \u0013\u0011\t\t%a\n\u0003\u001dM+\u0017/^3oG\u0016tU/\u001c2fe\u00061B-\u001a7fi\u0016,\u0006\u000fV8NCb$\u0016.\\3ti\u0006l\u0007\u000f\u0006\u0004\u0002H\u0005-\u0013Q\n\u000b\u0004q\u0006%\u0003bBA\t\u001d\u0001\u000f\u00111\u0003\u0005\b\u0003Cq\u0001\u0019AA\u0012\u0011\u001d\tyE\u0004a\u0001\u0003#\nA\"\\1y)&lWm\u001d;b[B\u00042!LA*\u0013\r\t)F\f\u0002\u0005\u0019>tw-\u0001\u0014eK2,G/Z+q)>l\u0015\r_*fcV,gnY3Oe\u0006sG-T1y)&lWm\u001d;b[B$\u0002\"a\u0017\u0002`\u0005\u0005\u00141\r\u000b\u0004q\u0006u\u0003bBA\t\u001f\u0001\u000f\u00111\u0003\u0005\b\u0003Cy\u0001\u0019AA\u0012\u0011\u001d\tYd\u0004a\u0001\u0003{Aq!a\u0014\u0010\u0001\u0004\t\t&A\u0006eKN,'/[1mSj,G\u0003BA5\u0003\u0017#B!a\u001b\u0002\nB1\u0011QCA7\u0003cJA!a\u001c\u0002\u0018\t1a)\u001e;ve\u0016\u0004B!L\u001f\u0002tA9Q&!\u001e\u0002z\u0005\r\u0015bAA<]\t1A+\u001e9mKJ\u0002B!a\u001f\u0002\u00005\u0011\u0011Q\u0010\u0006\u0003CIKA!!!\u0002~\t\u00012K\\1qg\"|G/T3uC\u0012\fG/\u0019\t\u0004[\u0005\u0015\u0015bAAD]\t\u0019\u0011I\\=\t\u000f\u0005E\u0001\u0003q\u0001\u0002\u0014!9\u0011Q\u0012\tA\u0002\u0005=\u0015A\u0002:po>\u0003H\u000f\u0005\u0003.{\u0005E\u0005\u0003CAJ\u0003C\u000b9+!,\u000f\t\u0005U\u0015Q\u0014\t\u0004\u0003/sSBAAM\u0015\r\tYJK\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005}e&\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003G\u000b)KA\u0002NCBT1!a(/!\u0011\t\u0019*!+\n\t\u0005-\u0016Q\u0015\u0002\u0007'R\u0014\u0018N\\4\u0011\t\u0005=\u00161W\u0007\u0003\u0003cS1!!\u000bB\u0013\u0011\t),!-\u0003\u001d\u0005#HO]5ckR,g+\u00197vK\u0006qA.\u0019;fgR\u001cf.\u00199tQ>$H\u0003BA^\u0003\u0003$B!!0\u0002@B1\u0011P`A9\u0003\u000fAq!!\u0005\u0012\u0001\b\t\u0019\u0002C\u0004\u0002\"E\u0001\r!a\t\u0002/Mt\u0017\r]:i_R4uN]'bqRKW.Z:uC6\u0004HCBAd\u0003\u0017\fi\r\u0006\u0003\u0002>\u0006%\u0007bBA\t%\u0001\u000f\u00111\u0003\u0005\b\u0003C\u0011\u0002\u0019AA\u0012\u0011\u001d\tyE\u0005a\u0001\u0003#\n\u0001d\u001d8baNDw\u000e\u001e$pe6\u000b\u0007pU3rk\u0016t7-\u001a(s)\u0019\t\u0019.a6\u0002ZR!\u0011QXAk\u0011\u001d\t\tb\u0005a\u0002\u0003'Aq!!\t\u0014\u0001\u0004\t\u0019\u0003C\u0004\u0002<M\u0001\r!!\u0010\u0002OMt\u0017\r]:i_R4uN]'bqN+\u0017/^3oG\u0016t%/\u00118e\u001b\u0006DH+[7fgR\fW\u000e\u001d\u000b\t\u0003?\f\u0019/!:\u0002hR!\u0011QXAq\u0011\u001d\t\t\u0002\u0006a\u0002\u0003'Aq!!\t\u0015\u0001\u0004\t\u0019\u0003C\u0004\u0002<Q\u0001\r!!\u0010\t\u000f\u0005=C\u00031\u0001\u0002R\u00051A-\u001a7fi\u0016$R\u0001_Aw\u0003_Dq!!\t\u0016\u0001\u0004\t\u0019\u0003C\u0004\u0002rV\u0001\r!!\u0010\u0002\u0015M,\u0017/^3oG\u0016t%/\u0001\u0003tCZ,GCBA|\u0003w\fy\u0010F\u0002y\u0003sDq!!\u0005\u0017\u0001\b\t\u0019\u0002C\u0004\u0002~Z\u0001\r!!\u001f\u0002!Mt\u0017\r]:i_RlU\r^1eCR\f\u0007BB\u000f\u0017\u0001\u0004\t\u0019)A\u0006rk\u0016\u0014\u0018\u0010R3mKR,Gc\u0001=\u0003\u0006!9!qA\fA\u0002\t%\u0011\u0001D9vKJL(+Z9vKN$\b\u0003BAX\u0005\u0017IAA!\u0004\u00022\na\u0011+^3ssJ+\u0017/^3ti\u00069A-[:q_N,GCAA\u0001\u0001")
public final class V1LegacySnapshotDaoImpl
implements SnapshotDao {
    private final SnapshotPluginContext pluginContext;
    private final Option<AmazonDynamoDBAsync> asyncClient;
    private final Option<AmazonDynamoDB> syncClient;
    private final StreamReadClient streamReadClient;
    private final StreamWriteClient streamWriteClient;
    private final ByteArraySnapshotSerializer serializer;

    private StreamReadClient streamReadClient() {
        return this.streamReadClient;
    }

    private StreamWriteClient streamWriteClient() {
        return this.streamWriteClient;
    }

    private ByteArraySnapshotSerializer serializer() {
        return this.serializer;
    }

    public Source<BoxedUnit, NotUsed> deleteAllSnapshots(PersistenceId persistenceId, ExecutionContext ec) {
        QueryRequest queryRequest = new QueryRequest().withTableName(this.pluginContext.pluginConfig().tableName()).withKeyConditionExpression("#pid = :pid and #snr between :min and :max").withExpressionAttributeNames((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().sequenceNrColumnName())}))).asJava()).withExpressionAttributeValues((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), (Object)new AttributeValue().withS(persistenceId.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), (Object)new AttributeValue().withN(Integer.toString(0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), (Object)new AttributeValue().withN(Long.toString(Long.MAX_VALUE)))}))).asJava()).withConsistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginContext.pluginConfig().consistentRead()));
        return this.queryDelete(queryRequest);
    }

    public Source<BoxedUnit, NotUsed> deleteUpToMaxSequenceNr(PersistenceId persistenceId, SequenceNumber maxSequenceNr, ExecutionContext ec) {
        QueryRequest queryRequest = new QueryRequest().withTableName(this.pluginContext.pluginConfig().tableName()).withKeyConditionExpression("#pid = :pid and #snr between :min and :max").withExpressionAttributeNames((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().sequenceNrColumnName())}))).asJava()).withExpressionAttributeValues((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), (Object)new AttributeValue().withS(persistenceId.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), (Object)new AttributeValue().withN(Integer.toString(0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), (Object)new AttributeValue().withN(maxSequenceNr.asString()))}))).asJava()).withConsistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginContext.pluginConfig().consistentRead()));
        return this.queryDelete(queryRequest);
    }

    public Source<BoxedUnit, NotUsed> deleteUpToMaxTimestamp(PersistenceId persistenceId, long maxTimestamp, ExecutionContext ec) {
        QueryRequest queryRequest = new QueryRequest().withTableName(this.pluginContext.pluginConfig().tableName()).withKeyConditionExpression("#pid = :pid and #snr between :min and :max").withFilterExpression("#created <= :maxTimestamp").withExpressionAttributeNames((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().sequenceNrColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#created"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().createdColumnName())}))).asJava()).withExpressionAttributeValues((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), (Object)new AttributeValue().withS(persistenceId.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), (Object)new AttributeValue().withN(Integer.toString(0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), (Object)new AttributeValue().withN(Long.toString(Long.MAX_VALUE))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":maxTimestamp"), (Object)new AttributeValue().withN(Long.toString(maxTimestamp)))}))).asJava()).withConsistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginContext.pluginConfig().consistentRead()));
        return this.queryDelete(queryRequest);
    }

    public Source<BoxedUnit, NotUsed> deleteUpToMaxSequenceNrAndMaxTimestamp(PersistenceId persistenceId, SequenceNumber maxSequenceNr, long maxTimestamp, ExecutionContext ec) {
        QueryRequest queryRequest = new QueryRequest().withTableName(this.pluginContext.pluginConfig().tableName()).withKeyConditionExpression("#pid = :pid and #snr between :min and :max").withFilterExpression("#created <= :maxTimestamp").withExpressionAttributeNames((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().sequenceNrColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#created"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().createdColumnName())}))).asJava()).withExpressionAttributeValues((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), (Object)new AttributeValue().withS(persistenceId.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), (Object)new AttributeValue().withN(Integer.toString(0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), (Object)new AttributeValue().withN(maxSequenceNr.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":maxTimestamp"), (Object)new AttributeValue().withN(Long.toString(maxTimestamp)))}))).asJava()).withConsistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginContext.pluginConfig().consistentRead()));
        return this.queryDelete(queryRequest);
    }

    private Future<Option<Tuple2<SnapshotMetadata, Object>>> deserialize(Option<scala.collection.immutable.Map<String, AttributeValue>> rowOpt, ExecutionContext ec) {
        Option<scala.collection.immutable.Map<String, AttributeValue>> option = rowOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            scala.collection.immutable.Map row = (scala.collection.immutable.Map)some.value();
            PersistenceId x$12 = PersistenceId$.MODULE$.apply(((AttributeValue)row.apply((Object)this.pluginContext.pluginConfig().columnsDefConfig().persistenceIdColumnName())).getS());
            SequenceNumber x$2 = new SequenceNumber(new StringOps(Predef$.MODULE$.augmentString(((AttributeValue)row.apply((Object)this.pluginContext.pluginConfig().columnsDefConfig().sequenceNrColumnName())).getN())).toLong());
            byte[] x$3 = ((AttributeValue)row.apply((Object)this.pluginContext.pluginConfig().columnsDefConfig().snapshotColumnName())).getB().array();
            long x$4 = new StringOps(Predef$.MODULE$.augmentString(((AttributeValue)row.apply((Object)this.pluginContext.pluginConfig().columnsDefConfig().createdColumnName())).getN())).toLong();
            return this.serializer().deserialize(new SnapshotRow(x$12, x$2, x$4, x$3), ec).map((Function1 & Serializable & scala.Serializable)x$1 -> new Some(x$1), ec);
        }
        if (None$.MODULE$.equals(option)) {
            return Future$.MODULE$.successful((Object)None$.MODULE$);
        }
        throw new MatchError(option);
    }

    public Source<Option<Tuple2<SnapshotMetadata, Object>>, NotUsed> latestSnapshot(PersistenceId persistenceId, ExecutionContext ec) {
        QueryRequest queryRequest = new QueryRequest().withTableName(this.pluginContext.pluginConfig().tableName()).withKeyConditionExpression("#pid = :pid and #snr between :min and :max").withExpressionAttributeNames((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().sequenceNrColumnName())}))).asJava()).withExpressionAttributeValues((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), (Object)new AttributeValue().withS(persistenceId.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), (Object)new AttributeValue().withN(Integer.toString(0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), (Object)new AttributeValue().withN(Long.toString(Long.MAX_VALUE)))}))).asJava()).withScanIndexForward(Predef$.MODULE$.boolean2Boolean(false)).withLimit(Predef$.MODULE$.int2Integer(1)).withConsistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginContext.pluginConfig().consistentRead()));
        return (Source)Source$.MODULE$.single((Object)queryRequest).via((Graph)this.streamReadClient().queryFlow()).flatMapConcat((Function1 & Serializable & scala.Serializable)response -> {
            if (response.getSdkHttpMetadata().getHttpStatusCode() == 200) {
                return Source$.MODULE$.single((Object)((TraversableLike)((TraversableLike)Option$.MODULE$.apply((Object)response.getItems()).map((Function1 & Serializable & scala.Serializable)x$2 -> (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(x$2).asScala()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$3 -> ((TraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter(x$3).asScala()).toMap(Predef$.MODULE$.$conforms()), scala.collection.Seq$.MODULE$.canBuildFrom())).headOption());
            }
            int statusCode = response.getSdkHttpMetadata().getHttpStatusCode();
            return Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).toString()));
        }).mapAsync(1, (Function1 & Serializable & scala.Serializable)rowOpt -> this.deserialize((Option<scala.collection.immutable.Map<String, AttributeValue>>)rowOpt, ec));
    }

    public Source<Option<Tuple2<SnapshotMetadata, Object>>, NotUsed> snapshotForMaxTimestamp(PersistenceId persistenceId, long maxTimestamp, ExecutionContext ec) {
        QueryRequest queryRequest = new QueryRequest().withTableName(this.pluginContext.pluginConfig().tableName()).withKeyConditionExpression("#pid = :pid and #snr between :min and :max").withFilterExpression("#created <= :maxTimestamp").withExpressionAttributeNames((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().sequenceNrColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#created"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().createdColumnName())}))).asJava()).withExpressionAttributeValues((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), (Object)new AttributeValue().withS(persistenceId.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), (Object)new AttributeValue().withN(Integer.toString(0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), (Object)new AttributeValue().withN(Long.toString(Long.MAX_VALUE))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":maxTimestamp"), (Object)new AttributeValue().withN(Long.toString(maxTimestamp)))}))).asJava()).withScanIndexForward(Predef$.MODULE$.boolean2Boolean(false)).withConsistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginContext.pluginConfig().consistentRead()));
        return (Source)Source$.MODULE$.single((Object)queryRequest).via((Graph)this.streamReadClient().queryFlow()).flatMapConcat((Function1 & Serializable & scala.Serializable)response -> {
            if (response.getSdkHttpMetadata().getHttpStatusCode() == 200) {
                return Source$.MODULE$.single((Object)((TraversableLike)((TraversableLike)Option$.MODULE$.apply((Object)response.getItems()).map((Function1 & Serializable & scala.Serializable)x$4 -> (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(x$4).asScala()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$5 -> ((TraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter(x$5).asScala()).toMap(Predef$.MODULE$.$conforms()), scala.collection.Seq$.MODULE$.canBuildFrom())).headOption());
            }
            int statusCode = response.getSdkHttpMetadata().getHttpStatusCode();
            return Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).toString()));
        }).mapAsync(1, (Function1 & Serializable & scala.Serializable)rowOpt -> this.deserialize((Option<scala.collection.immutable.Map<String, AttributeValue>>)rowOpt, ec));
    }

    public Source<Option<Tuple2<SnapshotMetadata, Object>>, NotUsed> snapshotForMaxSequenceNr(PersistenceId persistenceId, SequenceNumber maxSequenceNr, ExecutionContext ec) {
        QueryRequest queryRequest = new QueryRequest().withTableName(this.pluginContext.pluginConfig().tableName()).withKeyConditionExpression("#pid = :pid and #snr between :min and :max").withExpressionAttributeNames((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().sequenceNrColumnName())}))).asJava()).withExpressionAttributeValues((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), (Object)new AttributeValue().withS(persistenceId.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), (Object)new AttributeValue().withN(Integer.toString(0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), (Object)new AttributeValue().withN(maxSequenceNr.asString()))}))).asJava()).withScanIndexForward(Predef$.MODULE$.boolean2Boolean(false)).withConsistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginContext.pluginConfig().consistentRead()));
        return (Source)Source$.MODULE$.single((Object)queryRequest).via((Graph)this.streamReadClient().queryFlow()).flatMapConcat((Function1 & Serializable & scala.Serializable)response -> {
            if (response.getSdkHttpMetadata().getHttpStatusCode() == 200) {
                return Source$.MODULE$.single((Object)((TraversableLike)((TraversableLike)Option$.MODULE$.apply((Object)response.getItems()).map((Function1 & Serializable & scala.Serializable)x$6 -> (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(x$6).asScala()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$7 -> ((TraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter(x$7).asScala()).toMap(Predef$.MODULE$.$conforms()), scala.collection.Seq$.MODULE$.canBuildFrom())).headOption());
            }
            int statusCode = response.getSdkHttpMetadata().getHttpStatusCode();
            return Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).toString()));
        }).mapAsync(1, (Function1 & Serializable & scala.Serializable)rowOpt -> this.deserialize((Option<scala.collection.immutable.Map<String, AttributeValue>>)rowOpt, ec));
    }

    public Source<Option<Tuple2<SnapshotMetadata, Object>>, NotUsed> snapshotForMaxSequenceNrAndMaxTimestamp(PersistenceId persistenceId, SequenceNumber maxSequenceNr, long maxTimestamp, ExecutionContext ec) {
        QueryRequest queryRequest = new QueryRequest().withTableName(this.pluginContext.pluginConfig().tableName()).withKeyConditionExpression("#pid = :pid and #snr between :min and :max").withFilterExpression("#created <= :maxTimestamp").withExpressionAttributeNames((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#pid"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().persistenceIdColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#snr"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().sequenceNrColumnName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#created"), (Object)this.pluginContext.pluginConfig().columnsDefConfig().createdColumnName())}))).asJava()).withExpressionAttributeValues((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":pid"), (Object)new AttributeValue().withS(persistenceId.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":min"), (Object)new AttributeValue().withN(Integer.toString(0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":max"), (Object)new AttributeValue().withN(maxSequenceNr.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":maxTimestamp"), (Object)new AttributeValue().withN(Long.toString(maxTimestamp)))}))).asJava()).withScanIndexForward(Predef$.MODULE$.boolean2Boolean(false)).withConsistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginContext.pluginConfig().consistentRead()));
        return (Source)Source$.MODULE$.single((Object)queryRequest).via((Graph)this.streamReadClient().queryFlow()).flatMapConcat((Function1 & Serializable & scala.Serializable)response -> {
            if (response.getSdkHttpMetadata().getHttpStatusCode() == 200) {
                return Source$.MODULE$.single((Object)((TraversableLike)((TraversableLike)Option$.MODULE$.apply((Object)response.getItems()).map((Function1 & Serializable & scala.Serializable)x$8 -> (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(x$8).asScala()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$9 -> ((TraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter(x$9).asScala()).toMap(Predef$.MODULE$.$conforms()), scala.collection.Seq$.MODULE$.canBuildFrom())).headOption());
            }
            int statusCode = response.getSdkHttpMetadata().getHttpStatusCode();
            return Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).toString()));
        }).mapAsync(1, (Function1 & Serializable & scala.Serializable)rowOpt -> this.deserialize((Option<scala.collection.immutable.Map<String, AttributeValue>>)rowOpt, ec));
    }

    public Source<BoxedUnit, NotUsed> delete(PersistenceId persistenceId, SequenceNumber sequenceNr) {
        DeleteItemRequest req = new DeleteItemRequest().withTableName(this.pluginContext.pluginConfig().tableName()).withKey((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext.pluginConfig().columnsDefConfig().persistenceIdColumnName()), (Object)new AttributeValue().withS(persistenceId.asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext.pluginConfig().columnsDefConfig().sequenceNrColumnName()), (Object)new AttributeValue().withN(sequenceNr.asString()))}))).asJava());
        return (Source)Source$.MODULE$.single((Object)req).via((Graph)this.streamWriteClient().deleteItemFlow()).flatMapConcat((Function1 & Serializable & scala.Serializable)response -> {
            if (response.getSdkHttpMetadata().getHttpStatusCode() == 200) {
                return Source$.MODULE$.single((Object)BoxedUnit.UNIT);
            }
            int statusCode = response.getSdkHttpMetadata().getHttpStatusCode();
            return Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).toString()));
        });
    }

    public Source<BoxedUnit, NotUsed> save(SnapshotMetadata snapshotMetadata, Object snapshot, ExecutionContext ec) {
        return (Source)Source$.MODULE$.future(this.serializer().serialize(snapshotMetadata, snapshot, ec)).flatMapConcat((Function1 & Serializable & scala.Serializable)snapshotRow -> {
            PutItemRequest req = new PutItemRequest().withTableName($this.pluginContext.pluginConfig().tableName()).withItem((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.pluginContext.pluginConfig().columnsDefConfig().persistenceIdColumnName()), (Object)new AttributeValue().withS(snapshotRow.persistenceId().asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.pluginContext.pluginConfig().columnsDefConfig().sequenceNrColumnName()), (Object)new AttributeValue().withN(snapshotRow.sequenceNumber().asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.pluginContext.pluginConfig().columnsDefConfig().snapshotColumnName()), (Object)new AttributeValue().withB(ByteBuffer.wrap(snapshotRow.snapshot()))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.pluginContext.pluginConfig().columnsDefConfig().createdColumnName()), (Object)new AttributeValue().withN(Long.toString(snapshotRow.created())))}))).asJava());
            return (Source)Source$.MODULE$.single((Object)req).via((Graph)this.streamWriteClient().putItemFlow()).flatMapConcat((Function1 & Serializable & scala.Serializable)response -> {
                if (response.getSdkHttpMetadata().getHttpStatusCode() == 200) {
                    return Source$.MODULE$.single((Object)BoxedUnit.UNIT);
                }
                int statusCode = response.getSdkHttpMetadata().getHttpStatusCode();
                return Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).toString()));
            });
        });
    }

    private Source<BoxedUnit, NotUsed> queryDelete(QueryRequest queryRequest) {
        return (Source)((Source)Source$.MODULE$.single((Object)queryRequest).via((Graph)this.streamReadClient().queryFlow()).map((Function1 & Serializable & scala.Serializable)v -> (Seq)Option$.MODULE$.apply((Object)v.getItems()).map((Function1 & Serializable & scala.Serializable)x$10 -> (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(x$10).asScala()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$)).mapConcat((Function1 & Serializable & scala.Serializable)x$11 -> x$11.toVector()).grouped(this.pluginContext.pluginConfig().clientConfig().batchWriteItemLimit()).map((Function1 & Serializable & scala.Serializable)rows -> (scala.collection.immutable.Seq)rows.map((Function1 & Serializable & scala.Serializable)row -> {
            scala.collection.mutable.Map _row = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(row).asScala();
            PersistenceId x$1 = PersistenceId$.MODULE$.apply(((AttributeValue)_row.apply((Object)$this.pluginContext.pluginConfig().columnsDefConfig().persistenceIdColumnName())).getS());
            SequenceNumber x$2 = new SequenceNumber(new StringOps(Predef$.MODULE$.augmentString(((AttributeValue)_row.apply((Object)$this.pluginContext.pluginConfig().columnsDefConfig().sequenceNrColumnName())).getN())).toLong());
            byte[] x$3 = ((AttributeValue)_row.apply((Object)$this.pluginContext.pluginConfig().columnsDefConfig().snapshotColumnName())).getB().array();
            long x$4 = new StringOps(Predef$.MODULE$.augmentString(((AttributeValue)_row.apply((Object)$this.pluginContext.pluginConfig().columnsDefConfig().createdColumnName())).getN())).toLong();
            return new SnapshotRow(x$1, x$2, x$4, x$3);
        }, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)rows -> new BatchWriteItemRequest().withRequestItems((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.pluginContext.pluginConfig().tableName()), CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)rows.map((Function1 & Serializable & scala.Serializable)row -> new WriteRequest().withDeleteRequest(new DeleteRequest().withKey((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.pluginContext.pluginConfig().columnsDefConfig().persistenceIdColumnName()), (Object)new AttributeValue().withS(row.persistenceId().asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.pluginContext.pluginConfig().columnsDefConfig().sequenceNrColumnName()), (Object)new AttributeValue().withN(row.sequenceNumber().asString()))}))).asJava())), Seq$.MODULE$.canBuildFrom())).asJava())}))).asJava()))).via((Graph)this.streamWriteClient().batchWriteItemFlow()).flatMapConcat((Function1 & Serializable & scala.Serializable)response -> {
            if (response.getSdkHttpMetadata().getHttpStatusCode() == 200) {
                return Source$.MODULE$.single((Object)BoxedUnit.UNIT);
            }
            int statusCode = response.getSdkHttpMetadata().getHttpStatusCode();
            return Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).toString()));
        });
    }

    public void dispose() {
        Option option;
        Option option2;
        Tuple2 tuple2 = new Tuple2(this.asyncClient, this.syncClient);
        if (tuple2 != null && (option2 = (Option)tuple2._1()) instanceof Some) {
            Some some = (Some)option2;
            AmazonDynamoDBAsync a = (AmazonDynamoDBAsync)some.value();
            a.shutdown();
            return;
        }
        if (tuple2 != null && (option = (Option)tuple2._2()) instanceof Some) {
            Some some = (Some)option;
            AmazonDynamoDB s = (AmazonDynamoDB)some.value();
            s.shutdown();
            return;
        }
    }

    public V1LegacySnapshotDaoImpl(SnapshotPluginContext pluginContext, Option<AmazonDynamoDBAsync> asyncClient, Option<AmazonDynamoDB> syncClient, Serialization serialization) {
        this.pluginContext = pluginContext;
        this.asyncClient = asyncClient;
        this.syncClient = syncClient;
        Tuple2 tuple2 = new Tuple2(asyncClient, syncClient);
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (None$.MODULE$.equals(option) && None$.MODULE$.equals(option2)) {
                throw new IllegalArgumentException("aws clients is both None");
            }
        }
        this.streamReadClient = new StreamReadClient((PluginContext)pluginContext, asyncClient, syncClient, pluginContext.pluginConfig().readBackoffConfig());
        this.streamWriteClient = new StreamWriteClient((PluginContext)pluginContext, asyncClient, syncClient, pluginContext.pluginConfig().writeBackoffConfig());
        this.serializer = new ByteArraySnapshotSerializer(serialization, pluginContext.metricsReporter(), pluginContext.traceReporter());
    }
}

