/*
 * Decompiled with CFR 0.152.
 */
package com.github.j5ik2o.akka.persistence.dynamodb.snapshot;

import com.github.j5ik2o.akka.persistence.dynamodb.model.PersistenceId;
import com.github.j5ik2o.akka.persistence.dynamodb.model.PersistenceId$;
import com.github.j5ik2o.akka.persistence.dynamodb.model.SequenceNumber;
import com.github.j5ik2o.akka.persistence.dynamodb.snapshot.PartitionKey;
import com.github.j5ik2o.akka.persistence.dynamodb.snapshot.PersistenceIdOps;
import com.github.j5ik2o.akka.persistence.dynamodb.snapshot.SnapshotPluginContext;
import com.github.j5ik2o.akka.persistence.dynamodb.snapshot.ToPersistenceIdOps;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.text.DecimalFormat;
import net.ceedubs.ficus.Ficus$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\r4qAD\b\u0011\u0002G\u0005a\u0004C\u0003&\u0001\u0019\u0005aeB\u00039\u001f!\u0005\u0011HB\u0003\u000f\u001f!\u0005!\bC\u0003<\u0007\u0011\u0005AH\u0002\u0003>\u0007\tq\u0004\u0002\u0003!\u0006\u0005\u0003\u0005\u000b\u0011B!\t\u000bm*A\u0011\u0001#\t\u000b\u0015*A\u0011\t%\u0007\t-\u001b!\u0001\u0014\u0005\t\u0001&\u0011\t\u0011)A\u0005\u0003\")1(\u0003C\u0001!\")1+\u0003C!)\")Q%\u0003C!A\n!\u0002+\u0019:uSRLwN\\&fsJ+7o\u001c7wKJT!\u0001E\t\u0002\u0011Mt\u0017\r]:i_RT!AE\n\u0002\u0011\u0011Lh.Y7pI\nT!\u0001F\u000b\u0002\u0017A,'o]5ti\u0016t7-\u001a\u0006\u0003-]\tA!Y6lC*\u0011\u0001$G\u0001\u0007UVJ7NM8\u000b\u0005iY\u0012AB4ji\",(MC\u0001\u001d\u0003\r\u0019w.\\\u0002\u0001'\t\u0001q\u0004\u0005\u0002!G5\t\u0011EC\u0001#\u0003\u0015\u00198-\u00197b\u0013\t!\u0013E\u0001\u0004B]f\u0014VMZ\u0001\be\u0016\u001cx\u000e\u001c<f)\r93f\r\t\u0003Q%j\u0011aD\u0005\u0003U=\u0011A\u0002U1si&$\u0018n\u001c8LKfDQ\u0001L\u0001A\u00025\nQ\u0002]3sg&\u001cH/\u001a8dK&#\u0007C\u0001\u00182\u001b\u0005y#B\u0001\u0019\u0012\u0003\u0015iw\u000eZ3m\u0013\t\u0011tFA\u0007QKJ\u001c\u0018n\u001d;f]\u000e,\u0017\n\u001a\u0005\u0006i\u0005\u0001\r!N\u0001\u000fg\u0016\fX/\u001a8dK:+XNY3s!\tqc'\u0003\u00028_\tq1+Z9vK:\u001cWMT;nE\u0016\u0014\u0018\u0001\u0006)beRLG/[8o\u0017\u0016L(+Z:pYZ,'\u000f\u0005\u0002)\u0007M\u00111aH\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003e\u00121cU3rk\u0016t7-\u001a(v[\n,'OQ1tK\u0012\u001c2!B\u0010@!\tA\u0003!A\u0007qYV<\u0017N\\\"p]R,\u0007\u0010\u001e\t\u0003Q\tK!aQ\b\u0003+Ms\u0017\r]:i_R\u0004F.^4j]\u000e{g\u000e^3yiR\u0011Qi\u0012\t\u0003\r\u0016i\u0011a\u0001\u0005\u0006\u0001\u001e\u0001\r!\u0011\u000b\u0004O%S\u0005\"\u0002\u0017\t\u0001\u0004i\u0003\"\u0002\u001b\t\u0001\u0004)$A\u0005)feNL7\u000f^3oG\u0016LEMQ1tK\u0012\u001cB!C\u0010@\u001bB\u0011\u0001FT\u0005\u0003\u001f>\u0011!\u0003V8QKJ\u001c\u0018n\u001d;f]\u000e,\u0017\nZ(qgR\u0011\u0011K\u0015\t\u0003\r&AQ\u0001Q\u0006A\u0002\u0005\u000b\u0011b]3qCJ\fGo\u001c:\u0016\u0003U\u0003\"AV/\u000f\u0005][\u0006C\u0001-\"\u001b\u0005I&B\u0001.\u001e\u0003\u0019a$o\\8u}%\u0011A,I\u0001\u0007!J,G-\u001a4\n\u0005y{&AB*ue&twM\u0003\u0002]CQ\u0019q%\u00192\t\u000b1j\u0001\u0019A\u0017\t\u000bQj\u0001\u0019A\u001b")
public interface PartitionKeyResolver {
    public PartitionKey resolve(PersistenceId var1, SequenceNumber var2);

    public static final class PersistenceIdBased
    implements PartitionKeyResolver,
    ToPersistenceIdOps {
        private final SnapshotPluginContext pluginContext;

        @Override
        public PersistenceIdOps ToPersistenceIdOps(PersistenceId self) {
            return ToPersistenceIdOps.ToPersistenceIdOps$(this, self);
        }

        @Override
        public String separator() {
            return (String)Ficus$.MODULE$.toFicusConfig(this.pluginContext.pluginConfig().sourceConfig()).getAs("persistence-id-separator", Ficus$.MODULE$.optionValueReader(Ficus$.MODULE$.stringValueReader())).getOrElse((Function0 & Serializable)() -> PersistenceId$.MODULE$.Separator());
        }

        @Override
        public PartitionKey resolve(PersistenceId persistenceId, SequenceNumber sequenceNumber) {
            String string;
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            DecimalFormat df = new DecimalFormat("0000000000000000000000000000000000000000");
            byte[] bytes = StringOps$.MODULE$.reverse$extension(Predef$.MODULE$.augmentString(persistenceId.asString())).getBytes(StandardCharsets.UTF_8);
            BigInt hash = package$.MODULE$.BigInt().apply(md5.digest(bytes));
            BigInt mod = hash.abs().$percent(BigInt$.MODULE$.int2bigInt(this.pluginContext.pluginConfig().shardCount())).$plus(BigInt$.MODULE$.int2bigInt(1));
            Option<String> modelNameOpt = this.ToPersistenceIdOps(persistenceId).prefix();
            Option<String> option = modelNameOpt;
            if (option instanceof Some) {
                Some some = (Some)option;
                String modelName = (String)some.value();
                string = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s-%s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{modelName, df.format(mod)}));
            } else if (None$.MODULE$.equals(option)) {
                string = df.format(mod);
            } else {
                throw new MatchError(option);
            }
            String pkey = string;
            return new PartitionKey(pkey);
        }

        public PersistenceIdBased(SnapshotPluginContext pluginContext) {
            this.pluginContext = pluginContext;
            ToPersistenceIdOps.$init$(this);
        }
    }

    public static final class SequenceNumberBased
    implements PartitionKeyResolver {
        private final SnapshotPluginContext pluginContext;

        @Override
        public PartitionKey resolve(PersistenceId persistenceId, SequenceNumber sequenceNumber) {
            String pkey = new StringBuilder(1).append(persistenceId.asString()).append("-").append(sequenceNumber.value() % (long)this.pluginContext.pluginConfig().shardCount()).toString();
            return new PartitionKey(pkey);
        }

        public SequenceNumberBased(SnapshotPluginContext pluginContext) {
            this.pluginContext = pluginContext;
        }
    }
}

