/*
 * Decompiled with CFR 0.152.
 */
package com.github.j5ik2o.akka.persistence.dynamodb.query.scaladsl;

import akka.NotUsed;
import akka.actor.ActorRef;
import akka.actor.ActorRefFactory;
import akka.actor.ActorSystem;
import akka.actor.Cancellable;
import akka.actor.DynamicAccess;
import akka.actor.ExtendedActorSystem;
import akka.actor.Scheduler;
import akka.event.LoggingAdapter;
import akka.pattern.AskableActorRef$;
import akka.persistence.Persistence;
import akka.persistence.Persistence$;
import akka.persistence.PersistentRepr;
import akka.persistence.journal.EventAdapter;
import akka.persistence.journal.EventAdapters;
import akka.persistence.query.EventEnvelope;
import akka.persistence.query.EventEnvelope$;
import akka.persistence.query.Offset;
import akka.persistence.query.Sequence;
import akka.persistence.query.scaladsl.CurrentEventsByPersistenceIdQuery;
import akka.persistence.query.scaladsl.CurrentEventsByTagQuery;
import akka.persistence.query.scaladsl.CurrentPersistenceIdsQuery;
import akka.persistence.query.scaladsl.EventsByPersistenceIdQuery;
import akka.persistence.query.scaladsl.EventsByTagQuery;
import akka.persistence.query.scaladsl.PersistenceIdsQuery;
import akka.serialization.Serialization;
import akka.serialization.SerializationExtension$;
import akka.stream.ActorMaterializer;
import akka.stream.ActorMaterializer$;
import akka.stream.Graph;
import akka.stream.Materializer;
import akka.stream.scaladsl.Sink$;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import akka.util.Timeout;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBAsync;
import com.github.j5ik2o.akka.persistence.dynamodb.config.JournalPluginBaseConfig;
import com.github.j5ik2o.akka.persistence.dynamodb.config.PluginConfig;
import com.github.j5ik2o.akka.persistence.dynamodb.config.QueryPluginConfig;
import com.github.j5ik2o.akka.persistence.dynamodb.config.QueryPluginConfig$;
import com.github.j5ik2o.akka.persistence.dynamodb.config.client.ClientType$;
import com.github.j5ik2o.akka.persistence.dynamodb.config.client.ClientVersion$;
import com.github.j5ik2o.akka.persistence.dynamodb.journal.JournalRow;
import com.github.j5ik2o.akka.persistence.dynamodb.journal.dao.JournalRowReadDriver;
import com.github.j5ik2o.akka.persistence.dynamodb.journal.dao.v1.V1JournalRowReadDriver;
import com.github.j5ik2o.akka.persistence.dynamodb.journal.dao.v2.V2JournalRowReadDriver;
import com.github.j5ik2o.akka.persistence.dynamodb.metrics.MetricsReporter;
import com.github.j5ik2o.akka.persistence.dynamodb.metrics.MetricsReporterProvider;
import com.github.j5ik2o.akka.persistence.dynamodb.metrics.MetricsReporterProvider$;
import com.github.j5ik2o.akka.persistence.dynamodb.query.JournalSequenceActor;
import com.github.j5ik2o.akka.persistence.dynamodb.query.JournalSequenceActor$;
import com.github.j5ik2o.akka.persistence.dynamodb.query.JournalSequenceActor$GetMaxOrderingId$;
import com.github.j5ik2o.akka.persistence.dynamodb.query.dao.QueryProcessor;
import com.github.j5ik2o.akka.persistence.dynamodb.query.dao.ReadJournalDaoImpl;
import com.github.j5ik2o.akka.persistence.dynamodb.query.dao.V1QueryProcessor;
import com.github.j5ik2o.akka.persistence.dynamodb.query.dao.V2QueryProcessor;
import com.github.j5ik2o.akka.persistence.dynamodb.query.scaladsl.DynamoDBReadJournal$;
import com.github.j5ik2o.akka.persistence.dynamodb.query.scaladsl.DynamoDBReadJournal$Continue$;
import com.github.j5ik2o.akka.persistence.dynamodb.query.scaladsl.DynamoDBReadJournal$ContinueDelayed$;
import com.github.j5ik2o.akka.persistence.dynamodb.query.scaladsl.DynamoDBReadJournal$OffsetOps$;
import com.github.j5ik2o.akka.persistence.dynamodb.query.scaladsl.DynamoDBReadJournal$Stop$;
import com.github.j5ik2o.akka.persistence.dynamodb.serialization.ByteArrayJournalSerializer;
import com.github.j5ik2o.akka.persistence.dynamodb.serialization.FlowPersistentReprSerializer;
import com.github.j5ik2o.akka.persistence.dynamodb.utils.ClientUtils$;
import com.typesafe.config.Config;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import org.slf4j.LoggerFactory;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnceOps;
import scala.collection.Set;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set$;
import scala.collection.immutable.SetOps;
import scala.collection.immutable.Vector;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;

@ScalaSignature(bytes="\u0006\u0005\u0011Uv!B7o\u0011\u0003yhaBA\u0002]\"\u0005\u0011Q\u0001\u0005\b\u0003'\tA\u0011AA\u000b\u0011%\t9\"\u0001b\u0001\n\u000b\tI\u0002\u0003\u0005\u0002\"\u0005\u0001\u000bQBA\u000e\r%\t\u0019#\u0001I\u0001$S\t)cB\u0004\u0002N\u0006AI)!\u0015\u0007\u000f\u0005%\u0012\u0001##\u0002,!9\u00111C\u0004\u0005\u0002\u0005=\u0003\"CA*\u000f\u0005\u0005I\u0011IA+\u0011%\t9gBA\u0001\n\u0003\tI\u0007C\u0005\u0002r\u001d\t\t\u0011\"\u0001\u0002t!I\u0011qP\u0004\u0002\u0002\u0013\u0005\u0013\u0011\u0011\u0005\n\u0003\u001f;\u0011\u0011!C\u0001\u0003#C\u0011\"a'\b\u0003\u0003%\t%!(\t\u0013\u0005}u!!A\u0005B\u0005\u0005\u0006\"CAR\u000f\u0005\u0005I\u0011BAS\u000f\u001d\ty-\u0001EE\u0003g3q!!,\u0002\u0011\u0013\u000by\u000bC\u0004\u0002\u0014I!\t!!-\t\u0013\u0005M##!A\u0005B\u0005U\u0003\"CA4%\u0005\u0005I\u0011AA5\u0011%\t\tHEA\u0001\n\u0003\t)\fC\u0005\u0002\u0000I\t\t\u0011\"\u0011\u0002\u0002\"I\u0011q\u0012\n\u0002\u0002\u0013\u0005\u0011\u0011\u0018\u0005\n\u00037\u0013\u0012\u0011!C!\u0003;C\u0011\"a(\u0013\u0003\u0003%\t%!)\t\u0013\u0005\r&#!A\u0005\n\u0005\u0015vaBAi\u0003!%\u00151\u0019\u0004\b\u0003{\u000b\u0001\u0012RA`\u0011\u001d\t\u0019\"\bC\u0001\u0003\u0003D\u0011\"a\u0015\u001e\u0003\u0003%\t%!\u0016\t\u0013\u0005\u001dT$!A\u0005\u0002\u0005%\u0004\"CA9;\u0005\u0005I\u0011AAc\u0011%\ty(HA\u0001\n\u0003\n\t\tC\u0005\u0002\u0010v\t\t\u0011\"\u0001\u0002J\"I\u00111T\u000f\u0002\u0002\u0013\u0005\u0013Q\u0014\u0005\n\u0003?k\u0012\u0011!C!\u0003CC\u0011\"a)\u001e\u0003\u0003%I!!*\u0007\r\u0005M\u0017aAAk\u00119\tin\nC\u0001\u0002\u000b\u0015)\u0019!C\u0005\u0003?D1\"a<(\u0005\u000b\u0005\t\u0015!\u0003\u0002b\"9\u00111C\u0014\u0005\u0002\u0005E\bbBA}O\u0011\u0005\u00111 \u0005\n\u00037;\u0013\u0011!C!\u0003;C\u0011Ba\u0001(\u0003\u0003%\tE!\u0002\b\u0013\t%\u0011!!A\t\u0002\t-a!CAj\u0003\u0005\u0005\t\u0012\u0001B\u0007\u0011\u001d\t\u0019b\fC\u0001\u0005\u001fAqA!\u00050\t\u000b\u0011\u0019\u0002C\u0005\u0003\u001a=\n\t\u0011\"\u0002\u0003\u001c!I!qD\u0018\u0002\u0002\u0013\u0015!\u0011\u0005\u0005\n\u0005\u0013\t\u0011\u0011!C\u0002\u0005S1a!a\u0001o\u0001\t5\u0002B\u0003B/k\t\u0005\t\u0015!\u0003\u0003`!Q!QN\u001b\u0003\u0002\u0003\u0006IAa\u001c\t\u0015\tuTG!A!\u0002\u0017\u0011y\bC\u0004\u0002\u0014U\"\tAa#\t\u0013\t]UG1A\u0005\f\te\u0005\u0002\u0003BTk\u0001\u0006IAa'\t\u0013\t%VG1A\u0005\n\t-\u0006\u0002\u0003BZk\u0001\u0006IA!,\t\u0013\tUVG1A\u0005\f\t]\u0006\u0002\u0003Bck\u0001\u0006IA!/\t\u0013\t\u001dWG1A\u0005\f\t%\u0007\u0002\u0003Blk\u0001\u0006IAa3\t\u0013\teWG1A\u0005\n\tm\u0007\u0002\u0003Btk\u0001\u0006IA!8\t\u0013\t%XG1A\u0005\n\t-\b\u0002\u0003B\u0000k\u0001\u0006IA!<\t\u0013\r\u0005QG1A\u0005\n\r\r\u0001\u0002CB\bk\u0001\u0006Ia!\u0002\t\u0013\rEQG1A\u0005\n\rM\u0001\u0002CB\u0016k\u0001\u0006Ia!\u0006\t\u0017\r5R\u00071AA\u0002\u0013%1q\u0006\u0005\f\u0007\u0017*\u0004\u0019!a\u0001\n\u0013\u0019i\u0005C\u0006\u0004XU\u0002\r\u0011!Q!\n\rE\u0002bCB-k\u0001\u0007\t\u0019!C\u0005\u00077B1ba\u00196\u0001\u0004\u0005\r\u0011\"\u0003\u0004f!Y1\u0011N\u001bA\u0002\u0003\u0005\u000b\u0015BB/\u0011\u001d\u0019Y'\u000eC\u0005\u0007[BAba\u001c6!\u0003\u0005\u0019\u0011)A\u0005\u0007cB\u0011b!$6\u0005\u0004%Iaa$\t\u0011\rEU\u0007)A\u0005\u0007oB\u0011ba%6\u0005\u0004%Ia!&\t\u0011\r]U\u0007)A\u0005\u0007\u0007C\u0011b!'6\u0005\u0004%Iaa'\t\u0011\r\rV\u0007)A\u0005\u0007;C\u0011b!*6\u0005\u0004%I!!\u0016\t\u0011\r\u001dV\u0007)A\u0005\u0003/B\u0011b!+6\u0005\u0004%Iaa+\t\u0011\r]V\u0007)A\u0005\u0007[C\u0011b!/6\u0005\u0004%Iaa/\t\u0011\r%W\u0007)A\u0005\u0007{C!ba36\u0011\u000b\u0007I\u0011BBg\u0011%\u0019).\u000eb\u0001\n\u0013\u00199\u000e\u0003\u0005\u0004jV\u0002\u000b\u0011BBm\u0011\u001d\u0019Y/\u000eC!\u0007[Dqa!?6\t\u0003\u001ai\u000fC\u0004\u0004|V\"Ia!@\t\u000f\u0011]Q\u0007\"\u0011\u0005\u001a!9AqF\u001b\u0005B\u0011E\u0002b\u0002C\u001dk\u0011%A1\b\u0005\b\t\u001f*D\u0011\tC)\u0011\u001d!Y&\u000eC\u0005\t;Bq\u0001\"&6\t\u0013!9\nC\u0004\u0005PU\"\t\u0001b)\t\u000f\u0011UU\u0007\"\u0011\u0005*\"9AQS\u001b\u0005\u0002\u0011=\u0016a\u0005#z]\u0006lw\u000e\u0012\"SK\u0006$'j\\;s]\u0006d'BA8q\u0003!\u00198-\u00197bINd'BA9s\u0003\u0015\tX/\u001a:z\u0015\t\u0019H/\u0001\u0005es:\fWn\u001c3c\u0015\t)h/A\u0006qKJ\u001c\u0018n\u001d;f]\u000e,'BA<y\u0003\u0011\t7n[1\u000b\u0005eT\u0018A\u000266S.\u0014tN\u0003\u0002|y\u00061q-\u001b;ik\nT\u0011!`\u0001\u0004G>l7\u0001\u0001\t\u0004\u0003\u0003\tQ\"\u00018\u0003'\u0011Kh.Y7p\t\n\u0013V-\u00193K_V\u0014h.\u00197\u0014\u0007\u0005\t9\u0001\u0005\u0003\u0002\n\u0005=QBAA\u0006\u0015\t\ti!A\u0003tG\u0006d\u0017-\u0003\u0003\u0002\u0012\u0005-!AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002\u007f\u0006Q\u0011\nZ3oi&4\u0017.\u001a:\u0016\u0005\u0005mqBAA\u000fC\t\ty\"A\u000fkk%\\'g\u001c\u0018es:\fWn\\\u0017eE6\u0012X-\u00193.U>,(O\\1m\u0003-IE-\u001a8uS\u001aLWM\u001d\u0011\u0003\u0017\u0019cwn^\"p]R\u0014x\u000e\\\n\u0004\u000b\u0005\u001d\u0011\u0006B\u0003\b%u\u0011\u0001bQ8oi&tW/Z\n\n\u000f\u0005\u001d\u0011QFA\u0019\u0003o\u00012!a\f\u0006\u001b\u0005\t\u0001\u0003BA\u0005\u0003gIA!!\u000e\u0002\f\t9\u0001K]8ek\u000e$\b\u0003BA\u001d\u0003\u0013rA!a\u000f\u0002F9!\u0011QHA\"\u001b\t\tyDC\u0002\u0002By\fa\u0001\u0010:p_Rt\u0014BAA\u0007\u0013\u0011\t9%a\u0003\u0002\u000fA\f7m[1hK&!\u00111JA'\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\u0011\t9%a\u0003\u0015\u0005\u0005E\u0003cAA\u0018\u000f\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u0016\u0011\t\u0005e\u00131M\u0007\u0003\u00037RA!!\u0018\u0002`\u0005!A.\u00198h\u0015\t\t\t'\u0001\u0003kCZ\f\u0017\u0002BA3\u00037\u0012aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLXCAA6!\u0011\tI!!\u001c\n\t\u0005=\u00141\u0002\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003k\nY\b\u0005\u0003\u0002\n\u0005]\u0014\u0002BA=\u0003\u0017\u00111!\u00118z\u0011%\tihCA\u0001\u0002\u0004\tY'A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003\u0007\u0003b!!\"\u0002\f\u0006UTBAAD\u0015\u0011\tI)a\u0003\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u000e\u0006\u001d%\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a%\u0002\u001aB!\u0011\u0011BAK\u0013\u0011\t9*a\u0003\u0003\u000f\t{w\u000e\\3b]\"I\u0011QP\u0007\u0002\u0002\u0003\u0007\u0011QO\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u00111N\u0001\ti>\u001cFO]5oOR\u0011\u0011qK\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0003O\u0003B!!\u0017\u0002*&!\u00111VA.\u0005\u0019y%M[3di\ny1i\u001c8uS:,X\rR3mCf,GmE\u0005\u0013\u0003\u000f\ti#!\r\u00028Q\u0011\u00111\u0017\t\u0004\u0003_\u0011B\u0003BA;\u0003oC\u0011\"! \u0017\u0003\u0003\u0005\r!a\u001b\u0015\t\u0005M\u00151\u0018\u0005\n\u0003{B\u0012\u0011!a\u0001\u0003k\u0012Aa\u0015;paNIQ$a\u0002\u0002.\u0005E\u0012q\u0007\u000b\u0003\u0003\u0007\u00042!a\f\u001e)\u0011\t)(a2\t\u0013\u0005u\u0014%!AA\u0002\u0005-D\u0003BAJ\u0003\u0017D\u0011\"! $\u0003\u0003\u0005\r!!\u001e\u0002\u0011\r{g\u000e^5ok\u0016\fqbQ8oi&tW/\u001a#fY\u0006LX\rZ\u0001\u0005'R|\u0007OA\u0005PM\u001a\u001cX\r^(qgN\u0019q%a6\u0011\t\u0005%\u0011\u0011\\\u0005\u0005\u00037\fYA\u0001\u0004B]f4\u0016\r\\\u0001_G>lGeZ5uQV\u0014GE[\u001bjWJzG%Y6lC\u0012\u0002XM]:jgR,gnY3%Ift\u0017-\\8eE\u0012\nX/\u001a:zIM\u001c\u0017\r\\1eg2$C)\u001f8b[>$%IU3bI*{WO\u001d8bY\u0012zeMZ:fi>\u00038\u000f\n\u0013uQ\u0006$XCAAq!\u0011\t\u0019/a;\u000e\u0005\u0005\u0015(bA9\u0002h*\u0019Q/!;\u000b\u0003]LA!!<\u0002f\n1qJ\u001a4tKR\fqlY8nI\u001dLG\u000f[;cI),\u0014n\u001b\u001apI\u0005\\7.\u0019\u0013qKJ\u001c\u0018n\u001d;f]\u000e,G\u0005Z=oC6|GM\u0019\u0013rk\u0016\u0014\u0018\u0010J:dC2\fGm\u001d7%\tft\u0017-\\8E\u0005J+\u0017\r\u001a&pkJt\u0017\r\u001c\u0013PM\u001a\u001cX\r^(qg\u0012\"C\u000f[1uAQ!\u00111_A{!\r\tyc\n\u0005\b\u0003oT\u0003\u0019AAq\u0003\u0011!\b.\u0019;\u0002\u000bY\fG.^3\u0016\u0005\u0005u\b\u0003BA\u0005\u0003\u007fLAA!\u0001\u0002\f\t!Aj\u001c8h\u0003\u0019)\u0017/^1mgR!\u00111\u0013B\u0004\u0011%\ti(LA\u0001\u0002\u0004\t)(A\u0005PM\u001a\u001cX\r^(qgB\u0019\u0011qF\u0018\u0014\u0007=\n9\u0001\u0006\u0002\u0003\f\u0005ya/\u00197vK\u0012*\u0007\u0010^3og&|g\u000e\u0006\u0003\u0002~\nU\u0001b\u0002B\fc\u0001\u0007\u00111_\u0001\u0006IQD\u0017n]\u0001\u0013Q\u0006\u001c\bnQ8eK\u0012*\u0007\u0010^3og&|g\u000e\u0006\u0003\u0002\u001e\nu\u0001b\u0002B\fe\u0001\u0007\u00111_\u0001\u0011KF,\u0018\r\\:%Kb$XM\\:j_:$BAa\t\u0003(Q!\u00111\u0013B\u0013\u0011%\tihMA\u0001\u0002\u0004\t)\bC\u0004\u0003\u0018M\u0002\r!a=\u0015\t\u0005M(1\u0006\u0005\b\u0003o$\u0004\u0019AAq'E)\u0014q\u0001B\u0018\u0005s\u0011yD!\u0012\u0003L\tE#q\u000b\t\u0005\u0005c\u0011)$\u0004\u0002\u00034)\u0019q.!:\n\t\t]\"1\u0007\u0002\f%\u0016\fGMS8ve:\fG\u000e\u0005\u0003\u00032\tm\u0012\u0002\u0002B\u001f\u0005g\u0011!dQ;se\u0016tG\u000fU3sg&\u001cH/\u001a8dK&#7/U;fef\u0004BA!\r\u0003B%!!1\tB\u001a\u0005M\u0001VM]:jgR,gnY3JIN\fV/\u001a:z!\u0011\u0011\tDa\u0012\n\t\t%#1\u0007\u0002\"\u0007V\u0014(/\u001a8u\u000bZ,g\u000e^:CsB+'o]5ti\u0016t7-Z%e#V,'/\u001f\t\u0005\u0005c\u0011i%\u0003\u0003\u0003P\tM\"AG#wK:$8OQ=QKJ\u001c\u0018n\u001d;f]\u000e,\u0017\nZ)vKJL\b\u0003\u0002B\u0019\u0005'JAA!\u0016\u00034\t92)\u001e:sK:$XI^3oiN\u0014\u0015\u0010V1h#V,'/\u001f\t\u0005\u0005c\u0011I&\u0003\u0003\u0003\\\tM\"\u0001E#wK:$8OQ=UC\u001e\fV/\u001a:z\u0003\u0019\u0019wN\u001c4jOB!!\u0011\rB5\u001b\t\u0011\u0019G\u0003\u0003\u0003^\t\u0015$b\u0001B4y\u0006AA/\u001f9fg\u00064W-\u0003\u0003\u0003l\t\r$AB\"p]\u001aLw-\u0001\u0006d_:4\u0017n\u001a)bi\"\u0004BA!\u001d\u0003z9!!1\u000fB;!\u0011\ti$a\u0003\n\t\t]\u00141B\u0001\u0007!J,G-\u001a4\n\t\u0005\u0015$1\u0010\u0006\u0005\u0005o\nY!\u0001\u0004tsN$X-\u001c\t\u0005\u0005\u0003\u00139)\u0004\u0002\u0003\u0004*!!QQAu\u0003\u0015\t7\r^8s\u0013\u0011\u0011IIa!\u0003'\u0015CH/\u001a8eK\u0012\f5\r^8s'f\u001cH/Z7\u0015\r\t5%1\u0013BK)\u0011\u0011yI!%\u0011\u0007\u0005\u0005Q\u0007C\u0004\u0003~e\u0002\u001dAa \t\u000f\tu\u0013\b1\u0001\u0003`!9!QN\u001dA\u0002\t=\u0014AA3d+\t\u0011Y\n\u0005\u0003\u0003\u001e\n\rVB\u0001BP\u0015\u0011\u0011\t+a\u0003\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u0003&\n}%\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0003\r)7\rI\u0001\u000eIft\u0017-\\5d\u0003\u000e\u001cWm]:\u0016\u0005\t5\u0006\u0003\u0002BA\u0005_KAA!-\u0003\u0004\niA)\u001f8b[&\u001c\u0017iY2fgN\fa\u0002Z=oC6L7-Q2dKN\u001c\b%A\u0002nCR,\"A!/\u0011\t\tm&\u0011Y\u0007\u0003\u0005{SAAa0\u0002j\u000611\u000f\u001e:fC6LAAa1\u0003>\n\t\u0012i\u0019;pe6\u000bG/\u001a:jC2L'0\u001a:\u0002\t5\fG\u000fI\u0001\u0005?2|w-\u0006\u0002\u0003LB!!Q\u001aBj\u001b\t\u0011yM\u0003\u0003\u0003R\u0006%\u0018!B3wK:$\u0018\u0002\u0002Bk\u0005\u001f\u0014a\u0002T8hO&tw-\u00113baR,'/A\u0003`Y><\u0007%A\trk\u0016\u0014\u0018\u0010\u00157vO&t7i\u001c8gS\u001e,\"A!8\u0011\t\t}'1]\u0007\u0003\u0005CT1A!\u0018s\u0013\u0011\u0011)O!9\u0003#E+XM]=QYV<\u0017N\\\"p]\u001aLw-\u0001\nrk\u0016\u0014\u0018\u0010\u00157vO&t7i\u001c8gS\u001e\u0004\u0013aD7fiJL7m\u001d*fa>\u0014H/\u001a:\u0016\u0005\t5\bCBA\u0005\u0005_\u0014\u00190\u0003\u0003\u0003r\u0006-!AB(qi&|g\u000e\u0005\u0003\u0003v\nmXB\u0001B|\u0015\r\u0011IP]\u0001\b[\u0016$(/[2t\u0013\u0011\u0011iPa>\u0003\u001f5+GO]5dgJ+\u0007o\u001c:uKJ\f\u0001#\\3ue&\u001c7OU3q_J$XM\u001d\u0011\u0002\u001bM,'/[1mSj\fG/[8o+\t\u0019)\u0001\u0005\u0003\u0004\b\r-QBAB\u0005\u0015\u0011\u0019\t!!;\n\t\r51\u0011\u0002\u0002\u000e'\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8\u0002\u001dM,'/[1mSj\fG/[8oA\u0005Q1/\u001a:jC2L'0\u001a:\u0016\u0005\rU\u0001CBB\f\u00077\u0019y\"\u0004\u0002\u0004\u001a)\u00191\u0011\u0001:\n\t\ru1\u0011\u0004\u0002\u001d\r2|w\u000fU3sg&\u001cH/\u001a8u%\u0016\u0004(oU3sS\u0006d\u0017N_3s!\u0011\u0019\tca\n\u000e\u0005\r\r\"bAB\u0013e\u00069!n\\;s]\u0006d\u0017\u0002BB\u0015\u0007G\u0011!BS8ve:\fGNU8x\u0003-\u0019XM]5bY&TXM\u001d\u0011\u0002!)\fg/Y*z]\u000e\u001cE.[3oiZ\u0013TCAB\u0019!\u0011\u0019\u0019da\u0012\u000e\u0005\rU\"bA:\u00048)!1\u0011HB\u001e\u0003!\u0019XM\u001d<jG\u0016\u001c(\u0002BB\u001f\u0007\u007f\ta!Y<tg\u0012\\'\u0002BB!\u0007\u0007\na!Y7bu>t'BAB#\u0003!\u0019xN\u001a;xCJ,\u0017\u0002BB%\u0007k\u0011a\u0002R=oC6|GIY\"mS\u0016tG/\u0001\u000bkCZ\f7+\u001f8d\u00072LWM\u001c;We}#S-\u001d\u000b\u0005\u0007\u001f\u001a)\u0006\u0005\u0003\u0002\n\rE\u0013\u0002BB*\u0003\u0017\u0011A!\u00168ji\"I\u0011QP&\u0002\u0002\u0003\u00071\u0011G\u0001\u0012U\u00064\u0018mU=oG\u000ec\u0017.\u001a8u-J\u0002\u0013!\u00056bm\u0006\f5/\u001f8d\u00072LWM\u001c;WeU\u00111Q\f\t\u0005\u0007g\u0019y&\u0003\u0003\u0004b\rU\"a\u0005#z]\u0006lw\u000e\u00122Bgft7m\u00117jK:$\u0018!\u00066bm\u0006\f5/\u001f8d\u00072LWM\u001c;We}#S-\u001d\u000b\u0005\u0007\u001f\u001a9\u0007C\u0005\u0002~9\u000b\t\u00111\u0001\u0004^\u0005\u0011\".\u0019<b\u0003NLhnY\"mS\u0016tGO\u0016\u001a!\u0003\u0015\u0019Gn\\:f)\t\u0019y%A\u0002yIY\u0002\u0002\"!\u0003\u0004t\r]41Q\u0005\u0005\u0007k\nYA\u0001\u0004UkBdWM\r\t\u0005\u0007s\u001ay(\u0004\u0002\u0004|)!1QPB\u0012\u0003\r!\u0017m\\\u0005\u0005\u0007\u0003\u001bYH\u0001\u000bK_V\u0014h.\u00197S_^\u0014V-\u00193Ee&4XM\u001d\t\u0005\u0007\u000b\u001bI)\u0004\u0002\u0004\b*\u00191Q\u00109\n\t\r-5q\u0011\u0002\u000f#V,'/\u001f)s_\u000e,7o]8s\u0003QQw.\u001e:oC2\u0014vn\u001e*fC\u0012$%/\u001b<feV\u00111qO\u0001\u0016U>,(O\\1m%><(+Z1e\tJLg/\u001a:!\u00039\tX/\u001a:z!J|7-Z:t_J,\"aa!\u0002\u001fE,XM]=Qe>\u001cWm]:pe\u0002\naB]3bI*{WO\u001d8bY\u0012\u000bw.\u0006\u0002\u0004\u001eB!1QQBP\u0013\u0011\u0019\tka\"\u0003%I+\u0017\r\u001a&pkJt\u0017\r\u001c#b_&k\u0007\u000f\\\u0001\u0010e\u0016\fGMS8ve:\fG\u000eR1pA\u0005iqO]5uKBcWoZ5o\u0013\u0012\fab\u001e:ji\u0016\u0004F.^4j]&#\u0007%A\u0007fm\u0016tG/\u00113baR,'o]\u000b\u0003\u0007[\u0003Baa,\u000446\u00111\u0011\u0017\u0006\u0005\u0007K\t9/\u0003\u0003\u00046\u000eE&!D#wK:$\u0018\tZ1qi\u0016\u00148/\u0001\bfm\u0016tG/\u00113baR,'o\u001d\u0011\u0002\u001fI,gM]3tQ&sG/\u001a:wC2,\"a!0\u0011\t\r}6QY\u0007\u0003\u0007\u0003TAaa1\u0003 \u0006AA-\u001e:bi&|g.\u0003\u0003\u0004H\u000e\u0005'A\u0004$j]&$X\rR;sCRLwN\\\u0001\u0011e\u00164'/Z:i\u0013:$XM\u001d<bY\u0002\nAC[8ve:\fGnU3rk\u0016t7-Z!di>\u0014XCABh!\u0011\u0011\ti!5\n\t\rM'1\u0011\u0002\t\u0003\u000e$xN\u001d*fM\u0006YA-\u001a7bsN{WO]2f+\t\u0019I\u000e\u0005\u0005\u0004\\\u000e}\u00171NBr\u001b\t\u0019iNC\u0002p\u0005{KAa!9\u0004^\n11k\\;sG\u0016\u0004BA!!\u0004f&!1q\u001dBB\u0005-\u0019\u0015M\\2fY2\f'\r\\3\u0002\u0019\u0011,G.Y=T_V\u00148-\u001a\u0011\u0002+\r,(O]3oiB+'o]5ti\u0016t7-Z%egR\u00111q\u001e\t\t\u00077\u001cyNa\u001c\u0004rB!11_B{\u001b\t\tI/\u0003\u0003\u0004x\u0006%(a\u0002(piV\u001bX\rZ\u0001\u000fa\u0016\u00148/[:uK:\u001cW-\u00133t\u0003-\tG-\u00199u\u000bZ,g\u000e^:\u0015\t\r}H1\u0003\t\u0007\t\u0003!9\u0001b\u0003\u000e\u0005\u0011\r!\u0002\u0002C\u0003\u0003\u000f\u000b\u0011\"[7nkR\f'\r\\3\n\t\u0011%A1\u0001\u0002\u0007-\u0016\u001cGo\u001c:\u0011\t\u00115AqB\u0007\u0003\u0003OLA\u0001\"\u0005\u0002h\nq\u0001+\u001a:tSN$XM\u001c;SKB\u0014\bb\u0002C\u000bG\u0002\u0007A1B\u0001\u000fa\u0016\u00148/[:uK:$(+\u001a9s\u0003q\u0019WO\u001d:f]R,e/\u001a8ug\nK\b+\u001a:tSN$XM\\2f\u0013\u0012$\u0002\u0002b\u0007\u0005$\u0011\u001dB1\u0006\t\t\u00077\u001cy\u000e\"\b\u0004rB!\u00111\u001dC\u0010\u0013\u0011!\t#!:\u0003\u001b\u00153XM\u001c;F]Z,Gn\u001c9f\u0011\u001d!)\u0003\u001aa\u0001\u0005_\nQ\u0002]3sg&\u001cH/\u001a8dK&#\u0007b\u0002C\u0015I\u0002\u0007\u0011Q`\u0001\u000fMJ|WnU3rk\u0016t7-\u001a(s\u0011\u001d!i\u0003\u001aa\u0001\u0003{\fA\u0002^8TKF,XM\\2f\u001dJ\fQ#\u001a<f]R\u001c()\u001f)feNL7\u000f^3oG\u0016LE\r\u0006\u0005\u0005\u001c\u0011MBQ\u0007C\u001c\u0011\u001d!)#\u001aa\u0001\u0005_Bq\u0001\"\u000bf\u0001\u0004\ti\u0010C\u0004\u0005.\u0015\u0004\r!!@\u00027\u00154XM\u001c;t\u0005f\u0004VM]:jgR,gnY3JIN{WO]2f))!Y\u0002\"\u0010\u0005@\u0011\u0005C1\t\u0005\b\tK1\u0007\u0019\u0001B8\u0011\u001d!IC\u001aa\u0001\u0003{Dq\u0001\"\fg\u0001\u0004\ti\u0010C\u0004\u0004:\u001a\u0004\r\u0001\"\u0012\u0011\r\u0005%!q\u001eC$!!\tIaa\u001d\u0004>\u0012%\u0003\u0003\u0002BA\t\u0017JA\u0001\"\u0014\u0003\u0004\nI1k\u00195fIVdWM]\u0001\u0013GV\u0014(/\u001a8u\u000bZ,g\u000e^:CsR\u000bw\r\u0006\u0004\u0005\u001c\u0011MCq\u000b\u0005\b\t+:\u0007\u0019\u0001B8\u0003\r!\u0018m\u001a\u0005\b\t3:\u0007\u0019AAq\u0003\u0019ygMZ:fi\u0006I2-\u001e:sK:$(j\\;s]\u0006dWI^3oiN\u0014\u0015\u0010V1h))!Y\u0002b\u0018\u0005b\u0011\rDq\r\u0005\b\t+B\u0007\u0019\u0001B8\u0011\u001d!I\u0006\u001ba\u0001\u0003{Dq\u0001\"\u001ai\u0001\u0004\ti0A\u0002nCbDq\u0001\"\u001bi\u0001\u0004!Y'\u0001\bmCR,7\u000f^(sI\u0016\u0014\u0018N\\4\u0011\t\u00115Dq\u0012\b\u0005\t_\"YI\u0004\u0003\u0005r\u0011%e\u0002\u0002C:\t\u000fsA\u0001\"\u001e\u0005\u0006:!Aq\u000fCB\u001d\u0011!I\b\"!\u000f\t\u0011mDq\u0010\b\u0005\u0003{!i(C\u0001~\u0013\tYH0\u0003\u0002zu&\u0011q\u000f_\u0005\u0003kZL!a\u001d;\n\u0005E\u0014\u0018b\u0001CGa\u0006!\"j\\;s]\u0006d7+Z9vK:\u001cW-Q2u_JLA\u0001\"%\u0005\u0014\niQ*\u0019=Pe\u0012,'/\u001b8h\u0013\u0012T1\u0001\"$q\u0003-)g/\u001a8ug\nKH+Y4\u0015\u0011\u0011mA\u0011\u0014CN\t;Cq\u0001\"\u0016j\u0001\u0004\u0011y\u0007C\u0004\u0005Z%\u0004\r!!@\t\u000f\u0011}\u0015\u000e1\u0001\u0005\"\u0006!B/\u001a:nS:\fG/Z!gi\u0016\u0014xJ\u001a4tKR\u0004b!!\u0003\u0003p\u0006uHC\u0002C\u000e\tK#9\u000bC\u0004\u0005V)\u0004\rAa\u001c\t\u000f\u0011e#\u000e1\u0001\u0002~R1A1\u0004CV\t[Cq\u0001\"\u0016l\u0001\u0004\u0011y\u0007C\u0004\u0005Z-\u0004\r!!9\u0015\r\u0011mA\u0011\u0017CZ\u0011\u001d!)\u0006\u001ca\u0001\u0005_Bq\u0001\"\u0017m\u0001\u0004\ti\u0010")
public class DynamoDBReadJournal
implements CurrentPersistenceIdsQuery,
PersistenceIdsQuery,
CurrentEventsByPersistenceIdQuery,
EventsByPersistenceIdQuery,
CurrentEventsByTagQuery,
EventsByTagQuery {
    private ActorRef journalSequenceActor;
    private String configPath;
    private final ExtendedActorSystem system;
    private final ExecutionContext ec;
    private final DynamicAccess dynamicAccess;
    private final ActorMaterializer mat;
    private final LoggingAdapter _log;
    private final QueryPluginConfig queryPluginConfig;
    private final Option<MetricsReporter> metricsReporter;
    private final Serialization serialization;
    private final FlowPersistentReprSerializer<JournalRow> serializer;
    private DynamoDbClient javaSyncClientV2;
    private DynamoDbAsyncClient javaAsyncClientV2;
    private final /* synthetic */ Tuple2 x$6;
    private final JournalRowReadDriver journalRowReadDriver;
    private final QueryProcessor queryProcessor;
    private final ReadJournalDaoImpl readJournalDao;
    private final String writePluginId;
    private final EventAdapters eventAdapters;
    private final FiniteDuration refreshInterval;
    private final Source<Object, Cancellable> delaySource;
    private volatile boolean bitmap$0;

    public static Offset OffsetOps(Offset offset) {
        return DynamoDBReadJournal$.MODULE$.OffsetOps(offset);
    }

    public static String Identifier() {
        return DynamoDBReadJournal$.MODULE$.Identifier();
    }

    private ExecutionContext ec() {
        return this.ec;
    }

    private DynamicAccess dynamicAccess() {
        return this.dynamicAccess;
    }

    private ActorMaterializer mat() {
        return this.mat;
    }

    private LoggingAdapter _log() {
        return this._log;
    }

    private QueryPluginConfig queryPluginConfig() {
        return this.queryPluginConfig;
    }

    private Option<MetricsReporter> metricsReporter() {
        return this.metricsReporter;
    }

    private Serialization serialization() {
        return this.serialization;
    }

    private FlowPersistentReprSerializer<JournalRow> serializer() {
        return this.serializer;
    }

    private DynamoDbClient javaSyncClientV2() {
        return this.javaSyncClientV2;
    }

    private void javaSyncClientV2_$eq(DynamoDbClient x$1) {
        this.javaSyncClientV2 = x$1;
    }

    private DynamoDbAsyncClient javaAsyncClientV2() {
        return this.javaAsyncClientV2;
    }

    private void javaAsyncClientV2_$eq(DynamoDbAsyncClient x$1) {
        this.javaAsyncClientV2 = x$1;
    }

    public void com$github$j5ik2o$akka$persistence$dynamodb$query$scaladsl$DynamoDBReadJournal$$close() {
        block1: {
            if (this.javaAsyncClientV2() != null) {
                this.javaAsyncClientV2().close();
            }
            if (this.javaSyncClientV2() == null) break block1;
            this.javaSyncClientV2().close();
        }
    }

    private JournalRowReadDriver journalRowReadDriver() {
        return this.journalRowReadDriver;
    }

    private QueryProcessor queryProcessor() {
        return this.queryProcessor;
    }

    private ReadJournalDaoImpl readJournalDao() {
        return this.readJournalDao;
    }

    private String writePluginId() {
        return this.writePluginId;
    }

    private EventAdapters eventAdapters() {
        return this.eventAdapters;
    }

    private FiniteDuration refreshInterval() {
        return this.refreshInterval;
    }

    private ActorRef journalSequenceActor$lzycompute() {
        DynamoDBReadJournal dynamoDBReadJournal = this;
        synchronized (dynamoDBReadJournal) {
            if (!this.bitmap$0) {
                this.journalSequenceActor = this.system.systemActorOf(JournalSequenceActor$.MODULE$.props(this.readJournalDao(), this.queryPluginConfig().journalSequenceRetrievalConfig(), (Materializer)this.mat()), new StringBuilder(49).append(this.configPath).append(".akka-persistence-dynamodb-journal-sequence-actor").toString());
                this.bitmap$0 = true;
            }
        }
        this.configPath = null;
        return this.journalSequenceActor;
    }

    private ActorRef journalSequenceActor() {
        return !this.bitmap$0 ? this.journalSequenceActor$lzycompute() : this.journalSequenceActor;
    }

    private Source<Object, Cancellable> delaySource() {
        return this.delaySource;
    }

    public Source<String, NotUsed> currentPersistenceIds() {
        return (Source)this.readJournalDao().allPersistenceIds(Long.MAX_VALUE).map((Function1 & Serializable)x$7 -> x$7.asString());
    }

    public Source<String, NotUsed> persistenceIds() {
        return (Source)Source$.MODULE$.repeat((Object)BoxesRunTime.boxToInteger((int)0)).flatMapConcat((Function1 & Serializable)x$8 -> DynamoDBReadJournal.$anonfun$persistenceIds$1(this, BoxesRunTime.unboxToInt((Object)x$8))).statefulMapConcat((Function0 & Serializable)() -> {
            ObjectRef knownIds = ObjectRef.create((Object)Set$.MODULE$.empty());
            return (Function1 & Serializable)id -> DynamoDBReadJournal.next$1(id, knownIds);
        });
    }

    private Vector<PersistentRepr> adaptEvents(PersistentRepr persistentRepr) {
        EventAdapter adapter = this.eventAdapters().get(persistentRepr.payload().getClass());
        return ((IterableOnceOps)adapter.fromJournal(persistentRepr.payload(), persistentRepr.manifest()).events().map((Function1 & Serializable)payload -> persistentRepr.withPayload(payload))).toVector();
    }

    public Source<EventEnvelope, NotUsed> currentEventsByPersistenceId(String persistenceId, long fromSequenceNr, long toSequenceNr) {
        return this.eventsByPersistenceIdSource(persistenceId, fromSequenceNr, toSequenceNr, (Option<Tuple2<FiniteDuration, Scheduler>>)None$.MODULE$);
    }

    public Source<EventEnvelope, NotUsed> eventsByPersistenceId(String persistenceId, long fromSequenceNr, long toSequenceNr) {
        return this.eventsByPersistenceIdSource(persistenceId, fromSequenceNr, toSequenceNr, (Option<Tuple2<FiniteDuration, Scheduler>>)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.refreshInterval()), (Object)this.system.scheduler())));
    }

    private Source<EventEnvelope, NotUsed> eventsByPersistenceIdSource(String persistenceId, long fromSequenceNr, long toSequenceNr, Option<Tuple2<FiniteDuration, Scheduler>> refreshInterval) {
        int batchSize = this.queryPluginConfig().maxBufferSize();
        return (Source)this.readJournalDao().getMessagesAsPersistentReprWithBatch(persistenceId, fromSequenceNr, toSequenceNr, batchSize, refreshInterval).mapAsync(1, (Function1 & Serializable)deserializedRepr -> Future$.MODULE$.fromTry(deserializedRepr)).mapConcat((Function1 & Serializable)persistentRepr -> this.adaptEvents((PersistentRepr)persistentRepr)).map((Function1 & Serializable)repr -> EventEnvelope$.MODULE$.apply((Offset)new Sequence(repr.sequenceNr()), repr.persistenceId(), repr.sequenceNr(), repr.payload(), repr.timestamp()));
    }

    public Source<EventEnvelope, NotUsed> currentEventsByTag(String tag, Offset offset) {
        return this.currentEventsByTag(tag, DynamoDBReadJournal$OffsetOps$.MODULE$.value$extension(DynamoDBReadJournal$.MODULE$.OffsetOps(offset)));
    }

    private Source<EventEnvelope, NotUsed> currentJournalEventsByTag(String tag, long offset, long max, JournalSequenceActor.MaxOrderingId latestOrdering) {
        return latestOrdering.maxOrdering() < offset ? Source$.MODULE$.empty() : (Source)this.readJournalDao().eventsByTag(tag, offset, latestOrdering.maxOrdering(), max).mapAsync(1, (Function1 & Serializable)result -> Future$.MODULE$.fromTry(result)).mapConcat((Function1 & Serializable)x0$1 -> {
            Tuple3 tuple3 = x0$1;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            PersistentRepr repr = (PersistentRepr)tuple3._1();
            long ordering = BoxesRunTime.unboxToLong((Object)tuple3._3());
            Iterable iterable = (Iterable)this.adaptEvents(repr).map((Function1 & Serializable)r -> EventEnvelope$.MODULE$.apply((Offset)new Sequence(ordering), r.persistenceId(), r.sequenceNr(), r.payload(), r.timestamp()));
            return iterable;
        });
    }

    private Source<EventEnvelope, NotUsed> eventsByTag(String tag, long offset, Option<Object> terminateAfterOffset) {
        Timeout askTimeout = new Timeout(this.queryPluginConfig().journalSequenceRetrievalConfig().askTimeout());
        int batchSize = this.queryPluginConfig().maxBufferSize();
        return (Source)Source$.MODULE$.unfoldAsync((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)offset), (Object)DynamoDBReadJournal$Continue$.MODULE$), (Function1 & Serializable)x0$1 -> {
            Future future;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            long from = tuple2._1$mcJ$sp();
            FlowControl control = (FlowControl)tuple2._2();
            FlowControl flowControl = control;
            if (DynamoDBReadJournal$Stop$.MODULE$.equals(flowControl)) {
                future = Future$.MODULE$.successful((Object)None$.MODULE$);
                return future;
            } else if (DynamoDBReadJournal$Continue$.MODULE$.equals(flowControl)) {
                future = this.retrieveNextBatch$1(askTimeout, tag, from, batchSize, terminateAfterOffset);
                return future;
            } else {
                if (!DynamoDBReadJournal$ContinueDelayed$.MODULE$.equals(flowControl)) throw new MatchError((Object)flowControl);
                future = akka.pattern.package$.MODULE$.after(this.refreshInterval(), $this.system.scheduler(), (Function0 & Serializable)() -> this.retrieveNextBatch$1(askTimeout, tag, from, batchSize, terminateAfterOffset), this.ec());
            }
            return future;
        }).mapConcat((Function1 & Serializable)x -> (Seq)Predef$.MODULE$.identity(x));
    }

    public Source<EventEnvelope, NotUsed> currentEventsByTag(String tag, long offset) {
        return (Source)this.readJournalDao().maxJournalSequence().flatMapConcat((Function1 & Serializable)maxOrderingInDb -> this.eventsByTag(tag, offset, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)maxOrderingInDb)))));
    }

    public Source<EventEnvelope, NotUsed> eventsByTag(String tag, Offset offset) {
        return this.eventsByTag(tag, DynamoDBReadJournal$OffsetOps$.MODULE$.value$extension(DynamoDBReadJournal$.MODULE$.OffsetOps(offset)));
    }

    public Source<EventEnvelope, NotUsed> eventsByTag(String tag, long offset) {
        return this.eventsByTag(tag, offset, (Option<Object>)None$.MODULE$);
    }

    public static final /* synthetic */ Source $anonfun$persistenceIds$1(DynamoDBReadJournal $this, int x$8) {
        return (Source)$this.delaySource().flatMapConcat((Function1 & Serializable)x$9 -> $this.currentPersistenceIds());
    }

    /*
     * WARNING - void declaration
     */
    private static final Iterable next$1(String id, ObjectRef knownIds$1) {
        void var2_2;
        scala.collection.immutable.Set xs = (scala.collection.immutable.Set)((SetOps)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{id}))).diff((Set)((scala.collection.immutable.Set)knownIds$1.elem));
        knownIds$1.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)knownIds$1.elem).$plus((Object)id);
        return var2_2;
    }

    public static final /* synthetic */ boolean $anonfun$eventsByTag$4(long target$1, EventEnvelope x$10) {
        return DynamoDBReadJournal$OffsetOps$.MODULE$.value$extension(DynamoDBReadJournal$.MODULE$.OffsetOps(x$10.offset())) >= target$1;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static final /* synthetic */ Some $anonfun$eventsByTag$3(int batchSize$1, Option terminateAfterOffset$1, JournalSequenceActor.MaxOrderingId queryUntil$1, long from$1, Seq xs) {
        hasMoreEvents = xs.size() == batchSize$1;
        var9_6 = false;
        var10_7 = null;
        var11_8 = terminateAfterOffset$1;
        if (!(var11_8 instanceof Some)) ** GOTO lbl-1000
        var9_6 = true;
        var10_7 = (Some)var11_8;
        target = BoxesRunTime.unboxToLong((Object)var10_7.value());
        if (!hasMoreEvents && target <= queryUntil$1.maxOrdering()) {
            var6_10 /* !! */  = DynamoDBReadJournal$Stop$.MODULE$;
        } else lbl-1000:
        // 2 sources

        {
            var6_10 /* !! */  = var9_6 != false && xs.exists((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$eventsByTag$4$adapted(long akka.persistence.query.EventEnvelope ), (Lakka/persistence/query/EventEnvelope;)Ljava/lang/Object;)((long)(target = BoxesRunTime.unboxToLong((Object)var10_7.value())))) != false ? DynamoDBReadJournal$Stop$.MODULE$ : (hasMoreEvents != false ? DynamoDBReadJournal$Continue$.MODULE$ : DynamoDBReadJournal$ContinueDelayed$.MODULE$);
        }
        nextControl /* !! */  = var6_10 /* !! */ ;
        nextStartingOffset = xs.isEmpty() != false ? package$.MODULE$.max(from$1, queryUntil$1.maxOrdering()) : BoxesRunTime.unboxToLong((Object)((IterableOnceOps)xs.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$eventsByTag$5$adapted(akka.persistence.query.EventEnvelope ), (Lakka/persistence/query/EventEnvelope;)Ljava/lang/Object;)())).max((Ordering)Ordering.Long$.MODULE$));
        return new Some((Object)new Tuple2((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)nextStartingOffset), (Object)nextControl /* !! */ ), (Object)xs));
    }

    private final Future retrieveNextBatch$1(Timeout askTimeout$1, String tag$1, long from$1, int batchSize$1, Option terminateAfterOffset$1) {
        ActorRef qual$1 = akka.pattern.package$.MODULE$.ask(this.journalSequenceActor());
        JournalSequenceActor$GetMaxOrderingId$ x$1 = JournalSequenceActor$GetMaxOrderingId$.MODULE$;
        Timeout x$2 = askTimeout$1;
        ActorRef x$3 = AskableActorRef$.MODULE$.ask$default$3$extension(qual$1, (Object)x$1);
        return AskableActorRef$.MODULE$.ask$extension(qual$1, (Object)x$1, x$2, x$3).mapTo(ClassTag$.MODULE$.apply(JournalSequenceActor.MaxOrderingId.class)).flatMap((Function1 & Serializable)queryUntil -> ((Future)this.currentJournalEventsByTag(tag$1, from$1, batchSize$1, (JournalSequenceActor.MaxOrderingId)queryUntil).runWith((Graph)Sink$.MODULE$.seq(), (Materializer)this.mat())).map(arg_0 -> DynamoDBReadJournal.$anonfun$eventsByTag$3(batchSize$1, terminateAfterOffset$1, queryUntil, from$1, arg_0), this.ec()), this.ec());
    }

    public DynamoDBReadJournal(Config config, String configPath, ExtendedActorSystem system) {
        JournalRowReadDriver journalRowReadDriver;
        QueryProcessor queryProcessor;
        block25: {
            Tuple2 tuple2;
            block24: {
                Tuple2 tuple22;
                this.configPath = configPath;
                this.system = system;
                LoggerFactory.getLogger(this.getClass());
                this.ec = system.dispatcher();
                this.dynamicAccess = system.dynamicAccess();
                this.mat = ActorMaterializer$.MODULE$.apply(ActorMaterializer$.MODULE$.apply$default$1(), ActorMaterializer$.MODULE$.apply$default$2(), (ActorRefFactory)system);
                this._log = system.log();
                this.queryPluginConfig = QueryPluginConfig$.MODULE$.fromConfig(config);
                MetricsReporterProvider metricsReporterProvider = MetricsReporterProvider$.MODULE$.create(this.dynamicAccess(), (PluginConfig)this.queryPluginConfig());
                this.metricsReporter = metricsReporterProvider.create();
                this.serialization = (Serialization)SerializationExtension$.MODULE$.apply((ActorSystem)system);
                this.serializer = new ByteArrayJournalSerializer(this.serialization(), this.queryPluginConfig().tagSeparator(), this.metricsReporter());
                system.registerOnTermination(new Runnable(this){
                    private final /* synthetic */ DynamoDBReadJournal $outer;

                    public void run() {
                        this.$outer.com$github$j5ik2o$akka$persistence$dynamodb$query$scaladsl$DynamoDBReadJournal$$close();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                Enumeration.Value value = this.queryPluginConfig().clientConfig().clientVersion();
                Enumeration.Value value2 = ClientVersion$.MODULE$.V2();
                Enumeration.Value value3 = value;
                if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                    Tuple2 tuple23;
                    Enumeration.Value value4 = this.queryPluginConfig().clientConfig().clientType();
                    Enumeration.Value value5 = ClientType$.MODULE$.Sync();
                    Enumeration.Value value6 = value4;
                    if (!(value5 != null ? !value5.equals(value6) : value6 != null)) {
                        DynamoDbClient client = ClientUtils$.MODULE$.createV2SyncClient(this.dynamicAccess(), this.queryPluginConfig().configRootPath(), (PluginConfig)this.queryPluginConfig(), (Function1 & Serializable)v -> {
                            this.javaSyncClientV2_$eq(v);
                            return BoxedUnit.UNIT;
                        }, this._log());
                        tuple23 = new Tuple2((Object)new Some((Object)client), (Object)None$.MODULE$);
                    } else {
                        Enumeration.Value value7 = ClientType$.MODULE$.Async();
                        Enumeration.Value value8 = value4;
                        if (!(value7 != null ? !value7.equals(value8) : value8 != null)) {
                            DynamoDbAsyncClient client = ClientUtils$.MODULE$.createV2AsyncClient(this.dynamicAccess(), (PluginConfig)this.queryPluginConfig(), (Function1 & Serializable)v -> {
                                this.javaAsyncClientV2_$eq(v);
                                return BoxedUnit.UNIT;
                            });
                            tuple23 = new Tuple2((Object)None$.MODULE$, (Object)new Some((Object)client));
                        } else {
                            throw new MatchError((Object)value4);
                        }
                    }
                    Tuple2 tuple24 = tuple23;
                    if (tuple24 == null) {
                        throw new MatchError((Object)tuple24);
                    }
                    Option maybeSyncClient = (Option)tuple24._1();
                    Option maybeAsyncClient = (Option)tuple24._2();
                    Tuple2 tuple25 = new Tuple2((Object)maybeSyncClient, (Object)maybeAsyncClient);
                    Tuple2 tuple26 = tuple25;
                    Option maybeSyncClient2 = (Option)tuple26._1();
                    Option maybeAsyncClient2 = (Option)tuple26._2();
                    tuple22 = new Tuple2((Object)new V2JournalRowReadDriver((ActorSystem)system, maybeAsyncClient2, maybeSyncClient2, (JournalPluginBaseConfig)this.queryPluginConfig(), this.metricsReporter()), (Object)new V2QueryProcessor((ActorSystem)system, (Option<DynamoDbAsyncClient>)maybeAsyncClient2, (Option<DynamoDbClient>)maybeSyncClient2, this.queryPluginConfig(), this.metricsReporter()));
                } else {
                    Enumeration.Value value9 = ClientVersion$.MODULE$.V1();
                    Enumeration.Value value10 = value;
                    if (!(value9 != null ? !value9.equals(value10) : value10 != null)) {
                        Tuple2 tuple27;
                        Enumeration.Value value11 = this.queryPluginConfig().clientConfig().clientType();
                        Enumeration.Value value12 = ClientType$.MODULE$.Sync();
                        Enumeration.Value value13 = value11;
                        if (!(value12 != null ? !value12.equals(value13) : value13 != null)) {
                            AmazonDynamoDB client = ClientUtils$.MODULE$.createV1SyncClient(this.dynamicAccess(), this.queryPluginConfig().configRootPath(), (PluginConfig)this.queryPluginConfig(), this._log());
                            tuple27 = new Tuple2((Object)new Some((Object)client), (Object)None$.MODULE$);
                        } else {
                            Enumeration.Value value14 = ClientType$.MODULE$.Async();
                            Enumeration.Value value15 = value11;
                            if (!(value14 != null ? !value14.equals(value15) : value15 != null)) {
                                AmazonDynamoDBAsync client = ClientUtils$.MODULE$.createV1AsyncClient(this.dynamicAccess(), (PluginConfig)this.queryPluginConfig());
                                tuple27 = new Tuple2((Object)None$.MODULE$, (Object)new Some((Object)client));
                            } else {
                                throw new MatchError((Object)value11);
                            }
                        }
                        Tuple2 tuple28 = tuple27;
                        if (tuple28 == null) {
                            throw new MatchError((Object)tuple28);
                        }
                        Option maybeSyncClient = (Option)tuple28._1();
                        Option maybeAsyncClient = (Option)tuple28._2();
                        Tuple2 tuple29 = new Tuple2((Object)maybeSyncClient, (Object)maybeAsyncClient);
                        Tuple2 tuple210 = tuple29;
                        Option maybeSyncClient3 = (Option)tuple210._1();
                        Option maybeAsyncClient3 = (Option)tuple210._2();
                        tuple22 = new Tuple2((Object)new V1JournalRowReadDriver((ActorSystem)system, maybeAsyncClient3, maybeSyncClient3, (JournalPluginBaseConfig)this.queryPluginConfig(), this.metricsReporter(), this.ec()), (Object)new V1QueryProcessor((ActorSystem)system, (Option<AmazonDynamoDBAsync>)maybeAsyncClient3, (Option<AmazonDynamoDB>)maybeSyncClient3, this.queryPluginConfig(), this.metricsReporter(), this.ec()));
                    } else {
                        Enumeration.Value value16 = ClientVersion$.MODULE$.V1Dax();
                        Enumeration.Value value17 = value;
                        if (!(value16 != null ? !value16.equals(value17) : value17 != null)) {
                            Tuple2 tuple211;
                            Enumeration.Value value18 = this.queryPluginConfig().clientConfig().clientType();
                            Enumeration.Value value19 = ClientType$.MODULE$.Sync();
                            Enumeration.Value value20 = value18;
                            if (!(value19 != null ? !value19.equals(value20) : value20 != null)) {
                                AmazonDynamoDB client = ClientUtils$.MODULE$.createV1DaxSyncClient(this.queryPluginConfig().configRootPath(), this.queryPluginConfig().clientConfig(), this._log());
                                tuple211 = new Tuple2((Object)new Some((Object)client), (Object)None$.MODULE$);
                            } else {
                                Enumeration.Value value21 = ClientType$.MODULE$.Async();
                                Enumeration.Value value22 = value18;
                                if (!(value21 != null ? !value21.equals(value22) : value22 != null)) {
                                    AmazonDynamoDBAsync client = ClientUtils$.MODULE$.createV1DaxAsyncClient(this.queryPluginConfig().clientConfig());
                                    tuple211 = new Tuple2((Object)None$.MODULE$, (Object)new Some((Object)client));
                                } else {
                                    throw new MatchError((Object)value18);
                                }
                            }
                            Tuple2 tuple212 = tuple211;
                            if (tuple212 == null) {
                                throw new MatchError((Object)tuple212);
                            }
                            Option maybeSyncClient = (Option)tuple212._1();
                            Option maybeAsyncClient = (Option)tuple212._2();
                            Tuple2 tuple213 = new Tuple2((Object)maybeSyncClient, (Object)maybeAsyncClient);
                            Tuple2 tuple214 = tuple213;
                            Option maybeSyncClient4 = (Option)tuple214._1();
                            Option maybeAsyncClient4 = (Option)tuple214._2();
                            tuple22 = new Tuple2((Object)new V1JournalRowReadDriver((ActorSystem)system, maybeAsyncClient4, maybeSyncClient4, (JournalPluginBaseConfig)this.queryPluginConfig(), this.metricsReporter(), this.ec()), (Object)new V1QueryProcessor((ActorSystem)system, (Option<AmazonDynamoDBAsync>)maybeAsyncClient4, (Option<AmazonDynamoDB>)maybeSyncClient4, this.queryPluginConfig(), this.metricsReporter(), this.ec()));
                        } else {
                            throw new MatchError((Object)value);
                        }
                    }
                }
                tuple2 = tuple22;
                if (tuple2 == null) break block24;
                JournalRowReadDriver journalRowReadDriver2 = (JournalRowReadDriver)tuple2._1();
                queryProcessor = (QueryProcessor)tuple2._2();
                if (journalRowReadDriver2 == null) break block24;
                journalRowReadDriver = journalRowReadDriver2;
                if (queryProcessor != null) break block25;
            }
            throw new MatchError((Object)tuple2);
        }
        QueryProcessor queryProcessor2 = queryProcessor;
        Tuple2 tuple2 = new Tuple2((Object)journalRowReadDriver, (Object)queryProcessor2);
        this.x$6 = tuple2;
        this.journalRowReadDriver = (JournalRowReadDriver)this.x$6._1();
        this.queryProcessor = (QueryProcessor)this.x$6._2();
        this.readJournalDao = new ReadJournalDaoImpl(this.queryProcessor(), this.journalRowReadDriver(), this.queryPluginConfig(), this.serializer(), this.metricsReporter(), this.ec(), (ActorSystem)system);
        this.writePluginId = config.getString("write-plugin");
        this.eventAdapters = ((Persistence)Persistence$.MODULE$.apply((ActorSystem)system)).adaptersFor(this.writePluginId());
        this.refreshInterval = this.queryPluginConfig().refreshInterval();
        this.delaySource = (Source)Source$.MODULE$.tick(this.queryPluginConfig().refreshInterval(), new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(0)).seconds(), (Object)BoxesRunTime.boxToInteger((int)0)).take(1L);
    }

    public static final /* synthetic */ Object $anonfun$eventsByTag$4$adapted(long target$1, EventEnvelope x$10) {
        return BoxesRunTime.boxToBoolean((boolean)DynamoDBReadJournal.$anonfun$eventsByTag$4(target$1, x$10));
    }

    public static final /* synthetic */ Object $anonfun$eventsByTag$5$adapted(EventEnvelope x$11) {
        return BoxesRunTime.boxToLong((long)DynamoDBReadJournal$OffsetOps$.MODULE$.value$extension(DynamoDBReadJournal$.MODULE$.OffsetOps(x$11.offset())));
    }

    private static interface FlowControl {
    }

    public static final class OffsetOps {
        private final Offset com$github$j5ik2o$akka$persistence$dynamodb$query$scaladsl$DynamoDBReadJournal$OffsetOps$$that;

        public Offset com$github$j5ik2o$akka$persistence$dynamodb$query$scaladsl$DynamoDBReadJournal$OffsetOps$$that() {
            return this.com$github$j5ik2o$akka$persistence$dynamodb$query$scaladsl$DynamoDBReadJournal$OffsetOps$$that;
        }

        public long value() {
            return DynamoDBReadJournal$OffsetOps$.MODULE$.value$extension(this.com$github$j5ik2o$akka$persistence$dynamodb$query$scaladsl$DynamoDBReadJournal$OffsetOps$$that());
        }

        public int hashCode() {
            return DynamoDBReadJournal$OffsetOps$.MODULE$.hashCode$extension(this.com$github$j5ik2o$akka$persistence$dynamodb$query$scaladsl$DynamoDBReadJournal$OffsetOps$$that());
        }

        public boolean equals(Object x$1) {
            return DynamoDBReadJournal$OffsetOps$.MODULE$.equals$extension(this.com$github$j5ik2o$akka$persistence$dynamodb$query$scaladsl$DynamoDBReadJournal$OffsetOps$$that(), x$1);
        }

        public OffsetOps(Offset that) {
            this.com$github$j5ik2o$akka$persistence$dynamodb$query$scaladsl$DynamoDBReadJournal$OffsetOps$$that = that;
        }
    }
}

